Option Explicit


'-- AutoProcess Property
Global Const HDC_AUTOPROCESS_NONE = 0
Global Const HDC_AUTOPROCESS_SERIAL = 1
Global Const HDC_AUTOPROCESS_KEY = 2
Global Const HDC_AUTOPROCESS_BOTH = 3

'-- AutoScroll Property
Global Const HDC_AUTOSCROLL_NONE = 0
Global Const HDC_AUTOSCROLL_VERTICAL = 1
Global Const HDC_AUTOSCROLL_HORIZONTAL = 2
Global Const HDC_AUTOSCROLL_BOTH = 3
Global Const HDC_AUTOSCROLL_VERTKEY = 4

'-- BackSpace Property
Global Const HDC_BACKSPACE_DESTRUCTIVE = 0
Global Const HDC_BACKSPACE_NON_DESTRUCTIVE = 1

'-- CaptureMode Property
Global Const HDC_CAPTURE_STANDARD = 0
Global Const HDC_CAPTURE_BINARY = 1
Global Const HDC_CAPTURE_VISIBLE = 2

'-- ColorFilter Property
Global Const HDC_COLOR_FULL = 0
Global Const HDC_COLOR_GRAY = 1
Global Const HDC_COLOR_MONO = 2

'-- Cursor Type Property
Global Const HDC_CURSOR_BAR = 0
Global Const HDC_CURSOR_BLOCK = 1

'-- CommEvent Property (OnComm Events)
Global Const HDC_EV_SEND = 1
Global Const HDC_EV_RECEIVE = 2
Global Const HDC_EV_CTS = 3
Global Const HDC_EV_DSR = 4
Global Const HDC_EV_CD = 5
Global Const HDC_EV_RING = 6
Global Const HDC_EV_EOF = 7
Global Const HDC_EV_XFER = 100

'-- CommEvent Property (OnComm Errors)
Global Const HDC_ER_BREAK = 1001
Global Const HDC_ER_CTSTO = 1002
Global Const HDC_ER_DSRTO = 1003
Global Const HDC_ER_FRAME = 1004
Global Const HDC_ER_INTO = 1005
Global Const HDC_ER_OVERRUN = 1006
Global Const HDC_ER_CDTO = 1007
Global Const HDC_ER_RXOVER = 1008
Global Const HDC_ER_RXPARITY = 1009
Global Const HDC_ER_TXFULL = 1010

'-- Emulation Property
Global Const HDC_EMULATION_NONE = 0
Global Const HDC_EMULATION_TTY = 1
Global Const HDC_EMULATION_ANSI = 2
Global Const HDC_EMULATION_VT52 = 3
Global Const HDC_EMULATION_VT100 = 4

'-- Handshaking Property
Global Const HDC_HANDSHAKING_NONE = 0
Global Const HDC_HANDSHAKING_XONXOFF = 1
Global Const HDC_HANDSHAKING_RTS = 2
Global Const HDC_HANDSHAKING_RTSXONXOFF = 3

'-- KeyTranslation Property
Global Const HDC_KEY_NONE = 0
Global Const HDC_KEY_MANUAL = 1
Global Const HDC_KEY_VT100 = 2

'-- XferProtocol Property
Global Const HDC_XMODEM_CHECKSUM = 0
Global Const HDC_XMODEM_CRC = 1
Global Const HDC_XMODEM_1K = 2
Global Const HDC_YMODEM_BATCH = 3
Global Const HDC_YMODEM_G = 4
Global Const HDC_ZMODEM = 5
Global Const HDC_KERMIT = 6
Global Const HDC_COMPUSERVE_BPLUS = 7

'-- XferStatus Property
Global Const HDC_XFER_TERM_ERROR = -1
Global Const HDC_XFER_TERM_OK = 0
Global Const HDC_XFER_WAITING = 1
Global Const HDC_XFER_FILE_READY = 2
Global Const HDC_XFER_FILE_START = 3
Global Const HDC_XFER_XFERING = 4
Global Const HDC_XFER_SKIP = 5
Global Const HDC_XFER_ABORT = 6
Global Const HDC_XFER_FINISHED = 7
Global Const HDC_XFER_LOSTCARRIER = 8
Global Const HDC_XFER_TIMEOUT = 9

'-- XferStatusDialog Property
Global Const HDC_XFERDIALOG_NONE = 0
Global Const HDC_XFERDIALOG_MODELESS = 1
Global Const HDC_XFERDIALOG_MODAL = 2

'-- Notification Property
Global Const HDC_NOTIFICATION_MANUAL = 0
Global Const HDC_NOTIFICATION_DRIVER = 1

Sub CenterForm (Frm As Form)
'-- Places a form in the middle of the screen
    
    Frm.Left = (Screen.Width - Frm.Width) \ 2
    Frm.Top = (Screen.Height - Frm.Height) \ 2

End Sub

Function GetConfigFileName$ ()
'-- This routine returns your app's INI File name

Dim Period As Integer
Dim AppName$

    AppName$ = App.EXEName
    Period = InStr(AppName$, ".")
    If Period Then
        AppName$ = Left$(AppName$, Period - 1)
    End If
       
    GetConfigFileName$ = AppName$ & ".INI"
    
End Function

Function ReadScreen$ (Comm1 As Control, Row, Col, NumChars)
'-- Returns a string of text from the terminal window.
'   Row and Col are 1 based. i.e. 1-25, 1-80

Dim L As Integer, I As Integer, LineCount As Integer, OffSet As Integer
Dim CRLF$, Txt$

    '-- Check the No-Brainer Errors
    If Row > Comm1.Rows Then
        MsgBox "ReadScreen: Invalid Row argument"
        Exit Function
    ElseIf Col > Comm1.Columns Then
        MsgBox "ReadScreen: Invalid Column argument"
        Exit Function
    End If

    '-- Define CRLF
    CRLF$ = Chr$(13) & Chr$(10)

    '-- Determine the offset to the first column of the Row
    Txt$ = Comm1.Text
    L = Len(Txt$)
    
    '-- Determine the Offset
    If Row > 1 Then
        For I = 1 To L
            If Mid$(Txt$, I, 2) = CRLF$ Then
                LineCount = LineCount + 1
                If LineCount = Row - 1 Then
                    Exit For
                End If
            End If
        Next
        OffSet = I + 1 + Col
    Else
        OffSet = Col
    End If

    '-- Read the text
    If OffSet + NumChars > L Then
        MsgBox "ReadScreen: Invalid NumChars argument"
        Exit Function
    Else
        ReadScreen$ = Mid$(Txt$, OffSet, NumChars)
    End If

End Function

Function ZTrim$ (St$)
'-- Trims trailing null bytes, tabs, carriage returns, and line feeds from a string,
'   as well as trailing and leading spaces. Also converts embedded nulls to spaces.

Dim L As Integer, I As Integer
Dim Z$, T$, CR$, LF$, S$, Tilde$

    Z$ = Chr$(0)
    T$ = Chr$(9)
    CR$ = Chr$(13)
    LF$ = Chr$(10)
    S$ = Chr$(32)
    Tilde$ = "~"

    L = Len(St$)
    
    For I = 1 To L
        Select Case Right$(St$, 1)
            Case Z$, T$, CR$, LF$, S$
                If L > 1 Then
                    St$ = Left$(St$, L - 1)
                    L = L - 1
                Else
                    St$ = ""
                End If
            Case Else
                Exit For
        End Select
    Next
    
    '-- Replace imbedded Chr$(0)s
    L = Len(St$)
    For I = 1 To L
        If Mid$(St$, I, 1) = Z$ Then
            Mid$(St$, I, 1) = S$
        End If
    Next

    '-- Replace Tildes
    L = Len(St$)
    For I = 1 To L
        If Mid$(St$, I, 1) = Tilde$ Then
            Mid$(St$, I, 1) = S$
        End If
    Next
    
    ZTrim$ = Trim$(St$)

End Function

