 /*-------------------------------------
    BEEPER2.C -- Timer Demo Program No. 1
		 (c) Charles Petzold, 1990
 ---------------------------------------*/
 #include <windows.h>
 #define ID_TIMER 1

 long FAR PASCAL WndProc (HWND, WORD, WORD, LONG);
 int FAR PASCAL TimerProc (HWND, WORD, WORD, LONG);
  int PASCAL WinMain (HANDLE hInstance, HANDLE hPrevInstance,
		      LPSTR lpszCmdLine, int nCmdShow)
       {
       static char szAppName[] = "Beeper2";
       FARPROC	   lpfnTimerProc;
       HWND 	   hwnd;
       MSG	   msg;
       WNDCLASS	   wndclass;

       if (!hPrevInstance)
	    {
	    wndclass.style	 = CS_HREDRAW | CS_VREDRAW;
	    wndclass.lpfnWndProc = WndProc;
	    wndclass.cbClsExtra	 = 0;
	    wndclass.cbWndExtra	 = 0;
	    wndclass.hInstance	 = hInstance;
	    wndclass.hIcon	 = LoadIcon (NULL, IDI_APPLICATION);
	    wndclass.hCursor	 = LoadCursor (NULL, IDC_ARROW);
	    wndclass.hbrBackground = GetStockObject (WHITE_BRUSH);
	    wndclass.lpszMenuName  = NULL;
	    wndclass.lpszClassName = szAppName;

	    RegisterClass (&wndclass);
	    }
       hwnd = CreateWindow (szAppName, "Beeper2 Timer Demo",
			    WS_OVERLAPPEDWINDOW,
			    CW_USEDEFAULT, CW_USEDEFAULT,
			    CW_USEDEFAULT, CW_USEDEFAULT,
			    NULL, NULL, hInstance, NULL);

       lpfnTimerProc = MakeProcInstance(TimerProc, hInstance);

       while (!SetTimer (hwnd, ID_TIMER, 1000, lpfnTimerProc))
	    if (IDCANCEL == MessageBox (hwnd,
				  "Too many clocks or timers!", szAppName,
				  MB_ICONEXCLAMATION | MB_RETRYCANCEL))
		 return FALSE;

       ShowWindow (hwnd, nCmdShow);
       UpdateWindow (hwnd);

       while (GetMessage (&msg, NULL, 0, 0))
	    {
	    TranslateMessage (&msg);
	    DispatchMessage (&msg);
	    }
       return msg.wParam;
       }

  long FAR PASCAL WndProc (HWND hwnd, WORD message, WORD wParam, LONG lParam)
       {

       switch (message)
	    {
	    case WM_DESTROY:
		KillTimer(hwnd,ID_TIMER);
		PostQuitMessage(0);
		return 0;
	     }
       return DefWindowProc(hwnd,message,wParam,lParam);
       }
 int FAR PASCAL TimerProc(HWND hwnd, WORD message, WORD wParam, LONG lParam)
       {
       static BOOL fFlipFlop = FALSE;
       HBRUSH	   hBrush;
       HDC	   hdc;
       RECT	   rc;
       MessageBeep (0);
       fFlipFlop = !fFlipFlop;

       GetClientRect(hwnd,&rc);
       hdc = GetDC(hwnd);
       hBrush = CreateSolidBrush(fFlipFlop ? RGB(255,0,0) : RGB(0,0,255));
       FillRect (hdc,&rc,hBrush);
       ReleaseDC(hwnd,hdc) ;
       DeleteObject(hBrush);
       return 0;
       }