//---------------------------------------------------------------------
// b4dmsgrs.cpp	2-28-93	djf
// B4DMsgResource class definitiion
//---------------------------------------------------------------------

//---------------------------------------------------------------------
// includes
//---------------------------------------------------------------------
#include "b4dmsg.h"
#include "b4dmsgrs.h"

B4DMsgResource::B4DMsgResource()
{
	if ((hLib = LoadLibrary ((LPTSTR)"b4dmsg.dll")) == NULL)
		RaiseException
			(
			B4D_ERROR_LOAD_LIBRARY_FAILED,
			EXCEPTION_NONCONTINUABLE,
			0,
			NULL			
			);

} // B4DMsgResource::B4DMsgResource()

B4DMsgResource::~B4DMsgResource()
{
	FreeLibrary( hLib );
} // B4DMsgResource::~B4DMsgResource()

// get the message associated with exception code
const char *B4DMsgResource::get		
	( 
	DWORD 	dwExceptionCode,
	DWORD	*pArgs
	) const
{
	static const int BUF_LEN = 256;
	static char buffer[BUF_LEN];

	int nBytesRead = 
		FormatMessage
			(
			FORMAT_MESSAGE_FROM_HMODULE,
			hLib,
			dwExceptionCode, 
			0,	// language - I don't know where this comes from
			buffer,
			BUF_LEN,
			pArgs
			);

	// I don't think we should throw an exception here if the 
	// LoadString fails:  too much chance of endless loop.
	if ( !nBytesRead )
		wsprintf
			( 
			buffer, 
			"Unknown B4D Exception 0x%lX",
			dwExceptionCode,
			GetLastError()
			);

	return buffer;
	
} // const char *B4DMsgResource::get

