#define WVBLACK		0
#define WVRED		1
#define WVGREEN		2
#define WVBLUE		3
#define WVBROWN		4
#define WVMAGENTA	5
#define WVCYAN		6
#define WVWHITE		7
#define WVGRAY		8
#define WVLIGHTRED	9
#define WVLIGHTGREEN	10
#define WVLIGHTBLUE	11
#define WVYELLOW	12
#define WVLIGHTMAGENTA	13
#define WVLIGHTCYAN	14
#define WVLIGHTGRAY	15

typedef struct {	/* 2D floating point coordinates */
	float	x, y, w;
} POINT2D;

typedef struct {	/* 3D floating point coordinates */
	float	x, y, z, w;
} POINT3D;

typedef WORD		HVIEW;		/* Handle of viewer */
typedef	float		*Vector;	/* Pointer to vector */
typedef	POINT2D		*LPPOINT2D;	/* Pointer to 2D points */
typedef POINT3D		*LPPOINT3D;	/* Pointer to 3D points */

/*****************************************************************************

		Misc Functions

*****************************************************************************/

short	BackfaceCulling (short flag);
short	CountClockwise (short flag);
void	AssignPoint2D (POINT2D p, float x, float y);
void	AssignPoint3D (POINT3D p, float x, float y, float z);
float	DegreeToRadian (float Degree);
float	RadianToDegree (float Radian);
HVIEW	CreateViewer2D (NPSTR Name, int X, int Y, int Width, int Height);
HVIEW	CreateViewer3D (NPSTR Name, int X, int Y, int Width, int Height);

/*****************************************************************************

		System Configuration Function

*****************************************************************************/

void	Max2DViewer (short n);
void	Max3DViewer (short n);
void	Max2DMStack (short n);
void	Max3DMStack (short n);

short	InitialGraphics2D (short nview, short npoint, short ndepth);
short	InitialGraphics3D (short nview, short npoint, short ndepth);
void	ExitGraphics (void);
HPEN	PenColor (HDC hDC, short color_index);
HBRUSH	BrushColor (HDC hDC, short color_index);

/*****************************************************************************

		Matrix Stack Operation Function

*****************************************************************************/

short	PushMatrix2D (void);
short	PushMatrix3D (void);
short	PopMatrix2D (void);
short	PopMatrix3D (void);

/*****************************************************************************

			Transformtion Function

*****************************************************************************/

/* Model view transformation matrix */
short	SetView3D (HVIEW hview, float vx, float vy, float vz,
		float rx, float ry, float rz, float twist);
short	SetPolarView3D (HVIEW hview, float cx, float cy, float cz,
		float dist, float azim, float inc, float twist);
short	SetView2D (HVIEW hview,	float x, float y, float angle);
short	SetProjection2D (HVIEW hview, float left, float right,
		float bottom, float top);
short	SetWindow2D (HVIEW hview, float x1, float y1, float x2, float y2);
short	SetPerspective3D (HVIEW hview, float fovy, float aspect,
		float front, float back);
short	SetOrthogonal3D (HVIEW hview, float left, float right,
		float bottom, float top, float front, float back);
short	SetWindow3D (HVIEW hview, float left, float right,
		float top, float bottom, float front, float back);
short	SetViewport2D (HVIEW hview, short x, short y, short w, short h);
short	SetViewport3D (HVIEW hview, short x, short y, short w, short h);
short	SelectViewer3D (HVIEW hview);
short	SelectViewer2D (HVIEW hview);

/*****************************************************************************

				View Moving Function

*****************************************************************************/

short	MoveViewer3D (HVIEW hview, float LR, float UD, float BF);
short	MoveWorld3D (HVIEW hview, float X, float Y, float Z);
short	RotateViewer3D (HVIEW hview, float Yaw, float Pitch, float Twist);
short	RotateWorld3D (HVIEW hview, float X, float Y, float Z);
short	ZoomViewer3D (HVIEW hview, float zoom);
short	MoveViewer2D (HVIEW hview, float LeftRight, float UpDown);
short	RotateViewer2D (HVIEW hview, float Angle);
short	ZoomViewer2D (HVIEW hview, float zoom);

short	Num2DViewer (void);
short	Num3DViewer (void);
short	ValidHView2D (HVIEW hview);
short	ValidHView3D (HVIEW hview);
short	DisplayViewerFrame2D (HDC hDC, HVIEW hview, short color);
short	DisplayViewerName2D (HDC hDC, HVIEW hview, short color, short top);
short	DisplayViewerFrame3D (HDC hDC, HVIEW hview, short color);
short	DisplayViewerName3D (HDC hDC, HVIEW hview, short color, short top);
short	ClearViewer3D (HDC hDC, HVIEW hview, short color);
short	ClearViewer2D (HDC hDC, HVIEW hview, short color);
short	ViewerPosition2D (HVIEW hview, float *cx, float *cy, float *angle);
short	ViewerField3D (HVIEW hview, float *left, float *right,
		float *bottom, float *top, float *front, float *back);
short	ViewerField2D (HVIEW hview, float *left, float *right,
		float *top, float *bottom);
short	ViewerMode3D (HVIEW hview);

/*****************************************************************************

			Transformation Function

*****************************************************************************/

void	Rotate3D (float angle, char axis);
void	Translate3D (float x, float y, float z);
void	Scale3D (float x, float y, float z);

void	Translate2D (float x, float y);
void	Rotate2D (float angle);
void	Scale2D (float x, float y);

/*****************************************************************************

			Camera Information Functions

*****************************************************************************/

short	GetViewerName2D (HVIEW hview, NPSTR name);
short	SetViewerName2D (HVIEW hview, NPSTR name);
short	GetViewerName3D (HVIEW hview, NPSTR name);
short	SetViewerName3D (HVIEW hview, NPSTR name);
short	GetViewport2D (HVIEW hview, short *x, short *y, short *w, short *h);
short	GetViewport3D (HVIEW hview, short *x, short *y, short *w, short *h);

/*****************************************************************************

			Drawing Functions

*****************************************************************************/

void	MoveTo2D (HDC hDC, float x, float y);
void	LineTo2D (HDC hDC, float x, float y);
void	DrawLine2D (HDC hDC, float x1, float y1, float x2, float y2);
void	Polyline2D (HDC hDC, LPPOINT2D point, short count);
void	Polygon2D (HDC hDC, LPPOINT2D vertex, short count);
void	ResetVertex2D (void);
void	SetVertex2D (float x, float y);
short	RectangleVertex2D (float x1, float y1, float x2, float y2,
		LPPOINT2D vertex);
void	Rectangle2D (HDC hDC, float x1, float y1, float x2, float y2);
short	NgonVertex2D (short n, float x, float y, float r1, float r2,
		LPPOINT2D vertex);
short	ArcVertex2D (float x, float y, float r1, float r2,
		float start, float angle, LPPOINT2D vertex);
void	Ngon2D (HDC hDC, float x, float y, float r1, float r2, short count);
short	NsideBowVertex2D (float x, float y, float r1, float r2,
		float start, float angle, short count, LPPOINT2D vertex);
void	Arc2D (HDC hDC, float x, float y, float r, float start, float angle);
void	EllipseArc2D (HDC hDC, float x, float y, float r1, float r2,
		float start, float angle);
void	Wedge2D (HDC hDC, float x, float y, float r1, float r2,
		float start, float angle);
void	Circle2D (HDC hDC, float x, float y, float r);
void	Ellipse2D (HDC hDC, float x, float y, float r1, float r2);
short	NsideFlowerVertex2D (short n, float x, float y, float r1, float r2,
		float aspect, LPPOINT2D vertex);
short	NsideStarVertex2D (short n, float x, float y, float r, float aspect,
		LPPOINT2D vertex);
void	NsideStar2D (HDC hDC, float x, float y, float radius, short count);
void	NsideFlower2D (HDC hDC, float x, float y, float r1, float r2, short n);
void	MoveTo3D (HDC hDC, float x, float y, float z);
void	LineTo3D (HDC hDC, float x, float y, float z);
void	Line3D (HDC hDC, float x1, float y1, float z1,
			float x2, float y2, float z2);
void	Polyline3D (HDC hDC, LPPOINT3D point, short count);
void	Polygon3D (HDC hDC, LPPOINT3D vertex, short count);
void	MarkPosition3D (HDC hDC, float x, float y, float z, float scale);
void	ResetVertex3D (void);
void	SetVertex3D (float x, float y, float z);
void	Shape3D (HDC hDC, float x, float y, float z,
		LPPOINT2D vertex, short count);
void	Rectangle3D (HDC hDC, float x1, float y1,
		float x2, float y2, float z);
void	Box3D (HDC hDC, float x1, float y1, float z1,
		float x2, float y2, float z2);
void	Cube3D (HDC hDC, float x1, float y1, float z1,
		float x2, float y2, float z2);
void	Sphere3D (HDC hDC, float x, float y, float z, float r,
		short count1, short count2);
void	Ball3D (HDC hDC, float x, float y, float z, float r);
void	Pyramid3D (HDC hDC, float x, float y, float z, float height,
		LPPOINT2D basevertex, short count);
void	Prism3D (HDC hDC, float x, float y, float z, float h,
		LPPOINT2D basevertex, LPPOINT2D headvertex, short count);
void	NsideStar3D (HDC hDC, float x, float y, float z, float h,
		float radius, short count);
void	NsideFlower3D (HDC hDC, float x, float y, float z, float h,
		float r1, float r2, short count);
void	NsidePyramid3D (HDC hDC, float x, float y, float z,
		float r, float height, short count);
void	Cone3D (HDC hDC, float x, float y, float z, float r, float h);
void	NsidePrism3D (HDC hDC, float x, float y, float z,
		float r, float h, short n);
void	Cylinder3D (HDC hDC, float x, float y, float z,	float r, float h);

short	BeginDoubleBuffer3D (HDC *hdc, HVIEW hview);
short	BeginDoubleBuffer2D (HDC *hdc, HVIEW hview);
short	EndDoubleBuffer3D (HDC *hdc, HVIEW hview);
short	EndDoubleBuffer2D (HDC *hdc, HVIEW hview);
short	UpdateBuffer3D (HDC hdc, HVIEW hview);
short	UpdateBuffer2D (HDC hdc, HVIEW hview);

void	Tetrahedron (HDC hdc, float r);
void	Octahedron (HDC hdc, float r);
void	Dodecahedron (HDC hdc, float r);
void	Icosahedron (HDC hdc, float r);

/*****************************************************************

Curves and Surfaces

*****************************************************************/


void	BezierCurve2D (HDC hdc, LPPOINT2D CtrlPoly);
void	BezierCurve3D (HDC hdc, LPPOINT3D CtrlPoly);
void	HermitCurve2D (HDC hdc, LPPOINT2D CtrlPoly);
void	HermitCurve3D (HDC hdc, LPPOINT3D CtrlPoly);
void	BSplineCurve2D (HDC hdc, LPPOINT2D CtrlPoly, int count);
void	BSplineCurve3D (HDC hdc, LPPOINT3D CtrlPoly, int count);
void	NURBSCurve2D (HDC hdc, LPPOINT2D CtrlPoly, int count, Vector knot);
void	NURBSCurve3D (HDC hdc, LPPOINT3D CtrlPoly, int count, Vector knot);
void	BezierSurface3D (HDC hdc, LPPOINT3D CtrlPoly, int ns, int nt);
void	NURBSSurface3D (HDC hdc, LPPOINT3D CtrlPoly, int Scount, int Tcount,
		Vector Sknot, Vector Tknot, int ns, int nt);

