Listing 1: Processing the WM_BUTTONDOWN messages
    case WM_RBUTTONDOWN:
    case WM_LBUTTONDOWN:
      LBtnDown = ( msg == WM_LBUTTONDOWN );
      RBtnDown = ( msg == WM_RBUTTONDOWN );
      SetCapture( hWnd );
      GetClientRect( hWnd, &ZoomRect );
      ClientToScreen( hWnd, (POINT FAR *)&ZoomRect );
      ClientToScreen( hWnd, (POINT FAR *)&ZoomRect+1 );
      ClipCursor( &ZoomRect );  // cage mouse to client area
      ZoomRect.top = ZoomRect.bottom = HIWORD( lParam );
// start point
      ZoomRect.left = ZoomRect.right = LOWORD( lParam );
      break;

Listing 2: Processing the WM_MOUSEMOVE message
    case WM_MOUSEMOVE:
      if( ( RBtnDown || LBtnDown ) && GetCapture() == hWnd )
        { hDC = GetDC( hWnd  );                         // get DC
          DrawFocusRect( hDC, &ZoomRect );              // erase old box
          ZoomRect.bottom = HIWORD( lParam );   // set new size
          ZoomRect.right = LOWORD( lParam );
          DrawFocusRect( hDC, &ZoomRect );              // show new box
          ReleaseDC( hWnd, hDC );                       // return DC
        }
      break;


Listing 3: Processing the WM_BUTTONUP message
    case WM_RBUTTONUP:
    case WM_LBUTTONUP:
      if( ( RBtnDown || LBtnDown ) && GetCapture() == hWnd )
        { int w, h;
          ClipCursor( NULL );
          ReleaseCapture();                     // uncage the mouse
          hDC = GetDC( hWnd );          // erase the rectangle
          DrawFocusRect( hDC, &ZoomRect );
          ReleaseDC( hWnd, hDC );
          if( ZoomRect.left > ZoomRect.right )  // calc limits
            { int temp = ZoomRect.left;
              ZoomRect.left = ZoomRect.right;
              ZoomRect.right = temp;
            }
          if( ZoomRect.top > ZoomRect.bottom )
            { int temp = ZoomRect.top;
              ZoomRect.top = ZoomRect.bottom;
              ZoomRect.bottom = temp;
            }
          w = ZoomRect.right - ZoomRect.left;
          h = ZoomRect.bottom - ZoomRect.top;

          if( w > 7 && h > 7 ) // 8x8 is minimum active area!
            { if( LBtnDown )   // zoom in for L Button
                RectZoom( w, h, hWnd );  // does the zoom...
              else             // copy to clip rect for R Button
                { ClipRect.right  = ZoomRect.right;
                  ClipRect.left   = ZoomRect.left;
                  ClipRect.bottom = ZoomRect.bottom;
                  ClipRect.top    = ZoomRect.top;
                }
            }
        }
      RBtnDown = LBtnDown = FALSE;  // clear both flags when done
      break;
