C	extern void	__stdcall OZCURSCB (long* type, long* num, float* x, float* y, 
C									float* extra);

C ===========================================================================================
C
C
	SUBROUTINE OZCURSCB (ITYPE, NUM, X, Y, EXTRA, IHANDLE)
C	=================

	INCLUDE "OZAPI.INC"
	DIMENSION X(*), Y(*)
C
C	CALLED WHEN THE BUTTON IS RELEASED WHEN SELECTING WITH A CURSOR
C     THE CURSOR WAS INITIALISED WITH A CALL TO GINLC AND HAS TO BE 
C      DISABLED WITH ANOTHER CALL TO GINLC WHEN NO LONGER REQUIRED.
C
C	ITYPE IS THE TYPE OF CURSOR AS PASSED TO GINLC
C     NUM IS THE NUMBER OF VERTICES RETURNED IN X AND Y ARRAYS
C     X,Y CONTAIN:
C		POINT SELECTED WITH CROSS HAIRS
C		TWO CORNERS FOR BOX CURSORS
C		CENTRE FOR CIRCLE
C		DIGITISED LINE (YOU HAVE TO CLOSE IT IF YOU WANT A POLY)
C     EXTRA CONTAINS EXTRA INFO, CURRENTLY THE RADIUS FOR A CIRCLE CURSOR
C	IHANDLE IS AN IDENTIFIER GIVEN IN GINLC CALL
	

	CALL GSLN (1) ! LINE TYPE
	CALL GSLW (1) ! LINE WIDTH
	CALL GSPLCI (ITYPE) ! COLOUR INDEX

C  CROSS HAIR

	IF (ITYPE.EQ.1)  THEN
        CALL GSPMCI (ITYPE) ! MARKER COLOUR INDEX
	  CALL GSMKSIZE (200.0) ! SIZE
	  CALL GSMK (76) ! MARKER TYPE
	  IHANDLE = GPM (1,X,Y) ! POLYMARKER
	END IF

C  BOX CURSOR OR FIXED SIZE BOX

	IF (ITYPE.EQ.2 .OR. ITYPE.EQ.5)  THEN
	  CALL GSFAIS (1) ! SOLID FILL
	  CALL GSFACI (ITYPE) ! COLOUR INDEX
	  IHANDLE = GFRECT (X(1), X(2), Y(1), Y(2))
	END IF

C  CIRCLE

	IF (ITYPE.EQ.3)  THEN
        CALL GSPMCI (ITYPE) ! MARKER COLOUR INDEX
	  CALL GSMK (181) ! MARKER TYPE
	  CALL GSMKSIZE (2.0 * EXTRA/10000.0) ! SIZE
	  IHANDLE = GPM (1,X,Y) ! POLYMARKER
	END IF

C  STRAIGHT LINE

	IF (ITYPE.EQ.4)  THEN
	  IHAND = GPL (2,X,Y)
	END IF


C  DIGITISE LINE

	IF (ITYPE.EQ.6)  THEN
	  IHAND = GPL (NUM,X,Y)
	END IF

	CALL GUWK (1,1)
     	RETURN
	END

