C	OZMENU.FOR
C
C  MENU CALLBACK I.E. CALLED WHENEVER THE USER SELECTS A MENU ITEM
C
	SUBROUTINE OZMENUCB (IPULL, ITEM, IDENT)
C
C	IPULL = THE PULLDOWN MENU (1-10), 0=POPUP MENU
C	ITEM = WHICH PULLDOWN ITEM
C	IDENT = THE IDENTIFIER SPECIFIED WHEN CREATED
C
C	REPLACE ALL THE CODE HERE WITH YOUR APPLICATIONS HANDLING OF MENU ITEM SELECTIONS
C

      USE MSFLIB

	INCLUDE	"OZAPI.INC"
	CHARACTER*80 MSG
	CHARACTER*1 NULL
	CHARACTER*50 STRING
	CHARACTER*30 LBITEMS(10)
	CHARACTER*30 ITEMTEXT
	LOGICAL BOOL, SAVEFILE, GKSOPEN
	INTEGER	CUSTCOL(32)
	CHARACTER*256 FILENAME
	CHARACTER*50 FILTERNAME(10)
	CHARACTER*10 FILTERPATTERN(10)
      DIMENSION PX(1000),PY(1000)
	DIMENSION CURSOR(4)

	DIMENSION PALCOL(360)

	DATA GKSOPEN / .FALSE. /
C PALETTE COLOURS  B,G,R
	DATA PALCOL /    
     -     0.996078 ,0.000000 ,0.219608    ,
     -     0.996078 ,0.000000 ,0.294118    ,
     -     0.992157 ,0.000000 ,0.341176    ,
     -     0.992157 ,0.000000 ,0.384314    ,
     -     0.988235 ,0.000000 ,0.419608    ,
     -     0.984314 ,0.000000 ,0.450980    ,
     -     0.984314 ,0.000000 ,0.478431    ,
     -     0.980392 ,0.000000 ,0.505882    ,
     -     0.976471 ,0.000000 ,0.529412    ,
     -     0.972549 ,0.000000 ,0.552941    ,
     -     0.968627 ,0.000000 ,0.572549    ,
     -     0.964706 ,0.000000 ,0.592157    ,
     -     0.960784 ,0.000000 ,0.611765    ,
     -     0.956863 ,0.000000 ,0.627451    ,
     -     0.952941 ,0.000000 ,0.643137    ,
     -     0.949020 ,0.000000 ,0.658824    ,
     -     0.945098 ,0.000000 ,0.674510    ,
     -     0.941176 ,0.000000 ,0.690196    ,
     -     0.937255 ,0.000000 ,0.705882    ,
     -     0.933333 ,0.000000 ,0.717647    ,
     -     0.929412 ,0.000000 ,0.729412    ,
     -     0.925490 ,0.000000 ,0.741176    ,
     -     0.921569 ,0.000000 ,0.752941    ,
     -     0.917647 ,0.000000 ,0.764706    ,
     -     0.909804 ,0.000000 ,0.776471    ,
     -     0.905882 ,0.000000 ,0.788235    ,
     -     0.901961 ,0.000000 ,0.800000    ,
     -     0.898039 ,0.000000 ,0.807843    ,
     -     0.890196 ,0.000000 ,0.819608    ,
     -     0.886275 ,0.000000 ,0.827451    ,
     -     0.882353 ,0.000000 ,0.839216    ,
     -     0.874510 ,0.000000 ,0.847059    ,
     -     0.870588 ,0.000000 ,0.854902    ,
     -     0.866667 ,0.000000 ,0.862745    ,
     -     0.858824 ,0.000000 ,0.870588    ,
     -     0.854902 ,0.000000 ,0.878431    ,
     -     0.847059 ,0.000000 ,0.886275    ,
     -     0.843137 ,0.000000 ,0.894118    ,
     -     0.835294 ,0.000000 ,0.901961    ,
     -     0.831373 ,0.090196 ,0.909804    ,
     -     0.823529 ,0.125490 ,0.917647    ,
     -     0.815686 ,0.152941 ,0.921569    ,
     -     0.811765 ,0.172549 ,0.929412    ,
     -     0.803922 ,0.192157 ,0.937255    ,
     -     0.796078 ,0.207843 ,0.941176    ,
     -     0.792157 ,0.223529 ,0.949020    ,
     -     0.784314 ,0.239216 ,0.952941    ,
     -     0.776471 ,0.254902 ,0.960784    ,
     -     0.772549 ,0.266667 ,0.964706    ,
     -     0.764706 ,0.282353 ,0.972549    ,
     -     0.756863 ,0.298039 ,0.976471    ,
     -     0.749020 ,0.309804 ,0.980392    ,
     -     0.741176 ,0.321569 ,0.988235    ,
     -     0.733333 ,0.333333 ,0.992157    ,
     -     0.725490 ,0.345098 ,0.996078    ,
     -     0.717647 ,0.356863 ,1.000000    ,
     -     0.709804 ,0.368627 ,1.000000    ,
     -     0.701961 ,0.380392 ,1.000000    ,
     -     0.694118 ,0.392157 ,1.000000    ,
     -     0.686275 ,0.400000 ,1.000000    ,
     -     0.678431 ,0.411765 ,1.000000    ,
     -     0.670588 ,0.423529 ,1.000000    ,
     -     0.658824 ,0.435294 ,1.000000    ,
     -     0.650980 ,0.447059 ,1.000000    ,
     -     0.643137 ,0.454902 ,1.000000    ,
     -     0.635294 ,0.466667 ,1.000000    ,
     -     0.623529 ,0.478431 ,1.000000    ,
     -     0.615686 ,0.486275 ,1.000000    ,
     -     0.603922 ,0.498039 ,1.000000    ,
     -     0.596078 ,0.509804 ,1.000000    ,
     -     0.584314 ,0.517647 ,1.000000    ,
     -     0.572549 ,0.529412 ,1.000000    ,
     -     0.564706 ,0.541176 ,1.000000    ,
     -     0.552941 ,0.549020 ,1.000000    ,
     -     0.541176 ,0.560784 ,1.000000    ,
     -     0.529412 ,0.568627 ,1.000000    ,
     -     0.521569 ,0.580392 ,1.000000    ,
     -     0.509804 ,0.592157 ,1.000000    ,
     -     0.494118 ,0.600000 ,1.000000    ,
     -     0.486275 ,0.611765 ,1.000000    ,
     -     0.470588 ,0.619608 ,1.000000    ,
     -     0.458824 ,0.631373 ,1.000000    ,
     -     0.447059 ,0.639216 ,1.000000    ,
     -     0.431373 ,0.650980 ,1.000000    ,
     -     0.419608 ,0.658824 ,1.000000    ,
     -     0.407843 ,0.670588 ,1.000000    ,
     -     0.392157 ,0.678431 ,1.000000    ,
     -     0.376471 ,0.690196 ,1.000000    ,
     -     0.360784 ,0.698039 ,1.000000    ,
     -     0.345098 ,0.709804 ,1.000000    ,
     -     0.329412 ,0.721569 ,1.000000    ,
     -     0.313726 ,0.729412 ,1.000000    ,
     -     0.294118 ,0.737255 ,1.000000    ,
     -     0.278431 ,0.749020 ,1.000000    ,
     -     0.254902 ,0.756863 ,1.000000    ,
     -     0.235294 ,0.768627 ,1.000000    ,
     -     0.211765 ,0.776471 ,1.000000    ,
     -     0.184314 ,0.788235 ,1.000000    ,
     -     0.156863 ,0.800000 ,1.000000    ,
     -     0.121569 ,0.807843 ,1.000000    ,
     -     0.058824 ,0.815686 ,1.000000    ,
     -     0.000000 ,0.827451 ,1.000000    ,
     -     0.000000 ,0.835294 ,1.000000    ,
     -     0.000000 ,0.847059 ,1.000000    ,
     -     0.000000 ,0.854902 ,1.000000    ,
     -     0.000000 ,0.866667 ,1.000000    ,
     -     0.000000 ,0.874510 ,1.000000    ,
     -     0.000000 ,0.886275 ,1.000000    ,
     -     0.000000 ,0.894118 ,1.000000    ,
     -     0.000000 ,0.905882 ,1.000000    ,
     -     0.000000 ,0.913725 ,1.000000    ,
     -     0.000000 ,0.921569 ,1.000000    ,
     -     0.000000 ,0.933333 ,1.000000    ,
     -     0.000000 ,0.945098 ,1.000000    ,
     -     0.000000 ,0.952941 ,1.000000    ,
     -     0.000000 ,0.960784 ,1.000000    ,
     -     0.000000 ,0.972549 ,1.000000    ,
     -     0.000000 ,0.980392 ,1.000000    ,
     -     0.000000 ,0.992157 ,1.000000    ,
     -     0.000000 ,1.000000 ,1.000000      /
C
C ----------- STUFF FOR DEMO FOLLOWS

	NULL = CHAR(0)



C	THE DEMO JUST USES THE IDENT OF THE SELECTED MENU ITEM
C
C =================== MENU SWAPPING ================================================
C
C	SWAP TO THE STANDARD WINDOWS SET OF MENUS (SWAPPING IS JUST TO SHOW HOW ITS DONE )
C
	IF (IDENT.EQ.1)  THEN
		CALL OZCLEARALLMENUS
		IPULL = OZADDPULLDOWN('Menus'C)
		ITEM =  OZADDMENUITEM (IPULL, 'Swap to graphics menus'C, 2)
		ITEM =  OZADDMENUITEM (IPULL, 'Display popup menu'C, 51)
		IPULL = OZADDPULLDOWN('DialogBox'C)
		ITEM =  OZADDMENUITEM (IPULL, 
     -		'Abort Retry Ignore/ Exclamation / Ignore'C, 101)
		ITEM =  OZADDMENUITEM (IPULL, 'OK / Information'C, 102)
		ITEM =  OZADDMENUITEM (IPULL, 
     -		'OK Cancel / Question / Cancel'C, 103)
		ITEM =  OZADDMENUITEM (IPULL, 
     -		'Retry Cancel / Stop / Retry'C, 104)
		ITEM =  OZADDMENUITEM (IPULL, 'Yes No'C, 105)
		ITEM =  OZADDMENUITEM (IPULL, 'Yes No Cancel'C, 106)
		IPULL = OZADDPULLDOWN('Misc'C)
		ITEM =  OZADDMENUITEM (IPULL, 'Window title'C, 201)
		ITEM =  OZADDMENUITEM (IPULL, 'Busy cursor'C, 203)
		ITEM =  OZADDMENUITEM (IPULL, 'Remove busy cursor'C, 204)
		IPULL = OZADDPULLDOWN('Dialogs'C)
		ITEM =  OZADDMENUITEM (IPULL, 'Integer'C, 301)
		ITEM =  OZADDMENUITEM (IPULL, 'Real'C, 302)
		ITEM =  OZADDMENUITEM (IPULL, 'String'C, 303)
		ITEM =  OZADDMENUITEM (IPULL, 'List box'C, 304)
		ITEM =  OZADDMENUITEM (IPULL, 'List box from file'C, 305)
		ITEM =  OZADDMENUITEM (IPULL, 'Display text file'C, 306)
		IPULL = OZADDPULLDOWN('Common Dialogs'C)
		ITEM =  OZADDMENUITEM (IPULL, 'Colour'C, 501)
		ITEM =  OZADDMENUITEM (IPULL, 'Save file name'C, 502)
		ITEM =  OZADDMENUITEM (IPULL, 'Open file name'C, 503)
		IPULL = OZADDPULLDOWN('Help'C)
		ITEM =  OZADDMENUITEM (IPULL, 'Help Contents'C, 401)
		ITEM =  OZADDMENUITEM (IPULL, 'Help Index'C, 402)
		ITEM =  OZADDMENUITEM (IPULL, 'About'C, 403)

C		SHUT DOWN GKS
		IF (GKSOPEN)  THEN
			GKSOPEN = .FALSE.
			CALL GCLRWK (1,1)
			CALL GDAWK (1) ! DEACTIVATE
			CALL GCLWK (1) ! CLOSE WORKSTATION
			CALL GCLKS ! CLOSE GKS
		END IF

	END IF
C
C	SWAP TO GRAPHICS MENUS
C
	IF (IDENT.EQ.2)  THEN
		CALL OZCLEARALLMENUS
		IPULL = OZADDPULLDOWN('Menus'C)
		ITEM =  OZADDMENUITEM (IPULL, 'Swap to Windows menus'C, 1)
		IPULL = OZADDPULLDOWN('GKS'C)
		ITEM =  OZADDMENUITEM (IPULL, 'Lines'C, 602)
		ITEM =  OZADDMENUITEM (IPULL, 'Update lines'C, 612)
		ITEM =  OZADDMENUITEM (IPULL, 'Markers'C, 603)
		ITEM =  OZADDMENUITEM (IPULL, 'Update markers'C, 613)
		ITEM =  OZADDMENUITEM (IPULL, 'Text'C, 604)
		ITEM =  OZADDMENUITEM (IPULL, 'Centred text'C, 605)
		ITEM =  OZADDMENUITEM (IPULL, 'Vertical text'C, 606)
		ITEM =  OZADDMENUITEM (IPULL, 'Polygons'C, 607)
		ITEM =  OZADDMENUITEM (IPULL, 'Update polygons'C, 617)
		ITEM =  OZADDMENUITEM (IPULL, 'Colour palette'C, 608)
		IPULL = OZADDPULLDOWN('Cursor Mode'C)
		ITEM =  OZADDMENUITEM (IPULL, 'None, disable'C, 700)
		ITEM =  OZADDMENUITEM (IPULL, 'Cross hair'C, 701)
		ITEM =  OZADDMENUITEM (IPULL, 'Box cursor'C, 702)
		ITEM =  OZADDMENUITEM (IPULL, 'Circle'C, 703)
		ITEM =  OZADDMENUITEM (IPULL, 'Straight line'C, 704)
		ITEM =  OZADDMENUITEM (IPULL, 'Fixed size box'C, 705)
		ITEM =  OZADDMENUITEM (IPULL, 'Digitise line'C, 706)
		IPULL = OZADDPULLDOWN('Locator'C)
		ITEM =  OZADDMENUITEM (IPULL, 'One cross hair'C, 801)
		ITEM =  OZADDMENUITEM (IPULL, 'One box cursor'C, 802)
		ITEM =  OZADDMENUITEM (IPULL, 'One circle'C, 803)
		ITEM =  OZADDMENUITEM (IPULL, 'One straight line'C, 804)
		ITEM =  OZADDMENUITEM (IPULL, 'One fixed size box'C, 805)
		ITEM =  OZADDMENUITEM (IPULL, 'Digitise one line'C, 806)
C	 INITIALISE GKS
		IDWS = 1	! WORKSTATION ID
		CALL GOPKS () ! OPEN GKS
		CALL GOPWK (10,1,2) ! OPEN WORKSTATION
		CALL GACWK (10) ! ACTIVATE
		CALL GSSEG (1)	! USE FIRST SEGMENT
		CALL GSVP (0,0.0,1.0,0.0,0.75) ! VIEWPORT
		CALL GSWN (0,0.0,10000.0,0.0,7500.0) ! WINDOW 1000X750
		CALL GSCLIP (1)  ! ON
		CALL GSCR (IDWS,0,0.5,0.5,0.5) ! BACKGROUND
		CALL GSCR (IDWS,1,0.0,0.0,1.0)
		CALL GSCR (IDWS,2,0.0,1.0,0.0)
		CALL GSCR (IDWS,3,0.0,1.0,1.0) ! SET COLOUR TABLE  (R,G,B)
		CALL GSCR (IDWS,4,1.0,0.0,0.0)
		CALL GSCR (IDWS,5,1.0,0.0,1.0)
		CALL GSCR (IDWS,6,1.0,1.0,0.0)
		CALL GSCR (IDWS,7,1.0,1.0,1.0)
		DO I=8 , 236
			CALL GSCR (IDWS,I,1.0,1.0,0.0)
		END DO
		CALL WINFNT ('Arial Bold'C, 1) ! DEFINE 1 FONT
		CALL MRKFNT ('Wingdings'C)		! marker font
		GKSOPEN = .TRUE.
	END IF
C
C	POPUP MENUS
C
	IF (IDENT.EQ.51)  THEN
		CALL OZCLEARPOPUPMENU
		ITEM =  OZADDPOPUPITEM ('Popup ITEM 1'C, 61)
		ITEM =  OZADDPOPUPITEM ('Popup ITEM 2'C, 62)
		CALL OZDISPLAYPOPUP
	END IF

	IF (IDENT.EQ.61)  THEN
		IDUM = OZMESSAGEBOX ('Popup ITEM 1 selected'C, 2, 2, 1)
		CALL OZDISPLAYPOPUP
	END IF

	IF (IDENT.EQ.62)  THEN
		IDUM = OZMESSAGEBOX ('Popup ITEM 2 selected'C, 2, 2, 1)
		CALL OZDISPLAYPOPUP
	END IF

C
C ====================================  MESSAGEBOXES ===========================
C
C	extern "C" long ozmessagebox (char* text, long* type, long* icon, long* button);
	IF (IDENT.GT.100.AND.IDENT.LT.199)  THEN
		IF (IDENT.EQ.101)  THEN
			ISEL = OZMESSAGEBOX (
     -			'Abort Retry Ignore/ Exclamation / Ignore'C, 1, 1, 3)
		END IF
		IF (IDENT.EQ.102)  THEN
			ISEL = OZMESSAGEBOX ('OK / Information'C, 2, 2, 1)
		END IF
		IF (IDENT.EQ.103)  THEN
			ISEL = OZMESSAGEBOX (
     -			'OK Cancel / Question / Cancel'C, 3, 3, 2)
		END IF
		IF (IDENT.EQ.104)  THEN
			ISEL = OZMESSAGEBOX (
     -			'Retry Cancel / Stop / Retry'C, 4, 4, 1)
		END IF
		IF (IDENT.EQ.105)  THEN
			ISEL = OZMESSAGEBOX ('Yes No'C, 5, 1, 1)
		END IF
		IF (IDENT.EQ.106)  THEN
			ISEL = OZMESSAGEBOX ('Yes No Cancel'C, 6, 1, 1)
		END IF
		IF (ISEL.EQ.1) THEN
			IDUM = OZMESSAGEBOX ('Abort button selected'C, 2, 2, 1)
		ELSE IF (ISEL.EQ.2) THEN
			IDUM = OZMESSAGEBOX ('Cancel button selected'C, 2, 2, 1)
		ELSE IF (ISEL.EQ.3) THEN
			IDUM = OZMESSAGEBOX ('Ignore button selected'C, 2, 2, 1)
		ELSE IF (ISEL.EQ.4) THEN
			IDUM = OZMESSAGEBOX ('No button selected'C, 2, 2, 1)
		ELSE IF (ISEL.EQ.5) THEN
			IDUM = OZMESSAGEBOX ('OK button selected'C, 2, 2, 1)
		ELSE IF (ISEL.EQ.6) THEN
			IDUM = OZMESSAGEBOX ('Retry button selected'C, 2, 2, 1)
		ELSE IF (ISEL.EQ.7) THEN
			IDUM = OZMESSAGEBOX ('Yes button selected'C, 2, 2, 1)
		END IF
	END IF

C ============================== MISC WINDOWS ===================================

	IF (IDENT.EQ.201)  THEN
		CALL OZTITLE('New window title'C)
	END IF

	IF (IDENT.EQ.203)  THEN
		CALL OZBUSY()
	END IF

	IF (IDENT.EQ.204)  THEN
		CALL OZNOTBUSY()
	END IF



C ====================== dialog boxes ==================================

	IF (IDENT.EQ.301)  THEN
		INT =  OZINTDLG(
	1    'Input an integer range -5 to 5, default -1'C, -5, 5, -1)
		WRITE (MSG,3011)  INT,NULL
3011	    FORMAT('Integer=',I10,A1)
		IDUM = OZMESSAGEBOX (MSG, 2, 2, 1)
	END IF


	IF (IDENT.EQ.302)  THEN
		R =  OZREALDLG(
	1         'Input a real value range -5.0 to 5.5, default 1.33'C,
	1                               -5.0, 5.5, 1.33)
		WRITE (MSG,3021)  R,NULL
3021	    FORMAT('Real=',F10.3,A1)
		IDUM = OZMESSAGEBOX (MSG, 2, 2, 1)
	END IF


	IF (IDENT.EQ.303)  THEN
		STRING = 'Initial value'C
		CALL OZSTRINGDLG ('Input a string of up to 20 chars'C, 
     1                                    STRING, 20)
		WRITE (MSG,3031)  STRING,NULL
3031	    FORMAT('String=',A,A1)
		IDUM = OZMESSAGEBOX (MSG, 2, 2, 1)
	END IF


	IF (IDENT.EQ.304)  THEN
		LBITEMS(1) = 'Dogs'C
		LBITEMS(2) = 'Cats'C
		LBITEMS(3) = 'Fish'C
		LBITEMS(4) = 'Horses'C
		N =  OZLISTBOXDLG('Select animal'C, LBITEMS, 30, 4)
		WRITE (MSG,3041)  N,NULL
3041	    FORMAT('Chosen item number',I2,A1)
		IDUM = OZMESSAGEBOX (MSG, 2, 2, 1)
	END IF


	IF (IDENT.EQ.305)  THEN
		OPEN (22, FILE='DLGDATA.TMP', STATUS='UNKNOWN')
		DO I=1,100
			WRITE (22, 3053)  I
3053			FORMAT('Item',I4)
		END DO
		CLOSE (22)
		CALL OZFILELISTBOXDLG('Select item'C, 'DLGDATA.TMP'C, 
     -                              ITEM, ITEMTEXT, 30)
	    WRITE (MSG,3056)  ITEM,ITEMTEXT,NULL
3056	    FORMAT('Chosen item number=',I4,' text=',A30,A1)
		IDUM = OZMESSAGEBOX (MSG, 2, 2, 1)
	END IF


	IF (IDENT.EQ.306)  THEN
		OPEN (22, FILE='DLGTEXT.TMP', STATUS='UNKNOWN')
		WRITE (22, 3063) 
3063		FORMAT('Yes'/'  I love'/'    you'/'      too!!!!')
		WRITE (22, 3064) 
3064		FORMAT('O yes I do')
		CLOSE (22)
		CALL OZTEXTDLG('DLGTEXT.TMP'C)
	END IF

C============================= Help menu =================================

	IF (IDENT.EQ.401)  THEN
		CALL OZHELPCONTENTS ('OZAPI.HLP'C)
	END IF

	IF (IDENT.EQ.402)  THEN
		CALL OZHELPINDEX ('OZAPI.HLP'C)
	END IF

	IF (IDENT.EQ.403)  THEN
		CALL OZABOUT()
	END IF

C============================= Common dialogs ===========================

	IF (IDENT.EQ.501)  THEN
		R = 1.0
		G = 1.0
		B = 0.0
		BOOL = OZCOLOURDLG (R, G, B, CUSTCOL)
		WRITE (MSG,5011)  BOOL, R,G,B, NULL
5011	    FORMAT('Bool=',L1, ' R=',F4.2, ' G=',F4.2, ' B=',F4.2, A1)
		IDUM = OZMESSAGEBOX (MSG, 2, 2, 1)
	END IF

	IF (IDENT.EQ.502)  THEN
		SAVEFILE = .TRUE.
		FILENAME = 'NONE'C
		FILTERNAME(1)    = 'Library Files (*.lib)'C
		FILTERPATTERN(1) = '*.lib'C
		FILTERNAME(2)    = 'Object files (*.obj)'C
		FILTERPATTERN(2) = '*.obj'C
		FILTERNAME(3)    = 'All Files (*.*)'C
		FILTERPATTERN(3) = '*.*'C
		BOOL = OZFILENAME (SAVEFILE, FILENAME, 256, 
	-            'File to save as'C,
	-            'lib'C, 'c:\\MsDev\\lib\\'C, 
     -            3, FILTERNAME(1), 50, FILTERPATTERN(1), 10)
		IF (BOOL) THEN
		    WRITE (MSG,5021)  FILENAME(1:50),NULL
5021			FORMAT('File name=',A50,A1)
			IDUM = OZMESSAGEBOX (MSG, 2, 2, 1)
		ELSE
			IDUM = OZMESSAGEBOX ('No file chosen'C, 2, 2, 1)
		ENDIF
	END IF

	IF (IDENT.EQ.503)  THEN
		SAVEFILE = .FALSE.
		FILENAME = 'AUTOEXEC.BAT'C
		FILTERNAME(1)    = 'Batch (*.bat)'C
		FILTERPATTERN(1) = '*.bat'C
		FILTERNAME(2)    = 'All Files (*.*)'C
		FILTERPATTERN(2) = '*.*'C
		BOOL = OZFILENAME (SAVEFILE, FILENAME, 256, 
	-            'File to open for reading'C,
	-            'bat'C, 'c:\\'C, 
     -            2, FILTERNAME, 50, FILTERPATTERN, 10)
		IF (BOOL) THEN
		    WRITE (MSG,5031)  FILENAME(1:50),NULL
5031			FORMAT('File name=',A50,A1)
			IDUM = OZMESSAGEBOX (MSG, 2, 2, 1)
		ELSE
			IDUM = OZMESSAGEBOX ('No file chosen'C, 2, 2, 1)
		ENDIF
	END IF



C============================= GKS Graphics===========================



C LINES
	IF (IDENT.EQ.602)  THEN
		CALL GCLRWK (IDWS,1) ! CLEAR
		CALL GSSEG (1)	! USE FIRST SEGMENT
		CALL GSVP (0,0.0,0.5,0.0,0.375) ! VIEWPORT BOTTOM LEFT
		CALL GSWN (0,0.0,10000.0,0.0,7500.0) ! WINDOW 1000X750
		CALL GSCLIP (1)  ! ON
		YBASE = 1000.0
	    IFIRST = 0	! FIRST HANDLE FOR UPDATE
		DO ITYPE = 1 , 4
			YBASE = YBASE + 500.0
			IFLOP = 1000
			DO IX=1 , 10
				X = 500.0 * IX + 3000.0
				IFLOP = -IFLOP
				Y = YBASE + IFLOP
				PX(IX) = X
				PY(IX) = Y
			END DO
			PX(10) = PX(1)
			PY(10) = PY(1)
			CALL GSLN (ITYPE) ! LINE TYPE (ONLY WIDTH 1)
			CALL GSLW (ITYPE) ! LINE WIDTH
			CALL GSPLCI (ITYPE) ! COLOUR INDEX
			IHANDLE = GPL (10,PX,PY) ! POLYLINE
	  IF (IFIRST.EQ.0)  IFIRST = IHANDLE
	  END DO
	  CALL GUWK (IDWS,1)
	  CALL GSLW (1)
	END IF
C
C MARKERS (ON LINE GRID) FROM BOTTOM LEFT
	IF (IDENT.EQ.603)  THEN
        CALL GCLRWK (IDWS,1) ! CLEAR
	  CALL GSSEG (22)	! SEGMENT
	  CALL GSVP (0,0.0,1.0,0.0,0.75) ! VIEWPORT
	  CALL GSWN (0,0.0,10000.0,0.0,7500.0) ! WINDOW 1000X750
	  CALL GSCLIP (1)  ! ON
	  DO LINE=1,16
	    CALL HLINE (500.0, 8000.0, 300.0 * LINE)
	  END DO
	  DO J=1,16
	    CALL VLINE (300.0, 4800.0, 450.0 * J)
	  END DO
        CALL GSPMCI (4) ! MARKER COLOUR INDEX
	  CALL GSMKSIZE (0.02) ! SIZE
	  IFIRST = 0	! FIRST HANDLE FOR UPDATE
	  MARKER = 0
	  DO LINE=1,16
		PY(1) = 300.0 * LINE
		DO J=1,16
	        PX(1) = 450.0 * J
			CALL GSMK (MARKER) ! MARKER TYPE
			MARKER = MARKER + 1
			IHANDLE = GPM (1,PX,PY) ! POLYMARKER
	        IF (IFIRST.EQ.0)  IFIRST = IHANDLE
		END DO
	  END DO
	  CALL GUWK (IDWS,1)
	END IF
C
C TEXT
 	IF (IDENT.EQ.604)  THEN
	  CALL GCLRWK (IDWS,1) ! CLEAR
	  CALL GSSEG (23)	! SEGMENT
	  CALL GSVP (0,0.5,1.0,0.375,0.75) ! VIEWPORT TOP RIGHT
	  CALL GSWN (0,0.0,10000.0,0.0,7500.0) ! WINDOW 1000X750
	  CALL GSCLIP (1)  ! ON
	  Y = 1000.0
	  CALL GSTXFP (1,0) ! FONT & PRECISION
	  CALL GSCHXP(0.5)
	  CALL VLINE (50.0, 7000.0, 2000.0)
	  DO ITEXT=1 , 4
		  CALL HLINE (0.0, 5000.0, Y)
		  CALL GSTXCI (ITEXT) ! COLOUR INDEX
		  CHH = 200.0 * ITEXT
		  CALL GSCHH (CHH) ! HEIGHT
		  CALL GSTXP (0) ! PATH TO RIGHT
		  IF (ITEXT.LT.3) THEN
			CALL GSTXAL (1,4) ! LEFT, BASE
	      ELSE
			CALL GSTXAL (3,4) ! RIGHT, BASE
	      END IF
		  IHANDLE = GTX (2000.0,Y,'HORIZONTAL'C)
		  Y = Y + 500.0
	  END DO
	  CALL GUWK (IDWS,1)
	END IF
C
C CENTRED TEXT
	IF (IDENT.EQ.605)  THEN
		CALL GCLRWK (IDWS,1) ! CLEAR
		CALL GSSEG (24)	! SEGMENT
		CALL GSVP (0,0.0,1.0,0.0,0.75) ! VIEWPORT
		CALL GSWN (0,0.0,10000.0,0.0,7500.0) ! WINDOW 1000X750
		CALL GSCLIP (1)  ! ON
		Y = 1000.0
	    CALL GSTXFP (1,0) ! FONT & PRECISION
	    CALL GSCHXP(0.5)
	    CALL VLINE (50.0, 7000.0, 5000.0)
		DO ITEXT=1 , 4
		  CALL HLINE (0.0, 10000.0, Y)
		  CALL GSTXCI (ITEXT) ! COLOUR INDEX
		  CHH = 100.0 * ITEXT
		  CALL GSCHH (CHH) ! HEIGHT
		  CALL GSTXP (0) ! PATH TO RIGHT
		  CALL GSTXAL (2,4) ! CENTRE, BASE
		  IHANDLE = GTX (5000.0,Y,'CENTRED'C)
		  Y = Y + 1000.0
	   END DO
	  CALL GUWK (IDWS,1)
	END IF
C
C VERTICAL TEXT
	IF (IDENT.EQ.606)  THEN
	  CALL GCLRWK (IDWS,1) ! CLEAR
	  CALL GSSEG (25)	! SEGMENT
	  CALL GSVP (0,0.0,1.0,0.0,0.75) ! VIEWPORT
	  CALL GSWN (0,0.0,100.0,0.0,75.0) ! WINDOW 1000X750
	  CALL GSCLIP (1)  ! ON
	  X = 10.0
	  CALL GSTXFP (1,0) ! FONT & PRECISION
	  CALL GSCHXP(0.5)
	  CALL HLINE (0.0, 80.0, 50.0)
	  DO ITEXT=1 , 4
	      CALL VLINE (0.0, 70.0, X)
		  CALL GSTXCI (ITEXT) ! COLOUR INDEX
		  CHH = 1.0 * ITEXT
		  CALL GSCHH (CHH) ! HEIGHT
		  CALL GSTXP (3) ! PATH DOWN
			CALL GSTXAL (1,1) ! LEFT, TOP
		  IHANDLE = GTX (X,50.0,'VERTICAL'C)
		   X = X + 10.0
	  END DO
	  CALL GUWK (IDWS,1)
	END IF
C
C POLYGONS & RECTANGLES
	IF (IDENT.EQ.607)  THEN
	  CALL GUWK (IDWS,1)
	  CALL GCLRWK (IDWS,1) ! CLEAR
	  CALL GSSEG (26)	! SEGMENT
	  CALL GSCLIP (0)  ! OFF
	  CALL GSVP (0,0.0,1.0,0.0,0.75) ! VIEWPORT

	  CALL GSWN (0, 0.0, 1.0, 0.0, 1.0)	! FIRST DRAW OUTSIDE LINE
	  CALL GSLN (1) ! LINE TYPE
	  CALL GSLW (1) ! LINE WIDTH
	  CALL GSPLCI (2) ! COLOUR INDEX
	  PX(1) = 0.0
	  PY(1) = 0.0
	  PX(2) = 0.0
	  PY(2) = 1.0 ! BOUNDARY
	  PX(3) = 1.0
	  PY(3) = 1.0
	  PX(4) = 1.0
	  PY(4) = 0.0
	  PX(5) = 0.0
	  PY(5) = 0.0
	  IHANDLE = GPL (5,PX,PY) ! POLYLINE

	  CALL GSWN (0, 0.0,10000.0, 0.0,7500.0) ! WINDOW 

	  CALL GSFAIS (1) ! SOLID FILL
	  CALL GSFACI (4) ! COLOUR INDEX
	  IHANDLE = GFRECT (500.0, 9500.0, 500.0, 7500.0)
	  IFIRST = IHANDLE ! HOLD FOR UPDATE

	  PX(1) = 0.0
	  PY(1) = 0.0
	  PX(2) = 10000.0
	  PY(2) = 4000.0 ! TRIANGLE
	  PX(3) = 7500.0
	  PY(3) = 2000.0
	  PX(4) = 0.0
	  PY(4) = 0.0
	  CALL GSFAIS (1) ! SOLID FILL
	  CALL GSFACI (6) ! COLOUR INDEX
	  IHANDLE = GFA (4,PX,PY,.FALSE.) ! POLYGON

	  CALL GSFAIS (4) ! CROSS HATCH
	  CALL GSFACI (5) ! COLOUR INDEX
	  CALL GSPLCI (3) ! LINE COLOUR INDEX
	  PX(1) = 1000.0
	  PY(1) = 2000.0
	  PX(2) = 5000.0
	  PY(2) = 7000.0 ! TRIANGLE
	  PX(3) = 8000.0
	  PY(3) = 3000.0
	  PX(4) = 1000.0
	  PY(4) = 2000.0
	  IHANDLE = GFA (4,PX,PY,.TRUE.) ! POLYGON
	  CALL GUWK (IDWS,1)
	END IF

C  SHOW 128 COLOURS
	IF (IDENT.EQ.608)  THEN
	  CALL GUWK (IDWS,1)
	  CALL GCLRWK (IDWS,1) ! CLEAR
	  CALL GSSEG (29)	! SEGMENT
	  CALL GSCLIP (0)  ! OFF
	  CALL GSVP (0,0.0,1.0,0.0,0.5) ! VIEWPORT

	  IPAL = 8		! LOAD UP COLOUR PALETTE
	  ICOL = 1
	  DO I=1, 120
		B = PALCOL(ICOL)
		G = PALCOL(ICOL+1)
		R = PALCOL(ICOL+2)
		ICOL = ICOL + 3
		CALL GSCR (IDWS,IPAL, R, G, B)
		IPAL= IPAL + 1
	  END DO

	  CALL GSWN (0, 0.0, 15.0, 0.0, 7.0) ! WINDOW 

	  CALL GSFAIS (1) ! SOLID FILL
	  ICOL = 0
	  DO IY=1,8
		Y = IY - 1
		DO IX=1,16
			X = IX - 1
			CALL GSFACI (ICOL) ! COLOUR INDEX
			ICOL = ICOL + 1
			IHANDLE = GFRECT (X, X+1.0, Y, Y+1.0)
		END DO
	  END DO
	  CALL GUWK (IDWS,1)
	END IF
C UPDATE LINES IF CURRENT DISPLAY
	IF (IPREV.EQ.602.AND.IDENT.EQ.612)  THEN
	    IHAND = IFIRST
		DO ITYPE = 1 , 4
			KTYPE = 5 - ITYPE 
        CALL GUPDPL (IHAND, KTYPE, 1, KTYPE)  
	  IHAND = IHAND + 1        
	  END DO
	  CALL GUWK (IDWS,1)
	  CALL GSLW (1)
	END IF

C UPDATE MARKERS IF CURRENT DISPLAY
	IF (IPREV.EQ.603 .AND. IDENT.EQ.613)  THEN
        CALL GSPMCI (4) ! MARKER COLOUR INDEX
	  IHAND = IFIRST
	  MARKER = 0
	  DO LINE=1,16
		DO J=1,16
			MARKER = MARKER + 1
			CALL GUPDPM   (IHAND, 0.01, 6)   
			IHAND = IHAND + 1       
		END DO
	  END DO
	  CALL GUWK (IDWS,1)
	END IF

C
C UPDATE POLYGONS & RECTANGLES IF CURRENT DISPLAY
	IF (IPREV.EQ.607 .AND. IDENT.EQ.617)  THEN
	  IHAND = IFIRST
	  DO IPOLY=1,3
		CALL GUPDFA   (IHAND, IPOLY)   
		IHAND = IHAND + 1       
	  END DO
	CALL GUWK (IDWS,1)
	END IF



C ============== GKS cursor mode =============================


	IF (IDENT.GE.700.AND.IDENT.LT.790)  THEN
	  CURSOR(1) = 0.0	! CURSOR DATA USUALLY NOT REQUIRED
	  CURSOR(2) = 0.0
        CALL GCLRWK (IDWS,1) ! DISPLAY GRID FOR CHECKING SELECTION (SPACING 1000)
	  CALL GSSEG (31)	! SEGMENT
	  CALL GSVP (0,0.0,1.0,0.0,0.75) ! VIEWPORT
	  CALL GSWN (0,0.0,10000.0,0.0,7500.0) ! WINDOW 1000X750
	  CALL GSCLIP (0)  ! OFF
	  DO J=1,7
	    CALL HLINE (0.0, 10000.0, 1000.0 * J)
	  END DO
	  DO J=1,9
	    CALL VLINE (0.0, 7500.0, 1000.0 * J)
	  END DO
	  CALL GUWK (IDWS,1)
	END IF

C DISABLE CURSOR

	IF (IDENT.EQ.700)  THEN
	   CALL GINLC (IDWS, 0, CURSOR, 700)
	END IF

C  CROSS HAIR

	IF (IDENT.EQ.701)  THEN
	   CALL GINLC (IDWS, 1, CURSOR, 701)
	END IF
C  BOX CURSOR

	IF (IDENT.EQ.702)  THEN
	   CALL GINLC (IDWS, 2, CURSOR, 702)
	END IF

C  CIRCLE

	IF (IDENT.EQ.703)  THEN
	   CALL GINLC (IDWS, 3, CURSOR, 703)
	END IF

C  STRAIGHT LINE

	IF (IDENT.EQ.704)  THEN
	   CALL GINLC (IDWS, 4, CURSOR, 704)
	END IF

C  FIXED SIZE BOX

	IF (IDENT.EQ.705)  THEN
	   CURSOR(1) = 1000.0	! SET INITIAL SIZE
	   CURSOR(2) = 500.0
	   CALL GINLC (IDWS, 5, CURSOR, 705)
	END IF

C  DIGITISE LINE

	IF (IDENT.EQ.706)  THEN
	   CALL GINLC (IDWS, 6, CURSOR, 706)
	END IF
	IF (IDENT.GE.700.AND.IDENT.LT.790)  THEN
	  CURSOR(1) = 0.0	! CURSOR DATA USUALLY NOT REQUIRED
	  CURSOR(2) = 0.0
        CALL GCLRWK (IDWS,1) ! DISPLAY GRID FOR CHECKING SELECTION (SPACING 1000)
	  CALL GSSEG (31)	! SEGMENT
	  CALL GSVP (0,0.0,1.0,0.0,0.75) ! VIEWPORT
	  CALL GSWN (0,0.0,10000.0,0.0,7500.0) ! WINDOW 1000X750
	  CALL GSCLIP (0)  ! OFF
	  DO J=1,7
	    CALL HLINE (0.0, 10000.0, 1000.0 * J)
	  END DO
	  DO J=1,9
	    CALL VLINE (0.0, 7500.0, 1000.0 * J)
	  END DO
	  CALL GUWK (IDWS,1)
	END IF

C ============== GKS locator =============================

	IF (IDENT.GE.800.AND.IDENT.LT.890)  THEN
C       CALL GCLRWK (IDWS,1) ! DISPLAY GRID FOR CHECKING SELECTION (SPACING 1000)
	  CALL GSSEG (41)	! SEGMENT
	  CALL GSVP (0,0.0,1.0,0.0,0.75) ! VIEWPORT
	  CALL GSWN (0,0.0,10000.0,0.0,7500.0) ! WINDOW 1000X750
	  CALL GSCLIP (0)  ! OFF
	  DO J=1,7
	    CALL HLINE (0.0, 10000.0, 1000.0 * J)
	  END DO
	  DO J=1,9
	    CALL VLINE (0.0, 7500.0, 1000.0 * J)
	  END DO
	  CALL GSLN (1) ! LINE TYPE
	  CALL GSLW (1) ! LINE WIDTH
	  CALL GSPLCI (1) ! COLOUR INDEX
	END IF

C  CROSS HAIR

	IF (IDENT.EQ.801)  THEN
	   CALL GRQLC  (IDWS, PX1, PY1)
         CALL GSPMCI (2) ! MARKER COLOUR INDEX
	   CALL GSMKSIZE (0.02) ! SIZE
	   CALL GSMK (76) ! MARKER TYPE
	   PX(1) = PX1
	   PY(1) = PY1
	   IHANDLE = GPM (1, PX, PY) ! POLYMARKER
	END IF

C  BOX CURSOR

	IF (IDENT.EQ.802)  THEN
	  CALL GRQBOX  (IDWS, PX1, PY1, PX2, PY2)
	  CALL GSFAIS (1) ! SOLID FILL
	  CALL GSFACI (2) ! COLOUR INDEX
	  IHANDLE = GFRECT (PX1, PX2, PY1, PY2)
	END IF

C  CIRCLE

	IF (IDENT.EQ.803)  THEN
	   CALL GRQCIRC  (IDWS, PX1, PY1, RADIUS)
         CALL GSPMCI (2) ! MARKER COLOUR INDEX
	   CALL GSMK (181) ! MARKER TYPE
	   CALL GSMKSIZE (2.0 * RADIUS/10000.0) ! SIZE
	   PX(1) = PX1
	   PY(1) = PY1
	   IHANDLE = GPM (1, PX, PY) ! POLYMARKER
	END IF

C  STRAIGHT LINE

	IF (IDENT.EQ.804)  THEN
	   CALL GRQLIN  (IDWS, PX1, PY1, PX2, PY2)
	   PX(1) = PX1
	   PX(2) = PX2
	   PY(1) = PY1
	   PY(2) = PY2
	   IHAND = GPL (2,PX,PY)
	END IF

C  FIXED SIZE BOX

	IF (IDENT.EQ.805)  THEN
	   PX1 = 0.0	! SET INITIAL SIZE
	   PX2 = 1000.0
	   PY1 = 0.0
	   PY2 = 500.0
	   CALL GRQFB  (IDWS, PX1, PY1, PX2, PY2)
	   CALL GSFAIS (1) ! SOLID FILL
	   CALL GSFACI (2) ! COLOUR INDEX
	  IHANDLE = GFRECT (PX1, PX2, PY1, PY2)
	END IF

C  DIGITISE LINE

	IF (IDENT.EQ.806)  THEN
	   CALL GRQDIG  (IDWS, PX, PY, 1000, NUMDIG)
	   IHAND = GPL (NUMDIG, PX, PY)
	END IF

	IF (IDENT.GE.800.AND.IDENT.LT.890)  THEN
	  CALL GUWK (IDWS,1)
	END IF


c ==================================================================================

C  STORE PREVIOUS MENU SELECTION
	IPREV = IDENT
	RETURN
	END

C ********************************************************************************
C
C	VERTICAL & HORIZONTAL; LINES FOR GKS TESTING
C
	SUBROUTINE HLINE (X1, X2, Y)
	INCLUDE	"OZAPI.INC"
	DIMENSION PX(2), PY(2)
	PY(1) = Y
	PY(2) = Y
	PX(1) = X1
	PX(2) = X2
	CALL GSLN (1) ! LINE TYPE
	CALL GSLW (1) ! LINE WIDTH
	CALL GSPLCI (6) ! COLOUR INDEX
	IHAND = GPL (2,PX,PY)
	RETURN
	END
C
	SUBROUTINE VLINE (Y1, Y2, X)
	INCLUDE	"OZAPI.INC"
	DIMENSION PX(2), PY(2)
	PY(1) = Y1
	PY(2) = Y2
	PX(1) = X
	PX(2) = X
	CALL GSLN (1) ! LINE TYPE
	CALL GSLW (1) ! LINE WIDTH
	CALL GSPLCI (7) ! COLOUR INDEX
	IHAND = GPL (2,PX,PY)
	RETURN
	END

