# AC3D tcl functions


#init the globals
set select_mode "tree"
set load_file_path [pwd]
set save_file_path [pwd]
set texture_file_path [pwd]

if { $tcl_platform(platform) == "windows" } {
    set old_file_dialog 0
} else {
    set old_file_dialog 1
}

set motif_file_dialog 0





# the last ac file loaded or saved
set acfilename ""

set filetypes  {
{{ AC3D files} {.ac}}
}

proc show_message { mess } {

option add *Dialog.msg.wrapLength 60c
tk_messageBox -message $mess -title "AC3D Message" -type ok
#    tk_dialog .dialog "AC3D message" $mess "" -1 "Close"
    update
}


proc get_openfilename { title suffix { name "" } } {
global fsBox
global old_file_dialog
global motif_file_dialog
global tk_strictMotif
global filetypes


    if { $old_file_dialog } {
        set fsBox(pattern) "*$suffix"
        set filename [FSBox $title $name]
    } else {
        set old_strictmotif $tk_strictMotif
        if { $motif_file_dialog } {
            set tk_strictMotif 1
        } else {
            set tk_strictMotif 0
        }

        set filename [tk_getOpenFile -title $title -defaultextension $suffix \
		    -filetypes $filetypes]
        set tk_strictMotif $old_strictmotif
    }
    return $filename
}

proc get_savefilename { title suffix { name "" } } {
global fsBox
global old_file_dialog
global motif_file_dialog
global tk_strictMotif
global filetypes

    if { $old_file_dialog } {
        set fsBox(pattern) "*$suffix"
        set filename [FSBox $title $name]
    } else {
        set old_strictmotif $tk_strictMotif
        if { $motif_file_dialog } {
            set tk_strictMotif 1
        } else {
            set tk_strictMotif 0
        }

        set filename [tk_getSaveFile -title $title -defaultextension $suffix \
		     -filetypes $filetypes ]
        set tk_strictMotif $old_strictmotif
    }
    return $filename
}


proc update_savefile_menu {} {
global acfilename

    set name [file tail $acfilename]
    if { $acfilename != "" } {
        .mbar.file.menu entryconfigure 1 -state normal
        .mbar.file.menu entryconfigure 1 -label "Save $name"
    } else {
        .mbar.file.menu entryconfigure 1 -state disabled
    }
}


proc menu_load_ac {} {
global acfilename;
global filetypes
global fsBox 
global load_file_path

set filetypes  {
{{ AC3D files} {.ac}}
{{ All files} *}
}

    set fsBox(path) $load_file_path
    set filename [get_openfilename "Load AC3D file" ".ac" $acfilename]
    if { $filename != "" } {
        ac3d load_ac $filename
        set acfilename $filename
        update_savefile_menu
        sync_ui
        set load_file_path $fsBox(path)
    }
}




# save the current model with the last filename used - if blank then get filename

proc menu_save_last {} {
    global acfilename;

    if { $acfilename != "" } {
        ac3d save_ac $acfilename
    } else {
        menu_save_ac
    }
}


proc menu_load_texture {} {
global filetypes
global tcl_platform
global fsBox
global texture_file_path

if { $tcl_platform(platform) != "windows" } {
    set filetypes  {
    {{ RGB texture files} {.rgb}}
    {{ All files} *}
}

} else {
set filetypes  {
{{ Bitmap picture files} {.bmp}}
{{ All files} *}
}
}


    set fsBox(path) $texture_file_path
    set filename [get_openfilename "Load texture file" ".rgb"]

    if { $filename != "" } {
        ac3d load_and_set_new_texture $filename
        set texture_file_path $fsBox(path)
    }
}


proc menu_load_background_image { win } {
global filetypes
global tcl_platform
global fsBox
global texture_file_path

if { $tcl_platform(platform) != "windows" } {
    set filetypes  {
    {{ RGB texture files} {.rgb}}
    {{ All files} *}
}

} else {
set filetypes  {
{{ Bitmap picture files} {.bmp}}
{{ All files} *}
}
}
    set fsBox(path) $texture_file_path
    set filename [get_openfilename "Load background image file" ".rgb"]

    if { $filename != "" } {
        ac3d load_background_image $filename $win
        set texture_file_path $fsBox(path)
    }
}




proc menu_quit {} {
#    if { [ tk_dialog .dialog "Quit AC3D!" "Quit - Are you sure?" "" -1 "Quit" "Cancel"] == 0 } {
#        exit
#    }
    
    set answer [tk_messageBox -message "Quit AC3D?" -title "Quit?" -type yesno -icon question]
    case $answer {
        yes exit
        no {}
    }
}

proc menu_clear {} {
#    if { [ tk_dialog .dialog "Delete current model?" "Clear - Are you sure?" "" -1 "Clear" "Cancel"] == 0 } {
#        ac3d clear_all
#        sync_ui
#    }


    set answer [tk_messageBox -message "Clear - Are you sure?" -title "Delete current model?" -type yesno -icon question]
    case $answer {
        yes {
             ac3d clear_all
             ac3d redraw_orth
             sync_ui
             }
        no {}
    }
}


proc save_confirm {title ac3dcommand pattern { name "" } } {
global old_file_dialog

    set filename [get_savefilename $title $pattern $name]

    if { $filename == "" } {
        return
    }

    if  { ( $old_file_dialog == 1 ) && [file exists $filename ] } {
        set result [tk_dialog .dialog "$title Overwrite existing file?" \
            "there is already a file with this name - Overwrite it?" \
            "" 0 "Overwrite" "Cancel"]

        if { $result != 0 } {
            return
        }
    }

    ac3d $ac3dcommand $filename
    return $filename
}

proc menu_save_ac {} {

global acfilename
global filetypes
global fsBox
global save_file_path

set filetypes  {
{{ AC3D model files} {.ac}}
}

    set fsBox(path) $save_file_path
    set newname [save_confirm "Save AC3D file" "save_ac" ".ac" $acfilename]
    if { $newname != "" } {
        set acfilename $newname
        update_savefile_menu
        set save_file_path $fsBox(path)
    }
}


proc menu_save_selection {} {

global acfilename;
global filetypes
global fsBox
global save_file_path

set filetypes  {
{{ AC3D model files} {.ac}}
}
    set fsBox(path) $save_file_path
    set newname [save_confirm "Save selection as AC3D file" "save_selection_ac" ".ac" $acfilename]
    set save_file_path $fsBox(path)

#    if { $newname != "" } {
#        set acfilename $newname
#        update_savefile_menu
#    }
}


proc menu_write_dive {} {
global filetypes
global fsBox
global save_file_path

set filetypes  {
{{ Dive files} {.vr}}
}
    set fsBox(path) $save_file_path
    save_confirm "Save Dive file" "write_dive" ".vr"
    set save_file_path $fsBox(path)

}

proc menu_write_vrml {} {
global filetypes
global fsBox
global save_file_path

set filetypes  {
{{ VRML files} {.wrl}}
}
    set fsBox(path) $save_file_path
    save_confirm "Write VRML 1 file" "write_vrml" ".wrl"
    set save_file_path $fsBox(path)

}


proc menu_write_vrml2 {} {
global filetypes
global fsBox
global save_file_path

set filetypes  {
{{ VRML files} {.wrl}}
}
    set fsBox(path) $save_file_path
    save_confirm "Write VRML 2 file" "write_vrml2" ".wrl"
    set save_file_path $fsBox(path)

}

proc menu_write_massive {} {
global filetypes

set filetypes  {
{{ Massive format files} {.massive}}
}
    save_confirm "Write Massive file" "write_massive" ".massive"
}

proc menu_write_rib {} {
global filetypes
global fsBox
global save_file_path

set filetypes  {
{{ Renderman files} {.rib}}
}
    set fsBox(path) $save_file_path
    save_confirm "Write RenderMan file" "write_rib" ".rib"
    set save_file_path $fsBox(path)
}

proc menu_write_POV {} {
global filetypes
global fsBox
global save_file_path

set filetypes  {
{{ POV files} {.pov}}
}
    set fsBox(path) $save_file_path
    save_confirm "Write POV file" "write_POV" ".pov"
    set save_file_path $fsBox(path)
}

proc menu_write_DVS {} {
global filetypes
global fsBox
global save_file_path

set filetypes  {
{{ All files} {*}}
}
    set fsBox(path) $save_file_path
    save_confirm "Write DVS" "write_dvs" ".*"
    set save_file_path $fsBox(path)
}

proc menu_write_triangles {} {
global filetypes
global fsBox
global save_file_path

set filetypes  {
{{ Triangle files} {.tri}}
}
    set fsBox(path) $save_file_path
    save_confirm "Write TRI" "write_tri" ".tri"
    set save_file_path $fsBox(path)
}


proc menu_import_dxf {} {
global filetypes
global fsBox
global load_file_path

set filetypes  {
{{ DXF files} {.dxf}}
{{ All files} *}
}
    set fsBox(path) $load_file_path
    set filename [get_openfilename "Import DXF file" .dxf]
    set load_file_path $fsBox(path)

    if { $filename != "" } {
        ac3d import_dxf $filename
        sync_ui
    }
}

proc menu_import_3DS {} {
global filetypes
global fsBox
global load_file_path

set filetypes  {
{{ 3D Studio files} {.3ds}}
{{ All files} *}
}
    set fsBox(path) $load_file_path
    set filename [get_openfilename "Import 3DS file" .3ds]
    set load_file_path $fsBox(path)

    if { $filename != "" } {
        ac3d import_3ds $filename
        sync_ui
    }
}


proc menu_import_lightwave {} {
global filetypes
global fsBox
global load_file_path

set filetypes  {
{{ Lightwave object files} {.lwo}}
{{ Lightwave scene files} {.lws}}
{{ All files} *}
}
    set fsBox(path) $load_file_path
    set filename [get_openfilename "Import Lightwave file" .lwo]
    set load_file_path $fsBox(path)

    if { $filename != "" } {
        ac3d import_lightwave $filename
        sync_ui
    }
}

proc menu_import_triangles {} {
global filetypes
global fsBox
global load_file_path

set filetypes  {
{{ Triangle files} {.tri}}
{{ All files} *}
}
    set fsBox(path) $load_file_path
    set filename [get_openfilename "Import Triangle file" .tri]
    set load_file_path $fsBox(path)

    if { $filename != "" } {
        ac3d import_tri $filename
        sync_ui
    }
}


proc menu_import_vector {} {
global filetypes
global fsBox
global load_file_path

set filetypes  {
{{ Vector files} {.r2v}}
{{ All files} *}
}
    set fsBox(path) $load_file_path
    set filename [get_openfilename "Import vector file" .r2v]
    set load_file_path $fsBox(path)

    if { $filename != "" } {
        ac3d import_vector $filename
        sync_ui
    }
}

proc menu_import_vrml {} {
global filetypes
global fsBox
global load_file_path

set filetypes  {
{{ VRML files} {.wrl}}
{{ All files} *}
}
    set fsBox(path) $load_file_path
    set filename [get_openfilename "Import VRML 1 file" .wrl]
    set load_file_path $fsBox(path)

    if { $filename != "" } {
        ac3d import_vrml $filename
        sync_ui
    }
}



proc update_selected_message {} {
global numselected
global numselectedobjects
global select_mode
global select_info

    if { ( $numselected == 0 ) && ( $numselectedobjects == 0 ) } {
        set select_info "Nothing selected"
        return
    }

    if { $select_mode == "tree" } {
        set select_info "Groups/Objects selected: $numselectedobjects"
    } elseif { $select_mode == "object" } {
        set select_info "Objects selected: $numselectedobjects"
    } elseif { $select_mode == "light" } {
        set select_info "Lights selected: $numselectedobjects"
    } else {
        set select_info "Vertices selected: $numselected"
    }
}



proc disable_object_data {} {
    set_sensitive FALSE  .current_object_name_entry
 #.current_object_url

    if { [winfo exists .d] } {
        set_sensitive FALSE .d.object_data .d.hf.object_name_entry .d.hf.object_url_entry
    }

}

proc enable_object_data {} {
    set_sensitive TRUE  .current_object_name_entry 
#.current_object_url

    if { [winfo exists .d] } {
        set_sensitive TRUE .d.object_data .d.hf.object_name_entry .d.hf.object_url_entry
       }
}

proc menu_set_sensitive { name bool } {
global tcl_version

    if { $bool } {
	    set t normal
	} else {
	    set t disabled
	}

    if { $tcl_version >= 8 } {
        switch $name {
	        object { .poo entryconfigure 3 -state $t }
	    	surface { .poo entryconfigure 4 -state $t  }
		vertex { .poo entryconfigure 5 -state $t }
	    }
	} else {
        switch $name {
	        object { .mbar.object configure -state $t }
	    	surface { .mbar.surface configure  -state $t  }
		vertex { .mbar.vertex configure  -state $t }
	    }   
    }

}



proc do_ui_sensitivity {} {
    global numselected
    global numselectedobjects
    global select_mode
    global objects_are_hidden
    global undo_count
    global undo_string

#puts "selectedmode $select_mode    $numselected $numselectedobjects"

    if { ( $numselectedobjects == 1 ) } {
        enable_object_data
    } else {
        disable_object_data
    }


    if { ( $numselectedobjects == 0 ) && ($numselected == 0 ) } {
    # NOTHING IS SELECTED
        set_sensitive false \
              .function_group\
              .function_ungroup\
              .function_mirrorx \
              .function_mirrory \
              .function_mirrorz \
              .function_double_size\
              .function_half_size\
              .function_plus_size\
              .function_minus_size\
              .hide_selected


        menu_set_sensitive object false
        menu_set_sensitive surface false
        menu_set_sensitive vertex false
        set_sensitive false .drag_mode_extrude

        #disable surface type stuff
        set_sensitive false \
            .function_surface_poly \
           .function_surface_polyline \
           .function_surface_line \
           .function_surface_smooth \
           .function_surface_flat \
           .function_surface_one_sided \
           .function_surface_two_sided

        # DISABLE SOME MENU ITEMS
        # edit->duplicate
        .mbar.edit.menu entryconfigure 2 -state disabled
        # edit->delete
        .mbar.edit.menu entryconfigure 3 -state disabled
        # edit->delete_all (clear)
        .mbar.edit.menu entryconfigure 4 -state disabled
        # edit->deselect all
        .mbar.edit.menu entryconfigure 7 -state disabled
        # edit->move and size to
        .mbar.edit.menu entryconfigure 11 -state disabled
        .mbar.edit.menu entryconfigure 12 -state disabled

        #view->fit&goto selection
        .mbar.view.menu entryconfigure 3 -state disabled
        .mbar.view.menu entryconfigure 4 -state disabled
        #view->3d_view selection
        .mbar.view.menu entryconfigure 7 -state disabled



    } else {
    # SOMETHING IS SELECTED

    # enable functions that work on objects and vertices
        set_sensitive true \
              .function_mirrorx \
              .function_mirrory \
              .function_mirrorz \
              .function_double_size\
              .function_half_size\
              .function_plus_size\
              .function_minus_size\
              .hide_selected


        #Enable surface type stuff
        set_sensitive true \
            .function_surface_poly \
           .function_surface_polyline \
           .function_surface_line \
           .function_surface_smooth \
           .function_surface_flat \
           .function_surface_one_sided \
           .function_surface_two_sided


        menu_set_sensitive surface true

        # ENABLE SOME MENU ITEMS
        # edit->duplicate
        .mbar.edit.menu entryconfigure 2 -state normal
        # edit->delete
        .mbar.edit.menu entryconfigure 3 -state normal
        # edit->delete_all (clear)
        .mbar.edit.menu entryconfigure 4 -state normal
        # edit->deselect all
        .mbar.edit.menu entryconfigure 7 -state normal
        # edit->move and size to
        .mbar.edit.menu entryconfigure 11 -state normal
        .mbar.edit.menu entryconfigure 12 -state normal

        #view->fit&goto selection
        .mbar.view.menu entryconfigure 3 -state normal
        .mbar.view.menu entryconfigure 4 -state normal
        #view->3d_view selection
        .mbar.view.menu entryconfigure 7 -state normal




        if { $select_mode == "tree"} {

         if { $numselectedobjects == 0 } {
             set_sensitive FALSE .function_group .function_ungroup 
         } elseif { $numselectedobjects == 1 } {
             set_sensitive TRUE .function_ungroup 
             set_sensitive FALSE .function_group
         } elseif { $numselectedobjects > 1 } {
             set_sensitive TRUE .function_group .function_ungroup
         }

        } else { #disable group/ungroup for any mode apart from TREE
            set_sensitive FALSE .function_group .function_ungroup 
        }


        if { $select_mode != "vertex" } {
            set_sensitive true .drag_mode_extrude
            menu_set_sensitive vertex false
           # disable edit->select whole surfaces
           .mbar.edit.menu entryconfigure 9 -state disabled

        } else {
            set_sensitive false .drag_mode_extrude
            menu_set_sensitive vertex true
           # enable edit->select whole surfaces
           .mbar.edit.menu entryconfigure 9 -state normal


        }
        


        if { ( $numselectedobjects == 0 ) } {
            menu_set_sensitive object false
        } else {
            menu_set_sensitive object true
        }
    }

    # set up the UNDO buttons and menu item
    .mbar.edit.menu entryconfigure 0 -label "$undo_string"

    if { ( $undo_count != 0 ) } {
        set_sensitive true .function_undo
        .mbar.edit.menu entryconfigure 0 -state normal
    } else {
        set_sensitive false .function_undo   
        .mbar.edit.menu entryconfigure 0 -state disabled
     
    }
        
    if { ( $objects_are_hidden ) } {
        set_sensitive true .unhide
    } else {
        set_sensitive false .unhide
    }

}


proc set_undo_string {str } {
global undo_string

    if { $str == "" } {
        set undo_string "Nothing to Undo"
        .mbar.edit.menu entryconfigure 0 -state disabled
        set_sensitive false .function_undo
    } else {
        set undo_string "Undo $str"
        .mbar.edit.menu entryconfigure 0 -state normal
        set_sensitive true .function_undo

    }
    # set up the UNDO buttons and menu item
    .mbar.edit.menu entryconfigure 0 -label $undo_string
    # the text on the undo button will update because the variable is linked to it    
}


proc sync_ui {} {

    update_selected_message
    do_ui_sensitivity
}


proc set_raised { args } {
    foreach i $args {
        $i configure -relief raised
    }
}

proc set_sunken { args } {
    foreach i $args {
        $i configure -relief sunken
    }
}


proc set_select_mode_ui { newmodename } {
global select_mode
global numselectedobjects
#puts "set_select_mode_ui $select_mode $numselectedobjects new $newmodename\n"

    # set the tcl variable 
    set select_mode $newmodename

    # display message regarding current selection
    sync_ui

}



# a DRAG MODE button was pressed or this proc was called from C prog

proc set_drag_mode_ui { newmodename  } {
global drag_mode

    # set the tcl variables for the DRAG MODE
    set drag_mode $newmodename

}



proc set_draw_mode_ui { newmodename  } {
global draw_mode

    # set the  tcl variables for the DRAW MODE
    set draw_mode $newmodename
}






proc ScrolledHorizCanvas { c width height region } {
	frame $c
	canvas $c.canvas -width $width -height $height \
		-xscrollcommand "$c.xscroll set" \
		-scrollregion $region 

	scrollbar $c.xscroll -orient horizontal \
		-command "$c.canvas xview"


	pack $c.xscroll -side bottom -fill x
	pack $c.canvas -side left -fill both -expand true
#pack $c.canvas -expand yes -fill both
#	pack $c -side top -fill both -expand true

	set f [frame $c.canvas.f -bd 0]

	$c.canvas create window 0 0 -anchor nw -window $f

#	return $c.canvas
}

proc WORKINGScrolledHorizCanvas { c width height region } {
	frame $c
	canvas $c.canvas -width $width -height $height \
		-xscrollcommand [list $c.xscroll set] 
#		-scrollregion $region 

        $c.canvas configure -scrollregion $region

	scrollbar $c.xscroll -orient horizontal \
		-command [list $c.canvas xview]

	pack $c.xscroll -side bottom -fill x
	pack $c.canvas -side left -fill both -expand true
#	pack $c -side top -fill both -expand true

	set f [frame $c.canvas.f -bd 0]

	$c.canvas create window 0 0 -anchor nw -window $f

#	return $c.canvas
}


proc ScrolledCanvas { c width height region } {
	frame $c
	canvas $c.canvas -width $width -height $height \
		-scrollregion $region \
		-xscrollcommand [list $c.xscroll set] \
		-yscrollcommand [list $c.yscroll set]
	scrollbar $c.xscroll -orient horizontal \
		-command [list $c.canvas xview]
	scrollbar $c.yscroll -orient vertical \
		-command [list $c.canvas yview]
	pack $c.xscroll -side bottom -fill x
	pack $c.yscroll -side right -fill y
	pack $c.canvas -side left -fill both -expand true
	pack $c -side top -fill both -expand true

	set f [frame $c.canvas.f -bd 0]

	$c.canvas create window 0 0 -anchor nw -window $f

	return $c.canvas
}




# loop though list of buttons and set their state 

proc set_state {state args } {
    foreach i $args {
        $i configure -state $state
    }
}



proc set_sensitive { bool args } {
global bindings

    if { $bool } {
        set state normal
    } else {
        set state disabled
    }


    foreach i $args {
        set type [winfo class $i]
         if { $type == "Label" } {
            if { $bool } {
			    $i configure -fg black
                if { $bindings($i) != "" } {
				     bindtags $i $bindings($i)
				}               
				
			} else {  #disable
			    $i configure -fg #a3a3a3
                set poo [bindtags $i]
                if { $poo != "none" } {
				    set bindings($i) [bindtags $i]
                }
				bindtags $i { none }			
			}			 
		 } else {
             $i configure -state $state
         }
    }

}




proc edit_dive_data {} {
     global current_object_data
#puts "display_object_data $current_object_data"

if ![winfo exists .d] {

    toplevel .d
    wm transient .d [winfo toplevel [winfo parent .d]]
    wm title .d "AC3D Object Data"

    frame .d.hf
    pack .d.hf -side top

    frame .d.bottomhf
    pack .d.bottomhf -side bottom
    button .d.bottomhf.close -text "Close" -command "destroy .d"
    pack .d.bottomhf.close

    label .d.hf.object_name_label -text "Object name:" -width 12
    add_balloon .d.hf.object_name_label "This is the object's name.\nit can also be changed on the control panel"
    entry .d.hf.object_name_entry -textvariable current_object_name -relief sunken -bd 2
    bind .d.hf.object_name_entry <Leave> {
        ac3d set_current_object_name $current_object_name
        }

    label .d.hf.object_url_label -text "URL:"
    add_balloon .d.hf.object_url_label "If there is a URl then a VRML object will have a link to it"
    entry .d.hf.object_url_entry -textvariable current_object_url -relief sunken -bd 2 -width 56
    bind .d.hf.object_url_entry <Leave> {
        ac3d set_current_object_url $current_object_url
        }

    horiz_pack .d.hf .d.hf.object_name_label .d.hf.object_name_entry \
        .d.hf.object_url_label .d.hf.object_url_entry

    label .d.object_data_label -text "String:"
    add_balloon .d.object_data_label "Object data string - saved with object (in .ac files)\ninserted in some output formats"
    pack .d.object_data_label -side top

     text .d.object_data -width 60 -height 10 \
             -yscrollcommand ".d.ys set" \
             -xscrollcommand ".d.xs set" \
             -wrap none -padx 4 -pady 4 \
             -exportselection true 
#             -insertwidth $cursorwidth -insertbackground $cursorcolour 

     scrollbar .d.ys -command ".d.object_data yview" 
     scrollbar .d.xs -command ".d.object_data xview" -orient horizontal
     pack .d.ys -in .d -side left -fill y -expand 0
     pack .d.xs -in .d -side bottom -fill both -expand 0
     pack .d.object_data -in .d -side left -fill both -expand 1


    bind .d.object_data <Leave> {
        ac3d set_current_object_data [.d.object_data get 0.0 end-1c]
        }
} else {
    raise .d
}

    # make sure that the fields are disabled if they need to be:
    do_ui_sensitivity

    # fill in the fields
    display_object_data

}


proc display_object_data {} {
# put the text from the tcl variable into the text widget 
# so that it can be edited by the user

    global current_object_data

    if { [winfo exists .d] } {
        
      .d.object_data delete 0.0 end

      # don't forget to enable the text widget before inserting!
      if { ($current_object_data != "") } {
        set state [ .d.object_data cget -state ]
        .d.object_data configure -state normal
        .d.object_data insert end $current_object_data
        .d.object_data configure -state $state
      }

    }
}



proc get_object_data {} {
# put the text from the text widget into the tcl variable 
     global current_object_data

    if { [winfo exists .d] } {
        set current_object_data [.d.object_data get 0.0 end-1c]
    }
}



set update_textures 1

proc update_texture_rep { tx ty } {
    ac3d set_texture_repeats $tx $ty
    ac3d redraw_3d
}





set texture_repeat_x 1.0
set texture_repeat_y 1.0

proc menu_edit_texture_repeats {} {
global update_textures
global texture_repeat_x texture_repeat_y

   if ![winfo exists .t] {
    toplevel .t 
    wm transient .t [winfo toplevel [winfo parent .t]]
    wm title .t "Set Texture repeats"

    frame .t.f1
    label .t.l1 -text "Texture repeat X"
    entry .t.tx -textvariable texture_repeat_x
    button .t.xl -text "<" -command { set texture_repeat_x [expr $texture_repeat_x - 1.0]; if { $update_textures } {update_texture_rep $texture_repeat_x $texture_repeat_y}}
    button .t.xr -text ">" -command { set texture_repeat_x [expr $texture_repeat_x + 1.0]; if { $update_textures } {update_texture_rep $texture_repeat_x $texture_repeat_y}}
    pack .t.l1 .t.tx .t.xl .t.xr -in .t.f1 -side left

    frame .t.f2
    label .t.l2 -text "Texture repeat X"
    entry .t.ty -textvariable texture_repeat_y
    button .t.yl -text "<" -command { set texture_repeat_y [expr $texture_repeat_y - 1.0]; if { $update_textures } {update_texture_rep $texture_repeat_x $texture_repeat_y}}
    button .t.yr -text ">" -command { set texture_repeat_y [expr $texture_repeat_y + 1.0]; if { $update_textures } {update_texture_rep $texture_repeat_x $texture_repeat_y}}
    pack .t.l2 .t.ty .t.yl .t.yr -in .t.f2 -side left
    bind .t.tx <Leave> { update_texture_rep $texture_repeat_x $texture_repeat_y}
    bind .t.tx <Return> { update_texture_rep $texture_repeat_x $texture_repeat_y}
    bind .t.ty <Leave> { update_texture_rep $texture_repeat_x $texture_repeat_y}
    bind .t.ty <Return> { update_texture_rep $texture_repeat_x $texture_repeat_y}

    pack .t.f1 .t.f2

    button .t.ok -text "Close" -command " destroy .t"
    button .t.apply -text "Apply" -command { update_texture_rep $texture_repeat_x $texture_repeat_y}

    checkbutton .t.rtu -text "Realtime update" -variable update_textures -command " ac3d redraw_3d "
    pack .t.rtu
    pack .t.ok .t.apply -side left
    centre_window_on_screen .t

    }

}




bind balloon <Enter> {

#&& [%W cget -state] != "disabled"
    if {[info exists balloonHelp(%W)] && $prefs_balloon_help} {
            set balloonHelp(%W,after) [after 500 {showBalloonHelp %W "$balloonHelp(%W)"}]
    }
}

bind balloon <Leave> {
    unShowBalloonHelp %W
}

bind balloon <Any-KeyPress> {
    unShowBalloonHelp %W
}

bind balloon <Any-Button> {
    unShowBalloonHelp %W
}

proc showBalloonHelp {w message} {
    global balloonHelp
    global tcl_platform


        if ![winfo exists .balloon] {
            toplevel .balloon
            wm overrideredirect .balloon true
            pack [label .balloon.l \
                    -foreground black \
                    -background yellow \
                    -highlightthickness 1 \
                    -highlightbackground black]
            wm withdraw .balloon
        }
        .balloon.l configure -text $message
        update idletasks

        set x [expr [winfo pointerx .]+16]
        set y [expr [winfo pointery .]+16]

        wm withdraw .balloon 
        raise .balloon 
        wm geometry .balloon "+$x+$y"

        wm deiconify .balloon
        if { $tcl_platform(platform) == "windows" } {
            wm geometry .balloon "+$x+$y"  
        }

}

proc unShowBalloonHelp {w} {
    global balloonHelp
    if [info exists balloonHelp($w,after)] {
        after cancel $balloonHelp($w,after)
        unset balloonHelp($w,after)
    }
    catch {wm withdraw .balloon}
}

proc add_balloon { wid message } {
global balloonHelp

    set balloonHelp($wid) $message
    bindtags $wid "[bindtags $wid] balloon"
}


proc add_menu_balloons { win message_list} {
global balloon_menu_help

    bind $win <Motion> {+unShowBalloonHelp %W; balloon_menu_motion %W %y %s}
    bind $win <Any-KeyPress> {+unShowBalloonHelp %W}
    bind $win <Leave> {+unShowBalloonHelp %W}
    bind $win <ButtonRelease> {+unShowBalloonHelp %W}

    set balloon_menu_help($win) $message_list
#puts "LIST \n$message_list\n\nend\n\n"
}


proc balloon_menu_motion {w y s} {
    set oldy -1
    set idx 0
    set newy [$w yposition $idx]
    while {$oldy != $newy} {
        if {$y < $newy} {
            set idx [expr $idx - 1]
            handle_balloon_menu_entry $w $idx
            return
        }
        set oldy $newy
        incr idx
        set newy [$w yposition $idx]
    }
    set idx [expr $idx-1]
    handle_balloon_menu_entry $w $idx
}


proc handle_balloon_menu_entry {w i} {
   global balloon_menu_help
   global balloonHelp
    
   if {$i > -1} {
       set type [$w type $i]
       if {$type == "tearoff"} {
       } elseif {$type == "separator"} {
       } elseif {$type == "command" || $type == "radiobutton" || $type == "checkbutton" } {
           set name [$w entrycget $i -label]
             if {$name != {}} {
                 set balloonHelp($w,after)\
                     [ after 500 "showBalloonHelp $w \"[lindex $balloon_menu_help($w) $i]\""]
             }   
       }
   }
}





proc dialog_addtext {} {
    toplevel .at -height 300
    wm transient .at [winfo toplevel [winfo parent .at]]
    wm title .at "Add Text"
    label .at.lab -text "Enter text"
    grid .at.lab -row 0 -column 0 -columnspan 2

    label .at.lab2 -text "Font file"
    grid .at.lab2 -row 1 -column 0   -sticky we
    add_balloon .at.lab2 "This should be an AC3D font file"

    entry .at.fp -relief sunken -bd 2 -textvariable prefs_fontpath
    grid .at.fp -row 1 -column 1 -columnspan 2  -sticky we

    label .at.lab3 -text "Text"
    grid .at.lab3 -row 2 -column 0   -sticky we

    entry .at.text -relief sunken -bd 2 
    grid .at.text -row 2 -column 1 -columnspan 2  -sticky we
    bind .at.text <Return> {
        ac3d add_text [%W get]
        destroy .at
        }
    focus .at.text

    button .at.ok -text "Create" -command { ac3d add_text [.at.text get] ; destroy .at }
    button .at.cancel -text "Cancel" -command "destroy .at"
    grid .at.ok -row 3 -column 0 -sticky we
    grid .at.cancel -row 3 -column 1 -sticky we
    centre_window_on_screen .at
    grab .at

}

proc dialog_select_by_name {} {
global select_mode

    toplevel .at -height 300
    wm transient .at [winfo toplevel [winfo parent .at]]
    wm title .at "Select by name"
    set poo  "Enter name of object/s to be appended to selection"
    if { $select_mode == "tree" } {
        set poo "TREE edit mode - whole groups containing\nnamed subobject/s will be selected\n\n$poo"
        }
    label .at.lab -text $poo
    grid .at.lab -row 0 -column 0 -columnspan 3

    entry .at.text -relief sunken -bd 2 
    bind .at.text <Return> {
        ac3d select_by_name [%W get]
        destroy .at
        }
    grid .at.text -row 1 -column 0 -columnspan 3  -sticky we

    focus .at.text

    button .at.ok -text "Select" -command { ac3d select_by_name [.at.text get] }
    button .at.ok2 -text "Unselect" -command { ac3d unselect_by_name [.at.text get] }
    button .at.cancel -text "Close" -command "destroy .at"
    grid .at.ok -row 2 -column 0 -sticky we
    grid .at.ok2 -row 2 -column 1 -sticky we
    grid .at.cancel -row 2 -column 2 -sticky we
    centre_window_on_screen .at

    grab .at
}




proc dialog_sizeto {} {
global sizex
global sizey
global sizez

    set size [ac3d get_selection_size]
    set sizex [lindex $size 0]
    set sizey [lindex $size 1]
    set sizez [lindex $size 2]

    toplevel .st -height 300
    wm transient .st [winfo toplevel [winfo parent .st]]

    wm title .st "Size selection"
    label .st.title -text "Size selection \n (-1 for no change)"
    label .st.labx -text "X"
    label .st.laby -text "Y"
    label .st.labz -text "Z"
    entry .st.textx -relief sunken -bd 2 -width 9 -justify right -textvariable sizex
    entry .st.texty -relief sunken -bd 2  -width 9 -justify right -textvariable sizey
    entry .st.textz -relief sunken -bd 2  -width 9 -justify right -textvariable sizez
    grid .st.title -row 0 -column 0 -columnspan 2 -sticky we
    grid .st.labx -row 1 -column 0 -sticky we
    grid .st.laby -row 2 -column 0 -sticky we
    grid .st.labz -row 3 -column 0 -sticky we
    grid .st.textx -row 1 -column 1 -sticky we
    grid .st.texty -row 2 -column 1 -sticky we
    grid .st.textz -row 3 -column 1 -sticky we
    button .st.ok -text "Size" -command { ac3d size_to $sizex $sizey $sizez }
    button .st.cancel -text "Close" -command "destroy .st"
    grid .st.ok -row 4 -column 0 -sticky we
    grid .st.cancel -row 4 -column 1 -sticky we
    centre_window_on_screen .st
    grab .st
}


proc dialog_moveto {} {
global sizex
global sizey
global sizez

    set size [ac3d get_selection_centre]
    set sizex [lindex $size 0]
    set sizey [lindex $size 1]
    set sizez [lindex $size 2]

    toplevel .st -height 300
    wm transient .st [winfo toplevel [winfo parent .st]]

    wm title .st "Move selection"
    label .st.title -text "Move selection (centre point of)"
    label .st.labx -text "X"
    label .st.laby -text "Y"
    label .st.labz -text "Z"
    entry .st.textx -relief sunken -bd 2 -width 9 -justify right -textvariable sizex
    entry .st.texty -relief sunken -bd 2  -width 9 -justify right -textvariable sizey
    entry .st.textz -relief sunken -bd 2  -width 9 -justify right -textvariable sizez
    grid .st.title -row 0 -column 0 -columnspan 2 -sticky we
    grid .st.labx -row 1 -column 0 -sticky we
    grid .st.laby -row 2 -column 0 -sticky we
    grid .st.labz -row 3 -column 0 -sticky we
    grid .st.textx -row 1 -column 1 -sticky we
    grid .st.texty -row 2 -column 1 -sticky we
    grid .st.textz -row 3 -column 1 -sticky we
    button .st.ok -text "Move" -command { ac3d move_to $sizex $sizey $sizez }
    button .st.cancel -text "Close" -command "destroy .st"
    grid .st.ok -row 4 -column 0 -sticky we
    grid .st.cancel -row 4 -column 1 -sticky we
    centre_window_on_screen .st

    grab .st
}



proc set_FOV { val } {
#called from scale
global prefs_fov

    set prefs_fov $val
    ac3d do_perspective
    ac3d redraw_3d
}


proc dialog_FOV {} {
global prefs_fov

    toplevel .at -height 300
    wm transient .at [winfo toplevel [winfo parent .at]]
    wm title .at "Field of view"

    scale .at.scale -label FOV -from 1 -to 180 -orient horizontal -command { set_FOV }
    .at.scale set $prefs_fov
    grid .at.scale -row 0 -column 0 -sticky we  -columnspan 2
    button .at.ok -text "Set default (50)" -command { set prefs_fov 50 ; ac3d do_perspective ; ac3d redraw_3d ; destroy .at }
    button .at.cancel -text "Close" -command "destroy .at"
    grid .at.ok -row 2 -column 1 -sticky we
    grid .at.cancel -row 2 -column 0 -sticky we
    grab .at
    centre_window_on_screen .at
}

set message_after ""

proc display_message {mess} {
global message
global message_after

    if { $message_after != ""} {
        catch {after cancel $message_after }
    }
    set message $mess
    set message_after [after 3000 {set message ""; set message_after ""}]
#update causes probs- allows new events to be processed before orig have finished
    update idletasks
}


proc set_progress_bar {percent} {
    set w [winfo width .progressbar]
    set h [winfo width .progressbar]
    set nw [expr $w/100.0*$percent]
    .progressbar coords rect 0 0 $nw  $h
    update idletasks
}


proc menu_info {} {
    set info [ac3d get_info]

    if ![winfo exists .inf] {

    toplevel .inf
    wm transient .inf [winfo toplevel [winfo parent .inf]]

    wm title .inf "Model info."

     text .inf.text -width 80 -height 25 \
             -yscrollcommand ".inf.ys set" \
             -xscrollcommand ".inf.xs set" \
             -wrap none -padx 4 -pady 4 \
             -exportselection true 

     scrollbar .inf.ys -command ".inf.text yview" 
     scrollbar .inf.xs -command ".inf.text xview" -orient horizontal
     pack .inf.ys -side left -fill y -expand 0
     pack .inf.xs  -side bottom -fill both -expand 0
     pack .inf.text -side left -fill both -expand 1
     centre_window_on_screen .inf
} else {
    .inf.text delete 0.0 end
}

    .inf.text insert end $info
    .inf.text see end
    raise .inf
}



proc centre_window_on_screen { w } {
global tcl_platform
    wm withdraw $w
    update idletasks
    set x [expr [winfo screenwidth $w]/2 - [winfo reqwidth $w]/2 \
	    - [winfo vrootx [winfo parent $w]]]
    set y [expr [winfo screenheight $w]/2 - [winfo reqheight $w]/2 \
	    - [winfo vrooty [winfo parent $w]]]
    wm geom $w +$x+$y
    wm deiconify $w
if { $tcl_platform(platform) == "windows" } {
    wm geom $w +$x+$y
}
}






































































































