# main AC3D TCL file defines control panel UI

tk appname ac3d
puts "TCL/TK :"
puts [winfo name .]
  wm protocol . WM_DELETE_WINDOW { menu_quit }


set tk_strictMotif $prefs_tk_strictmotif

if { $tcl_platform(platform) != "windows" } {
  if { $prefs_font_main != "" } {
    option add *font     $prefs_font_main
    }
  if { $prefs_font_menu != ""} {
    option add *Menubutton*font  $prefs_font_menu
    }
}


set highlight 0

# if strict motif is on then you must add one to ypad for same appearance
if { $tk_strictMotif == 1 } {
    set ypad 1
} else {
    set ypad 0
}


proc section_frame {name} {
    frame $name -relief ridge -borderwidth 2 
}

proc horiz_pack {parent args } {
    foreach i $args {
        pack $i -in $parent -side left -fill both -expand 1 -pady 0 -padx 0 -ipady 0 -ipadx 0
    }
}

proc vert_pack {parent args } {
    foreach i $args {
        pack $i -in $parent -side top -fill both -expand 1 -pady 0 -padx 0
#        pack $i -in $parent -side top  -pady 0 -padx 0
    }
}


set draw_mode select

proc trace_proc { name1 name2 op } {
global currentrb

upvar $name1 newval


$currentrb($name1) configure -relief raised

set n $name1.id($newval)
upvar #0 $n shit

set currentrb($name1) $shit
$currentrb($name1) configure -relief sunken
}


proc mode_button {name text command { variable ""} { value "" } } {
global highlight
global ypad
global tcl_version
global $variable
global currentrb


#        radiobutton $name -text $text -command $command -padx 0 -pady $ypad -height 1\
#            -highlightthickness  $highlight -indicatoron false \
#			 -bd 1 -variable $variable -value $value


    label $name -text $text -relief raised
    bind $name <ButtonPress-1> "%W configure -relief sunken"
    bind $name <ButtonRelease-1> "set $variable $value; $command"

    set winname "$variable.id($value)"
    uplevel 1 " set $winname $name "
    upvar $winname poo

    if { [set $variable] == $value} {
        $name configure -relief sunken
	set currentrb($variable) $name
	trace variable $variable w trace_proc
    }

}

proc cbutton {name text command } {
global highlight
global ypad
global tcl_version

#    if { $tcl_version >= 8 } {
label $name -text $text -relief raised
bind $name <ButtonPress-1> { %W configure -relief sunken }
bind $name <ButtonRelease-1> " %W configure -relief raised ; $command "
#    } else {
#        button $name -text $text -command $command -padx 0 -pady $ypad  \
#	    	-highlightthickness $highlight
#    }
}

proc do_render {} {
global prefs_render_command

    eval $prefs_render_command
}



    wm title . $ac3d_version_string
    wm geometry . +$prefs_cp_x+$prefs_cp_y


# menu bar

    frame .mbar -relief raised -bd 2
    pack .mbar -side top -fill x

    frame .cp
    pack .cp -side left -fill y

    frame .bottombar -relief raised -bd 2
    pack .bottombar -side bottom -fill x

    frame .toolbar -relief sunken -bd 2
    pack .toolbar -side top -fill x 

	





    canvas .views -relief raised -bd 2 -bg red
    pack .views -side left -fill both -expand 1

# file menu
    catch { menubutton .mbar.file -text "File" -menu .mbar.file.menu -underline 0} err
    if { ($err != ".mbar.file") } {
        puts "$err An error has occured which is probably due a bad menu font\nClearing options and retrying."
        option clear
        menubutton .mbar.file -text "File" -menu .mbar.file.menu -underline 0
        }    


    menu .mbar.file.menu -tearoff 0



    .mbar.file.menu add command -label "Load..." -command "menu_load_ac" -accelerator Ctrl+L -underline 0
    .mbar.file.menu add command -label "Save" -command "menu_save_last" -underline 0  -accelerator Ctrl+S
    .mbar.file.menu add command -label "Save as..." -command "menu_save_ac" -underline 5
    .mbar.file.menu add command -label "Save selection..." -command "menu_save_selection" -underline 7
    .mbar.file.menu add separator
    .mbar.file.menu add cascade -label "Import" -menu .mbar.file.menu.import -underline 0
    .mbar.file.menu add cascade -label "Export" -menu .mbar.file.menu.export -underline 0
    .mbar.file.menu add separator
    .mbar.file.menu add command -label "Quit..." -command "menu_quit" -underline 0

     bind . <Control-l> "menu_load_ac"
     bind . <Control-s> "menu_save_ac"
     bind . <Control-q> "menu_quit"

    add_menu_balloons .mbar.file.menu { "load an AC3D file" "save the current model" \
        "save the current model with a new name" "save selection as an AC3D file" \
        "" "Import menu" "Export" "" "Exit AC3D" }



    menu .mbar.file.menu.export -tearoff 0
    .mbar.file.menu.export add command -label "POV..." -command "menu_write_POV" -underline 0
    .mbar.file.menu.export add command -label "RenderMan..." -command "menu_write_rib" -underline 0
    .mbar.file.menu.export add command -label "VRML 1..." -command "menu_write_vrml" -underline 5
    .mbar.file.menu.export add command -label "VRML 2..." -command "menu_write_vrml2" -underline 5
    .mbar.file.menu.export add command -label "Dive..." -command "menu_write_dive" -underline 0
    .mbar.file.menu.export add command -label "Massive..." -command "menu_write_massive" -underline 0
    .mbar.file.menu.export add command -label "DVS..." -command "menu_write_DVS" -underline 1
    .mbar.file.menu.export add command -label "Triangles..." -command "menu_write_triangles" -underline 0

    menu .mbar.file.menu.import -tearoff 0
    .mbar.file.menu.import add command -label "3DS..." -command "menu_import_3DS" -underline 0
    .mbar.file.menu.import add command -label "DXF..." -command "menu_import_dxf" -underline 0
    .mbar.file.menu.import add command -label "Lightwave..." -command "menu_import_lightwave" -underline 0
    .mbar.file.menu.import add command -label "Triangles..." -command "menu_import_triangles" -underline 0
    .mbar.file.menu.import add command -label "Vectors..." -command "menu_import_vector" -underline 0
    .mbar.file.menu.import add command -label "VRML 1..." -command "menu_import_vrml" -underline 5


# edit menu
    menubutton .mbar.edit -text "Edit" -menu .mbar.edit.menu -underline 0
    menu .mbar.edit.menu -tearoff 0
    .mbar.edit.menu add command -label "Undo" -command "ac3d undo" -accelerator Ctrl+Z -underline 0
    .mbar.edit.menu add separator
    .mbar.edit.menu add command -label "Duplicate" -command "ac3d duplicate" -accelerator Ctrl+D  -underline 0
    .mbar.edit.menu add command -label "Delete" -command "ac3d delete" -accelerator Delete 
    .mbar.edit.menu add command -label "Delete all" -command "menu_clear" 
    .mbar.edit.menu add separator

    .mbar.edit.menu add command -label "Select all" -command "ac3d select_all" -accelerator Ctrl+A  -underline 7
    .mbar.edit.menu add command -label "Deselect all" -command "ac3d clear_selection"
    .mbar.edit.menu add command -label "Select/unselect by name..." -command "dialog_select_by_name"  -underline 19
    .mbar.edit.menu add command -label "Select whole surfaces" -command "ac3d select_part_selected_surfaces" -underline 2

    .mbar.edit.menu add separator
    .mbar.edit.menu add command -label "Move to..." -command "dialog_moveto" -underline 0
    .mbar.edit.menu add command -label "Size to..." -command "dialog_sizeto" -underline 0

    .mbar.edit.menu add separator
    .mbar.edit.menu add command -label "Settings..." -command "show_settings" -underline 2
    .mbar.edit.menu add command -label "Save settings..." -command "ac3d save_settings" -underline 0
     bind . <Control-z> "ac3d undo"
     bind . <Control-a> "ac3d select_all"

    add_menu_balloons .mbar.edit.menu { \
        "undo this operation" \
        "" \
        "make a copy of the selected" \
        "delete selected" "delete everything" \
        "" \
        "select everything" \
        "clear the selection" \
        "select or unselect objects by entering their names" \
        "select surfaces that have one or move vertex selected" \
        "" \
        "move the selection to a specific xyz position" \
        "resize the selection to a specific size" \
        "" \
        "show the settings/preferences window" \
        "save the current settings" }

# View menu
    menubutton .mbar.view -text "View" -menu .mbar.view.menu -underline 0
    menu .mbar.view.menu -tearoff 0
    .mbar.view.menu add command -label "Zoom in" -command "ac3d zoom_in" -accelerator z -underline 5
    .mbar.view.menu add command -label "Zoom out" -command "ac3d zoom_out" -accelerator x -underline 5
    .mbar.view.menu add command -label "Fit all" -command "ac3d fit_all" -accelerator Ctrl+F -underline 4
    .mbar.view.menu add command -label "Fit selection" -command "ac3d fit_selected_all" -accelerator F -underline 0
    .mbar.view.menu add command -label "Goto selection" -command "ac3d goto_selected_all" -accelerator G -underline 0
    .mbar.view.menu add cascade -label "Background image" -menu .mbar.view.menu.bgimage -underline 0
     bind . <Control-f> "ac3d fit_all"

    menu .mbar.view.menu.bgimage -tearoff 0
    .mbar.view.menu.bgimage add cascade -label "Set" -menu .mbar.view.menu.bgimage.set -underline 0
    .mbar.view.menu.bgimage add cascade -label "Clear" -menu .mbar.view.menu.bgimage.clear -underline 0

    menu .mbar.view.menu.bgimage.set -tearoff 0
    .mbar.view.menu.bgimage.set add command -label $prefs_window_label_xy -command "menu_load_background_image 0"
    .mbar.view.menu.bgimage.set add command -label $prefs_window_label_zy -command "menu_load_background_image 1"
    .mbar.view.menu.bgimage.set add command -label $prefs_window_label_xz -command "menu_load_background_image 2"

    menu .mbar.view.menu.bgimage.clear -tearoff 0
    .mbar.view.menu.bgimage.clear add command -label $prefs_window_label_xy -command "ac3d clear_background_image 0"
    .mbar.view.menu.bgimage.clear add command -label $prefs_window_label_zy -command "ac3d clear_background_image 1"
    .mbar.view.menu.bgimage.clear add command -label $prefs_window_label_xz -command "ac3d clear_background_image 2"


    .mbar.view.menu add separator
    .mbar.view.menu add command -label "3D view to selection" -command "ac3d set_view_3d_selection"
    .mbar.view.menu add command -label "3D view to cursor" -command "ac3d set_view_3d_cursor"
    .mbar.view.menu add command -label "3D view to origin" -command "ac3d set_view_3d_origin"
    .mbar.view.menu add separator
    .mbar.view.menu add command -label "Reset" -command "ac3d reset_views" -accelerator Space -underline 0

    add_menu_balloons .mbar.view.menu { \
        "magnify the views in the orthographic windows" \
        "minify the views in the orthographic windows" \
        "set the window zoom so that the whole model can be seen" \
        "set the views so that the selection fills the windows" \
        "centre the views around the centre of the selection" \
        "" \
        "" \
        "set the 3D view to the centre of the selection" \
        "set the 3D view to the 3D cursor" \
        "set the 3D view to the origin" \
        "" \
        "reset the view centering and zoom levels" }
        



# Object menu


    menubutton .mbar.object -text "Object" -menu .mbar.object.menu -underline 0

    menu .mbar.object.menu -tearoff 0
    
    .mbar.object.menu add cascade -label "Revolve" -menu .mbar.object.menu.revolve -underline 0

    menu .mbar.object.menu.revolve -tearoff 0
    .mbar.object.menu.revolve add command -label "X axis" -command "ac3d revolve 0"  -underline 0
    .mbar.object.menu.revolve add command -label "Y axis" -command "ac3d revolve 1" -underline 0
    .mbar.object.menu.revolve add command -label "Z axis" -command "ac3d revolve 2" -underline 0

    .mbar.object.menu add cascade -label "Texture" -menu .mbar.object.menu.texture -underline 0

    .mbar.object.menu add command -label "Optimize vertices" -command "ac3d optimize" -underline 9
    .mbar.object.menu add command -label "Optimize surfaces" -command "ac3d optimize_surfaces" -underline 9

    menu .mbar.object.menu.texture -tearoff 0
    .mbar.object.menu.texture add command -label "Set no texture" -command "ac3d set_no_texture"
    .mbar.object.menu.texture add cascade -label "Remap texture coords" -menu .mbar.object.menu.texture.remaptexture
    .mbar.object.menu.texture add command -label "Set texture repeat..." -command "menu_edit_texture_repeats"
    .mbar.object.menu.texture add command -label "Load texture..." -command "menu_load_texture"

    menu .mbar.object.menu.texture.remaptexture -tearoff 0
    .mbar.object.menu.texture.remaptexture add command -label "XY (Front)" -command "ac3d remap_textures 0; ac3d redraw_3d" -underline 4
    .mbar.object.menu.texture.remaptexture add command -label "ZY (Side)" -command "ac3d remap_textures 1 ; ac3d redraw_3d" -underline 4
    .mbar.object.menu.texture.remaptexture add command -label "XZ (Plan)" -command "ac3d remap_textures 2; ac3d redraw_3d"  -underline 4


    .mbar.object.menu add command -label "Re-centre" -command "ac3d object_recentre ; ac3d redraw_orth" -underline 3
    .mbar.object.menu add command -label "Minimum-centre" -command "ac3d object_mincentre ; ac3d redraw_orth" -underline 0

    .mbar.object.menu add command -label "Fragment" -command "ac3d object_fragment ; ac3d redraw_orth" -underline 0
    .mbar.object.menu add command -label "Merge" -command "ac3d object_merge ; ac3d redraw_orth" -underline 1

    .mbar.object.menu add command -label "Edit Object data..." -command "edit_dive_data" -underline 6

    add_menu_balloons .mbar.object.menu { "" "" \
        "delete any vertices that are in the same object and have the same position" \
        "remove any surfaces that are duplicated in the same object\n also removes polygons that have only 1 or 2 vertices" \
        "recalculate the centre of each object" \
        "calculate the minimum xyz coor of an object and use this as its centre" \
        "turn each surface in an object into an individual object" \
        "put all selected surfaces into a single object\n(you may want to optimize vertices after this\nin order to share vertices across surfaces" \
        "show the object-data window" }

# Surface menu

    menubutton .mbar.surface -text "Surface" -menu .mbar.surface.menu -underline 0
    menu .mbar.surface.menu -tearoff 0
    
    .mbar.surface.menu add command -label "Flip normal" -command "ac3d surface_flip_normals" -underline 0
    .mbar.surface.menu add command -label "Change vertex order" -command "ac3d surface_change_vertex_order" -underline 0
    .mbar.surface.menu add command -label "Subdivide" -command "ac3d surface_subdivide" -underline 0
    .mbar.surface.menu add command -label "Spline" -command "ac3d surface_spline" -underline 1
    .mbar.surface.menu add command -label "Spike" -command "ac3d surface_spike" -underline 3
    .mbar.surface.menu add command -label "Make hole" -command "ac3d surface_make_hole" -underline 5
    .mbar.surface.menu add command -label "Bevel" -command "ac3d surface_bevel" -underline 0
    .mbar.surface.menu add command -label "Cut-away object" -command "ac3d surface_create_object"  -underline 9
    .mbar.surface.menu add command -label "Triangulate" -command "ac3d surface_triangulate"  -underline 0

    .mbar.surface.menu add cascade -label "Remap texture coords" -menu .mbar.surface.menu.remaptexture
    menu .mbar.surface.menu.remaptexture -tearoff 0
    .mbar.surface.menu.remaptexture add command -label "XY (Front)" -command "ac3d remap_textures 0" -underline 4
    .mbar.surface.menu.remaptexture add command -label "ZY (Side)" -command "ac3d remap_textures 1" -underline 4
    .mbar.surface.menu.remaptexture add command -label "XZ (Plan)" -command "ac3d remap_textures 2" -underline 4

    add_menu_balloons .mbar.surface.menu { \
        "reverse the order of the vertices so that the normal is flipped" \
        "put the first vertex to the end of the surface.\nuseful for changing the start/end of a line\nand for fixing polygons with bad normals" \
        "split quads into 4 smaller surfaces, triangles into 3" \
        "interpolate points between the current vertices" \
        "create a spike on each surface" \
        "make a hole in each selected surface" \
        "create a beveled effect by creating more surfaces" \
        "take selected surfaces and put them into a new object" \
        "divide polygons into triangles" }


# Vertex menu
    menubutton .mbar.vertex -text "Vertex" -menu .mbar.vertex.menu -underline 5
    menu .mbar.vertex.menu -tearoff 0
    .mbar.vertex.menu add command -label "Snap together" -command "ac3d snaptogether"  -underline 0 -accelerator s
    .mbar.vertex.menu add command -label "Snap to grid" -command "ac3d snaptogrid" -underline 8
    .mbar.vertex.menu add command -label "Snap objects by vertices" -command "ac3d object_snap_together_by_vertices" -underline 16
    .mbar.vertex.menu add command -label "Snap object vertex pairs" -command "ac3d snap_object_vertex_pairs" -underline 19
    .mbar.vertex.menu add command -label "Insert vertex" -command "ac3d insert_vertex" -underline 0 
    .mbar.vertex.menu add command -label "Create surface" -command "ac3d createsurface" -underline 0 
    .mbar.vertex.menu add command -label "Remove surface only" -command "ac3d removesurface" -underline 0 

    add_menu_balloons .mbar.vertex.menu { \
        "move selected vertices to the same point" \
        "move selected vertices to the nearest grid point" \
        "move two objects together so that the vertex selected\nin each is in the same position" \
        "move closest vertex pairs together in two objects" \
        "insert a new vertex between each pair of selected vertices" \
        "create a new surface to span across selected vertices\nnote that the order of selection maters" \
        "remove selected surfaces but not the vertices" }


# 3D menu

    menubutton .mbar.3d -text "3D" -menu .mbar.3d.menu -underline 0

    menu .mbar.3d.menu -tearoff 0
    .mbar.3d.menu add radiobutton -label "Wireframe" -variable prefs_view3dmode -value 1 -command "ac3d redraw_3d" -underline 0 
    .mbar.3d.menu add radiobutton -label "Filled" -variable prefs_view3dmode -value 0 -command "ac3d redraw_3d" -underline 0 
    .mbar.3d.menu add checkbutton -label "Texture" -variable prefs_view3dtextures -command "ac3d redraw_3d" -underline 0 
    .mbar.3d.menu add separator
    .mbar.3d.menu add checkbutton -label "Headlight" -variable prefs_headlight -command "ac3d redraw_3d" -underline 0 
    .mbar.3d.menu add checkbutton -label "Grid" -variable prefs_show_3d_grid -command "ac3d redraw_3d" -underline 0 
    .mbar.3d.menu add checkbutton -label "Axis" -variable prefs_show_axis -command "ac3d redraw_3d" -underline 0 
    .mbar.3d.menu add checkbutton -label "Move wireframe" -variable prefs_wireframe_move -underline 0 
    .mbar.3d.menu add separator
    .mbar.3d.menu add radiobutton -label "Spin" -variable person_walk_vehicle -value 0 -command "ac3d set_spin_viewer ; ac3d redraw_3d" -underline 0 
    .mbar.3d.menu add radiobutton -label "Walk" -variable person_walk_vehicle -value 1 -command "ac3d set_walk_viewer ; ac3d redraw_3d" -underline 3 
    .mbar.3d.menu add separator
    .mbar.3d.menu add command -label "FOV..." -command "dialog_FOV" -underline 2

    add_menu_balloons .mbar.3d.menu { \
        "view the 3d model as polygon outlines?" \
        "view filled polygons?" \
        "view textures?" \
        "" \
        "switch on the viewing light?" \
        "view the 3D grid?" \
        "view the axis guide?" \
        "display model in wireframe when dragging the mouse?" \
        "" \
        "select spin view mode - mouse and cursor keys spin the model" \
        "select walk view mode - cursor keys (with alt/ctrl) move view point" \
        "" \
        "adjust the field-of-view" }


# tools menu
    menubutton .mbar.tools -text "Tools" -menu .mbar.tools.menu -underline 0
    menu .mbar.tools.menu -tearoff 0
    .mbar.tools.menu add command -label "Add Text..." -command "dialog_addtext" -underline 4
    .mbar.tools.menu add command -label "Render..." -command "do_render" -underline 0
    .mbar.tools.menu add command -label "Info..." -command "menu_info" -underline 0

    add_menu_balloons .mbar.tools.menu { \
        "create some text from an AC3D font file" \
        "render the current model in an external renderer" \
        "display information about the current model" }

# HELP menu
    menubutton .mbar.help -text "Help" -menu .mbar.help.menu -underline 0    
    menu .mbar.help.menu -tearoff 0
    .mbar.help.menu add command -label "About AC3D..." -command "ac3d menu_about" -underline 0

    add_menu_balloons .mbar.help.menu { "Information about AC3D" }


# pack the menus into the menubar

    if { $tcl_version >= 8 } {
	    set m .poo
		menu $m -tearoff 0 -type toplevel
		$m add cascade -menu .mbar.file.menu -label "File" -underline 0
		$m add cascade -menu .mbar.edit.menu -label "Edit" -underline 0
		$m add cascade -menu .mbar.view.menu -label "View" -underline 0
		$m add cascade -menu .mbar.object.menu -label "Object" -underline 0
		$m add cascade -menu .mbar.surface.menu -label "Surface" -underline 0
		$m add cascade -menu .mbar.vertex.menu -label "Vertex" -underline 5
		$m add cascade -menu .mbar.3d.menu -label "3D" -underline 0
		$m add cascade -menu .mbar.tools.menu -label "Tools" -underline 0
		$m add cascade -menu .mbar.help.menu -label "Help" -underline 0

		. configure -menu .poo
    } else {    
        pack .mbar.file .mbar.edit .mbar.view .mbar.object .mbar.surface .mbar.vertex  .mbar.3d .mbar.tools -side left
        pack .mbar.help -side right
    }


# main control panel


    section_frame .message_frame
    label .select_mode_info -text "objects/vert selected" -textvariable select_info  -padx 0 -pady 0
    label .display_line_coors -text "" -textvariable coors -padx 0 -pady 0
    label .display_line_size -text "" -textvariable size -padx 0 -pady 0
#    label .display_line_message -text "shitty" -textvariable message -padx 0 -pady 0
    pack .select_mode_info .display_line_coors .display_line_size  -in .cp -side top -fill x


#select mode
    section_frame .select_mode_frame
    frame .select_mode_frame2
    frame .select_mode_frame3
    label .select_mode_title -text "Edit:"  -padx 0 -pady 0

    pack .select_mode_title -in .select_mode_frame

    mode_button .select_mode_tree  "Tree"  "ac3d set_select_mode  0; ac3d redraw_orth" select_mode tree
    add_balloon .select_mode_tree "Select/manipulate\ngroups and objects"
    mode_button .select_mode_object  "Object"  "ac3d set_select_mode  1 ; ac3d redraw_orth" select_mode object
    add_balloon .select_mode_object "Select/manipulate\nwhole objects"
    mode_button .select_mode_vertex  "Vertex"  "ac3d set_select_mode  2 ; ac3d redraw_orth"  select_mode vertex
    add_balloon  .select_mode_vertex "Select/manipulate individual\nsurfaces and vertices"

    pack .select_mode_frame2 -in .select_mode_frame -fill x
    pack .select_mode_frame3 -in .select_mode_frame -fill x
    pack .select_mode_tree .select_mode_object .select_mode_vertex -side left\
         -in .select_mode_frame2  -fill x -expand 1

    vert_pack .select_mode_frame

    label .selection_title -text "Selection:"  -padx 0 -pady 0
    vert_pack .select_mode_frame .selection_title


    frame .select_hide_frame
    cbutton .hide_selected "Hide sel" "ac3d hide_selected" 
    add_balloon .hide_selected "Hide selected objects from the display"
    cbutton .hide_unselected "Hide uns" "ac3d hide_unselected"
    add_balloon .hide_unselected "Hide objects not selected"
    cbutton .unhide "UNHIDE" "ac3d unhide" 
    add_balloon .unhide "Restore hidden objects"

    checkbutton .hide_in_3d -text "3D" -variable hide_objects_in_3d -highlightthickness 0 \
        -command "ac3d redraw_3d"
    add_balloon .hide_in_3d "show hidden objects in 3D window"

    horiz_pack .select_hide_frame .hide_selected .hide_unselected  .unhide .hide_in_3d 

    vert_pack .select_mode_frame .select_hide_frame

    # group/ungroup
    frame .function_frame1
    cbutton .function_group  "Group"  "ac3d group"
    add_balloon .function_group "Create a group object with selected as children"
    cbutton .function_ungroup  "Ungroup"  "ac3d ungroup"
    add_balloon .function_ungroup "Destroy group object leaving children"
    horiz_pack .function_frame1 .function_group .function_ungroup 

    pack .function_frame1 -in .select_mode_frame  -side top -fill both -expand 1




# drag mode
    section_frame .drag_mode_frame
    label .drag_mode_title -text "Mouse:"  -padx 0 -pady 0
    pack .drag_mode_title  -side top -in .drag_mode_frame



    set drag_mode move

    mode_button .drag_mode_move  "Move"  "ac3d set_drag_mode  100" drag_mode move
    add_balloon  .drag_mode_move "Mouse button 1 will drag selection"
    mode_button .drag_mode_resize  "Size"  "ac3d set_drag_mode  101" drag_mode resize
    add_balloon  .drag_mode_resize "Mouse button 1 will resize selection"
    mode_button .drag_mode_rotate  "Rotate"  "ac3d set_drag_mode  102" drag_mode rotate
    add_balloon  .drag_mode_rotate "Mouse button 1 will rotate\nselection about mouse pos"
    mode_button .drag_mode_extrude  "Extrude"  "ac3d set_drag_mode  103" drag_mode extrude
    add_balloon  .drag_mode_extrude "Mouse button 1 will extrude selection to release point"

    horiz_pack .drag_mode_frame .drag_mode_move .drag_mode_resize .drag_mode_rotate .drag_mode_extrude

#image create bitmap image_ptr -file "ptr.xbm"
#draw_mode

    section_frame .draw_mode_frame 
    frame .draw_mode_frame_col1
    frame .draw_mode_frame_col2
    frame .draw_mode_frame_col3

    label .draw_mode_title -text "Draw:"  -padx 0 -pady 0
    pack .draw_mode_title  -side top -in .draw_mode_frame
    mode_button .draw_mode_select "Select"  "ac3d set_draw_mode  0" draw_mode select
    add_balloon .draw_mode_select "Set Select mode - select objects by\nclicking or dragging mouse over vertices"
    mode_button .draw_mode_polygon  "Poly"  "ac3d set_draw_mode  1"  draw_mode polygon
    add_balloon .draw_mode_polygon "Draw a polygon\n (Click button 1 for each vertex,\n button 2 or 3 to finish)"
    mode_button .draw_mode_polyline  "Polyline"  "ac3d set_draw_mode  2"  draw_mode polyline
    add_balloon .draw_mode_polyline "Draw a polygon outline\n (Click button 1 for each vertex,\n button 2 or 3 to finish)"
    mode_button .draw_mode_line "Line"   "ac3d set_draw_mode  3"  draw_mode line
    add_balloon .draw_mode_line "Hand draw a line\n (Click button 1 for each vertex,\n button 2 or 3 to finish)"
    mode_button .draw_mode_rect  " Rect "  "ac3d set_draw_mode  4"  draw_mode rect
    add_balloon .draw_mode_rect "Draw a rectangle"
    mode_button .draw_mode_circle  "Ellipse"  "ac3d set_draw_mode  5"  draw_mode circle
    add_balloon .draw_mode_circle "Draw an circle/ellipse"
    mode_button .draw_mode_disk  "Disk"  "ac3d set_draw_mode  6"  draw_mode disk
    add_balloon .draw_mode_disk "Draw a disk"
    mode_button .draw_mode_cube  "Box"  "ac3d set_draw_mode  7"  draw_mode cube
    add_balloon .draw_mode_cube "Draw a cuboid"
    mode_button .draw_mode_sphere  "Sphere"  "ac3d set_draw_mode  8" draw_mode sphere
    add_balloon .draw_mode_sphere "Draw a sphere"
    mode_button .draw_mode_cone  "Cylinder"  "ac3d set_draw_mode  9"  draw_mode cone
    add_balloon .draw_mode_cone "Draw a cylinder"
    mode_button .draw_mode_mesh  "Mesh"  "ac3d set_draw_mode  10"  draw_mode mesh
    add_balloon .draw_mode_mesh "Draw a mesh"
    mode_button .draw_mode_grid  "Grid"  "ac3d set_draw_mode  11"  draw_mode grid
    add_balloon .draw_mode_grid "Draw a gridline object"

    mode_button .draw_mode_light  "Light"  "ac3d set_draw_mode  13"  draw_mode light
    add_balloon .draw_mode_light "Click to position a new light"

#    horiz_pack .draw_mode_frame_col1  .draw_mode_select .draw_mode_polygon  .draw_mode_polyline \
#        .draw_mode_line 

#    horiz_pack  .draw_mode_frame_col2 .draw_mode_rect  .draw_mode_circle .draw_mode_disk .draw_mode_cube \
#         
      
#    horiz_pack  .draw_mode_frame_col3 .draw_mode_sphere .draw_mode_cone .draw_mode_mesh .draw_mode_grid \
#             .draw_mode_light

    grid .draw_mode_select -in .draw_mode_frame_col1 -row 0 -column 0 -sticky we -columnspan 1
    grid .draw_mode_polygon -in .draw_mode_frame_col1 -row 1 -column 0 -sticky we
    grid .draw_mode_polyline -in .draw_mode_frame_col1 -row 1 -column 1 -sticky we 
    grid .draw_mode_line -in .draw_mode_frame_col1 -row 1 -column 2 -sticky we
    grid .draw_mode_circle -in .draw_mode_frame_col1 -row 2 -column 0 -sticky we
    grid .draw_mode_disk -in .draw_mode_frame_col1 -row 2 -column 1 -sticky we
    grid .draw_mode_rect -in .draw_mode_frame_col1 -row 2 -column 2 -sticky we
    grid .draw_mode_grid -in .draw_mode_frame_col1 -row 3 -column 0 -sticky we
    grid .draw_mode_mesh -in .draw_mode_frame_col1 -row 3 -column 1 -sticky we
    grid .draw_mode_cube -in .draw_mode_frame_col1 -row 3 -column 2 -sticky we
    grid .draw_mode_cone -in .draw_mode_frame_col1 -row 4 -column 0 -sticky we
    grid .draw_mode_sphere -in .draw_mode_frame_col1 -row 4 -column 1 -sticky we
    grid .draw_mode_light -in .draw_mode_frame_col1 -row 4 -column 2 -sticky we
grid columnconfigure .draw_mode_frame_col1 0 -minsize 60
grid columnconfigure .draw_mode_frame_col1 1 -minsize 60
grid columnconfigure .draw_mode_frame_col1 2 -minsize 60
    pack .draw_mode_frame_col1 \
         -in .draw_mode_frame -side top -fill both -expand 1



# functions
    section_frame .function_frame
    label .function_title -text "Functions:"  -padx 0 -pady 0
    pack .function_title  -side top -in .function_frame 



    frame .function_frame2
    cbutton .function_mirrorx  "Mirror X"  "ac3d mirror 0" 
    add_balloon .function_mirrorx "Flip selected about X axis"
    cbutton .function_mirrory  "Mirror Y"  "ac3d mirror 1"
    add_balloon .function_mirrory "Flip selected about Y axis"
    cbutton .function_mirrorz  "Mirror Z"  "ac3d mirror 2"
    add_balloon .function_mirrorz "Flip selected about Z axis"


    horiz_pack .function_frame2 .function_mirrorx .function_mirrory .function_mirrorz
        
    pack .function_frame2 -in .function_frame -side top -fill both

# double size / Half size
    frame .function_frame3
    cbutton .function_double_size  "200%"  "ac3d scale  2.0 2.0 2.0 ; ac3d redraw_all"
    add_balloon .function_double_size "Double size"

    cbutton .function_half_size  "50%"  "ac3d scale 0.5 0.5 0.5 ; ac3d redraw_all"
    add_balloon .function_half_size "Half size"

    cbutton .function_plus_size  "+10%"  "ac3d scale 1.1 1.1 1.1 ; ac3d redraw_all"
    add_balloon .function_plus_size "Increase size"

    cbutton .function_minus_size  "-10%"  "ac3d scale 0.9 0.9 0.9 ; ac3d redraw_all"
    add_balloon .function_minus_size "Decrease size"

    horiz_pack .function_frame3 .function_double_size .function_half_size .function_plus_size .function_minus_size

    pack .function_frame3 -in .function_frame  -side top  -fill both -expand 1 

    cbutton .function_undo  "UNDO"  "ac3d undo"
    set undo_string "UNDO"
    .function_undo configure -textvariable undo_string
    add_balloon .function_undo "Undo this operation"

   pack  .function_undo -in .function_frame -side top -fill both -expand 1 


    frame .surface_type_frame
    label .function_surface_type_label -text "Surface type:" -padx 0 -pady 0 
    pack .function_surface_type_label -in .surface_type_frame  

    frame .surface_type_frame2
    cbutton .function_surface_poly  "Poly"  "ac3d set_surface_type 0 ; ac3d redraw_3d"
    add_balloon .function_surface_poly "Set selected surfaces to polygons"
    cbutton .function_surface_polyline  "Polyline"  "ac3d set_surface_type 1 ; ac3d redraw_3d"
    add_balloon .function_surface_polyline "Set selected surfaces to closed lines"
    cbutton .function_surface_line  "Line"  "ac3d set_surface_type 2 ; ac3d redraw_3d"
    add_balloon .function_surface_line "Set selected surfaces to lines"

    frame .surface_type_frame3
    cbutton .function_surface_smooth "Smooth" "ac3d surface_set_shaded 1 ; ac3d redraw_3d"
    add_balloon .function_surface_smooth "Set smooth-shaded surfaces"
    cbutton .function_surface_flat "Flat" "ac3d surface_set_shaded 0 ; ac3d redraw_3d"
    add_balloon .function_surface_flat "Set flat-shaded surfaces"
    cbutton .function_surface_one_sided "1S" "ac3d surface_set_twosided 0"
    add_balloon .function_surface_one_sided "Set single-sided surfaces"
    cbutton .function_surface_two_sided "2S"  "ac3d surface_set_twosided 1"
    add_balloon .function_surface_two_sided "Set double-sided surfaces"

    horiz_pack .surface_type_frame2 .function_surface_poly .function_surface_polyline .function_surface_line
    horiz_pack .surface_type_frame3 \
        .function_surface_smooth .function_surface_flat .function_surface_one_sided .function_surface_two_sided
    vert_pack .surface_type_frame .surface_type_frame2 .surface_type_frame3

# the palette


ScrolledHorizCanvas .palette_frame 10 24 {0 0 1000 0}

#    label .pallabel -text "palette"
#    pack .pallabel -in .palette_frame

# object data
    frame .other_frame3
    label .current_ob_label -text "Obj name:"
    add_balloon .current_ob_label "Name of current object"


    entry .current_object_name_entry -relief sunken -bd 2 -textvariable current_object_name -width 12
    bind .current_object_name_entry <Leave> {
        ac3d set_current_object_name $current_object_name
        }

    pack .current_ob_label\
        -in .other_frame3 -side left -fill x -expand 0
    pack .current_object_name_entry\
        -in .other_frame3 -side left -fill both -expand 1

    pack  .message_frame .select_mode_frame .drag_mode_frame   -in .cp -side top -fill x -expand 0
    pack  .draw_mode_frame .function_frame -in .cp -side top -fill x -expand 1
    pack  .other_frame3 .palette_frame .surface_type_frame    -in .cp -side bottom -fill x -expand 0
        


frame .views.xyframe -bd 2 -relief sunken
frame .views.xyframe.f 
pack .views.xyframe.f  -fill both -expand 1
togl .views.xyframe.f.win -rgba true -double true -depth true
pack .views.xyframe.f.win  -fill both -expand 1

frame .views.zyframe -bd 2 -relief sunken
frame .views.zyframe.f 
pack .views.zyframe.f  -fill both -expand 1
togl .views.zyframe.f.win -rgba true -double true -depth true
pack .views.zyframe.f.win  -fill both -expand 1



frame .views.xzframe  -bd 2 -relief sunken
frame .views.xzframe.f 
pack .views.xzframe.f  -fill both -expand 1
togl .views.xzframe.f.win -rgba true -double true -depth true
pack .views.xzframe.f.win  -fill both -expand 1



frame .views.xyzframe -bd 2 -relief sunken
frame .views.xyzframe.f 
pack .views.xyzframe.f  -fill both -expand 1
togl .views.xyzframe.f.win -rgba true -double true -depth true
pack .views.xyzframe.f.win  -fill both -expand 1


# if { $tcl_platform(platform) != "windows" }   
#set fp [option get . keyboardFocusPolicy keyboardFocusPolicy]
#puts "focus policy $fp"                                                                             
#    if { [option get . keyboardFocusPolicy keyboardFocusPolicy] == "pointer" } {
        bind .views.xyframe <Enter> {focus .}
        bind .views.zyframe <Enter> {focus .}
        bind .views.xzframe <Enter> {focus .}
        bind .views.xyzframe <Enter> {focus .}
#    } else { 
#        bind .views.xyframe.f.win <Button> {focus .}
#        bind .views.zyframe <Button> {focus .}
#        bind .views.xzframe <Button> {focus .}
#        bind .views.xyzframe <Button> {focus .}
#    }



set viewsetting all

proc configure_views {} {
global viewsetting
global prefs_window_3d_width_percent
global prefs_window_3d_height_percent

    set w [winfo width .views]
    set h [winfo height .views ]
    set w2 [expr $w/2]
    set h2 [expr $h/2]


   set w3 [expr ($w/100.0)*$prefs_window_3d_width_percent]
   set h3 [expr ($h/100.0)*$prefs_window_3d_height_percent]
   set fw [expr $w-$w3]
   set fh [expr $h-$h3]

    switch $viewsetting {
        "all" {
            .views itemconfigure xy -width $fw -height $fh  
            .views coords xy 0 0

            .views itemconfigure zy -width $w3 -height $fh
            .views coords zy $fw 0

            .views itemconfigure xz -width $fw -height $h3
            .views coords xz 0 $fh

            .views itemconfigure xyz -width $w3 -height $h3 
            .views coords xyz $fw $fh
         }
       "xy" {
            .views coords xy 0 0 
            .views coords zy 5000 5000 
            .views coords xz 5000 5000 
            .views coords xyz 5000 5000 
            .views itemconfigure xy -width $w -height $h
        }
       "zy" {
            .views coords zy 0 0 
            .views coords xy 5000 5000 
            .views coords xz 5000 5000 
            .views coords xyz 5000 5000 
            .views itemconfigure zy -width $w -height $h
        }
       "xz" {
            .views coords xz 0 0 
            .views coords zy 5000 5000 
            .views coords xy 5000 5000 
            .views coords xyz 5000 5000 
            .views itemconfigure xz -width $w -height $h
        }
       "xyz" {
            .views coords xyz 0 0 
            .views coords zy 5000 5000 
            .views coords xy 5000 5000 
            .views coords xy 5000 5000 
            .views itemconfigure xyz -width $w -height $h
        }
    }

}


.views create window 0 0 -anchor nw -window .views.xyframe -tags xy
.views create window 400 0 -window .views.zyframe -anchor nw -tags zy
.views create window 0 400 -window .views.xzframe -anchor nw -tags xz 
.views create window 400 400  -window .views.xyzframe -anchor nw -tags xyz

bind .views <Configure> { configure_views }


proc viewbutton {name label value } {
    radiobutton $name -text $label -command configure_views -value $value \
    -variable viewsetting -indicatoron false -highlightthickness 0
}

mode_button .toolbar.all "ALL" configure_views viewsetting all 
add_balloon .toolbar.all "Tile all windows \[F5]"
mode_button .toolbar.xyz "3D" configure_views viewsetting xyz  
add_balloon .toolbar.xyz "$prefs_window_label_xyz \[F4]"
mode_button .toolbar.xy "XY" configure_views viewsetting xy 
add_balloon .toolbar.xy "$prefs_window_label_xy \[F3]"
mode_button .toolbar.zy "ZY" configure_views viewsetting zy 
add_balloon .toolbar.zy "$prefs_window_label_zy \[F2]"
mode_button .toolbar.xz "XZ" configure_views viewsetting xz  
add_balloon .toolbar.xz "$prefs_window_label_xz \[F1]"

bind . <F1> { set viewsetting xy ; configure_views }
bind . <F2> { set viewsetting zy ; configure_views }
bind . <F3> { set viewsetting xz ; configure_views }
bind . <F4> { set viewsetting xyz ; configure_views }
bind . <F5> { set viewsetting all ; configure_views }

pack .toolbar.all -side right 
pack .toolbar.xyz -side right 
pack .toolbar.xz -side right 
pack .toolbar.zy -side right
pack .toolbar.xy -side right


    # bottombar

    checkbutton .setting_show_centres -text "+"  -variable show_objectcentres -command "ac3d redraw_orth" -highlightthickness 0
    add_balloon .setting_show_centres "Show/hide object centres"
    checkbutton .setting_show_vert -text "V"  -variable show_vertices -command "ac3d redraw_orth" -highlightthickness 0
    add_balloon .setting_show_vert "Show/hide vertices"
    checkbutton .setting_show_grid -text "Grid" -command "" -variable show_grid -command "ac3d redraw_orth" -highlightthickness 0
    add_balloon .setting_show_grid "Switch draw grid"
    checkbutton .setting_gridlock -text "Gridsnap" -command "" -variable gridsnap -highlightthickness 0
    add_balloon .setting_gridlock "Switch snap-to-grid"
    pack .setting_show_centres .setting_show_vert .setting_show_grid \
       .setting_gridlock -in .bottombar -side left


    canvas .progressbar -width 3c -height 0.3c -relief sunken -bd 2
     .progressbar create rectangle 0 0 0 0 -fill blue -tags rect 
    add_balloon .progressbar "This is a progress bar"
    pack .progressbar -in .bottombar -side right

    label .message -textvariable message -width 60
    add_balloon .message "This is a message area"
    pack .message -in .bottombar -side right -fill x 




proc get_cmd {sock} {
    gets $sock cmd

    set result Error
    catch { set result [ uplevel #0 $cmd ] }

    set len [string length $result]
    incr len
    puts $sock $len
    flush $sock
    puts $sock $result
    flush $sock
}


proc do_connection {sock ip port} {
    fileevent $sock readable "get_cmd $sock"
    puts "socket connected to AC3D (socket id $sock, ip $ip, port $port)"
}



set err [catch {set sock [socket -server do_connection $tcl_socket_port]} ]
if {$err != 0 } {
    puts "error opening AC3D tcl socket"
}

#fconfigure $sock -blocking true
#puts "tcl_socket_port $tcl_socket_port"





































































































































