# TCL stuff to handle editing of palette entries


# popup menu bound to each palette button

menu .palette_menu -tearoff 0
.palette_menu add command -label "Edit..." -command "edit_palette_entry"
.palette_menu add command -label "New entry" -command "new_palette_entry"



proc popup_palette_menu { x y entry } {
global current_palette_edit

    tk_popup .palette_menu $x $y
    set current_palette_edit $entry
}


proc add_palette_button { colrgb colindex } {
global .palette_frame.canvas.f
global .palette_frame.canvas
global tcl_platform

    set parent .palette_frame.canvas.f

    set newname [ format "$parent.%04d" $colindex ]


if {$tcl_platform(platform) == "windows"} {
    button $newname -text $colindex -background $colrgb \
        -command "ac3d set_col $colindex ; ac3d redraw_3d" -bd 1 -padx 0 -pady 0 \
        -activebackground $colrgb -highlightthickness 0\
        -bitmap "" -default disabled
    $newname configure -width 3 -height 1

} else {
    button $newname -text $colindex -background $colrgb \
        -command "ac3d set_col $colindex ; ac3d redraw_3d" -bd 1 -padx 0 -pady 0 \
        -activebackground $colrgb -highlightthickness 0\
        -bitmap ""
    $newname configure -width 3 -height 2

}

    
    pack $newname -side left -in $parent

#update
#    set width [winfo width $newname]
#    set height [winfo height $newname ]
#puts "$width $height"

#    set newwidth "[expr ($width * ($colindex+10))]"
#puts "newwidth $newwidth"

#    $parent configure -width $newwidth
#    set region  "{ 0 0 $newwidth 0 }"

#    .palette_frame.canvas configure -scrollregion $region


    bind $newname <3> {
        popup_palette_menu %X %Y %W

    } 
    add_balloon $newname "Set all selected surfaces to this col"
}












# called when the popup menu on a palette entry is selected 

proc edit_palette_entry { } {
global current_palette_edit

    # extract the number of the palette entry from the end of the buttns name
    # there must be an easier way of doing this...
    set buttonid [ string range $current_palette_edit [expr [ string length .palette_frame.canvas.f]+1] end ]


    ac3d edit_palette_entry $buttonid
}


proc new_palette_entry { } {
global current_palette_edit

    # extract the number of the palette entry from the end of the buttns name
    # there must be an easier way of doing this...
    set buttonid [ string range $current_palette_edit [expr [ string length .palette_frame.canvas.f]+1] end ]

    ac3d new_palette_entry $buttonid
}




proc create_scale { name text entry} {

    set len 5c
    set res 0.0039215686
    scale $name -label $text -from 0.0 -to 1.0 -length $len -orient horizontal -command "newcolour $entry" -resolution $res
}



proc newcolour { index value } {
global prefs_realtimecolour
global progset
global current_palette_edit

    set index $current_palette_edit
        
        if { $progset == 0} {
          show_col_on_palbutton
          if { $prefs_realtimecolour} {
            ac3d set_palette_entry $index [.c.f1.diffuse_red get ] [.c.f1.diffuse_green get ]  [.c.f1.diffuse_blue get]\
                [.c.f2.ambient_red get ] [.c.f2.ambient_green get ]  [.c.f2.ambient_blue get] \
                [.c.f3.emissive_red get] [.c.f3.emissive_green get] [.c.f3.emissive_blue get]  \
                [.c.f4.specular_red get] [.c.f4.specular_green get] [.c.f4.specular_blue get] \
                [.c.f5.shininess get] [.c.f5.transparency get]
            ac3d redraw_3d
          }
        }

    } 

proc show_col_on_palbutton {} {

global current_palette_edit

    set index $current_palette_edit

    set palbuttonname [ format ".palette_frame.canvas.f.%04d" $index ]

# perhaps average out diff/amb/emm for a better approximation for button????

    set r  [expr int([.c.f1.diffuse_red get ] * 255)]
    set g  [expr int([.c.f1.diffuse_green get ] * 255)]
    set b  [expr int([.c.f1.diffuse_blue get ] * 255)]
        
    set col  [format #%02x%02x%02x $r $g $b ]
        
        $palbuttonname configure -background $col -activebackground $col

}

  
proc okpal { } {
global current_palette_edit

    set index $current_palette_edit
    show_col_on_palbutton

    ac3d set_palette_entry $index [.c.f1.diffuse_red get ] [.c.f1.diffuse_green get ]  [.c.f1.diffuse_blue get]\
                [.c.f2.ambient_red get ] [.c.f2.ambient_green get ]  [.c.f2.ambient_blue get] \
                [.c.f3.emissive_red get] [.c.f3.emissive_green get] [.c.f3.emissive_blue get]  \
                [.c.f4.specular_red get] [.c.f4.specular_green get] [.c.f4.specular_blue get] \
                [.c.f5.shininess get] [.c.f5.transparency get]
        ac3d redraw_3d
#        destroy .c 
}

proc cancelpal { index diffuse_red diffuse_green diffuse_blue ambient_red ambient_green ambient_blue \
            emmisive shininess transparency } {
#        ac3d set_palette_entry $index $r $g $b $e $s
        destroy .c
        ac3d redraw_3d
}




proc create_palette_window { title entry} {
global prefs_realtimecolour

    toplevel .c
    wm title .c $title

    frame .c.f1
    frame .c.f2
    frame .c.f3
    frame .c.f4
    frame .c.f5

    create_scale .c.f1.diffuse_red "Diffuse Red" $entry
    create_scale .c.f1.diffuse_green "Diffuse Green" $entry
    create_scale .c.f1.diffuse_blue "Diffuse Blue" $entry

    create_scale .c.f2.ambient_red "Ambient Red" $entry
    create_scale .c.f2.ambient_green "Ambient Green" $entry
    create_scale .c.f2.ambient_blue "Ambient Blue" $entry

    create_scale .c.f3.emissive_red "Emissive Red" $entry
    create_scale .c.f3.emissive_green "Emissive Green" $entry
    create_scale .c.f3.emissive_blue "Emissive Blue" $entry

    create_scale .c.f4.specular_red "Specular Red" $entry
    create_scale .c.f4.specular_green "Specular Green" $entry
    create_scale .c.f4.specular_blue "Specular Blue" $entry


    pack .c.f1.diffuse_red .c.f1.diffuse_green .c.f1.diffuse_blue

    pack .c.f2.ambient_red .c.f2.ambient_green .c.f2.ambient_blue
#    pack .c.f1 .c.f2 -side top  -anchor w
#    pack .c.f1 .c.f2 -anchor nw -side left  -expand 1 -fill x


    pack .c.f3.emissive_red .c.f3.emissive_green .c.f3.emissive_blue
    pack .c.f4.specular_red .c.f4.specular_green .c.f4.specular_blue
#    pack .c.f3 .c.f4 -side top  -anchor w

#    pack .c.f3 .c.f4 -anchor sw -side left -fill x -expand 1


    scale .c.f5.shininess -label Shininess -from 0.0 -to 128.0 -length 5c -orient horizontal -command "newcolour $entry" -resolution 1
    create_scale .c.f5.transparency "Transparency" $entry

    pack  .c.f5.shininess .c.f5.transparency
#    pack .c.f5


    frame .c.f
#    button .c.f.okbutton -text "OK" -command "okpal"
    button .c.f.cancelbutton -text "Close" -command "okpal; wm withdraw .c; grab release .c"
    checkbutton .c.f.rtu -text "Realtime update" -variable prefs_realtimecolour
    pack .c.f.rtu -side top
    pack   .c.f.cancelbutton   -side left 


    grid .c.f1 -column 0 -row 0
    grid .c.f2 -column 1 -row 0
    grid .c.f3 -column 0 -row 1
    grid .c.f4 -column 1 -row 1
    grid .c.f5 -column 0 -row 2

    grid .c.f -column 1 -row 2
}







proc edit_colour_ui { entry   diffuse_red diffuse_green diffuse_blue ambient_red ambient_green ambient_blue \
     emissive_red emissive_green emissive_blue \
     specular_red specular_green specular_blue shininess transparency} {

    global prefs_realtimecolour
    global progset
    global current_palette_edit

    set progset 1

    set exists dunno
    catch {set exists [wm state .c]}
    if { $exists == "dunno" } {
        create_palette_window "Edit Material $entry" $entry
        grab .c
    } else {
        wm deiconify .c
        wm title .c  "Edit Material $entry"

    }
    set current_palette_edit $entry


    .c.f1.diffuse_red set $diffuse_red
    .c.f1.diffuse_green set $diffuse_green
    .c.f1.diffuse_blue set $diffuse_blue

    .c.f2.ambient_red set $ambient_red
    .c.f2.ambient_green set $ambient_green
    .c.f2.ambient_blue set $ambient_blue

    .c.f3.emissive_red set $emissive_red
    .c.f3.emissive_green set $emissive_green
    .c.f3.emissive_blue set $emissive_blue

    .c.f4.specular_red set $specular_red
    .c.f4.specular_green set $specular_green
    .c.f4.specular_blue set $specular_blue

    .c.f5.shininess set $shininess
    .c.f5.transparency set $transparency

    set progset 0
    focus .c

}







