


proc prefs_changed { } {
global prefs_recalc_normals

     if { ! $prefs_recalc_normals } {
         if { ![winfo exists .recalc_normals] } {
             cbutton .recalc_normals "Recalc normals" "ac3d recalc_normals_all; ac3d redraw_3d"
             add_balloon .recalc_normals "Force recalculation of lighting normals"
             pack .recalc_normals -in .cp -side top
         }
     } else {
         catch {destroy .recalc_normals }
     }
}

set num_label_edit 0
set num_label_bool 0

proc show_settings {} {
global num_label_edit
global num_label_bool

    set num_label_edit 0
    set num_label_bool 0

    toplevel .panel -class Dialog
    wm transient .panel [winfo toplevel [winfo parent .panel]]
    wm title .panel "Settings"

    frame .panel.f -relief raised -bd 1

    label_edit .panel.f prefs_num_surface_div "Rotate segments" "The number of sections in a sphere and a revolve"
    label_edit .panel.f prefs_revolve_degs "Revolve degrees" "degrees of revolution used in Object->Revolve"
    label_edit .panel.f prefs_extrude_num "Extrude segments" "number of sections in an extrude"
    label_edit .panel.f prefs_grid "Snap grid" "dimension for the 'invisible' snap grid\nactive when 'gridsnap' is on"
    label_edit .panel.f prefs_drawgrid "Draw grid" "dimension for the visible lines in the orthographic windows"
    label_edit .panel.f prefs_meshx "Mesh X" "X dimention for squares in new 'Mesh' objects"
    label_edit .panel.f prefs_meshy "Mesh Y" "Y dimention for squares in new 'Mesh' objects"
    label_edit .panel.f prefs_vert_size "Vertex point size (pixels)" "adjust vertex squares in orth windows"
    label_edit .panel.f prefs_handle_size "Handle size (pixels)" "size of handles at edges of the selection box"
    label_edit .panel.f prefs_axis_size "3D Axis size" "size (m) of axis in 3D window"
    label_edit .panel.f prefs_hole_percent "Make hole %" "percentage of hole to make in Surface->make hole"
    label_edit .panel.f prefs_render_command "Render command" "command that is executed when you select File->render"
    label_edit .panel.f prefs_spike_factor "Spike size (m)" "Spike size in metres used in Surface->Spike" 
    label_edit .panel.f prefs_bevel_size "Bevel size (m)" "bevel size in metres used in Surface->Bevel" 
    label_edit .panel.f prefs_fontpath "fontpath" "File path for AC3D font file used in 'Add text'"
    label_edit .panel.f prefs_pov_file_header "POV header" "Text output at the very top of a POV file"

#    label_bool .panel.f prefs_hollow_handles "Hollow vertex points" "show vertices as outlines rather than filled rects?"
    label_bool .panel.f prefs_balloon_help "Balloon help" "Switch these balloons off!"
    label_bool .panel.f prefs_independent_scaling "Independent window zoom" "are windows all linked together for zooms?"
    label_bool .panel.f prefs_show_axis "Show 3D Axis" "show the 3D axis in the 3D window?"
    label_bool .panel.f prefs_sphere_triangles "Sphere based on triangles" "construct new spheres from triangles or quads?"
    label_bool .panel.f prefs_mesh_triangles "Mesh based on triangles" "construct new meshes from triangles or quads?"
    label_bool .panel.f prefs_fix_view_after_load "Fit view after load %" "zoom in to objects after loading?"
    label_bool .panel.f prefs_output_vrml_normals "Output VRML normals" \
         "some VRML browsers calculate normals, so don't need them supplied.\nswitching this off saves on file size"
    label_bool .panel.f prefs_output_vrml_textures "Output VRML textures" \
         "controls if textures and texture coordinates are generated in VRML files"
    label_bool .panel.f prefs_draw_moving_vertices "Draw vertices when moving" \
         "View vertex position when dragging objects in orth views?"
    label_bool .panel.f prefs_output_rib_header "output Renderman(.rib) header" "output world info/lights etc at start of rib file?"

    label_bool .panel.f prefs_pov_use_object_data "Use object data for POV files" "Use object data in POV file output"
    label_bool .panel.f prefs_rib_use_object_data "Use object data for RIB files" "Use object data in RIB (Renderman) file output"
    label_bool .panel.f prefs_use_textures_for_background_images "Use texturing for bg images" "draw background images with texturemapping or DrawPixel"
    label_bool .panel.f prefs_rotate_about_object_centre "rotate about object centre?" "when using the mouse to rotate an object - \nuse the mouse point or the object's centre to rotate about?"
    label_bool .panel.f prefs_show_window_labels "Display window labels?" "Show the window labels at the top of the orth windows?"

    label_bool .panel.f prefs_recalc_normals "Recalc normals" "Normals are recalculated when you rotate objects and drag vertices\nturning this off will speed up manipulation but may cause objects\nto be lit incorrectly in the 3D view (no difference in wireframe mode).\nWhen this is off, press the recalc normals button once to force recalculation"
    label_bool .panel.f prefs_doublebuffer_orth "Doublebuffer orth windows" "setting this will make updating less flickery\nbut means that you won't see the result of a redraw\n until the whole window has been drawn"

    frame .panel.buttons
    
    button .panel.buttons.ok -text "Close" -command {
        destroy .panel
        prefs_changed
    }
    button .panel.buttons.save -text "Save Settings" -command {
        destroy .panel
        ac3d save_settings
        prefs_changed
    }
    pack .panel.buttons.ok -side left
    pack .panel.buttons.save -side right

    pack .panel.f -side top
    pack .panel.buttons -side bottom

centre_window_on_screen .panel

    grab set .panel
    tkwait window .panel

}



proc label_edit { parent var { text "" } { balloon "" } } {
global num_label_edit

    label $parent.lel$num_label_edit -text $text
    if { $balloon != "" } {
        add_balloon $parent.lel$num_label_edit $balloon
        }

    entry $parent.le$num_label_edit -relief sunken -bd 2 -textvariable $var


    grid  $parent.lel$num_label_edit -column 0 -row $num_label_edit
    grid  $parent.le$num_label_edit -column 1 -row $num_label_edit
    incr num_label_edit
}



proc label_bool { parent var { text "" } { balloon "" } } {
global num_label_bool

    checkbutton $parent.label_edit_check$num_label_bool -text $text -variable $var 
    if { $balloon != "" } {
        add_balloon $parent.label_edit_check$num_label_bool $balloon
        }
    grid $parent.label_edit_check$num_label_bool -column 2 -row $num_label_bool   -sticky w
    incr num_label_bool
}


























