unit wapapi;

interface
uses  TSocketc;

   function StartServing(winhandle :word; imessage :integer) :integer; stdcall;
   function StopServing :integer; stdcall;
   function GetHostName(pName :pchar) :integer; stdcall;
   function GetDocName(pDoc :pchar; var iParms :integer) :integer; stdcall;
   function GetParm(iNumber :integer; pName, pValue :pchar) :integer; export; stdcall;
   function GetParms( pParmNames , pParmValues :array of pchar) :integer;  stdcall;
   function SendDocument(apDocName :pchar) :integer; stdcall;
   function BufferText(apText :PChar) :integer;  stdcall;
   function SendText :integer; stdcall;


implementation
uses
  SysUtils,  Classes,
  NWinSock, wserve {WbServe};
var
  wForm :tWbServe;


// Forward declarations
//
function HTTPConvert(sString :string) :string; forward;


// open the web server window and tell it what window to send
// notification to when a document is requested
//
function StartServing(winHandle :word; iMessage :integer) :integer; export; stdcall;
begin
   wForm := TWbServe.Create(application);
   wForm.InformWindow(winHandle, iMessage);
   StartServing := 1;
end;

function StopServing :integer; export; stdcall;
begin
  if wForm <> nil then
     wForm.Free;
  StopServing := 1;
end;

function GetHostName(pName :pchar) :integer; export; stdcall;
begin
  if StrLen(pName) > 0 then
     begin
        wForm.HostName(pName);
        GetHostName := 1;
     end
  else
     GetHostName := 0;
end;

// Get the name of the document and indicate whether the
//  document has any parameters
//
function GetDocName(pDoc :pchar; var iParms :integer) :integer; export; stdcall;
var
   bParms     :boolean;
   sTemp      :string;
begin
   sTemp := wForm.isFileName;
   if (Length(sTemp) = 0) then
     sTemp := 'Blank Document Name';
   StrPCopy(pDoc, sTemp);
   bParms := wForm.ibParms;
   if bParms = TRUE then
      iParms := wForm.iiParms
   else
      iParms := 0;
   GetDocName := 1;
end;

function GetParm(iNumber :integer; pName, pValue :pchar) :integer; export; stdcall;
var
   iPos, iPos2, iNum, iLen   :integer;
   sParms                    :String;
   sName, sValue             :String;
begin
  sParms := wForm.GetParmString;
  sParms := sParms + '&';
  iNum := 1;
  iPos := 1;
  iLen := Length(sParms);
  while (iNum < iNumber) and (iPos < iLen) do
  begin
     Inc(iPos);
     if sParms[iPos] = '&' then
     begin
        Inc(iPos);
        Inc(iNum);
     end
  end;
  if (iNum < iNumber) then     // The requestes parm # was not found
  begin                        //
     GetParm := -1;
     Exit;
  end;
  sParms := Copy(sParms, iPos, iLen - iPos + 1);
  iPos := Pos('&', sParms);
  if iPos = 0 then iPos := Length(sParms) + 1;
  iPos2 := Pos('=', sParms);
  if (iPos2 > 0) then
     begin
        sName := Copy(sParms, 1, iPos2 - 1);
        sValue := Copy(sParms, iPos2 + 1, iPos - iPos2 - 1);
        //
        // Convert any special characters
        //
        sName := HTTPConvert(sName);
        sValue := HTTPConvert(sValue);
        StrPCopy(pName, sName);
        StrPCopy(pValue, sValue);
        GetParm := 1;
     end
  else
     GetParm := -1;
end;

function GetParms( pParmNames , pParmValues :array of pchar) :integer; export; stdcall;
var
  iPos, iPos2, iNum     :integer;
  sParms                :String;
  sName, sValue         :String;
begin
  sParms := wForm.GetParmString;

  iPos := 1;
  iNum := 0;
  sParms := sParms + '&';
  while (iPos > 0) do
  begin
    iPos := Pos('&', sParms);
    if (iPos > 0) then
       begin
          iPos2 := Pos('=', sParms);
          if (iPos2 > 0) and (iPos2 < iPos) then
             begin
                sName := Copy(sParms, 1, iPos2 - 1);
                sValue := Copy(sParms, iPos2 + 1, iPos - iPos2 - 1);
                Inc(iNum);
                //
                // Convert any special characters
                //
                sName := HTTPConvert(sName);
                sValue := HTTPConvert(sValue);
                //wForm.st_message3.caption := IntToStr(iNum) + ' [' + sName + '] ' + sValue;
                StrPCopy(pParmNames[iNum], sName);
                StrPCopy(pParmValues[iNum], sValue);
             end;
          if (iPos < Length(sParms)) then
             sParms := Copy(sParms, iPos + 1, Length(sParms) - iPos + 1)
          else
             iPos := 0;
       end;
  end;
  GetParms := iNum;
end;



// Send a file to the requestor and close the HTTP connection
//
function SendDocument(apDocName :PChar) :integer; export; stdcall;
begin
   wForm.SendFullObject(apDocName);
   SendDocument := 1;
end;

// Add text to a buffer that will be sent to the requestor
//
function BufferText(apText :PChar) :integer; export; stdcall;
begin
  wForm.AddToBuffer(apText);
  BufferText := 1;
end;

// Send any text in the buffer to the requestor and close the HTTP connection
//
function SendText :integer; export; stdcall;
begin
   wForm.SendText();
end;

// Convert any special characters that are passed from forms
//
function HTTPConvert(sString :string) :string;
var
  iPos, iNum, iCode            :integer;
  sTemp, sChar                 :string;
begin
   sTemp := sString;
   iPos := 1;
   while iPos > 0 do
      begin
         iPos := Pos('+', sTemp);
         if (iPos > 0) then
            sTemp := Copy(sTemp, 1, iPos - 1) + ' ' + Copy(sTemp, iPos + 1, Length(sTemp) - iPos);
      end;

   iPos := 1;
   while iPos > 0 do
      begin
         iPos := Pos('%', sTemp);
         if (iPos > 0 ) then
            begin
               sChar := '$' + Copy(sTemp, iPos + 1, 2);
               Val(sChar, iNum, iCode);
               if iCode = 0 then
                  sChar := Char(iNum)
               else
                 sChar := '?';
               if sChar = '%' then sChar := '#@[a3^er)';
               sTemp := Copy(sTemp, 1, iPos - 1) + sChar + Copy(sTemp, iPos + 3, Length(sTemp)- iPos - 2);
            end;
      end;

   // Re-insert any percent signs that where extracted
   //
   iPos := 1;
   while iPos > 0 do
   begin
      iPos := Pos('#@[a3^er)', sTemp);
      if iPos > 0 then
         sTemp := Copy(sTemp, 1, iPos - 1) + '%' + Copy(sTemp, iPos + 9, Length(sTemp)- iPos - 7);
   end;
   HTTPConvert := sTemp;
end;


exports
  StartServing, StopServing, GetHostName,
  GetDocName, GetParm, GetParms,
  SendDocument,
  BufferText, SendText ;


begin
end.