#include <tbchild.h>
#include <windows.h>
#include <stdlib.h>
static DWORD stdhand[3]={STD_INPUT_HANDLE,STD_OUTPUT_HANDLE,STD_ERROR_HANDLE};
DWORD TBPipeIO(HANDLE *);
static char *  TbMergeEnvir(char **, DWORD);
#define PPIPE 0
#define SPIPE 1
#define RPIPE 2
#define WPIPE 3
#define IPIPE 4
int TbStartChildProcess(phand,pwr,prd,proc,args,envparm,flags,pstart)
HANDLE *phand;
HANDLE *pwr;
HANDLE *prd;
char	*proc;
char **args;
char **envparm;
DWORD flags;
PVOID pstart;
{
    SECURITY_ATTRIBUTES attr;
    HANDLE  pipes[12];
    STARTUPINFO start;
    PROCESS_INFORMATION procdata;
    BOOL	inherit;
    BOOL	procgo;
    DWORD	piped=0;
    DWORD	create=DETACHED_PROCESS;
    char	*envpass=0;
    char	*cmdline;
    char 	**argget;
    int		i;
    int		pipebase=0;
    int		cmdsize=0;
    attr.nLength=sizeof(SECURITY_ATTRIBUTES);
    attr.bInheritHandle=TRUE;
    attr.lpSecurityDescriptor=NULL;

    for (i=0;i<3;i++,phand++,pwr++,prd++,pipebase+=4)
    {
	pipes[pipebase+PPIPE]=*phand;
	pipes[pipebase+SPIPE]=pipes[pipebase+WPIPE]=pipes[pipebase+RPIPE]=0;
	if ( (int) (*phand) >=0)
	{
	    DuplicateHandle(GetCurrentProcess(),
			    GetStdHandle(stdhand[i]),
			    GetCurrentProcess(),
			    &pipes[pipebase+SPIPE],
			    0,
			    FALSE,
			    DUPLICATE_SAME_ACCESS);
      
	    if (!CreatePipe(&pipes[pipebase+RPIPE],
			    &pipes[pipebase+WPIPE],
			    &attr,
			    0))
		return(-1);
	    if (i)
	    {
		if (!SetStdHandle(stdhand[i],
				  pipes[pipebase+WPIPE]))
		    return(-1);
	    }
	    else
	    {
		HANDLE hDup;
		if (!SetStdHandle(stdhand[i],
				  pipes[pipebase+RPIPE]))
		    return(-1);
		DuplicateHandle(GetCurrentProcess(),
				pipes[pipebase+WPIPE],
				GetCurrentProcess(),
				&hDup,
				0,
				FALSE,
				DUPLICATE_SAME_ACCESS);
		CloseHandle(pipes[pipebase+WPIPE]);
		pipes[pipebase+WPIPE]=hDup;
	    }
	}
	*prd=pipes[pipebase+RPIPE];
	*pwr=pipes[pipebase+WPIPE];
    }
    if (!pstart)
    {
	start.cb=sizeof(STARTUPINFO);
	start.lpReserved=NULL;
	start.lpReserved2=NULL;
	start.cbReserved2=0;
	start.lpDesktop=NULL;
	start.lpTitle=NULL;
	start.dwFlags=0;
	pstart=&start;
    }
    envpass=TbMergeEnvir(envparm,flags);
    argget=args;
    while (*argget)
    {
	cmdsize+=strlen(*argget)+2;
	argget++;
    }
    cmdline=alloca(cmdsize+4);
    *cmdline=0;
    argget=args;
    while (*argget)
    {
	strcat(cmdline,*argget);
	strcat(cmdline," ");
	argget++;
    }

    if (flags & TB_START_CHILD_CONSOLE)
	create=0;
    if (flags & TB_START_CHILD_NEWCONSOLE)
	create=CREATE_NEW_CONSOLE;
    procgo=CreateProcess(proc,
			 cmdline,
			 NULL,
			 NULL,
			 TRUE,
			 create,
			 envpass,
			 NULL,
			 pstart,
			 &procdata);
    for (i=0,pipebase=0;i<3;i++,pipebase+=4)
    {
	SetStandardHandle(stdhand[i],
			  pipes[pipebase+SPIPE]);
	if (i)
	    CloseHandle(pipes[pipebase+WPIPE]);
    }
    if (procgo)
    {
	HANDLE *pass,*passput;
	for (i=0,pipebase=0;i<3;i++,pipebase+=4)
	{
	    if ( (int) (pipes[pipebase+PPIPE])>0)
	    {
		int  ii;
		DWORD threadid;
		pass=passput=malloc(sizeof(HANDLE)*5);
		for (ii=0;ii<4;ii++,passput++)
		    *passput=pipes[pipebase+ii];
		*passput=i;
		CreateThread(NULL,
			     0,
			     (LPTHREAD_START_ROUTINE) TBPipeIO,
			     pass,
			     0,
			     &threadid);
	    }
	}
    }
}



#define TBP_BUFFSIZE 1024
DWORD  TBPipeIO(hset)
HANDLE *hset;
{
    char    buff[TBP_BUFFSIZE];
    DWORD   wcount,rcount;

    HANDLE  readh=hset[RPIPE];
    HANDLE  writeh=hset[PPIPE];
    if (!hset[IPIPE])
    {
	readh=hset[PPIPE];
	writeh=hset[WPIPE];
    }
    while (1)
    {
	if (!ReadFile(readh,
		      buff,
		      TBP_BUFFSIZE,
		      &rcount,
		      NULL) || !rcount)
	    break;
	if (!WriteFile(writeh,
		       buff,
		       rcount,
		       &wcount,
		       NULL))
	    break;
    }
    CloseHandle(hset[RPIPE]);
    CloseHandle(hset[WPIPE]);
    return(0);
}








static char *  TbMergeEnvir(envparm,flag)
char **envparm;
DWORD	flag;
{
    char  * passenv=0;
    DWORD   sizeenv=4;
    char  **envlook=envparm;
    char  **envlook2=0;
    int  envlen;
    if (!envparm)
	return(passenv);
    if (flag && TB_START_CHILD_MERGENV )
	envlook2=environ;
    while (*envlook)
    {
	while (*envlook)
	{
	    sizeenv+=strlen(*envlook)+1;
	    envlook++;
	}
	if (envlook2)
	{
	    envlook=envlook2;
	    envlook2=0;
	}	
    }
    passenv=calloc(1,sizeenv);
    sizeenv=0;
    envlook=envparm;
    while (*envlook)
    {
	strcpy(passenv[sizeenv],*envlook);
	sizeenv+=strlen(*envlook)+1;
	envlook++;
    }
    if (!(flag && TB_START_CHILD_MERGENV ))
	return (passenv);
    envlook=environ;
    while (*envlook)
    {
	for(envlen=0;*envlook[envlen] && *envlook[envlen]!='=';envlen++);
	if (*envlook[envlen]=='=')
	{
	    envlook2=envparm;
	    envlen++;
	    while (*envlook2 && strncmp(*envlook2,*envlook,envlen))
		envlook2++;
	    if (!*envlook2)
	    {
		strcpy(passenv[sizeenv],*envlook);
		sizeenv+=strlen(*envlook)+1;
	    }
	}
	envlook++;
    }
    return(passenv);
}

