# Win32 NMAKE definitions


!IF "$(NTBUILD)" == "PDCBUILD"
ntbuild = -DWIN32_PDC_BUILD
!endif

NTTOOLTOP=c:/mstools



!IF "$(NTTOOL)" != ""
NTTOOLTOP=$(NTTOOL)
!ENDIF

NTINCLTOP=$(NTTOOLTOP)/h

!IF "$(NTINCL)" != ""
NTINCLTOP=$(NTINCL)
!ENDIF


!IF "$(NTGNULIB)" == ""
WIN32GNULIBB=\usr\local\lib
!ELSE
WIN32GNULIBB=$(NTGNULIB)
!ENDIF

WIN32GNULIB=$(WIN32GNULIBB)\win32gnu.lib
WIN32GNULIBMT=$(WIN32GNULIBB)\win32gnu.mt.lib

prefix=/usr/local

bindir=$(prefix)/bin
libdir=$(prefix)/lib



!IF "$(MTLIB)" != ""
mtcpy=cp
mtcc=$(cc)
mtcvtobj=$(cvtobj)
!ELSE
mtcpy=rem
mtcc=rem
mtcvtobj=rem
!endif


!IF "$(CPU)" == "i486"

# Debug switches are default for current release
#
# These switches allow for source level debugging
# with NTSD for local and global variables.


CPUTYPE=1
cdebug = -Ox

cc = cl386
cflags	= -c -G4d -W3 -Di386=1 -DWIN32 -DWIN32GNU $(cdebug) -I$(NTTOOLTOP)
cvtobj = REM MIPS-only conversion:
cvtdebug =

!ENDIF

!IF "$(CPU)" == "i386"

# Debug switches are default for current release
#
# These switches allow for source level debugging
# with NTSD for local and global variables.


CPUTYPE=1
cdebug = -Zi -Od

cc = cl386
cflags	= -c -G3d -W3 -Di386=1 -DWIN32 -DWIN32GNU  $(cdebug) -I$(NTTOOLTOP)
cvtobj = REM MIPS-only conversion:
cvtdebug =

!ENDIF



!IF "$(CPU)" == "MIPS"
#declarations for use on self hosted MIPS box.

CPUTYPE=2
cc = cc
cflags	= -c -std -G0 -O -o $(*B).obj -EL -DMIPS=1 -DWIN32 -DWIN32GNU -I$(NTTOOLTOP)
cvtobj = mip2coff
cvtdebug =
!ENDIF

!IFNDEF CPUTYPE
!ERROR  Must specify CPU Environment Variable (i386 or MIPS )
!ENDIF


#Universal declaration


linkdebug = -debug:full -debugtype:cv
link = link $(linkdebug)

# link flags - must be specified after $(link)
#
# conflags : creating a character based console application
# guiflags : creating a GUI based "Windows" application

conflags =  -subsystem:console -entry:mainCRTStartup
guiflags =  -subsystem:windows -entry:WinMainCRTStartup

# Link libraries - system import and C runtime libraries
#
# conlibs : libraries to link with for a console application
# guilibs : libraries to link with for a "Windows" application
#
# note : $(LIB) is set in environment variables

conlibs = $(LIB)\st\libc.lib $(LIB)\ntdll.lib $(LIB)\kernel32.lib $(LIB)\user32.lib 
conlibm = $(LIB)\mt\libcmt.lib $(LIB)\ntdll.lib $(LIB)\kernel32.lib $(LIB)\user32.lib 

guilibs = $(LIB)\libcmt.lib $(LIB)\*.lib


.c.obj:
	$(cc) $(cflags) $(CDEFS) $(ntbuild) $(cvars) $*.c
 	$(cvtobj) $*.obj
#	$(mtcpy) $*.c $*_mt.c
#	$(mtcc) $(cflags) $(CDEFS) $(ntbuild) $(cvars) -D_MT $*_mt.c
#	$(mtcvtobj) $*_mt.obj

