/*
   Alarm support for Windows NT (tm) port of GNU EMACS.
   Copyright (C) 1992 Free Software Foundation, Inc.

   This file is part of GNU Emacs.

   GNU Emacs is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 1, or (at your option) any later
   version.

   GNU Emacs is distributed in the hope that it will be useful, but WITHOUT
   ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
   FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
   more details.

   You should have received a copy of the GNU General Public License along
   with GNU Emacs; see the file COPYING.  If not, write to the Free Software
   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

   Tim Fleehart (apollo@online.com)	2-May-92
*/


/*
 *  Defines that we need from un*x.
 */

#define SIGINT	2		/* interrupt				*/
#define	SIGALRM	14		/* alarm				*/
#define	SIGCHLD	18		/* death of child			*/

#define NSIG	23		/* maximum signal number + 1		*/

#define	SIG_DFL	((int (*)())0)
#define	SIG_IGN	((int (*)())1)
#define	SIG_ERR	((int (*)())-1)

#define MAX_SECONDS ((int)(0xFFFFFFFF / 1000L))


#ifndef	WAIT_FOREVER
#define	WAIT_FOREVER	0xFFFFFFFF
#endif	/* !WAIT_FOREVER */


/*
 * and prototypes for our favourite functions
 */

int		alarm				(int);
int		(*Signal(int, int (*)()))	();
int		kill				(int, int);
int		pause				(void);
void		InitializeSignalProcessing	(void);
int		alarm_thread			(void *);
void		change_alarm			(void);
int		Wait				(int *);
