/* extern.h - External declarations for cpio.
   Copyright (C) 1988, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

extern int reset_time_flag;
extern int io_block_size;
extern int binary_flag;
extern int portability_flag;
extern int create_dir_flag;
extern int rename_flag;
extern int table_flag;
extern int unconditional_flag;
extern int verbose_flag;
extern int link_flag;
extern int retain_time_flag;
extern int copy_matching_files;
extern int numeric_uid;
extern int archive_desc;

extern char *input_buffer, *output_buffer;
extern char *in_buff, *out_buff;
extern unsigned input_size, output_size;
extern long input_bytes, output_bytes;
extern char *directory_name;
extern char **save_patterns;
extern int num_patterns;
extern char name_end;
extern char input_is_special;
extern char output_is_special;
extern char input_is_seekable;
extern char output_is_seekable;
extern char *program_name;
extern int (*xstat) ();
extern void (*copy_function) ();

long lseek ();
#if  !defined(STDC_HEADERS) && !defined(WIN32GNU)
char *malloc ();
char *realloc ();
#endif

char *find_inode_file ();
char *getgroup ();
char *getuser ();
char *xmalloc ();
char *xstrdup ();
void add_inode ();
void copy_buf_out ();
void copy_files ();
void copy_in_buf ();
void create_all_directories ();
void empty_output_buffer ();
void error ();
void get_next_reel ();
void hash_insert ();
void long_format ();
void process_copy_in ();
void process_copy_out();
void process_copy_pass ();
void protection ();
void toss_input ();
void write_out_header ();
