# Copyright (C) 1989, 1990, 1991, 1992 Free Software Foundation, Inc.
#      Written by James Clark (jjc@jclark.com)
# 
# This file is part of groff.
# 
# groff is free software; you can redistribute it and/or modify it under
# the terms of the GNU General Public License as published by the Free
# Software Foundation; either version 2, or (at your option) any later
# version.
# 
# groff is distributed in the hope that it will be useful, but WITHOUT ANY
# WARRANTY; without even the implied warranty of MERCHANTABILITY or
# FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
# for more details.
# 
# You should have received a copy of the GNU General Public License along
# with groff; see the file COPYING.  If not, write to the Free Software
# Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#
# Makefile.comm
#
SHELL=/bin/sh
INCLUDES=-I. -I$(srcdir) -I../include -I$(srcdir)/../include
ALL_CCFLAGS=$(INCLUDES) $(CCDEFINES) $(CCFLAGS) $(CPPFLAGS)
COMPILE.cc=$(CCC) $(ALL_CCFLAGS) -c
ALL_CFLAGS=$(CDEFINES) $(CFLAGS) $(CPPFLAGS)
COMPILE.c=$(CC) $(ALL_CFLAGS)  -c
LINK.cc=$(CCC) $(CCFLAGS) $(LDFLAGS)
LINK.c=$(CC) $(CFLAGS) $(LDFLAGS)
TOP=..
LIBGROFF=$(TOP)/libgroff/libgroff.a
LIBBIB=$(TOP)/libbib/libbib.a
LIBDRIVER=$(TOP)/libdriver/libdriver.a
LIBM=-lm
MLIB=
XLIBS=
YTABH=
YTABC=
GRAM=
LIBCLEAN=
CLEANADD=
MOSTLYCLEANFILES=$(MANCLEAN) $(PROG) $(OBJS) $(GENSRCS) $(GENHDRS) \
  depend.temp core $(CLEANADD)
CLEANFILES=$(LIBCLEAN)
DISTCLEANFILES=TAGS Makefile
REALCLEANFILES=$(YTABC) $(YTABH) Makefile.dep
NAMEPREFIX=
HDRS=
MANPAGES=$(MAN1) $(MAN5) $(MAN7)
MANCLEAN=$(MANPAGES)
fontsubdir=$(fontdir)/dev$(DEV)

all install install_bin install_data TAGS depend distfiles:

install: install_bin install_data

.PHONY: all clean distclean mostlyclean realclean extraclean depend distfiles
.PHONY: install install_bin install_data

mostlyclean:
	-rm -f $(MOSTLYCLEANFILES)

clean:
	-rm -f $(CLEANFILES) $(MOSTLYCLEANFILES)

distclean:
	-rm -f $(DISTCLEANFILES) $(CLEANFILES) $(MOSTLYCLEANFILES)

realclean:
	-rm -f $(REALCLEANFILES) $(DISTCLEANFILES) $(CLEANFILES) \
	  $(MOSTLYCLEANFILES)

extraclean:
	-rm -f $(DISTCLEANFILES) $(CLEANFILES) $(MOSTLYCLEANFILES) \
	  \#* *~ core junk grot old temp tmp tem

.SUFFIXES:
.SUFFIXES: .o .cc .c .y .man .n

.cc.o:
	$(COMPILE.cc) $<

.c.o:
	$(COMPILE.c) $<

.y.cc:
	if test -n "$(YTABH)"; then \
	  $(YACC) $(YACCFLAGS) -d $<; \
	else \
	  $(YACC) $(YACCFLAGS) $<; \
	fi
	mv y.tab.c $@
	test -z "$(YTABH)" || mv y.tab.h $(YTABH)

.man.n:
	@echo Making $@ from $<
	@-rm -f $@
	@sed -e "s;@HYPHENFILE@;$(hyphenfile);g" \
	-e "s;@FONTDIR@;$(fontdir);g" \
	-e "s;@FONTPATH@;$(fontpath);g" \
	-e "s;@MACRODIR@;$(tmacdir);g" \
	-e "s;@MACROPATH@;$(tmacpath);g" \
	-e "s;@DEVICE@;$(DEVICE);g" \
	-e "s;@DEFAULT_INDEX@;$(indexdir)/$(indexname);g" \
	-e "s;@DEFAULT_INDEX_NAME@;$(indexname);g" \
	-e "s;@INDEX_SUFFIX@;$(indexext);g" \
	-e "s;@COMMON_WORDS_FILE@;$(common_words_file);g" \
	-e "s;@MAN1EXT@;$(man1ext);g" \
	-e "s;@MAN5EXT@;$(man5ext);g" \
	-e "s;@MAN7EXT@;$(man7ext);g" \
	-e "s;@TMAC_S@;$(tmac_s);g" \
	-e "s;@TMAC_M@;$(tmac_m);g" \
	-e "s;@TMAC_MDIR@;$(macrodir)/mm;g" \
	-e "s;@BROKEN_SPOOLER_FLAGS@;$(BROKEN_SPOOLER_FLAGS);g" \
	-e "s;@VERSION@;`cat $(srcdir)/../VERSION`;g" \
	-e "s;@MDATE@;`$(SHELL) $(srcdir)/../mdate.sh $<`;g" \
	-e "s;@g@;$(g);g" \
	-e "s;@G@;`echo $(g) | tr [a-z] [A-Z]`;g" \
	$< >$@

.PHONY: install_man
install_man:
	-test -d $(manroot) || mkdir $(manroot)
	-test -d $(man1dir) || mkdir $(man1dir)
	@-pages="$(MAN1)"; \
	for p in $$pages; do \
	 prog=`basename $$p .n`; \
	 target=$(man1dir)/$(NAMEPREFIX)$$prog.$(man1ext); \
	 rm -f $$target; \
	 echo $(INSTALL_DATA) $$p $$target; \
	 $(INSTALL_DATA) $$p $$target; \
	done
	-test -d $(man5dir) || mkdir $(man5dir)
	@-pages="$(MAN5)"; \
	for p in $$pages; do \
	 target=$(man5dir)/`basename $$p .n`.$(man5ext); \
	 rm -f $$target; \
	 echo $(INSTALL_DATA) $$p $$target; \
	 $(INSTALL_DATA) $$p $$target; \
	done
	-test -d $(man7dir) || mkdir $(man7dir)
	@-pages="$(MAN7)"; \
	for p in $$pages; do \
	 target=$(man7dir)/`basename $$p .n`.$(man7ext); \
	 rm -f $$target; \
	 echo $(INSTALL_DATA) $$p $$target; \
	 $(INSTALL_DATA) $$p $$target; \
	done

.PHONY: install_prog
install_prog:
	-test -d $(bindir) || mkdir $(bindir)
	rm -f $(bindir)/$(NAMEPREFIX)$(PROG)
	$(INSTALL_PROGRAM) $(PROG) $(bindir)/$(NAMEPREFIX)$(PROG)

.PHONY: install_dev
install_dev:
	-test -d $(datadir) || mkdir $(datadir)
	-test -d $(datasubdir) || mkdir $(datasubdir)
	-test -d $(fontdir) || mkdir $(fontdir)
	-test -d $(fontsubdir) || mkdir $(fontsubdir)
	-if test -d $(srcdir)/generate; then \
	  test -d $(fontsubdir)/generate || mkdir $(fontsubdir)/generate; \
	fi
	-for f in $(DEVFILES); do \
	  rm -f $(fontsubdir)/$$f; \
	  if test -f $$f; then \
	    $(INSTALL_DATA) $$f $(fontsubdir)/$$f; \
	  else \
	    $(INSTALL_DATA) $(srcdir)/$$f $(fontsubdir)/$$f; \
	  fi; \
	done

.PHONY: depend_src
depend_src: depend.temp
	mv depend.temp Makefile.dep

depend.temp: FORCE
	> depend.temp;
	test -z "$(CCSRCS)$(YTABC)"  \
	  || $(CCC) $(ALL_CCFLAGS) -MM $(CCSRCS) $(YTABC) >>depend.temp
	test -z "$(CSRCS)" \
	  || $(CC) $(ALL_CFLAGS) -MM $(CSRCS) >>depend.temp
	if test -n "$(YTABH)"; then \
	  sed -e 's|$(YTABH)|$(YTABC)|g' depend.temp >depend.temp1; \
	  mv depend.temp1 depend.temp; \
	fi

.PHONY: TAGS_src
TAGS_src:
	$(ETAGS) $(ETAGSFLAGS) $(CCSRCS) $(CSRCS)
	test -z "$(GRAM)$(HDRS)" \
	  || $(ETAGS) $(ETAGSFLAGS) -a $(ETAGSCCFLAG) $(GRAM) $(HDRS)

Makefile:
	-rm -f Makefile
	echo srcdir=$(srcdir) >>Makefile
	echo VPATH=$(VPATH) >>Makefile
	cat $(MAKEFILEPARTS) /dev/null >>Makefile

FORCE:

.NOEXPORT:
