/* BUMP_ALLOC macro - increase table allocation by one element.
   Copyright (C) 1990 Free Software Foundation, Inc.
   Francois Pinard <pinard@iro.umontreal.ca>, 1990.
*/


/* Bump the allocation of the array pointed to by TABLE whenever required.
   The table already has already COUNT elements in it, this macro insure it
   has enough space to accomodate at least one more element.  Space is
   allocated (2 ^ EXPONENT) elements at a time.  Each element of the array
   is of type TYPE.

   Routines `xmalloc' and `xrealloc' are called to do the actual memory
   management.  This implies that the program will abort with an `Out of
   memory!' error if any problem arise.

   To work correctly, at least EXPONENT and TYPE should always be the same
   for all uses of this macro for any given TABLE.  A secure way to achieve
   this is to never use this macro directly, but use it to define other
   macros, which would then be TABLE-specific.

   The first time through, COUNT is usually zero.  Note that COUNT is not
   updated by this macro, but it should be udpate elsewhere, later.  This is
   convenient, because it allows TABLE[COUNT] to refer to the new element at
   the end.  Once its construction is completed, COUNT++ will record it in
   the table.  Calling this macro several times in a row without updating
   COUNT is a bad thing to do.  */

#define BUMP_ALLOC(table, count, exponent, type) \
  BUMP_ALLOC_VARSIZE ((table), (count), (exponent), type, sizeof (type))


/* In cases `sizeof TYPE' would not always yield the correct value for the
   size of each element entry, this macro accepts a supplementary SIZE
   argument.  The EXPONENT, TYPE and SIZE parameters should still have the
   same value for all macro calls related to a specific TABLE.  */

#define BUMP_ALLOC_VARSIZE(table, count, exponent, type, size) \
  if (((count) & ((1 << (exponent)) - 1)) == 0)				\
    if ((count) == 0)							\
      (table) = (type *) xmalloc ((1 << exponent) * size);		\
    else								\
      (table)								\
	= (type *) xrealloc ((table),					\
			     ((count) + (1 << (exponent))) * size);	\
  else
