.ds LH Weak Mutation
.ds RH Introduction
.bp
.ce
.ps 16
Introduction
.ps 12
.XS
Introduction
.XE
.sp
.NH 1
Operator Mutation Coverage
.LP
You can consider weak mutation coverage a
generalization of relational operator coverage (though, in fact, weak
mutation coverage came first).  Relational
coverage hypothesizes that the program contains a misuse of a
relational operator and requires tests that detect that misuse.
The same can be done with misuses of other kinds of operators, in which case we
call the approach \fIoperator mutation coverage\fR.  
.LP
For example, it may be
that a line of code is
.nf

    if (A && B)

but should be 

    if (A || B)

.fi
The coverage condition that distinguishes the correct program from
the buggy program is \fH(A&&B)!=(A||B)\fR.  One of the
arguments must be true, the other false.  Notice that multi-condition
coverage will require \fHA\fR true and \fHB\fR false (because
of C's short-circuit evaluation of \fH&&\fR). In this case,
multi-condition coverage also satisfies weak mutation coverage.
That's not true
of all operators, though.  Another potential fault is using
.nf

	A + B

instead of

	A - B

.fi
This is ruled out when \fHA+B != A-B\fR, or, simplifying, \fHB!=0\fR.
.LP
Such measures have been described in [Howden82], [DeMillo78],
[Hamlet77], and many later papers.
.NH 1 
Operand Mutation Coverage
.LP
Another common fault is to use the wrong variable or constant.  For
example, consider the assignment statement \fHA=C\fR, which should have been
\fHA=B\fR.  The fault will never cause a failure if \fHB\fR always
equals \fHC\fR, so we must write at least one
test in which the two variables have different values.
.LP
These measures are due to [Howden82] and [DeMillo78].  For commentary
on the cost of weak mutation coverage, see [Marick91a].
.NH 1 
The Rest of This Document
.LP
The next chapter describes control file options important to users of
weak mutation.  The chapter after that describes in detail what weak
mutation does and what the reporting tools say about it.  The final
chapter will help you when troubleshooting.
