.ds RH Control File
.bp
.ce
.ps 16
The Control File
.ps 12
.XS
The Control File
.XE
.sp
.NH 1 
Turning on Weak Mutation
.LP
The two types of weak mutation coverage may be turned on separately:
.nf

    (coverage operator operand)
    (coverage operator)
    (coverage operand)

.fi
These two types of coverage are not compatible with race, routine, or
call coverage.  You may use weak mutation coverage together with any
other type of coverage.  To get as much coverage as you can, use
.nf

  (coverage branch loop multi operator operand)

.fi
You do not need to call for relational coverage, since it's a subset of
operator coverage.
.LP
.NH 1 
Options
.LP
The following options may be set (or turned off) in the control file.
They won't make sense until you've read the following chapter.
.XP
\fBmacros\fR	Default: off
.sp
Under operand coverage, macros that expand to a constant, variable
name, array reference, structure dereference, or pointer dereference
are partially instrumented.  The top level construct is instrumented,
but not any components.  That is, given
.nf

#define ACCESS(ARRAY, OFFSET, VAL)  ARRAY[OFFSET+abs(myfun(VAL))]

ACCESS(a, o, v)

.fi
condition counts for the array access will be kept, but not for the
computations within the square brackets.  \fBgreport\fR will make
reports like
.nf

"lc.c", line 252: operand ACCESS might be index.
"lc.c", line 252: operand ACCESS might be constant.
"lc.c", line 252: operand ACCESS never differs from the previous element.

.fi
Operators that expand into operators are ignored.  That is, in
.nf

#define ADD(A+B)
ADD(a, b)+5

.fi
operator coverage will be applied to the \fH+\fR, operand coverage
will be applied to the \fH5\fR, and the expansion of \fHADD(a,b)\fR
will be ignored.

.XP
\fBdereference\fR	Default: on
.sp
Pointers are a problem for operand coverage.  Consider a statement
like 
.nf

	A := *P

.fi
We would like to rule out the case where P might have been Q by
requiring a test case in which *P!=*Q.  This is dangerous if Q is not
a valid pointer.  GCT attempts to avoid the dangers by (for example)
initializing all uninitialized pointers to zero and ruling out null
pointers without dereferencing them.  Not all dangers can be avoided,
but GCT's effectiveness would be markedly diminished if it never
dereferenced suspect pointers.  Consequently, the default is to
dereference pointers when needed.  If a pointer is invalid, a core
dump may result.  In this case, you might modify the program (to use
calloc instead of malloc when allocating arrays of pointers, for
example) or turn off the \fIdereference\fR option.
.XP 
\fBarray-substitutions\fR	Default: on
.sp
This is like the \fIdereference\fR option, but it turns off fewer
substitutions.  In an expression like
.nf

	array[i]
	
.fi
turning \fIarray-substitutions\fR off will eliminate a coverage condition that
would require
.nf

	array[i] != other_array[i]

.fi
.XP
\fBconstants\fR	Default: on
.sp
By default, operand coverage requires every variable to actually vary,
to be non-constant.  In practice, a large number of variables in
correct programs do not vary.  (Typically, these are variables whose
values are calculated only once.)  This results in a great number of
messages from \fBgreport\fR, most of which are impossible to
eliminate.  Sifting through them is a waste of time.  The
\fBconstants\fR option can be used to turn them off.
