.ds RH Routine and Call Coverage
.bp
.sp
.NH 1
Routine Coverage
.XS
   Routine Coverage
.XE
.LP
When an instrumented routine is entered, the condition count is
incremented.  Routine coverage is not affected by macros;
coverage is measured even for routines defined entirely within a
macro.
.LP
The \fBgreport\fR output is straightforward:
.nf

"example1.c", line 9: routine caller is never entered.

.fi
In this case, line 9 is the first statement of the routine (after any
declarations).  If \fBgreport -all\fR is used, you might see 
.nf

"example1.c", line 9: routine caller is never entered. [0]
"example1.c", line 30: routine main is never entered. [1]

.fi
which indicates that \fImain\fR has been called once, \fIcaller\fR
never.
.LP
There is one special case:  routines containing no statements, such as 
.nf

foo()
{
}

or 

foo(a)
int a;
{
  int only_a_declaration = bar(a);
}

.fi
do not have routine instrumentation added.
.sp
.NH 1
Call Coverage
.XS
   Call Coverage
.XE
.LP
When a function call is made, its condition count is incremented.
The point of instrumentation is the function name (which may be a
complex structure, such as an element of an array of function
pointers).  
.LP
\fBgreport\fR identifies both the function called and the function
that makes the call:
.nf

"example1.c", line 9: call of callme (in caller) never made.

.fi
If the function name is complex, it is abbreviated as with
multicondition coverage:
.nf

"example1.c", line 9: call of calltable[...] (in caller) never made.

.fi
Note that there is one condition count for all of \fHcalltable\fR, not
one for each element of the array (whose size may not be known at
compile time).
