.ds RH Checklist
.bp 
.sp 1 
.ce
.ps 16 
A Checklist 
.ps 12 
.XS
A Checklist
.XE
.sp
.LP
This section is to be used as a quick reference and checklist for
using GCT.  Refer to later sections for details.
.IP (1)
Copy the source to a test directory.  
.IP (2) 
Create the control file, \fIgct-ctrl\fR.
.IP (3)
Add a call to \fIgct_readlog\fR when the program starts.
Add calls to \fIgct_writelog\fR wherever the program exits.
.IP (4) 
Add the \fIgct\fR target to the makefile.  If all the source is in
a single directory, the target will look like this:
.RS
.nf

gct:
	gct-init;
	$(MAKE) all "CC=gct"
	$(CC) -c gct-ps-defs.c gct-write.c
	$(MAKE) all "OBJ=$(OBJ) gct-ps-defs.o gct-write.o"
	grestore

.fi
.RE
If you have multiple directories, your makefile will look much like
this:
.RS
.nf

gct:
	gct-init;
	$(MAKE) all "CC=gct -test-dir `pwd`"
	$(CC) -c gct-ps-defs.c gct-write.c
	$(MAKE) all "OBJ=$(OBJ) gct-ps-defs.o gct-write.o"
	grestore

.fi
.RE
The program is then made by typing "make gct".
.IP (6)
Execute the program to create a log file.
.RS
.nf

% \fBa.out < test-script-1\fR
% \fBa.out < test-script-2\fR

.fi
.RE
.IP (7)
Use the reporting tools.
.RS
.nf

hostname% \fBgreport LOG\fR
hostname% \fBgsummary LOG\fR

.fi
.RE

