.ds RH Changes to Makefiles
.bp
.sp
.NH 1
Changes to Makefiles
.XS
   Changes to Makefiles
.XE
.NH 2
Source in One Directory
.LP
GCT was designed to require minimal changes to makefiles and other
system-description scripts.  However, "minimal" is not "none".  
For makefiles, you must do the following:
.IP -
The makefiles must use the $(CC) macro. Instrumentation is done by
causing the makefile to call GCT instead of the standard C compiler:
$(CC) allows this global substitution.
.IP -
The makefile must use some macro that describes the object files of
the program (often called $(OBJ)).
.IP -
You must make sure that the makefile would recompile the source files
that you want instrumented.  (The makefile changes described below
ensure that instrumented files will be reinstrumented the next time
the makefile is invoked.)
.LP
Consider this makefile:

.B1
.RS
.nf
all:	program1.o program2.o
	cc -o system program1.o program2.o

program1.o:	incl.h program1.c
	cc -c program1.c

program2.o:	incl.h program2.c
	cc -c program2.c

.fi
.RE
.B2

It must be changed into the following makefile:

.B1
.RS
.nf
OBJ = program1.o program2.o

all:	$(OBJ)
	$(CC) -o system $(OBJ)

gct:
	gct-init;
	$(MAKE) all "CC=gct"
	$(CC) -c gct-ps-defs.c
	$(CC) -c gct-write.c
	$(MAKE) all "OBJ=$(OBJ) gct-ps-defs.o gct-write.o"
	grestore

program1.o:	incl.h program1.c
	$(CC) -c program1.c

program2.o:	incl.h program2.c
	$(CC)  -c program2.o

.fi
.RE
.B2

The commands in the \fIgct:\fR target do the following:
.IP (1)
\fBgct-init\fR 
.br
\fBgct-init\fR creates the files \fBgct-ps-defs.h\fR,
\fBgct-ps-defs.c\fR, \fBgct-defs.h\fR, and \fBgct-write.c\fR.   
It will not overwrite the latter
three files if they are already there.
.sp
The semicolon after \fBgct-init\fR is
needed because of a bug in some versions of \fBmake\fR.
.IP (2)
\fB$(MAKE) all "CC=gct"\fR
.br
This commands causes the makefile to invoke GCT on all the files it
would normally compile.
The instrumented files will have the same names as the original files.
The original files will be saved in the \fBgct_backup\fR subdirectory.
.IP (3)
\fB$(CC) -c gct-ps-defs.c; $(CC) -c gct-write.c\fR 
.br
This compiles the definitions of the instrumentation log and the
routine that writes the log.  These must be compiled at this point
because they depend on \fBgct-ps-defs.h\fR, which was updated to
contain the size of the log during the previous step.
.br
.IP (4)
\fB$(MAKE) all "OBJ=$(OBJ) gct-lib.o gct-write.o"\fR
.br
This compiles the instrumented files and links them together with
\fBgct-lib.o\fR and \fBgct-write.o\fR into an executable file.
.IP (5)
\fBgrestore\fR
.br
The
\fBgrestore\fR command copies all the files back from
\fBgct_backup\fR.  \fBgreport\fR output refers to the original
filenames, so you want those filenames to be human-readable, not
instrumented.
.sp
If the make fails, \fBgrestore\fR will not be executed.  This can be
useful when diagnosing the problem.  You should run \fBgrestore\fR by
hand before retrying the make.  If you forget, GCT will refuse to
reinstrument the already-instrumented files.  
.sp
BEWARE:  If you don't do the grestore, be careful not to remove the
files in the \fBgct_backup\fR directory.  They may be the only
uninstrumented versions.  (This is why you should always instrument a
copy of your source.)
.sp
.LP
A trace of the original makefile would look like this:
.RS
.nf

cc -c program1.c
cc -c program2.c
cc -o system program1.o program2.o

.fi
.RE
.LP
The modified makefile produces this:
.RS
.nf

gct-init;
make all "CC=gct"
gct -c program1.c
gct -c program2.c
gct -o system program1.o program2.o
cc -c gct-ps-defs.c
cc -c gct-write.c
make all "OBJ=program1.o program2.o gct-lib.o gct-write.o"
cc -c program1.c
cc -c program2.c
cc -o system program1.o program2.o gct-lib.o gct-write.o
grestore

.fi
.RE
.LP
All files are first instrumented, then the utility routines are
compiled, then the now-modified files are compiled.  All the object
files, including the utility routines, are linked together. Finally,
\fBgrestore\fR replaces the instrumented versions with the original
versions.
.NH 2 
Multiple directories
.LP
If source is in several directories, you must make a few extra changes.
.IP -
Make sure that the $(CC) macro is
passed to the makefiles that are called by the main makefile.  Call
the sub-makefiles from the main makefile with \fBmake "CC=$(CC)"\fR.
Sub-makefiles must also use $(CC).
.IP -
The name of the master directory where the map file will be
stored has to be passed down to the sub-makefile. 
Use the \fB-test-dir\fR option to GCT.
.LP
The main makefile could then look like
this, where the additional changes are highlighted.
.br

.B1
.RS
.nf
OBJ=	../src1/program1.o ../src1/program2.o ../src2/program3.o 
	../src2/program4.o ../src2/program5.o

all:     
	cd ../src1; \fBmake "CC=$(CC)"\fR
	cd ../src2; \fBmake "CC=$(CC)"\fR
	$(CC) -o system $(OBJ)

gct:
	gct-init;
	$(MAKE) all \fB"CC=gct -test-dir `pwd`"\fR
	$(CC) -c gct-ps-defs.c gct-write.c
	$(MAKE) all "OBJ=$(OBJ) gct-ps-defs.o gct-write.o"
	grestore 

.fi
.RE
.B2
.sp
Note: If you are working in a hierarchical directory structure, GCT
will greate a \fBgct_backup\fR directory in each subdirectory.
\fBgrestore\fR, run in the master directory, knows about all these
directories and will copy back all the files.
