.ds RH Loop Instrumentation
.bp
.sp
.NH 1
Loop Instrumentation
.XS
   Loop Instrumentation
.XE
.LP
These are the looping statements:
.TS
center allbox tab(|) ;
c c 
l l .
Operator | Point of instrumentation
for|for
while|while
do-while|do
.TE
Loops constructed with gotos are not measured.  
.LP
The \fBgreport\fR
message for a while loop might look like this:
.nf

"example1.c", line 9: loop zero times: 1, one time: 2, many times: 3.

.fi
The output refers to the test of the loop.  The "zero" entry is the
number of times the loop test failed on the first try; the "one" entry is
the number of times it succeeded exactly once; the "many" entry is the
number of times it succeeded at least twice.
.LP
To be precise: a \fItest sequence\fR is the series of values of
the test in a single execution of the loop.  Entering the looping
statement from
outside (even by a goto) begins the sequence; it ends when a statement
outside the loop is executed.  However, the beginning of a sequence
will be missed if a loop is exited with a goto or break and then entered with
another goto.
.LP
These test sequences are required: FALSE; TRUE-FALSE (or simply TRUE in the
case of a goto or break out of the loop); TRUE-TRUE-...-FALSE (or simply
TRUE-TRUE-... in the case of an escape from the loop).
.LP
Note that, in the case of a while loop, the \fBgreport\fR message
.nf

"example1.c", line 9: loop zero times: 1, one time: 0, many times: 0.

.fi
means that the body of the loop was never executed.  In a do-while
loop, it means that the body was executed once, since the loop body is
always executed before the loop test is evaluated.  
Therefore, the interpretation of a
line like the following is tricky:
.nf

"example1.c", line 9: loop zero times: 2, one time: 0, many times: 4.

.fi
The body of the loop has been executed exactly once on two occasions,
exactly twice on no occasions, and more than twice on four occasions.
.LP
This is admittedly confusing and will eventually be fixed.
