.ds LH User's Manual
.ds RH Introduction
.bp 
.ce
.ps 16 
Introduction 
.ps 12
.XS
Introduction
.XE
.sp
.LP
This manual describes the most common uses of GCT.  
You should read \fIA Tutorial Introduction to GCT\fR first.
When using GCT, you'll want to refer to the manpages (which should
have been installed when GCT was) and \fIGCT Troubleshooting\fR.
For conciseness, this manual does not describe some types of
instrumentation.  See \fIUsing Weak Mutation Coverage with GCT\fR and
\fIUsing Race Coverage with GCT\fR.
.NH 1
Test Suite Coverage 
.LP 
How do you tell when you're done testing?  You can test until you run
out of time, test until you can't think of any more test cases that
seem useful, or test until some objective stopping criterion is met.
GCT implements a variety of such criteria.  
.NH 2 
Branch Coverage
.LP
In branch coverage [Myers79], you measure whether every branch in the program
has been taken in every possible direction.  For example, in 
.nf

	func(count)
	{
	  if (count % 2 == 0)
	    printf("count is even.\\n");
	  for(; count < 5; count++)
	    printf("count %d\\n", count);
	}

.fi
the IF statement would have to be taken in both the true and false
directions.  The test of the FOR loop must have evaluated true at
least once and false at least once.  This could be accomplished by 
.nf

	func(4);
	func(13);

.fi
.NH 2 
Multiple-Condition Coverage
.LP
Multiple-condition coverage [Myers79] is stronger than branch coverage.  It
requires that every logical operand take on all possible values.  For
example, for
.nf

	if (A && B)

.fi
multiple condition coverage requires that A be both true and false and
that B be both true and false.  Notice that branch coverage is
satisfied with the two test cases (A=1,B=1) and (A=0, B=1), but
multiple-condition coverage is not.
.NH 2 
Loop coverage
.LP
Neither of the two coverage measures above force the detection of bugs
that exhibit themselves only when a loop is executed more than once.
For a loop like
.nf

	while (test)
	  body

.fi
loop coverage requires three conditions [Howden78], [Beizer83]:
.IP
that the test be FALSE on its first evaluation (thus, the body is not
executed).
.IP
that the test be TRUE the first time, then FALSE.  (The body is
executed exactly once).
.IP
that the test be TRUE at least twice (forcing at least two executions
of the loop).
.NH 2 
Routine Coverage
.LP
Routine coverage measures whether a routine has been entered.  It is
most useful for determining the coverage of large test suites running
against entire systems.
.NH 2
Call Coverage
.LP
Call coverage measures whether a certain function call has been made.
100% call coverage means that all calls between functions have
been exercised at least once:  every function has called every
other that it can call.
.NH 2
Other Coverage
.LP
Two other types of coverage are described in the companion documents 
\fIUsing Weak Mutation Coverage with GCT\fR and
\fIUsing Race Coverage with GCT\fR.
.NH 1 
Some Terminology
.LP
A \fBtest condition\fR is a description of
something that must be tested.  For example, "check that the routine
handles null pointers correctly" or "check that it handles negative
values for the variable A".   A test case may satisfy many test
conditions, and a single test condition may be satisfied by many test
cases.
.LP
Test conditions can be gotten from many places.  People often derive
them by looking at the program's user's manual (or other black-box
description).  GCT derives them from the code.  
GCT-generated test conditions are called \fBcoverage conditions\fR.
.LP
The \fBcondition count\fR tells how often a program under test has
been executed in a way that satisfies a particular coverage
condition.  The coverage condition is a characteristic of a program;
the condition count is a characteristic of a test suite for that
program.
.LP
\fBInstrumentation\fR is code added to the program to increment the
condition counts.
