.ds RH Directory and File Structure
.bp 
.sp
.ce
.ps 16
Instrumenting a Program
.ps 12
.XS
Instrumenting a Program
.XE
.sp
.LP
This chapter describes how to instrument a program.  The next
describes what the coverage data means.
.NH 1
Directory and File Structure
.XS
   Directory and File Structure
.XE
.LP
In the following sections, we will use this directory structure for the
examples.  The directory containing the makefile that makes the final
executable is called the \fBmaster directory\fR.  In our example, the
master directory is named \fBconfig\fR.
.nf


\fBtest/\fR
        \fBconfig/\fR   (the master directory)
                control file   (usually named \fBgct-ctrl\fR)
                map file   (usually named \fBgct-map\fR)
                edit file (usually named \fBgct-edit\fR)
                \fBMakefile\fR   (the master makefile)
                executable
                \fBgct-defs.h\fR
                \fBgct-ps-defs.h\fR
                \fBgct-ps-defs.c\fR
                \fBgct-write.c\fR
                \fBgct-rscript\fR
        \fBsrc1/\fR
                \fBMakefile\fR
                \fBprogram1.c\fR
                \fBprogram2.c\fR
                \fBgct_backup/\fR
                       \fBprogram1.c\fR
                       \fBprogram2.c\fR
        \fBsrc2/\fR
                \fBMakefile\fR
                \fBprogram3.c\fR
                \fBprogram4.c\fR
                \fBprogram5.c\fR

.fi
A number of GCT-specific files are added to the directories.  Most of
them can be ignored; however, all are described here for reference.
.IP "gct-ctrl   "
The control file controls which files and routines are to be
instrumented; it also describes what instrumentation is to be done.
.IP gct-map
Each coverage condition is given a unique number; the map file contains the
information needed to turn that number into comprehensible text.
.IP gct-edit
Each coverage condition may be suppressed using the \fBgedit(1)\fR
program.  This file identifies the suppressed conditions.
.IP gct-defs.h
This contains definitions used in the instrumented files and other
GCT-specific files.  It is copied into the directory once and is
usually never changed.
.IP gct-ps-defs.h
This file is generated each time the Makefile is executed.  Each
invocation of GCT uses this file to tell the next what number to use
for its first condition count.  (Just as a system build has many calls to
the C compiler, an instrumentation has many calls to GCT.)
.IP gct-ps-defs.c
This file contains the definition of the table used to store condition
counts.  It must be recompiled every time a new instrumented executable
is built, but it is never edited.
.IP gct-write.c
This file contains routines to read and write the condition counts.
This file is useful only for application programs; those testing
embedded systems will have to read and write condition counts some
other way. 
.IP gct_backup
When instrumenting a file, a copy is stored in this directory so
that the instrumented version can later be replaced by the original
version.  The makefile usually calls \fBgrestore\fR to do this
automatically.
.IP gct-rscript
This file tells the \fBgrestore\fR program how to undo the effects of
instrumentation.

