.ds RH Instrumenting Embedded Systems
.bp
.sp
.ce
.ps 16
Instrumenting Embedded Systems 
.ps 12
.XS
Instrumenting Embedded Systems
.XE
.sp
.LP
For our purposes, an embedded system is one that can't use ordinary
UNIX I/O.  An example might be a standalone real-time process on a
board that communicates with a server over a network.  The UNIX
kernel itself is another example.
.LP
To use GCT on such systems, you must make two kinds of
changes.  First, you must remove those parts of the library that
depend on normal UNIX I/O.  Second, you must provide another way to
extract the accumulated instrumentation information.
.NH 2 
Removing UNIX I/O
.LP
Do not use \fBgct_readlog()\fR or \fBgct_writelog()\fR.  Do not link 
\fIgct-write.c\fR into the final executable.
.NH 2
Alternate I/O
.LP
The instrumentation log is normally stored in memory until written out
by \fIfprintf\fR calls in \fIgct_writelog\fR.  Decide on some other
way of extracting the log.  For example, when instrumenting the UNIX
kernel, you might simply read it from \fB/dev/kmem\fR.  
.LP
The log is an array named Gct_table, whose size in bytes is given by
Gct_table_size.  The declarations and definitions can be found in
gct-defs.h and gct-ps-defs.c, respectively.
.lp
You need to find a way to transfer that table to the machine where the
map file is stored.  For example, if \fIcnn\fR is an open network
connection, you might use a call like this:
.nf

	result = write(cnn, Gct_table, Gct_table_size);

.fi
That table now needs to be converted into the form that \fBgreport\fR
and \fBgsummary\fR expect.  Write a small program that uses
\fBgct_writelog\fR to do that.
