.ds RH Editing the Source
.bp
.NH 1
Editing the Source
.XS
   Editing the Source
.XE
.NH 2
Gct_writelog
.LP
For speed, GCT uses in-core tables to store condition counts.
To have them
written to disk, you have to add
one line of code per exit to your program.  A call to \fIexit\fR
should be replaced with
.nf

   gct_writelog("\fIlogfile\fR");
   exit(3);

.fi
This calls the library routine \fBgct_writelog\fR which writes all
information about a particular test run to a log file called
\fIlogfile\fR.  Other process-terminating routines (like \fIabort\fR)
must be handled the same way.  If your program "falls off the end of
main", add a call before the closing bracket.
.LP
Often, you can find a simpler solution than editing the whole program.
One example is to add the following to an include file that the whole
program uses:
.RS
.nf

static
my_exit(value)
int value;
{
  gct_writelog("\fIlogfile\fR");
  exit(value);
}
#define exit my_exit

.fi
.RE
In a non-terminating program you must use a trigger event like a signal
to call \fBgct_writelog\fR.  
.NH 2
Gct_readlog
.IP
gct_readlog("\fIlogfile\fR");
.LP
reads condition counts from the given \fIlogfile\fR, if it exists.
If the logfile doesn't exist (or if \fBgct_readlog\fR isn't used),
the counts all start as zero.  The advantage of \fBgct_readlog\fR is
that successive runs of the program produce a cumulative log.  If you
don't use it, you can still create cumulative log files as follows:
.RS
.nf

% a.out < test-script-1; mv LOG LOG.old
% a.out < test-script-2
% gmerge LOG.old LOG > LOG.cumulative

.fi
.RE
but this is considerably less convenient.
