.ds RH The Types of Coverage
.bp
.sp
.ce
.ps 16
The Types of Coverage
.ps 12
.XS
The Types of Coverage
.XE
.sp
.LP
GCT can instrument the program to measure any of these kinds of coverage:
.nf
.ta +10

branch:	branch coverage
multi:	multi-conditional coverage
loop:	loop coverage
relational:	relational operator coverage
routine:	routine entry coverage
call:	call coverage

.fi
This chapter describes precisely what is measured for each of these
kinds.  It also describes what the \fBgreport\fR output will look
like.
.NH 2
More Terminology and Background
.LP
The condition count is incremented by instrumentation code inserted
into the program.  Whether instrumentation is inserted is controlled
in two ways:
.IP (1)
The \fBinstrumentation\fR option.  Normally, everything is
instrumented if the file is processed.
.IP (2)
The \fBmacros\fR option.  Normally, code within the expansion of a macro is not
instrumented.
.LP
When is code "within" a macro's expansion?
Instrumentation applies to whole statements or
expressions in the program (an IF statement, or a relational
expression).  However, GCT decides whether to instrument by examining
a single token, called the \fIpoint of instrumentation\fR. 
.LP
Consider this code:
.nf

        #define IF	if

        IF (x < 5)
        then x = 3;

.fi
The IF statement will \fBnot\fR be instrumented, because the point of
instrumentation (the \fHif\fR) is within a macro, even though the rest
of the statement is not.  The following sections define all the points
of instrumentation.
.LP
The arguments to a macro are part of its expansion.  For example, in
this code
.nf

	#define TEST(tst)  if ((tst)) {
	#define ENDTEST    }

	TEST(a < b)
	   printf("a is less than b");
	ENDTEST

.fi
\fHa<b\fR is not instrumented, for the same reason the \fHif\fR is not.
.LP
Most of the time, these subtleties are invisible.  Since the code
isn't instrumented, it isn't mentioned in \fBgreport\fR output, so you
never think about it.
.NH 2
General Notes about Greport Output
.LP
\fBgreport\fR lines look like this:
.nf

"example1.c", line 9: operator < might be <=. (L == R)
"example1.c", line 10: if was taken TRUE 1, FALSE 1 times.

.fi
"if" and "<" are tags that identify what the line refers to.  If there were more
than one "if" or "<" on the line, the tags would be
ambiguous.  In this case, the second and later instances would be
numbered:
.nf

"example1.c", line 9: operator < might be <=. (L == R)
"example1.c", line 9: operator < (2) might be <=. (L == R)
"example1.c", line 10: if was taken TRUE 1, FALSE 1 times.
"example1.c", line 10: if (2) was taken TRUE 0, FALSE 1 times.

.fi
.LP
In some cases, the identification tag is abbreviated to save space on
the line.
See the section on multicondition coverage, which is the type of
coverage that most uses abbreviations.
