.ds RH The Control File
.bp
.sp
.NH 1
The Control File
.XS
   The Control File
.XE
.LP
.LP
The control file is stored in the master directory.  It determines
which files and routines are instrumented and what kind of
instrumentation is done.   It is usually called \fBgct-ctrl\fR, but
the name can be changed with the \fB-test-control\fR option to GCT.
.LP
The control file consists of a number of entries, arbitrary white
space, and comments.  A comment begins with a '#'; it persists until
the end of the line.  The file contains the following three elements,
called \fItop level directives\fR,
arranged in any order:
.nf

\fIoption directives\fR
\fIcoverage directives\fR
\fIfile directives\fR

.fi
Although none of the directives are required, an empty control file is
useless.  
.NH 2 
Option Directives
.LP
Options set boolean values within GCT; a list of the options and
their default values is given below.  An option directive has this
form:
.nf

   (options \fIoption\fR...)

.fi
By naming an option, you turn it on.  By preceding it with a minus
sign, you turn it off.  Hence,
.nf

   (options option1 option2)

.fi
turns both option1 and option2 on, whereas
.nf

   (options -option1 -option2)

.fi
turns them off.
.LP
A list of options is given after the remaining directives are described.
.NH 2 
Coverage Directives
.LP
A coverage directive tells GCT what kinds of instrumentation to
perform (branch, loop, etc.).  Coverage directives are like options:
they are turned on by naming them, and turned off by preceding their
names with a minus sign:
.nf

   (coverage branch -loop)

.fi
Branch instrumentation is to be inserted; loop instrumentation
is not.
.sp
.sp
All possible coverage\** 
.FS
I am ignoring race and weak mutation coverage, as they're not covered
by this document.
.FE
would be turned on with
.nf

   (coverage branch loop multi relational routine call)

.fi
.sp
By default, no coverage is turned on.
.NH 2 
File Directives
.LP
A file directive has three forms:
.LP
1) Simply naming a file causes it to be instrumented.
Filenames that do not begin with a slash are interpreted relative to
the master directory.  So, file entries for the example directory
structure given earlier might look like:
.sp
.RS
.nf

\&../src1/program1.c
\&../src1/program2.c

.fi
.RE
(Remember that the master makefile is in the \fIconfig\fR subdirectory.)
.LP
2) Preceding a filename with a minus sign causes it not to be
instrumented.
.LP
3) If a file name is enclosed within parentheses, it is instrumented.
Further, option directives and coverage directives may also be specified; they override top-level
directives.  Thus, the following control file specifies that 
\fIoption1\fR applies to all files except \fImacros.c\fR.
.nf

(options option1)
(macros.c (options -option1))

.fi
.NH 2
Routine Directives
.LP
A file directive may also contain one or more routine directives.
A routine directive has one of three forms:
.LP
1) Simply naming a routine causes it to be instrumented.
.LP
2) Preceding its name with a minus sign causes it not to be
instrumented.
.LP
3) If the routine name is within parentheses, it is instrumented.
Option and coverage directives 
may also be specified.  They override those used at the
top level or within filename directives.
.LP
The routine name may be preceded by the keyword "routine"; this allows
you to instrument routines named "options", "instrument",
or "routine":
.nf

(file.c (options option1)
	(routine options (options -option1)))


.fi
.NH 2
Options
.XS
         Options
.XE
.ta +40
.XP
\fBfiles\fR	Default: off
.sp
This option can only be used at the outermost level.  If on, all
files are processed, except those explicitly turned off.  If off,
all files are ignored, except those explicitly turned on.  If a file
is not processed, it is completely untouched by GCT.
.sp
Example:  An empty control file causes no files to be processed.  To
process all files except \fImyfile.c\fR, use this control file:
.nf

(options files)
-myfile.c

.fi
The default is "off" because GCT is usually used from a makefile.  It
is better to explicitly name the files to be instrumented than to rely
on the makefile calling GCT on the right files.  (See section 6, Changes to
Makefiles, for details.)
.sp 2
.XP
\fBinstrument\fR	Default: on
.sp
The previous option told GCT whether to process a file.  This option
tells GCT whether to instrument all routines in such a file.  It is on
by default.
.sp
Example:  Suppose we want to instrument all routines in file1.c,
only routine instrument_me() in file2.c, 
all routines in file3.c except routine
do_not_instrument(), and no other files.
.nf

    # The default is to process no file.
    file1.c
    (file2.c (options -instrument) instrument_me)
    (file3.c -do_not_instrument)

.fi
This option can also be applied to a single routine, though it is
much less useful.  For example, the following control file applies a
debugging option to my_routine(), which we do not
want instrumented:
.nf

   (file2.c 
	(my_routine (options -instrument show-decls)))

.fi
.sp
.XP
\fBmacros\fR	Default: off
.sp
Consider the \fBgetc()\fR macro.  It expands into 298 characters of
code.  The results of instrumenting this could be quite confusing; for
a line like
.nf

   for (c = getc(stream); c >= 'A'; c = getc(stream))

.fi
\fBgreport\fR might refer to the first ">=" in the line, and you very likely
would not realize that the operation referred to is in the expansion
of getc.  Further, it is inappropriate to test the expansion of getc:
having been used millions of times, it's pretty likely to be correct
and should be treated just like a function call.  Therefore, by
default GCT does not instrument code within macro expansions.
.sp
The \fBmacros\fR
option
makes GCT instrument even code within macros.
The main use of this option is for function-defining macros.
Suppose you want to measure branch coverage for this code:
.nf

#define NEWFUNC(NAME, RETURN-TYPE) \\
RETURN-TYPE NAME (stream) \\
FILE *stream; \\
{ \\
    char a = getc(Stream); \\
    if ('0' == a) \\
	return 1; \\
    return 0; \\
}
NEWFUNC(myfunc, float)

.fi
Normally myfunc() would be completely uninstrumented.  To
instrument it, you must use the \fBmacros\fR option:
.nf

   (file.c (myfunc (options macros)))

.fi
You will have to put up with \fBgreport\fR messages about the contents
of \fIgetc\fR; this is unavoidable.  If the body of the function were not
defined within the macro, the option would be unneeded.
.NH 3
Weak Mutation Options
.LP
Some options apply only to weak mutation coverage.  They are
documented in \fIUsing Weak Mutation Coverage with GCT\fR.
.NH 3
Debugging Options
.LP
Some other options are useful when debugging GCT.  They are
documented in the source file \fIgct-opts.def\fR.

