.ds RH Branch Coverage
.bp
.sp
.NH 1
Branch Coverage
.XS
   Branch Coverage
.XE
.LP
When branch instrumentation is turned on, these operators must have
their tests evaluate to both zero and non-zero values:
.sp
.TS
center allbox tab(|) ;
c c 
l l .
Operator | Point of instrumentation
if|if
for|for
while|while
do-while|do
question|?
.TE
.LP
In a switch, each case label must be branched to.  The default case
must also be taken (even if one is not explicitly present).
Fall-throughs and gotos into a switch do not increment condition
counts; only the execution of the \fHswitch\fR expression is considered
to cause a true branch.
For example:
.nf

switch(tag) 
{ 
	case 1:
	case 2:
		<some code>
		break;
	case 3:
		goto_target:
		    <more code>
	case 4:
		<more code>
		break;
}

.fi
.IP -
If \fHtag\fR equals 1, the first case will be marked as
taken.  The second will not be marked as taken until the switch is
executed with \fHtag\fR equal to 2.
.IP -
A goto to \fHgoto_target\fR does not mean the third case has been
taken.  Even though it 
will cause a
fall-through into the fourth case, it does not count as a branch
to that case.
.IP -
Since this switch statement has no default case, GCT will insert
one.  That is, you are required to have a value for \fHtag\fR
different from 1, 2, 3, and 4.
.IP -
The point of instrumentation is the \fHcase\fR or \fHdefault\fR token.  (In
the case of the automatically inserted default, it's the closing
bracket of the switch.)  
.bp
.LP
As an example of the \fBgreport\fR output for branch coverage, consider this
program:

.RS
1    #include <stdio.h>
.br
2
.br
3    main () 
.br
4    {
.br
5      int arg;
.br
6
.br  
7      printf (" This is an example\\n");
.br
8      arg = 1;
.br
9      while ( arg <= 2 ) {
.br
10        if ( arg == 1 ) { if ( 4 == 2*2 ) printf (" Second \\n"); };
.br
11        arg++;
.br
12      };
.br
13      switch (arg) {
.br
14      case 2: /* some code */  break;
.br
15      case 3: printf (" Third \\n");
.br
.br
16      }
.br
17    }
.br
.RE

.LP
\fBgreport\fR's default output describes unsatisfied conditions:
.sp
"example1.c", line 10: if (2) was taken TRUE 1, FALSE 0 times.
.br
"example1.c", line 14: case was taken 0 times.
.br
"example1.c", line 16: default was taken 0 times.

.LP
There is more than one \fHif\fR statement on line 10, so 
\fBgreport\fR adds "(2)".
The system numbers such ambiguous keywords from left to right.
.LP
Note that a default case is reported for line 16, the line of the
switch's closing bracket.
.LP
If all conditions are required, \fBgreport -all\fR should be used:
.sp
"example1.c", line 9: while was taken TRUE 2, FALSE 1 times.
.br
"example1.c", line 10: if was taken TRUE 1, FALSE 1 times.
.br
"example1.c", line 10: if(2) was taken TRUE 1, FALSE 0 times.
.br
"example1.c", line 14: case was taken 0 times.
.br
"example1.c", line 15: case was taken 1 times.
.br
"example1.c", line 16: default was taken 0 times.
.LP
Examining this, we can see that the while loop was executed twice, and
was left because its test evaluated false.
