.+c "Introduction"
In this tutorial, you'll step through the basics of using GCT:
.np
Instrumenting a program.
.np
Obtaining coverage data.
.np
Writing new tests to increase coverage.
.lp
Most of the ideas will be introduced as they're used, but a 
summary of what GCT does seems in order.
.lp
A perfectly effective test suite would find every bug.  Since we don't
know how many bugs there are, we can't measure how closely a test
suite approaches perfection.  Consequently, we use some
approximate measure of test suite quality:  since we can't
measure what we want, we measure something related.
.lp
With coverage, we estimate test suite quality by examining how
thoroughly the tests exercise the code:
.np
Is every \fHif\fR statement taken in both the true and false directions?
(If it's never taken in the true direction, why do you believe 
that case works?)
.np
Is every \fHcase\fR taken?  What about the \fHdefault\fR case?
.np
Is every \fHwhile\fR loop executed more than once?  Does some test force the
\fHwhile\fR loop to be skipped? (That is, force the loop test to be false
the first time it's tested.)
.np
Is every loop executed exactly once?  (There are potential
initialization bugs that can be masked by later iterations of the
loop.)
.np
Do the tests probe off-by-one errors?
.lp
GCT answers these questions; equivalently, it measures branch, loop, and
relational operator 
coverage.  These types of coverage are most appropriate 
near the time the code is written ("unit testing").  Other types of
coverage are better suited for later testing ("system testing"), but
they aren't described here.  The principles are the same.
.lp
One of these principles is that coverage numbers must be used
carefully.  Approximate measures of quality are dangerous; it's easy
to concentrate on the "making the numbers", and somehow losing 
quality in the process.  By analogy, consider hiring a college
graduate.  A perfect grade point average from the best school in the
country means something quite different than one from <insert your
alma mater's traditional rival here>.  You wouldn't hire based only on
GPA; don't judge test quality only on coverage.
.lp
In particular, it is usually unwise to generate tests solely to
achieve high coverage.  While it is true
that good tests imply coverage, the converse is not necessarily true.
Many of the important bugs in programs are caused by omitted code
(such as missing error handling) -- measuring how well tests exercise
the code that's there tells you nothing about whether they exercise
code that's \fInot\fR there.\**
.(f
Here are some references about the prevalence of different types of
errors. Robert L. Glass, \*(lqPersistent Software Errors\*(rq,
\fITransactions on Software Engineering\fR, vol. SE-7, No. 2, pp.
162-168, March, 1981. 
V. Basili and D. Weiss,
\*(lqA Methodology for collecting valid software engineering data\*(rq,
\fIIEEE Transactions on Software Engineering\fR, vol. SE-10,
pp. 728-738, November, 1984.
Thomas J. Ostrand and Elaine J. Weyuker,  \*(lqCollecting and
Categorizing Software Error Data in an Industrial Environment\*(rq,
\fIJournal of Systems and Software\fR, Vol. 4, 1984, pp. 289-300.
Dewayne E. Perry and W. Michael Evangelist,
\*(lqAn Empirical Study of Software Interface Errors\*(rq,
\fIProceedings of the International Symposium on New Directions in
Computing\fP, 
IEEE Computer Society, August 1985, Trondheim, Norway, pages 32-38.
.)f
.lp
Because the focus of this tutorial is the mechanics of GCT, little
more will be said on this very important topic.
