.+c "A First Pass Over the Coverage Data"
.lp
To run the test suite, type 
.nf
\fH
    % run-suite
\fR
.fi
It should take about ten seconds.
The result is a logfile named \fILOG\fR.
.lp
To get a first idea of how thorough the test suite is, type 
.nf
\fH
    % gsummary LOG
\fR
.fi
.lp
You should see this:
.nf

BINARY BRANCH INSTRUMENTATION (76 conditions total)
3 ( 3.95%) not satisfied.
73 (96.05%) fully satisfied.

SWITCH INSTRUMENTATION (14 conditions total)
0 ( 0.00%) not satisfied.
14 (100.00%) fully satisfied.

LOOP INSTRUMENTATION (24 conditions total)
4 (16.67%) not satisfied.
20 (83.33%) fully satisfied.

MULTIPLE CONDITION INSTRUMENTATION (38 conditions total)
2 ( 5.26%) not satisfied.
36 (94.74%) fully satisfied.

OPERATOR INSTRUMENTATION (27 conditions total)
1 ( 3.70%) not satisfied.
26 (96.30%) fully satisfied.

SUMMARY OF ALL CONDITION TYPES (179 total)
10 ( 5.59%) not satisfied.
169 (94.41%) fully satisfied.

.fi
I'll explain the first two sections; the other types of
instrumentation are covered in the next chapter.
.lp
Every branching statement (\fHif\fR, \fH?\fR, or loop test)
generates two \fIcoverage conditions\fR:  one that the true case be
taken, and one 
that the false case be taken.  In \fBlc\fR, there are 38
branching statements generating 76 conditions.  Of these, three have
not been satisfied;  three cases (true or false) remain to be
exercised.
.lp
\fBlc\fR also contains some \fHswitch\fR statements with a total of 14 cases
(including defaults).  All the cases have been taken.  (Each
\fHcase\fR label is a
separate coverage condition.)
.lp
The summary coverage is high.  That's not surprising, since this test
suite was derived by removing a few tests from a test suite that
reached 100% coverage.  However, 
a summary coverage greater
than 90% is typical of thorough test suites.\**
.(f
\** In addition to the \fIExperience\fR paper mentioned earlier, I can
send an unpublished case study: the coverage of GCT's own test suite.
.)f
.lp
Simple numbers like \fBgsummary's\fR are a blunt instrument.
Don't use GCT to reduce your testing to a few
numbers, but rather to expand your understanding of what your
test suite really does.  \fBgreport\fR, described in the next chapter,
is the tool you'll use.
