/* bigram -- list bigrams for locate

   Usage: bigram < text > bigrams
   
   Use 'code' to encode a file using this output.

   Author: James A. Woods (jaw@riacs.edu)
   Modified by David MacKenzie (djm@ai.mit.edu)
   Public domain. */

#include <stdio.h>
#if defined(USG) || defined(STDC_HEADERS)
#include <string.h>
#else
#include <strings.h>
#endif
#ifdef STDC_HEADERS
#include <stdlib.h>
#else
char *malloc ();
#endif

int prefix_length ();

#include <sys/types.h>

#ifdef HAVE_UNISTD_H
#include <unistd.h>
#endif

#ifndef LIMITS_H_MISSING
#include <limits.h>
#else
#include <sys/param.h>
#endif

#ifdef _POSIX_VERSION
#ifndef PATH_MAX
#define PATH_MAX pathconf ("/", _PC_PATH_MAX)
#endif /* PATH_MAX */
#endif /* _POSIX_VERSION */

#ifndef _POSIX_PATH_MAX
#define _POSIX_PATH_MAX 255
#endif

#ifndef PATH_MAX
#ifdef MAXPATHLEN
#define PATH_MAX MAXPATHLEN
#else /* not MAXPATHLEN */
#define PATH_MAX _POSIX_PATH_MAX
#endif /* MAXPATHLEN */
#endif /* not PATH_MAX */

char *path;

char *oldpath;

void
main (argc, argv)
     int argc;
     char **argv;
{
  register int count, j;
  unsigned line_length;
  int path_max;

  path_max = PATH_MAX;
  if (path_max < 1)
    path_max = 1024;
  path = malloc (path_max + 2);
  oldpath = malloc (path_max + 2);
  if (path == 0 || oldpath == 0)
    {
      fprintf (stderr, "%s: virtual memory exhausted\n", argv[0]);
      exit (1);
    }
  path[path_max] = '\0';
  strcpy (oldpath, " ");

  while (fgets (path, path_max, stdin) != NULL)
    {
      line_length = strlen (path);
      if (line_length == 0)
	fprintf (stderr, "%s: null line in input\n", argv[0]);
      else if (path[line_length - 1] != '\n')
	fprintf (stderr, "%s: long line in input; truncating to `%s'\n",
		 argv[0], path);
      else
	path[line_length - 1] = '\0'; /* Remove newline. */

      count = prefix_length (oldpath, path);
      /* Output post-residue bigrams only. */
      for (j = count; path[j] != '\0'; j += 2)
	{
	  if (path[j + 1] == '\0')
	    break;
	  putchar (path[j]);
	  putchar (path[j + 1]);
	  putchar ('\n');
	}
      strcpy (oldpath, path);
    }
  exit (0);
}

/* Return length of longest common prefix of strings S1 and S2. */

int
prefix_length (s1, s2)
     char *s1, *s2;
{
  register char *start;

  for (start = s1; *s1 == *s2; s1++, s2++)
    if (*s1 == '\0')
      break;
  return s1 - start;
}
