/* cpio.h  -  constants and structures for cpio.
   Copyright (C) 1988, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#define	TRUE	1
#define FALSE	0

#if defined( __MSDOS__ ) || defined (WIN32GNU)
#define CONSOLE "con"
#else
#define CONSOLE "/dev/tty"
#endif

#ifdef WIN32GNU
#define mkdir(n,a) _mkdir(n)
#endif


struct cpio_header
{
  unsigned short h_magic;
  short h_dev;
  unsigned short h_ino;
  unsigned short h_mode;
  unsigned short h_uid;
  unsigned short h_gid;
  unsigned short h_nlink;
  short h_rdev;
  unsigned short h_mtimes[2];
  unsigned short h_namesize;
  unsigned short h_filesizes[2];
  unsigned long h_mtime;	/* Long-aligned copy of `h_mtimes'. */
  unsigned long h_filesize;	/* Long-aligned copy of `h_filesizes'. */
  char *h_name;
};
