dnl Parameterized macros that do not check for something specific.
dnl This file is part of Autoconf.
dnl Copyright (C) 1992 Free Software Foundation, Inc.
dnl
dnl This program is free software; you can redistribute it and/or modify
dnl it under the terms of the GNU General Public License as published by
dnl the Free Software Foundation; either version 2, or (at your option)
dnl any later version.
dnl
dnl This program is distributed in the hope that it will be useful,
dnl but WITHOUT ANY WARRANTY; without even the implied warranty of
dnl MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
dnl GNU General Public License for more details.
dnl
dnl You should have received a copy of the GNU General Public License
dnl along with this program; if not, write to the Free Software
dnl Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
dnl
dnl Written by David MacKenzie, with help from 
dnl Franc,ois Pinard, Karl Berry, Richard Pixley, and Ian Lance Taylor.
dnl
changequote([,])dnl
undefine([eval])dnl
dnl
dnl
dnl Utility functions for stamping the configure script.
dnl
dnl
define(AC_ACVERSION, 1.1)dnl
dnl This is defined by the --version option of the autoconf script.
ifdef([AC_PRINT_VERSION], [errprint(Autoconf version AC_ACVERSION
)])dnl
dnl
dnl These are currently not used, for the sake of people who diff
dnl configure scripts and don't want spurious differences.
dnl But they are too clever to just delete.
dnl
define(AC_USER, [esyscmd(
changequote({,})dnl
# Extract the user name from the first pair of parentheses.
({sedcmd='s/[^(]*(\([^)]*\)).*/\1/';}
changequote([,])dnl
whoami || id|sed "$sedcmd") 2>/dev/null|tr -d '\012')])dnl
dnl
define(AC_HOST, [esyscmd((hostname || uname -n) 2>/dev/null|tr -d '\012')])dnl
dnl
define(AC_DATE, [esyscmd(date|tr -d '\012')])dnl
dnl
dnl
dnl Controlling Autoconf operation
dnl
dnl
dnl This is separate from AC_INIT to prevent GNU m4 1.0 from coredumping
dnl when AC_CONFIG_HEADER is used.
define(AC_NOTICE,
[# Guess values for system-dependent variables and create Makefiles.
# Generated automatically using autoconf.
dnl [#] Generated automatically using autoconf version AC_ACVERSION
dnl [#] by AC_USER@AC_HOST on AC_DATE
# Copyright (C) 1991, 1992 Free Software Foundation, Inc.

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

# Usage: configure [--srcdir=DIR] [--host=HOST] [--gas] [--nfp] [--no-create]
#        [--prefix=PREFIX] [--exec_prefix=PREFIX] [--with-PROGRAM] [TARGET]
# Ignores all args except --srcdir, --prefix, --exec_prefix, and --no-create.
])dnl
dnl
define(AC_INIT,
[#!/bin/sh
AC_NOTICE
trap 'rm -f conftest* core; exit 1' 1 3 15

for arg
do
  # Handle --exec_prefix with a space before the argument.
  if test x$next_exec_prefix = xyes; then exec_prefix=$arg; next_exec_prefix=
  # Handle --host with a space before the argument.
  elif test x$next_host = xyes; then next_host=
  # Handle --prefix with a space before the argument.
  elif test x$next_prefix = xyes; then prefix=$arg; next_prefix=
  # Handle --srcdir with a space before the argument.
  elif test x$next_srcdir = xyes; then srcdir=$arg; next_srcdir=
  else
    case $arg in
     -exec_prefix=* | --exec_prefix=* | --exec_prefi=* | --exec_pref=* | --exec_pre=* | --exec_pr=* | --exec_p=* | --exec_=* | --exec=* | --exe=* | --ex=* | --e=*)
changequote(,)dnl
	exec_prefix=`echo $arg | sed 's/[-a-z_]*=//'` ;;
changequote([,])dnl
     -exec_prefix | --exec_prefix | --exec_prefi | --exec_pref | --exec_pre | --exec_pr | --exec_p | --exec_ | --exec | --exe | --ex | --e)
	next_exec_prefix=yes ;;

     -gas | --gas | --ga | --g) ;;

     -host=* | --host=* | --hos=* | --ho=* | --h=*) ;;
     -host | --host | --hos | --ho | --h)
	next_host=yes ;;

     -nfp | --nfp | --nf) ;;

     -no-create | --no-create | --no-creat | --no-crea | --no-cre | --no-cr | --no-c | --no- | --no)
        no_create=1 ;;

     -prefix=* | --prefix=* | --prefi=* | --pref=* | --pre=* | --pr=* | --p=*)
changequote(,)dnl
	prefix=`echo $arg | sed 's/[-a-z_]*=//'` ;;
changequote([,])dnl
     -prefix | --prefix | --prefi | --pref | --pre | --pr | --p)
	next_prefix=yes ;;

     -srcdir=* | --srcdir=* | --srcdi=* | --srcd=* | --src=* | --sr=* | --s=*)
changequote(,)dnl
	srcdir=`echo $arg | sed 's/[-a-z_]*=//'` ;;
changequote([,])dnl
     -srcdir | --srcdir | --srcdi | --srcd | --src | --sr | --s)
	next_srcdir=yes ;;

     -with-* | --with-*) ;;

     *) ;;
    esac
  fi
done

rm -f conftest*
compile='${CC-cc} $DEFS conftest.c -o conftest $LIBS >/dev/null 2>&1'

# A filename unique to this package, relative to the directory that
# configure is in, which we can look for to find out if srcdir is correct.
unique_file=$1

# Find the source files, if location was not specified.
if test -z "$srcdir"; then
  srcdirdefaulted=yes; srcdir=.
  if test ! -r $unique_file; then srcdir=..; fi
fi
if test ! -r $srcdir/$unique_file; then
  if test x$srcdirdefaulted = xyes; then
    echo "configure: Can not find sources in \`.' or \`..'." 1>&2
  else
    echo "configure: Can not find sources in \`${srcdir}'." 1>&2
  fi
  exit 1
fi
# Preserve a srcdir of `.' to avoid automounter screwups with pwd.
# But we can't avoid them for `..', to make subdirectories work.
case $srcdir in
  .|/*|~*) ;;
  *) srcdir=`cd $srcdir; pwd` ;; # Make relative path absolute.
esac
])dnl
dnl
dnl Protects the argument from being diverted twice
dnl if this macro is called twice for it.
dnl Diversion 0 is the normal output.
dnl Diversion 1 is sed substitutions for output files.
dnl Diversion 2 is variable assignments for config.status.
define(AC_SUBST,
[ifdef([AC_SUBST_$1], ,
[define([AC_SUBST_$1], )dnl
divert(1)dnl
s,@$1@,[$]$1,g
divert(2)dnl
$1='[$]$1'
divert(0)dnl
])])dnl
dnl
dnl Guess the value for the `prefix' variable by looking for
dnl the argument program along PATH and taking its parent.
dnl Example: if the argument is `gcc' and we find /usr/local/gnu/bin/gcc, 
dnl set `prefix' to /usr/local/gnu.
define(AC_PREFIX,
[if test -z "$prefix"
then
  echo checking for $1 to derive installation directory prefix
  saveifs="$IFS"; IFS="$IFS:"
  for dir in $PATH; do
    test -z "$dir" && dir=.
    if test $dir != . && test -f $dir/$1; then
changequote(,)dnl
      # Not all systems have dirname.
      prefix=`echo $dir|sed 's,/[^/][^/]*$,,'`
changequote([,])dnl
      break
    fi
  done
  IFS="$saveifs"
fi
])dnl
dnl
define(AC_CONFIG_HEADER, [define(AC_CONFIG_NAME, $1)
compile='rm -f conftest.t;
  mv conftest.c conftest.t;
  echo "$DEFS" > conftest.c;
  cat conftest.t >> conftest.c;
  rm -f conftest.t;
  ${CC-cc} conftest.c -o conftest $LIBS >/dev/null 2>&1'
])dnl
dnl
dnl Don't compare $2 to a blank, so we can support `-Dfoo='.
define(AC_DEFINE,
[ifdef([AC_CONFIG_NAME],
[ifelse($#, 2, [DEFS="${DEFS}#define $1 $2
"], [DEFS="${DEFS}#define $1 1
"])],
[ifelse($#, 2, DEFS="$DEFS -D$1=$2", DEFS="$DEFS -D$1=1")])])dnl
dnl
define(AC_BEFORE,
[ifdef([AC_PROVIDE_$2], [errprint(__file__:__line__: [$2 was called before $1
])])])dnl
dnl
define(AC_REQUIRE,
[ifdef([AC_PROVIDE_$1],,[indir([$1])
])])dnl
dnl
define(AC_PROVIDE,
[define([AC_PROVIDE_$1],)])dnl
dnl
dnl
dnl Checks for kinds of features
dnl
dnl
define(AC_PROGRAM_CHECK,
[if test -z "[$]$1"; then
  echo checking for $2
  saveifs="$IFS"; IFS="${IFS}:"
  for dir in $PATH; do
    test -z "$dir" && dir=.
    if test -f $dir/$2; then
      $1="$3"
      break
    fi
  done
  IFS="$saveifs"
fi
test -z "[$]$1" && $1="$4"
AC_SUBST($1)dnl
])dnl
dnl
define(AC_PROGRAMS_CHECK,
[for p in $2
do
AC_PROGRAM_CHECK($1, [$]p, [$]p, )
test -n "[$]$1" && break
done
])dnl
dnl
define(AC_HEADER_EGREP,
[AC_REQUIRE([AC_PROG_CPP])AC_PROVIDE([$0])ifdef([AC_CONFIG_NAME],
[echo "${DEFS}#include <$2>" > conftest.c
eval "$CPP conftest.c > conftest.out 2>&1"],
[echo '#include <$2>' > conftest.c
eval "$CPP $DEFS conftest.c > conftest.out 2>&1"])
if egrep "$1" conftest.out >/dev/null 2>&1; then
  ifelse([$3], , :, [$3])
ifelse([$4], , , [else 
  $4
])dnl
fi
rm -f conftest*
])dnl
dnl
dnl Because this macro is used by AC_GCC_TRADITIONAL, which must come early,
dnl it is not included in AC_BEFORE checks.
define(AC_PROGRAM_EGREP,
[AC_REQUIRE([AC_PROG_CPP])AC_PROVIDE([$0])cat <<EOF > conftest.c
ifdef([AC_CONFIG_NAME], [$DEFS])
[$2]
EOF
ifdef([AC_CONFIG_NAME],
[eval "$CPP conftest.c > conftest.out 2>&1"],
[eval "$CPP $DEFS conftest.c > conftest.out 2>&1"])
if egrep "$1" conftest.out >/dev/null 2>&1; then
  ifelse([$3], , :, [$3])
ifelse([$4], , , [else 
  $4
])dnl
fi
rm -f conftest*
])dnl
dnl
define(AC_HEADER_CHECK,
[echo checking for $1
ifelse([$3], , [AC_TEST_CPP([#include <$1>], [$2])],
[AC_TEST_CPP([#include <$1>], [$2], [$3])])
])dnl
dnl
define(AC_COMPILE_CHECK,
[AC_PROVIDE([$0])echo checking for $1
echo "$2
main() { exit(0); } t() { $3 }" > conftest.c
dnl Don't try to run the program, which would prevent cross-configuring.
if eval $compile; then
  ifelse([$4], , :, [$4])
ifelse([$5], , , [else
  $5
])dnl
fi
rm -f conftest*]
)dnl
dnl
define(AC_TEST_PROGRAM,
[AC_PROVIDE([$0])ifelse([$4], , , [AC_REQUIRE([AC_CROSS_CHECK])if test -n "$cross_compiling"
then
  $4
else
])dnl
cat <<EOF > conftest.c
[$1]
EOF
eval $compile
if test -s conftest && (./conftest; exit) 2>/dev/null; then
  ifelse([$2], , :, [$2])
ifelse([$3], , , [else
  $3
])dnl
fi
ifelse([$4], , , fi
)dnl
rm -f conftest*])dnl
dnl
define(AC_TEST_CPP,
[AC_REQUIRE([AC_PROG_CPP])cat <<EOF > conftest.c
ifdef([AC_CONFIG_NAME], [$DEFS])
[$1]
EOF
ifdef([AC_CONFIG_NAME],
[err=`eval "$CPP conftest.c 2>&1 >/dev/null"`],
[err=`eval "$CPP $DEFS conftest.c 2>&1 >/dev/null"`])
if test -z "$err"; then
  ifelse([$2], , :, [$2])
ifelse([$3], , , [else
  $3
])dnl
fi
rm -f conftest*])dnl
dnl
define(AC_REPLACE_FUNCS,
[for func in $1
do
AC_COMPILE_CHECK([${func}], ,
[
/* Override any gcc2 internal prototype to avoid an error.  */
extern char ${func}(); ${func}();], , [LIBOBJS="$LIBOBJS ${func}.o"])
done
AC_SUBST(LIBOBJS)dnl
])dnl
dnl
define(AC_FUNC_CHECK,
[ifelse([$3], , [AC_COMPILE_CHECK($1, , [
/* Override any gcc2 internal prototype to avoid an error.  */
extern char $1(); $1();],
$2)], [AC_COMPILE_CHECK($1, , [
/* Override any gcc2 internal prototype to avoid an error.  */
extern char $1(); $1();],
$2, $3)])dnl
])dnl
dnl
define(AC_HAVE_FUNCS,
[for func in $1
do
changequote(,)dnl
trfrom='[a-z]' trto='[A-Z]'
changequote([,])dnl
AC_FUNC_CHECK(${func},
AC_DEFINE(HAVE_`echo $func|tr "$trfrom" "$trto"`))dnl
done
])dnl
dnl
define(AC_HAVE_HEADERS,
[for hdr in $1
do
changequote(,)dnl
trfrom='[a-z]./' trto='[A-Z]__'
changequote([,])dnl
AC_HEADER_CHECK($hdr,
AC_DEFINE(HAVE_`echo $hdr|tr "$trfrom" "$trto"`))dnl
done
])dnl
dnl
dnl
dnl The big finish
dnl
dnl
define(AC_OUTPUT,
[changequote(,)dnl
if test -n "$prefix"; then
  test -z "$exec_prefix" && exec_prefix='$(prefix)'
  prsub="s,^prefix[ 	]*=.*$,prefix = $prefix,"
fi
if test -n "$exec_prefix"; then
  prsub="$prsub
s,^exec_prefix[ 	]*=.*$,exec_prefix = $exec_prefix,"
fi
changequote([,])dnl
AC_SUBST(LIBS)dnl
AC_SUBST(srcdir)dnl
dnl Substituting for DEFS would confuse sed if it contains multiple lines.
ifdef([AC_CONFIG_NAME], ,
[divert(1)dnl
s,@DEFS@,$DEFS,])dnl
divert(2)dnl
DEFS='$DEFS'
prefix='$prefix'
exec_prefix='$exec_prefix'
prsub='$prsub'
divert(0)dnl

trap 'rm -f config.status; exit 1' 1 3 15
echo creating config.status
rm -f config.status
cat <<EOF > config.status
#!/bin/sh
# Generated automatically by configure.
# Run this file to recreate the current configuration.
# This directory was configured as follows:
[#] [$]0 [$]*

case "[\$]1" in
  -recheck | --recheck | --rechec | --reche | --rech | --rec | --re | --r)
  exec /bin/sh [$]0 [$]* ;;
esac

ifdef([AC_CONFIG_NAME],
[trap 'rm -f $1 AC_CONFIG_NAME; exit 1' 1 3 15],
[trap 'rm -f $1; exit 1' 1 3 15])
undivert(2)dnl
EOF
cat <<\EOF >> config.status

top_srcdir=$srcdir
ifelse($#, 1, [for file in $1; do
changequote(,)dnl
  srcdir=$top_srcdir
  # Remove last slash and all that follows it.  Not all systems have dirname.
  dir=`echo $file|sed 's,/[^/][^/]*$,,'`
changequote([,])dnl
  if test "$dir" != "$file"; then
    test "$top_srcdir" != . && srcdir=$top_srcdir/$dir
    test ! -d $dir && mkdir $dir
  fi
  echo creating $file
  rm -f $file
  echo "# Generated automatically from `basename $file`.in by configure." > $file
  sed -e "
$prsub
undivert(1)dnl
" $top_srcdir/${file}.in >> $file
done
])dnl

ifdef([AC_CONFIG_NAME],
[echo creating AC_CONFIG_NAME
# Ultrix awk loses trailing comments from the header file, but
# that's not fatal.
rm -f conftest.h
echo "/* AC_CONFIG_NAME.  Generated automatically by configure.  */" > conftest.h
echo "$DEFS
/* END_OF_DEFS */" |
awk '
changequote(<<,>>)dnl
# The escaped newlines are to work around a bug in GNU m4 0.99
# in quoting more than 2 arguments in a single line.
BEGIN { filenum = 1 }
filenum == 1 && <<$>>1 == "#define" \
{ defs[<<$>>2] = <<$>>3
  for (i = 4; i <= NF; i++)
    defs[<<$>>2] = defs[<<$>>2] " " <<$>>i
}
/END_OF_DEFS/ { filenum = 2; next }
filenum == 2 && <<$>>1 == "#define" && \
defs[<<$>>2] != "" {
  <<$>>3 = defs[<<$>>2]
  print; next
}
filenum == 2 && <<$>>1 == "#undef" && \
defs[<<$>>2] != "" {
  <<$>>1 = "#define"
  <<$>>2 = <<$>>2 " " defs[<<$>>2]
  print; next
}
filenum == 2 { print }
changequote([,])dnl
' - $top_srcdir/AC_CONFIG_NAME.in >> conftest.h
if cmp -s AC_CONFIG_NAME conftest.h 2>/dev/null; then
  # The file exists and we would not be changing it.
  rm -f conftest.h
else
  rm -f AC_CONFIG_NAME
  mv conftest.h AC_CONFIG_NAME
fi

])dnl
EOF
chmod +x config.status
test -n "$no_create" || ./config.status
])dnl
dnl
