/********************************************************************\
*  Julie Solon							     *
*  Microsoft Developer Support                                       *
*  Copyright (c) 1992, 1993 Microsoft Corporation                    *
*                                                                    *
*  Comments:                                                         *
*                                                                    *
*  Functions:							     *
*                                                                    *
*								     *
\********************************************************************/


/*********************  Header Files  *********************/

#include <windows.h>
#include <string.h>
#include "server.h"

/**********************  Defines  *************************/

#define BUFSIZE 25

/*********************  Prototypes  ***********************/

LRESULT WINAPI MainWndProc( HWND, UINT, WPARAM, LPARAM );
LRESULT WINAPI AboutDlgProc( HWND, UINT, WPARAM, LPARAM );
LRESULT WINAPI TestFunc( DWORD * );

/*******************  Global Variables ********************/

HANDLE ghInstance;
char Buffer1[BUFSIZE];
char Buffer2[BUFSIZE];


/********************************************************************\
*  Function: int PASCAL WinMain(HINSTANCE, HINSTANCE, LPSTR, int)    *
*                                                                    *
*   Purpose: Initializes Application                                 *
*                                                                    *
*  Comments: Standard template                                       *
*                                                                    *
*                                                                    *
\********************************************************************/


int PASCAL WinMain( HINSTANCE hInstance,
		    HINSTANCE hPrevInstance,
		    LPSTR lpszCmdLine,
		    int nCmdShow )
{
   WNDCLASS wc;
   MSG msg;
   HWND hWnd;

   if( !hPrevInstance ) {
      wc.lpszClassName = "ServerClass";
      wc.lpfnWndProc = MainWndProc;
      wc.style = CS_OWNDC | CS_VREDRAW | CS_HREDRAW;
      wc.hInstance = hInstance;
      wc.hIcon = LoadIcon( NULL, IDI_APPLICATION );
      wc.hCursor = LoadCursor( NULL, IDC_ARROW );
      wc.hbrBackground = (HBRUSH)( COLOR_WINDOW+1 );
      wc.lpszMenuName = "ServerMenu";
      wc.cbClsExtra = 0;
      wc.cbWndExtra = 0;

      RegisterClass( &wc );
   }

   ghInstance = hInstance;

   hWnd = CreateWindow( "ServerClass",
			"Server Application",
                        WS_OVERLAPPEDWINDOW|WS_HSCROLL|WS_VSCROLL,
                        0,
                        0,
                        CW_USEDEFAULT,
                        CW_USEDEFAULT,
                        NULL,
                        NULL,
                        hInstance,
                        NULL
                      );

   ShowWindow( hWnd, nCmdShow );

   while( GetMessage( &msg, NULL, 0, 0 ) ) {
      TranslateMessage( &msg );
      DispatchMessage( &msg );
   }

   return msg.wParam;
}


/********************************************************************\
* Function: LRESULT CALLBACK MainWndProc(HWND, UINT, WPARAM, LPARAM) *
*                                                                    *
*  Purpose: Processes Application Messages                           *
*                                                                    *
* Comments: The following messages are processed                     *
*                                                                    *
*           WM_CREATE                                                *
*           WM_HSCROLL                                               *
*           WM_VSCROLL                                               *
*           WM_KEYDOWN                                               *
*           WM_PAINT                                                 *
*           WM_COMMAND                                               *
*           WM_DESTROY                                               *
*                                                                    *
*                                                                    *
\********************************************************************/


LRESULT CALLBACK MainWndProc( HWND hWnd, UINT msg, WPARAM wParam,
   LPARAM lParam )
{
   PAINTSTRUCT ps;
   HDC hDC;

   DWORD dwArg;
   DWORD ThreadID;

   STARTUPINFO si;
   PROCESS_INFORMATION pi;

   switch( msg ) {

/**************************************************************\
*     WM_CREATE:					       *
\**************************************************************/

      case WM_CREATE:
         strcpy( Buffer1, "This is a test" );
         strcpy( Buffer2, "This is another test" );

         memset( &si, 0, sizeof(STARTUPINFO) );
         si.lpReserved = NULL;
         si.lpReserved2 = NULL;

         CreateProcess( "cli16.exe",
            NULL,
            NULL,
            NULL,
            TRUE,
            NORMAL_PRIORITY_CLASS,
            NULL,
            NULL,
            &si,
            &pi
         );
	 break;

/**************************************************************\
*     WM_PAINT: 					       *
\**************************************************************/

      case WM_PAINT:
         hDC = BeginPaint( hWnd, &ps );

	 EndPaint( hWnd, &ps );
         break;

/**************************************************************\
*     WM_COMMAND:					       *
\**************************************************************/

      case WM_COMMAND:
         switch( wParam ) {
            case IDM_TEST1:
               dwArg = 1;
               CreateThread(  NULL,
                                 0,
 (LPTHREAD_START_ROUTINE) TestFunc,
                            &dwArg,
                                 0,
                         &ThreadID
               );
               break;
            case IDM_TEST2:
               dwArg = 2;
               CreateThread(  NULL,
                                 0,
 (LPTHREAD_START_ROUTINE) TestFunc,
                            &dwArg,
                                 0,
                         &ThreadID
               );
               break;

	    case IDM_ABOUT:
               DialogBox( ghInstance, "AboutDlg", hWnd, (DLGPROC)  
                             AboutDlgProc );
               break;
         }
         break;

/**************************************************************\
*     WM_DESTROY: PostQuitMessage() is called                  *
\**************************************************************/

      case WM_DESTROY:
         PostQuitMessage( 0 );
         break;

/**************************************************************\
*     Let the default window proc handle all other messages    *
\**************************************************************/

      default:
         return( DefWindowProc( hWnd, msg, wParam, lParam ));
   }

   return 0;
}

/********************************************************************\
* Function: LRESULT CALLBACK AboutDlgProc(HWND, UINT, WPARAM, LPARAM)*
*                                                                    *
*  Purpose: Processes "About" Dialog Box Messages                    *
*                                                                    *
* Comments: The Dialog Box is displayed when the user selects        *
*           Help.About.                                              *
*                                                                    *
\********************************************************************/


LRESULT CALLBACK AboutDlgProc( HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam )
{
   switch( uMsg ) {
      case WM_INITDIALOG:
         return TRUE;
      case WM_COMMAND:
         switch( wParam ) {
            case IDOK:
               EndDialog( hDlg, TRUE );
               return TRUE;
         }
      break;
   }

   return FALSE;
}

/*******************************************************************\
* Function: LRESTULT WINAPI TestFunc( DWORD )                       *
*                                                                   *
*  Purpose: Thread Function                                         *
*                                                                   *
* Comments: User selects menu option Test.Test1 or Test.Test2, a    *
*           thread is started which creates a pipe and puts a       *
*           message in it                                           *
*                                                                   *
\*******************************************************************/


LRESULT WINAPI TestFunc( DWORD *dwArg )
{
   char Buffer[BUFSIZE];

   HANDLE hPipe;
   DWORD dwBytes;
   BOOL fConnected;

   if( *dwArg == 1 )
      lstrcpy( Buffer, Buffer1 );
   else lstrcpy( Buffer, Buffer2 );

   hPipe = CreateNamedPipe( "\\\\.\\pipe\\TestPipe",
      PIPE_ACCESS_OUTBOUND,
      PIPE_TYPE_MESSAGE | PIPE_READMODE_MESSAGE | PIPE_WAIT,
      1,
      BUFSIZE,
      BUFSIZE,
      NMPWAIT_WAIT_FOREVER,
      NULL
   );
   fConnected = ConnectNamedPipe( hPipe, NULL );
   if( fConnected ) {
      WriteFile( hPipe,
      Buffer,
      lstrlen( Buffer ),
      &dwBytes,
      NULL
      );
   }
   FlushFileBuffers( hPipe );
   DisconnectNamedPipe( hPipe );

   CloseHandle( hPipe );
   ExitThread( 1 );
   return TRUE;
}
