// COPYRIGHT:
//
//   (C) Copyright Microsoft Corp. 1992.  All rights reserved.
//
//   You have a royalty-free right to use, modify, reproduce and
//   distribute the Sample Files (and/or any modified version) in
//   any way you find useful, provided that you agree that
//   Microsoft has no warranty obligations or liability for any
//   Sample Application Files which are modified.
#include "windows.h"
#include "mem.h"

/****************************************************************************
    MODULE:  memory2.c

    FUNCTION: MemoryInit(HANDLE)

    PURPOSE: Initializes window data and registers window class

****************************************************************************/


BOOL InitApplication (hInstance)
HANDLE hInstance;
{
   WNDCLASS wc;

   wc.style = NULL;
   wc.lpfnWndProc = MainWndProc;
   wc.cbClsExtra = 0;
   wc.cbWndExtra = 0;
   wc.hInstance = hInstance;
   wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
   wc.hCursor = LoadCursor(NULL, IDC_ARROW);
   wc.hbrBackground = COLOR_WINDOW + 1;
   wc.lpszMenuName = "MemoryMenu";
   wc.lpszClassName = "MemoryWClass";
   return (RegisterClass(&wc));
}


/****************************************************************************
    MODULE:  memory3.c


    FUNCTION:  InitInstance(HANDLE, int)

    PURPOSE:  Saves instance handle and creates main window

****************************************************************************/


BOOL InitInstance (hInstance, nCmdShow)
HANDLE hInstance;
int nCmdShow;
{
   HWND hwnd;

   hInst = hInstance;
   hwnd = CreateWindow("MemoryWClass", "Memory Sample Application",
                       WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT,
                       CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, hInstance,
                       NULL);
   if (!hwnd)
      return (FALSE);
   ShowWindow(hwnd, nCmdShow);
   UpdateWindow(hwnd);
   return (TRUE);
}
