//
//		Copyright 1998
//		North Coast Idea Co.
//		All Rights Reserved.
//

#ifndef __reporter_h
#define __reporter_h

#include "formdefs.h"

class CReporter
{
	friend class CFormImp;

	public:

		// if doCache is true, Reporter will always cache the most recent page.  
		// This reduces redraw times considerably since the metafile doesn't have 
		// to be remerged each time the page is drawn.

		CReporter( bool doCache = true );


		// Destructor.

	  virtual ~CReporter();


		// Display a page on a device context.  This does the work of retrieving
		// the merged metafile.

		void DisplayPage( CDC &dc, CRect &rect, int page );


		// Get a MetaFile of a page.  This just generates the merged metafile for you 
		// to use however you like.	 This may be useful for OLE representations of the 
		// document.

		HMETAFILE GetPageMetaFile( int page );


		// Display a MetaFile on a device context.  This is included to make it easy
		// to display any metafile on a device context.

		void DisplayMetaFile( CDC &dc, CRect &rect, HMETAFILE hmf );


		// Purge the cache.  Purge the cache whenever your source data is modified.  
		// This forces a remerge of the page.  You can also purge the cache to free 
		// up memory without deleting the object.  

		void PurgeCache();


	protected:


		// provide the Resource Id of the MetaFile for the specified page

		virtual int GetRawMetaFileId( int page ) = 0;


		// fill in the NCFORMRECTINFO structure for the current page and rectangle.  See the demo or
		// formdefs.h for details about structure.

		virtual void GetFormRectInfo( int page, int rect, NCFORMRECTINFO &info ){}


		// fill in the NCFORMRECTINFO structure for the field in the rect on page, at col and row.  This is 
		// for the built in table generator.

		virtual void GetTableFieldInfo( int page, int rect, int row, int col, NCFORMRECTINFO &info ){};


	private:

		CFormImp *m_FormImp;
};

#endif