//
//		Copyright 1998
//		North Coast Idea Co.
//		All Rights Reserved.
//

#include "stdafx.h"
#include "resource.h"
#include "Reporter DemoDoc.h"

int CReporterDemoDoc::GetRawMetaFileId( int page )
{
	// return  metafile resource id from page

	switch ( page )
	{
		case 1: // page 1

			return IDR_WMFPAGE1;

		case 2: // page 2

			return IDR_WMFPAGE2;

		case 3: // page 3

			return IDR_WMFPAGE3;
	}

	return 0;
}

// Step through each of the rectangles in the metafile.  When Reporter finds one, 
// it prompts these methods for info about the rect.  The decendant can insert 
// a field, draw directly onto the DC, or leave the rectangle as is.  Look at 
// FormDefs.h for definitions of various constants

void CReporterDemoDoc::GetFormRectInfo( int page, int rect, NCFORMRECTINFO &info )
{
	static char buf[ 128 ];

	switch ( page )
	{
		case 1: // page 1

			switch( rect )
			{
				case 1: // rect 1
					{
						CTime time = CTime::GetCurrentTime();

						CString s = time.Format( "%A, %B %d, %Y" );

						strcpy( buf, s );

						info.text = buf;
					}

					// Text

					info.type = RT_TEXTFIELD;

					// Left justified, Clip if extends beyond rect, color bkgnd, Bold.

					info.flags = TFF_LEFT | TFF_CLIP | TFF_OPAQUE | TFF_BOLD;

					// Use Courier New typface.

					info.typeface = "Courier New";

					return;


				case 2: // rect 2

					{
						CTime time = CTime::GetCurrentTime();

						CString s = time.Format( "%H:%M:%S" );

						strcpy( buf, s );

						info.text = buf;
					}

					info.type = RT_TEXTFIELD;

					info.flags = TFF_LEFT | TFF_BOLD;

					return;	 
			}

		case 2: // page 2

			switch( rect )
			{	
				case 1: // rect 1
				case 2:	// rect 2

					// both of these rectangles are tables with 10 cols and 10 rows.  

					info.type = RT_TABLE;

					info.flags = TRF_HORZLINES | TRF_VERTLINES | TRF_HAIRLINES;

					buf[ 0 ] = 10;	//number of cols

					buf[ 1 ] = 10;	//number of rows

					buf[ 2 ] = 1;		//1st col relative width

					buf[ 3 ] = 1;		//2nd col relative width

					buf[ 4 ] = 1;		//3rd col relative width

					buf[ 5 ] = 1;		//4th col relative width

					buf[ 6 ] = 1;		//5th col relative width

					buf[ 7 ] = 1;		//6th col relative width

					buf[ 8 ] = 1;		//7th col relative width

					buf[ 9 ] = 1;		//8th col relative width

					buf[ 10 ] = 1;	//9th col relative width

					buf[ 11 ] = 1;	//10th col relative width

					info.text = buf;

					return;		

				case 3: // rect 3

					// Checked checkbox

					info.type = RT_CHECKBOX;

					info.flags = CFF_CHECKED;
					
					return;
			
				case 4: // rect 4

					// Checked radio button

					info.type = RT_RADIOBTN;

					info.flags = CFF_CHECKED;

					return;	

				case 5: // rect 5

					// Paint directly to the dc.  This is a raw HDC not a CDC so you 
					// must use GDI API calls.  The dc is a MetaFileDC which limits 
					// some of the GDI functions that will work.  The device context 
					// has all the object selected that were used to draw the rectangle
					// in the metafile graphic.  In this case we have a dotted black pen
					// with a solid red brush.  These are set with the graphics software
					// used to edit the metafile.

					info.type = RT_DIRECT;

					::Pie( info.dc, info.rect.left, info.rect.top, info.rect.right, info.rect.bottom, 
					
						info.rect.right, ( info.rect.top + info.rect.bottom ) / 2,

						( info.rect.left + info.rect.right ) / 2, info.rect.top );
						
					return;
			}

			//case 3:  // page 3

				//  Order form, no fields to merge.
	}
}

// This method allows you to define fields in a table.
// Fields are enumerated first left to right then top to bottom.

void CReporterDemoDoc::GetTableFieldInfo( int page, int rect, int row, int col, NCFORMRECTINFO &info )
{
	static char buf[ 1024 ];

	// Since there are only two Tables and they're both on the same page, we won't test for page 

	if ( row == 1 )  // Table header
	{
		info.type = RT_TEXTFIELD;

		info.flags = TFF_CENTER;

		sprintf( buf, col - 1 ? "%d" : "", col - 1 );

		info.text = buf;

		info.bg = RGB( 192, 192, 192 ); // light gray background
	}

	else if ( col == 1 )
	{
		info.type = RT_TEXTFIELD;

		info.flags = TFF_CENTER;

		sprintf( buf, "%d", row - 1 );

		info.text = buf;

		info.bg = RGB( 192, 192, 192 ); // light gray background
	}
	
	else // fields
	{
		info.type = RT_TEXTFIELD;

		info.flags = TFF_CENTER;

		sprintf( buf, "%d", ( rect == 1 ) ? ( col - 1 ) + ( row - 1 ) : ( col - 1 ) * ( row - 1 )); 

		info.text = buf;
	}	
}

