//
//		Copyright 1998
//		North Coast Idea Co.
//		All Rights Reserved.
//

#ifndef __formdefs_h
#define __formdefs_h

// Rect Types

#define RT_RAW					0x01				// draw the rectangle without merging anything
#define RT_TEXTFIELD 		0x02				// text
#define RT_CHECKBOX  		0x04				// checkbox
#define RT_RADIOBTN			0x08				// radio button
#define RT_TABLE				0x10				// table
#define RT_DIRECT				0x20				// draw on the DC directly

																		
// Text Field Flags

#define TFF_LEFT				0x001				// left justified
#define TFF_RIGHT				0x002				// right justified
#define TFF_CENTER			0x004				// center justified
#define TFF_CLIP				0x008				// clip text
#define TFF_OPAQUE			0x010				// use opaque background
#define TFF_BASELINE		0x020				// baseline text
#define TFF_BOLD				0x040				// bold text
#define TFF_ITALIC			0x080				// italic text 
#define TFF_UNDERLINE		0x100				// underline


// Checkbox and Radio Btn Field Flags

#define CFF_UNCHECKED		0x000				// unchecked
#define CFF_CHECKED			0x001				// checked


// Table Rect Flags

#define TRF_RAWBOX			0x001				// play the rect over the finished grid
#define TRF_VERTLINES		0x002				// use vertical lines
#define TRF_HORZLINES		0x004				// use horizontal lines
#define TRF_HAIRLINES		0x008				// use hairlines
#define TRF_ONEPTLINES	0x010				// use one point lines
#define TRF_TWOPTLINES	0x020				// use two point lines


// NCFORMRECTIFO Structure

typedef struct tagNCFORMRECTINFO
{
	DWORD type;												// type of field

	DWORD flags;											// flags 

	LPCSTR text;											// pointer to char string

	LPCSTR typeface;									// typeface name

	COLORREF fg;											// forground color 0-255

	COLORREF bg;											// background color 0-255

	HDC dc;														// dc for direct drawing

	RECT rect;												// rect for direct drawing

} NCFORMRECTINFO;

#endif