VERSION 5.00
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.2#0"; "comctl32.ocx"
Begin VB.Form frmValueAnalyzer 
   Caption         =   "Value Analyzer"
   ClientHeight    =   2610
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   6720
   LinkTopic       =   "Form1"
   ScaleHeight     =   2610
   ScaleWidth      =   6720
   StartUpPosition =   2  'Bildschirmmitte
   Begin ComctlLib.ListView lvResults 
      Height          =   1695
      Left            =   120
      TabIndex        =   5
      Top             =   840
      Width           =   6495
      _ExtentX        =   11456
      _ExtentY        =   2990
      View            =   3
      LabelWrap       =   -1  'True
      HideSelection   =   -1  'True
      _Version        =   327680
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      BorderStyle     =   1
      Appearance      =   1
      MouseIcon       =   "ValueAnalyzer.frx":0000
      NumItems        =   0
   End
   Begin VB.ComboBox lstSeparator 
      Height          =   315
      Left            =   4320
      TabIndex        =   4
      ToolTipText     =   "Enter or select field separator"
      Top             =   360
      Width           =   975
   End
   Begin VB.CommandButton cmdAnalyze 
      Caption         =   "&Analyze"
      Default         =   -1  'True
      Height          =   375
      Left            =   5520
      TabIndex        =   2
      ToolTipText     =   "Analyze user selection"
      Top             =   300
      Width           =   1095
   End
   Begin VB.ComboBox lstValue 
      Height          =   315
      Left            =   120
      TabIndex        =   1
      ToolTipText     =   "Enter or select value"
      Top             =   360
      Width           =   3975
   End
   Begin VB.Label Label2 
      Caption         =   "&Separator"
      Height          =   255
      Left            =   4320
      TabIndex        =   3
      Top             =   120
      Width           =   855
   End
   Begin VB.Label Label1 
      Caption         =   "&Value"
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   615
   End
End
Attribute VB_Name = "frmValueAnalyzer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Dim oVA As New HTMLA.ValueAnalyzer

Private Sub cmdAnalyze_Click()

    Dim i As Long

    ClearResults
    
    If Len(lstValue.Text) > 0 Then
    
        'get separator
        If Len(lstSeparator.Text) > 0 Then
            oVA.Separator = Asc(Left(lstSeparator.Text, 1))
        End If
        
        'analyze user input
        oVA.Analyze (lstValue.Text)
        
        'output all values
        For i = 1 To oVA.Count
            
            AddResult ValueTypeToText(oVA.ValueType(i)), oVA.ValueData(i), _
                    UnitTypeToText(oVA.UnitType(i)), oVA.UnitData(i)
        Next i
        
    End If
    
End Sub

Private Function ValueTypeToText(ByVal typeId As Long) As String

    Select Case typeId
        Case SHTAValueTypeNull
            ValueTypeToText = "SHTAValueTypeNull"
        Case SHTAValueTypeNumber
            ValueTypeToText = "SHTAValueTypeNumber"
            
        Case SHTAValueTypeString   'this can never happen
            ValueTypeToText = "SHTAValueTypeString"
            
        Case SHTAValueTypeText
            ValueTypeToText = "SHTAValueTypeText"
        Case SHTAValueTypeHexNumber
            ValueTypeToText = "SHTAValueTypeHexNumber"
    End Select

End Function

Private Function UnitTypeToText(ByVal typeId As Long) As String

    Select Case typeId
        Case SHTAUnitTypeNull
            UnitTypeToText = "SHTAUnitTypeNull"
        Case SHTAUnitTypePercent
            UnitTypeToText = "SHTAUnitTypePercent"
        Case SHTAUnitTypeRel
            UnitTypeToText = "SHTAUnitTypeRel"
        Case SHTAUnitTypeUnknown
            UnitTypeToText = "SHTAUnitTypeUnknown"
    End Select

End Function

Private Sub Form_Load()

    Dim oHeader As ColumnHeader
    
    
    'prepare list view
    Set oHeader = lvResults.ColumnHeaders.Add(, , "Value Type")
    oHeader.Width = lvResults.Width / 5
    
    Set oHeader = lvResults.ColumnHeaders.Add(, , "Value Data")
    oHeader.Width = lvResults.Width / 5
    
    Set oHeader = lvResults.ColumnHeaders.Add(, , "Unit Type")
    oHeader.Width = lvResults.Width / 5
    
    Set oHeader = lvResults.ColumnHeaders.Add(, , "Unit Data")
    oHeader.Width = lvResults.Width / 5
    

    'add test values
    lstValue.AddItem "123"
    lstValue.AddItem "1.5"
    lstValue.AddItem "1,5"
    lstValue.AddItem "+1"
    lstValue.AddItem "-1"
    lstValue.AddItem "123*"
    lstValue.AddItem "123%"
    lstValue.AddItem "-123pt"
    lstValue.AddItem "  123pt "
    lstValue.AddItem "  123 pt "  'should be text
    lstValue.AddItem "123, 456"
    lstValue.AddItem "123, 456, 678"
    lstValue.AddItem "123, Beblebrox, 678"
    lstValue.AddItem "1%, 10%, 20%"
    lstValue.AddItem "1*, 10*, 20*"
    lstValue.AddItem "*"
    lstValue.AddItem ",, ,"
    lstValue.AddItem "123; 456; 678"
    lstValue.AddItem "123 456 678"
    lstValue.AddItem "#12345678"
    lstValue.AddItem "#abcdef"
    lstValue.AddItem "#abcdefg" 'should be text, because 'g' is not valid !!!
    
    lstValue.ListIndex = 0
    
    'add separators
    lstSeparator.AddItem ","
    lstSeparator.AddItem ";"
    lstSeparator.AddItem " "
    lstSeparator.ListIndex = 0
    
End Sub


Private Sub AddResult(sValueType As String, sValueData As String, _
    sUnitType As String, sUnitData As String)

    Dim oItem As ListItem
    
    Set oItem = lvResults.ListItems.Add(, , sValueType)
    oItem.SubItems(1) = sValueData
    oItem.SubItems(2) = sUnitType
    oItem.SubItems(3) = sUnitData

End Sub

Private Sub ClearResults()

    lvResults.ListItems.Clear

End Sub
