VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.1#0"; "COMDLG32.OCX"
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.2#0"; "comctl32.ocx"
Begin VB.Form frmMain 
   BorderStyle     =   1  'Fest Einfach
   Caption         =   "DocAnalyzer"
   ClientHeight    =   5475
   ClientLeft      =   150
   ClientTop       =   720
   ClientWidth     =   9975
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   OLEDropMode     =   1  'Manuell
   ScaleHeight     =   5475
   ScaleWidth      =   9975
   StartUpPosition =   3  'Windows-Standard
   Begin ComctlLib.ListView lvAttributes 
      Height          =   1575
      Left            =   120
      TabIndex        =   8
      Top             =   3480
      Width           =   6855
      _ExtentX        =   12091
      _ExtentY        =   2778
      View            =   3
      LabelWrap       =   -1  'True
      HideSelection   =   -1  'True
      _Version        =   327680
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      BorderStyle     =   1
      Appearance      =   1
      NumItems        =   6
      BeginProperty ColumnHeader(1) {0713E8C7-850A-101B-AFC0-4210102A8DA7} 
         Key             =   ""
         Object.Tag             =   ""
         Text            =   "Name"
         Object.Width           =   1270
      EndProperty
      BeginProperty ColumnHeader(2) {0713E8C7-850A-101B-AFC0-4210102A8DA7} 
         SubItemIndex    =   1
         Key             =   ""
         Object.Tag             =   ""
         Text            =   "Value T."
         Object.Width           =   794
      EndProperty
      BeginProperty ColumnHeader(3) {0713E8C7-850A-101B-AFC0-4210102A8DA7} 
         SubItemIndex    =   2
         Key             =   ""
         Object.Tag             =   ""
         Text            =   "ValueData"
         Object.Width           =   4233
      EndProperty
      BeginProperty ColumnHeader(4) {0713E8C7-850A-101B-AFC0-4210102A8DA7} 
         SubItemIndex    =   3
         Key             =   ""
         Object.Tag             =   ""
         Text            =   "Unit Type"
         Object.Width           =   882
      EndProperty
      BeginProperty ColumnHeader(5) {0713E8C7-850A-101B-AFC0-4210102A8DA7} 
         SubItemIndex    =   4
         Key             =   ""
         Object.Tag             =   ""
         Text            =   "Unit Data"
         Object.Width           =   882
      EndProperty
      BeginProperty ColumnHeader(6) {0713E8C7-850A-101B-AFC0-4210102A8DA7} 
         SubItemIndex    =   5
         Key             =   ""
         Object.Tag             =   ""
         Text            =   "Bool"
         Object.Width           =   882
      EndProperty
   End
   Begin ComctlLib.ListView lvDocTypeParams 
      Height          =   1575
      Left            =   7080
      TabIndex        =   6
      Top             =   3480
      Width           =   2775
      _ExtentX        =   4895
      _ExtentY        =   2778
      View            =   3
      LabelWrap       =   -1  'True
      HideSelection   =   -1  'True
      _Version        =   327680
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      BorderStyle     =   1
      Appearance      =   1
      NumItems        =   2
      BeginProperty ColumnHeader(1) {0713E8C7-850A-101B-AFC0-4210102A8DA7} 
         Key             =   ""
         Object.Tag             =   ""
         Text            =   "Value"
         Object.Width           =   2540
      EndProperty
      BeginProperty ColumnHeader(2) {0713E8C7-850A-101B-AFC0-4210102A8DA7} 
         SubItemIndex    =   1
         Key             =   ""
         Object.Tag             =   ""
         Text            =   "Type"
         Object.Width           =   2540
      EndProperty
   End
   Begin VB.TextBox txtData 
      Height          =   735
      Left            =   120
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertikal
      TabIndex        =   2
      Top             =   2400
      Width           =   9735
   End
   Begin ComctlLib.ListView lvObjects 
      Height          =   1695
      Left            =   120
      TabIndex        =   1
      Top             =   360
      Width           =   9735
      _ExtentX        =   17171
      _ExtentY        =   2990
      View            =   3
      LabelEdit       =   1
      LabelWrap       =   -1  'True
      HideSelection   =   -1  'True
      _Version        =   327680
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      BorderStyle     =   1
      Appearance      =   1
      NumItems        =   7
      BeginProperty ColumnHeader(1) {0713E8C7-850A-101B-AFC0-4210102A8DA7} 
         Key             =   ""
         Object.Tag             =   ""
         Text            =   "Type"
         Object.Width           =   1270
      EndProperty
      BeginProperty ColumnHeader(2) {0713E8C7-850A-101B-AFC0-4210102A8DA7} 
         SubItemIndex    =   1
         Key             =   ""
         Object.Tag             =   ""
         Text            =   "AttributeCount"
         Object.Width           =   2540
      EndProperty
      BeginProperty ColumnHeader(3) {0713E8C7-850A-101B-AFC0-4210102A8DA7} 
         SubItemIndex    =   2
         Key             =   ""
         Object.Tag             =   ""
         Text            =   "DocTypeParamCount"
         Object.Width           =   2540
      EndProperty
      BeginProperty ColumnHeader(4) {0713E8C7-850A-101B-AFC0-4210102A8DA7} 
         SubItemIndex    =   3
         Key             =   ""
         Object.Tag             =   ""
         Text            =   "ErrorNumber"
         Object.Width           =   1270
      EndProperty
      BeginProperty ColumnHeader(5) {0713E8C7-850A-101B-AFC0-4210102A8DA7} 
         SubItemIndex    =   4
         Key             =   ""
         Object.Tag             =   ""
         Text            =   "IsEmptySign"
         Object.Width           =   1270
      EndProperty
      BeginProperty ColumnHeader(6) {0713E8C7-850A-101B-AFC0-4210102A8DA7} 
         SubItemIndex    =   5
         Key             =   ""
         Object.Tag             =   ""
         Text            =   "Line"
         Object.Width           =   1270
      EndProperty
      BeginProperty ColumnHeader(7) {0713E8C7-850A-101B-AFC0-4210102A8DA7} 
         SubItemIndex    =   6
         Key             =   ""
         Object.Tag             =   ""
         Text            =   "Offset"
         Object.Width           =   1270
      EndProperty
   End
   Begin ComctlLib.StatusBar sbStatusBar 
      Align           =   2  'Unten ausrichten
      Height          =   270
      Left            =   0
      TabIndex        =   0
      Top             =   5205
      Width           =   9975
      _ExtentX        =   17595
      _ExtentY        =   476
      Style           =   1
      SimpleText      =   ""
      _Version        =   327680
      BeginProperty Panels {0713E89E-850A-101B-AFC0-4210102A8DA7} 
         NumPanels       =   3
         BeginProperty Panel1 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            AutoSize        =   1
            Object.Width           =   12409
            Text            =   "Status"
            TextSave        =   "Status"
            Object.Tag             =   ""
         EndProperty
         BeginProperty Panel2 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            Style           =   6
            AutoSize        =   2
            TextSave        =   "28.06.98"
            Object.Tag             =   ""
         EndProperty
         BeginProperty Panel3 {0713E89F-850A-101B-AFC0-4210102A8DA7} 
            Style           =   5
            AutoSize        =   2
            TextSave        =   "23:37"
            Object.Tag             =   ""
         EndProperty
      EndProperty
   End
   Begin MSComDlg.CommonDialog dlgCommonDialog 
      Left            =   1620
      Top             =   1350
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   327680
   End
   Begin VB.Label Label4 
      Caption         =   "&Attributes:"
      Height          =   255
      Left            =   120
      TabIndex        =   7
      Top             =   3240
      Width           =   975
   End
   Begin VB.Label Label3 
      Caption         =   "&DocTypeParams:"
      Height          =   255
      Left            =   7080
      TabIndex        =   5
      Top             =   3240
      Width           =   1575
   End
   Begin VB.Label Label2 
      Caption         =   "&Data:"
      Height          =   255
      Left            =   120
      TabIndex        =   4
      Top             =   2160
      Width           =   855
   End
   Begin VB.Label Label1 
      Caption         =   "&HTML Object:"
      Height          =   255
      Left            =   120
      TabIndex        =   3
      Top             =   120
      Width           =   1215
   End
   Begin ComctlLib.ImageList imlIcons 
      Left            =   1620
      Top             =   1590
      _ExtentX        =   1005
      _ExtentY        =   1005
      BackColor       =   -2147483643
      ImageWidth      =   16
      ImageHeight     =   16
      MaskColor       =   12632256
      _Version        =   327680
      BeginProperty Images {0713E8C2-850A-101B-AFC0-4210102A8DA7} 
         NumListImages   =   13
         BeginProperty ListImage1 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "frmMain.frx":0000
            Key             =   ""
         EndProperty
         BeginProperty ListImage2 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "frmMain.frx":0352
            Key             =   ""
         EndProperty
         BeginProperty ListImage3 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "frmMain.frx":06A4
            Key             =   ""
         EndProperty
         BeginProperty ListImage4 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "frmMain.frx":09F6
            Key             =   ""
         EndProperty
         BeginProperty ListImage5 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "frmMain.frx":0D48
            Key             =   ""
         EndProperty
         BeginProperty ListImage6 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "frmMain.frx":109A
            Key             =   ""
         EndProperty
         BeginProperty ListImage7 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "frmMain.frx":13EC
            Key             =   ""
         EndProperty
         BeginProperty ListImage8 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "frmMain.frx":173E
            Key             =   ""
         EndProperty
         BeginProperty ListImage9 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "frmMain.frx":1A90
            Key             =   ""
         EndProperty
         BeginProperty ListImage10 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "frmMain.frx":1DE2
            Key             =   ""
         EndProperty
         BeginProperty ListImage11 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "frmMain.frx":2134
            Key             =   ""
         EndProperty
         BeginProperty ListImage12 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "frmMain.frx":2486
            Key             =   ""
         EndProperty
         BeginProperty ListImage13 {0713E8C3-850A-101B-AFC0-4210102A8DA7} 
            Picture         =   "frmMain.frx":27D8
            Key             =   ""
         EndProperty
      EndProperty
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuFileOpen 
         Caption         =   "&Open"
         Shortcut        =   ^O
      End
      Begin VB.Menu mnuFileExit 
         Caption         =   "&Exit"
      End
   End
   Begin VB.Menu mnuSettings 
      Caption         =   "&Settings"
      Begin VB.Menu mnuSettingsConvertCharRefs 
         Caption         =   "&ConvertCharRefs"
      End
      Begin VB.Menu mnuSettingsUpperCaseAttributeNames 
         Caption         =   "&UpperCaseAttributeNames"
      End
      Begin VB.Menu mnuSettingsUpperCaseTagNames 
         Caption         =   "UpperCase&TagNames"
      End
      Begin VB.Menu mnuSettingsbar1 
         Caption         =   "-"
      End
      Begin VB.Menu mnuSettingsShowEoL 
         Caption         =   "&Show EoL"
      End
   End
End
Attribute VB_Name = "frmMain"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Dim oAnalyzer As New HTMLDocAnalyzer
Dim mbShowEols As Boolean



Private Sub Form_Load()
    Me.Left = GetSetting(App.Title, "Settings", "MainLeft", 1000)
    Me.Top = GetSetting(App.Title, "Settings", "MainTop", 1000)
    'Me.Width = GetSetting(App.Title, "Settings", "MainWidth", 6500)
    'Me.Height = GetSetting(App.Title, "Settings", "MainHeight", 6500)
    
    mbShowEols = True
End Sub


Private Sub Form_Unload(Cancel As Integer)
    Dim i As Integer

    'close all sub forms
    For i = Forms.Count - 1 To 1 Step -1
        Unload Forms(i)
    Next
    
    If Me.WindowState <> vbMinimized Then
        SaveSetting App.Title, "Settings", "MainLeft", Me.Left
        SaveSetting App.Title, "Settings", "MainTop", Me.Top
        'SaveSetting App.Title, "Settings", "MainWidth", Me.Width
        'SaveSetting App.Title, "Settings", "MainHeight", Me.Height
    End If
    
End Sub

Private Sub lvObjects_Click()
    
    Dim oItem As ListItem
    
    If lvObjects.ListItems.Count = 0 Then
        Exit Sub
    End If
    
    Set oItem = lvObjects.SelectedItem
    ClearSubLists
    AddValues (oItem.Tag)
    
    
End Sub

Private Sub lvObjects_KeyUp(KeyCode As Integer, Shift As Integer)

    If KeyCode = vbKeyUp Or KeyCode = vbKeyDown _
        Or KeyCode = vbKeyHome Or KeyCode = vbKeyEnd Or _
        KeyCode = vbKeyPageUp Or KeyCode = vbKeyPageDown Then
        lvObjects_Click
    End If
        
End Sub

Private Sub mnuFileOpen_Click()
    Dim sFile As String


    With dlgCommonDialog
        .DialogTitle = "Open HTML File"
        .Filter = "Alle Dateien (*.*)|*.*"
        .ShowOpen
        If Len(.filename) = 0 Then
            Exit Sub
        End If
        sFile = .filename
        
        'analyze HTML file
        Me.Caption = "DocAnalyzer " & "[" & sFile & "]"
        Analyze (sFile)
        
    End With
End Sub

Private Sub mnuFileExit_Click()
    'Entfernen des Formulars aus dem Speicher
    Unload Me
End Sub

Private Sub Analyze(sFileName As String)

    Dim i As Long
    Dim nRes As Long
    Dim oObj As HTMLAObject
    
    sbStatusBar.SimpleText = ""
    ClearObjectList
    ClearSubLists
    
    nRes = oAnalyzer.Analyze(sFileName)
    If nRes > 0 Then
        Beep
        sbStatusBar.SimpleText = "Error " & Str(nRes) & " " & HTAErrToText(nRes) & " in " & sFileName
    End If
    
    For i = 1 To oAnalyzer.Count
        Set oObj = oAnalyzer.GetObject(i)
        If oObj.Type = SHTAObjectTypeEol Then
            If mbShowEols Then
                AddHTMLAObject i, oObj
            End If
        Else
            AddHTMLAObject i, oObj
        End If
    Next

End Sub


Private Sub AddHTMLAObject(i As Long, oObj As HTMLAObject)
    
    Dim oItem As ListItem
    
    Set oItem = lvObjects.ListItems.Add(, , ObjectTypeToText(oObj.Type))
    oItem.SubItems(1) = oObj.AttributeCount
    oItem.SubItems(2) = oObj.DocTypeParamCount
    oItem.SubItems(3) = Str(oObj.ErrorNumber) & " " & HTOErrorNumberToText(oObj.ErrorNumber)
    oItem.SubItems(4) = oObj.IsEmptySign
    oItem.SubItems(5) = oObj.Line
    oItem.SubItems(6) = oObj.Offset
    
    oItem.Tag = i

End Sub

Private Sub form_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)

    If Data.GetFormat(vbCFFiles) Then
        Effect = vbDropEffectCopy And Effect
    Else
        Effect = vbDropEffectNone
    End If
    
End Sub

Private Sub form_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)

    If Data.GetFormat(vbCFFiles) Then
        If Data.Files.Count = 1 Then
            Me.Caption = "DocAnalyzer " & "[" & Data.Files.Item(1) & "]"
            Analyze (Data.Files.Item(1))
        End If
    End If

End Sub

Private Sub ClearSubLists()

    txtData.Text = ""
    lvAttributes.ListItems.Clear
    lvDocTypeParams.ListItems.Clear
    
End Sub

Private Sub AddValues(i As Long)
    
    Dim oObj As HTMLAObject
    
    Set oObj = oAnalyzer.GetObject(i)
    
    txtData = oObj.Data
    FillAttributeList oObj
    FillDocTypeParamList oObj

End Sub

Private Sub FillAttributeList(oObj As HTMLAObject)
    
    Dim oItem As ListItem
    Dim i As Long
    
    For i = 1 To oObj.AttributeCount
        Set oItem = lvAttributes.ListItems.Add(, , oObj.attributeName(i))
            oItem.SubItems(1) = ValueTypeToText(oObj.AttributeValueType(i))
            oItem.SubItems(2) = oObj.AttributeValueData(i)
            oItem.SubItems(3) = UnitTypeToText(oObj.AttributeUnitType(i))
            oItem.SubItems(4) = oObj.AttributeUnitData(i)
            oItem.SubItems(5) = oObj.AttributeIsBoolean(i)
    Next

End Sub
Private Sub ClearObjectList()

    lvObjects.ListItems.Clear

End Sub

Private Sub FillDocTypeParamList(oObj As HTMLAObject)
    
    Dim oItem As ListItem
    Dim i As Long
    
    For i = 1 To oObj.DocTypeParamCount
        Set oItem = lvDocTypeParams.ListItems.Add(, , oObj.DocTypeParamValue(i))
            oItem.SubItems(1) = ValueTypeToText(oObj.DocTypeParamType(i))
    Next

End Sub

Private Function ValueTypeToText(ByVal typeId As Long) As String

    Select Case typeId
        Case SHTAValueTypeNull
            ValueTypeToText = "Null"
        Case SHTAValueTypeNumber
            ValueTypeToText = "Number"
        Case SHTAValueTypeString
            ValueTypeToText = "String"
        Case SHTAValueTypeText
            ValueTypeToText = "Text"
        Case SHTAValueTypeHexNumber
            ValueTypeToText = "Number"
    End Select

End Function

Private Function UnitTypeToText(ByVal typeId As Long) As String

    Select Case typeId
        Case SHTAUnitTypeNull
            UnitTypeToText = "Null"
        Case SHTAUnitTypePercent
            UnitTypeToText = "Percent"
        Case SHTAUnitTypeRel
            UnitTypeToText = "Rel"
        Case SHTAUnitTypeUnknown
            UnitTypeToText = "Unknown"
    End Select

End Function

Private Function ObjectTypeToText(ByVal typeId As Long) As String

    Select Case typeId
        Case SHTAObjectTypeUnknown
            ObjectTypeToText = "Unknown"
        Case SHTAObjectTypeTagStart
            ObjectTypeToText = "TagStart"
        Case SHTAObjectTypeTagEnd
            ObjectTypeToText = "TagEnd"
        Case SHTAObjectTypeText
            ObjectTypeToText = "Text"
        Case SHTAObjectTypeDocType
            ObjectTypeToText = "DocType"
        Case SHTAObjectTypeCharRefNumDec
            ObjectTypeToText = "CharRefNumDec"
        Case SHTAObjectTypeCharRefNumHex
            ObjectTypeToText = "CharRefNumHex"
        Case SHTAObjectTypeCharRefName
            ObjectTypeToText = "CharRefName"
        Case SHTAObjectTypeComment
            ObjectTypeToText = "Comment"
        Case SHTAObjectTypeEol
            ObjectTypeToText = "Eol"
        Case SHTAObjectTypeError
            ObjectTypeToText = "Error"
    End Select

End Function

Private Function HTOErrorNumberToText(ByVal nCode As Long) As String

    Select Case nCode
        Case SHTAOErrNo
            HTOErrorNumberToText = ""
        Case SHTAOErrParseError
            HTOErrorNumberToText = "Parse Error"
        Case SHTAOErrCriticalParseError
            HTOErrorNumberToText = "Critical Parse Error"
        Case SHTAOErrInvalidToken
            HTOErrorNumberToText = "Invalid Token"
        Case SHTAOErrInvalidCharRef
            HTOErrorNumberToText = "Invalid CharRef"
        Case SHTAOErrFile
            HTOErrorNumberToText = "File Error"
    End Select

End Function

Private Sub mnuSettings_Click()

    mnuSettingsShowEoL.Checked = mbShowEols
    mnuSettingsConvertCharRefs.Checked = oAnalyzer.ConvertCharRefs
    mnuSettingsUpperCaseTagNames.Checked = oAnalyzer.UpperCaseTagNames
    mnuSettingsUpperCaseAttributeNames.Checked = oAnalyzer.UpperCaseAttributeNames

End Sub

Private Sub mnuSettingsConvertCharRefs_Click()

    mnuSettingsConvertCharRefs.Checked = Not mnuSettingsConvertCharRefs.Checked
    oAnalyzer.ConvertCharRefs = mnuSettingsConvertCharRefs.Checked
    
End Sub

Private Sub mnuSettingsShowEoL_Click()

    mnuSettingsShowEoL.Checked = Not mnuSettingsShowEoL.Checked
    mbShowEols = mnuSettingsShowEoL.Checked
    
End Sub

Private Sub mnuSettingsUpperCaseAttributeNames_Click()

    mnuSettingsUpperCaseAttributeNames.Checked = Not mnuSettingsUpperCaseAttributeNames.Checked
    oAnalyzer.UpperCaseAttributeNames = mnuSettingsUpperCaseAttributeNames.Checked
     
End Sub

Private Sub mnuSettingsUpperCaseTagNames_Click()

    mnuSettingsUpperCaseTagNames.Checked = Not mnuSettingsUpperCaseTagNames.Checked
    oAnalyzer.UpperCaseTagNames = mnuSettingsUpperCaseTagNames.Checked
     
End Sub


Private Function HTAErrToText(ByVal nCode As Long) As String

    Select Case nCode
        Case SHTAErrNo
            HTAErrToText = ""
        Case SHTAErrFileError
            HTAErrToText = "File"
        Case SHTAErrParseError
            HTAErrToText = "Parse"
        Case SHTAErrInvalidToken
            HTAErrToText = "Invalid Token"
        Case SHTAErrMemoryError
            HTAErrToText = "Not enough memory"
        Case SHTAErrUnknownError
            HTAErrToText = "Unknown"
        Case SHTAErrLicenseError
            HTAErrToText = "License"
        Case SHTAErrParserError
            HTAErrToText = "ParseR"
    End Select

End Function

