VERSION 5.00
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.2#0"; "COMCTL32.OCX"
Begin VB.Form frmURLAnalyzer 
   Caption         =   "URLAnalyzer"
   ClientHeight    =   3150
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   6855
   LinkTopic       =   "Form1"
   ScaleHeight     =   3150
   ScaleWidth      =   6855
   StartUpPosition =   2  'Bildschirmmitte
   Begin ComctlLib.ListView lvURLComponents 
      Height          =   1935
      Left            =   120
      TabIndex        =   5
      Top             =   1080
      Width           =   6615
      _ExtentX        =   11668
      _ExtentY        =   3413
      View            =   3
      LabelEdit       =   1
      LabelWrap       =   -1  'True
      HideSelection   =   -1  'True
      _Version        =   327680
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      BorderStyle     =   1
      Appearance      =   1
      MouseIcon       =   "URLAnalyzer.frx":0000
      NumItems        =   0
   End
   Begin VB.ComboBox lstURL 
      Height          =   315
      ItemData        =   "URLAnalyzer.frx":001C
      Left            =   720
      List            =   "URLAnalyzer.frx":001E
      TabIndex        =   1
      ToolTipText     =   "Enter an URL or select one from the list"
      Top             =   240
      Width           =   4575
   End
   Begin VB.CheckBox chkSplitNet 
      Caption         =   "&Split Net"
      Height          =   375
      Left            =   2880
      TabIndex        =   4
      ToolTipText     =   "Split network part of URL"
      Top             =   600
      Width           =   1095
   End
   Begin VB.CheckBox chkConvertEscapes 
      Caption         =   "&Convert Escapes"
      Height          =   375
      Left            =   720
      TabIndex        =   3
      ToolTipText     =   "Convert URL escape sequences"
      Top             =   600
      Width           =   1575
   End
   Begin VB.CommandButton cmdAnalyze 
      Caption         =   "&Analyze"
      Default         =   -1  'True
      Height          =   375
      Left            =   5640
      TabIndex        =   2
      ToolTipText     =   "Analyze current URL"
      Top             =   240
      Width           =   1095
   End
   Begin VB.Label Label1 
      Caption         =   "&URL"
      Height          =   255
      Left            =   120
      TabIndex        =   0
      Top             =   240
      Width           =   495
   End
End
Attribute VB_Name = "frmURLAnalyzer"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Dim oURLAnalyzer As New HTMLA.URLAnalyzer



Private Sub cmdAnalyze_Click()
    'Dim sText As String
    Dim i As Long
    
    
    If Len(lstURL.Text) > 0 Then
        'clear list
        ClearURLComponents
        
        'retrieve user settings
        If chkSplitNet.Value Then
            oURLAnalyzer.SplitNet = True
        Else
            oURLAnalyzer.SplitNet = False
        End If
    
        If chkConvertEscapes.Value Then
            oURLAnalyzer.ConvertEscapes = True
        Else
            oURLAnalyzer.ConvertEscapes = False
        End If
        
        
        'analyze selected content
        If oURLAnalyzer.Analyze(lstURL.Text) Then
        
            'fill list box
            For i = 1 To oURLAnalyzer.Count
                AddURLComponent URLComponentTypesToText(oURLAnalyzer.ComponentType(i)), _
                        oURLAnalyzer.ComponentData(i)
            Next
            
        End If
        
    End If
    
End Sub


Private Sub Form_Load()
    Dim oHeader As ColumnHeader
    
    'add headers and adjust header width
    Set oHeader = lvURLComponents.ColumnHeaders.Add(, , "Type")
    oHeader.Width = lvURLComponents.Width / 2 - 400
    
    Set oHeader = lvURLComponents.ColumnHeaders.Add(, , "Data")
    oHeader.Width = lvURLComponents.Width / 2 - 400

    lstURL.AddItem "http://www.software-systems.de"
    lstURL.AddItem "http://www.software-systems.de/"
    lstURL.AddItem "http://www.software-systems.de:80"
    lstURL.AddItem "http://www.software-systems.de/index.html"
    lstURL.AddItem "http://www.software-systems.de/index.html#top"
    lstURL.AddItem "http://www.software-systems.de/query.html?firstVar=value+and+more&secondVar=more%20data#top"
    lstURL.AddItem "/"
    lstURL.AddItem "/index.html"
    lstURL.AddItem "/index.html#top"
    lstURL.AddItem "/query.html?firstVar=value+and+more&secondVar=more%20data#top"
    lstURL.AddItem "index.html"
    lstURL.AddItem "index.html#top"
    lstURL.AddItem "../../example.html"
    lstURL.AddItem "#exampleFragment"
    lstURL.AddItem "query.html?firstVar=value+and+more&secondVar=more%20data#top"
    lstURL.AddItem "mailto:info@software-systems.de"
    lstURL.AddItem "ftp://www.software-systems.de/"
    lstURL.AddItem "ftp://TestUser:TestPassword@www.software-systems.de:2000/"
    lstURL.AddItem "clsid:5DD9B493-31B3-11D0-BADA-000000000000"
    lstURL.AddItem "SpinVB.CAB#version=1,0,0,0"
    lstURL.AddItem "jdbc:mysql:laber"
    lstURL.AddItem "file:///f:/www/index.htm"
    lstURL.ListIndex = 0
    
    If oURLAnalyzer.SplitNet Then
        chkSplitNet.Value = vbChecked
    Else
        chkSplitNet.Value = vbUnchecked
    End If
    If oURLAnalyzer.ConvertEscapes Then
        chkConvertEscapes.Value = vbChecked
    Else
        chkConvertEscapes.Value = vbUnchecked
    End If
    
End Sub

Private Function URLComponentTypesToText(ByVal typeId As Long) As String

    Select Case typeId
    
        Case SHTAURLCompTypeFragment
            URLComponentTypesToText = "SHTAURLCompTypeFragment"
        Case SHTAURLCompTypeMailAddress
            URLComponentTypesToText = "SHTAURLCompTypeMailAddress"
        Case SHTAURLCompTypeNet
            URLComponentTypesToText = "SHTAURLCompTypeNet"
        Case SHTAURLCompTypeNetHost
            URLComponentTypesToText = "SHTAURLCompTypeNetHost"
        Case SHTAURLCompTypeNetPort
            URLComponentTypesToText = "SHTAURLCompTypeNetPort"
        Case SHTAURLCompTypeNetPW
            URLComponentTypesToText = "SHTAURLCompTypeNetPW"
        Case SHTAURLCompTypeNetUser
            URLComponentTypesToText = "SHTAURLCompTypeNetUser"
        Case SHTAURLCompTypeNewsMsgId
            URLComponentTypesToText = "SHTAURLCompTypeNewsMsgId"
        Case SHTAURLCompTypeNewsMsgName
            URLComponentTypesToText = "SHTAURLCompTypeNewsMsgName"
        Case SHTAURLCompTypeParams
            URLComponentTypesToText = "SHTAURLCompTypeParams"
        Case SHTAURLCompTypePathAbs
            URLComponentTypesToText = "SHTAURLCompTypePathAbs"
        Case SHTAURLCompTypePathRel
            URLComponentTypesToText = "SHTAURLCompTypePathRel"
        Case SHTAURLCompTypeQuery
            URLComponentTypesToText = "SHTAURLCompTypeQuery"
        Case SHTAURLCompTypeScheme
            URLComponentTypesToText = "SHTAURLCompTypeScheme"
        Case SHTAURLCompTypeUnknown
            URLComponentTypesToText = "SHTAURLCompTypeUnknown"
            
    End Select

End Function


Private Sub AddURLComponent(sType As String, sData As String)
    
    Dim oItem As ListItem

    Set oItem = lvURLComponents.ListItems.Add(, , sType)
    oItem.SubItems(1) = sData

End Sub

Private Sub ClearURLComponents()
    
    lvURLComponents.ListItems.Clear
    
End Sub

