VERSION 5.00
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.2#0"; "comctl32.ocx"
Begin VB.Form frmMetaInfo 
   Caption         =   "MetaInfo"
   ClientHeight    =   5865
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   7440
   LinkTopic       =   "Form1"
   ScaleHeight     =   5865
   ScaleWidth      =   7440
   StartUpPosition =   2  'Bildschirmmitte
   Begin ComctlLib.ListView lvSystemSettings 
      Height          =   1215
      Left            =   240
      TabIndex        =   14
      Top             =   840
      Width           =   6975
      _ExtentX        =   12303
      _ExtentY        =   2143
      View            =   3
      LabelEdit       =   1
      LabelWrap       =   -1  'True
      HideSelection   =   -1  'True
      _Version        =   327680
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      BorderStyle     =   1
      Appearance      =   1
      NumItems        =   0
   End
   Begin ComctlLib.ListView lvUserSettings 
      Height          =   1215
      Left            =   240
      TabIndex        =   13
      Top             =   2400
      Width           =   6975
      _ExtentX        =   12303
      _ExtentY        =   2143
      View            =   3
      LabelEdit       =   1
      LabelWrap       =   -1  'True
      HideSelection   =   -1  'True
      _Version        =   327680
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      BorderStyle     =   1
      Appearance      =   1
      NumItems        =   0
   End
   Begin VB.TextBox txtFileName 
      Height          =   285
      Left            =   720
      OLEDropMode     =   1  'Manuell
      TabIndex        =   12
      ToolTipText     =   "Enter a file name or drag one from Windows"
      Top             =   240
      Width           =   4575
   End
   Begin VB.CommandButton cmdView 
      Caption         =   "&View"
      Default         =   -1  'True
      Height          =   375
      Left            =   6000
      TabIndex        =   11
      Top             =   150
      Width           =   1215
   End
   Begin VB.TextBox txtData 
      BackColor       =   &H8000000A&
      Height          =   615
      Left            =   240
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertikal
      TabIndex        =   9
      Top             =   3720
      Width           =   6975
   End
   Begin VB.ListBox lstKeywords 
      Height          =   1035
      Left            =   240
      Sorted          =   -1  'True
      TabIndex        =   4
      ToolTipText     =   "Keywords within Meta tags"
      Top             =   4680
      Width           =   4575
   End
   Begin VB.Label Label7 
      Caption         =   "(Drag and Drop enabled)"
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   6.75
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   3600
      TabIndex        =   10
      Top             =   600
      Width           =   1695
   End
   Begin VB.Label lblKeywordBytes 
      BorderStyle     =   1  'Fest Einfach
      Height          =   255
      Left            =   5760
      TabIndex        =   8
      Top             =   5160
      Width           =   855
   End
   Begin VB.Label Label6 
      Caption         =   "Bytes:"
      Height          =   255
      Left            =   5040
      TabIndex        =   7
      Top             =   5160
      Width           =   615
   End
   Begin VB.Label lblWords 
      BorderStyle     =   1  'Fest Einfach
      Height          =   255
      Left            =   5760
      TabIndex        =   6
      ToolTipText     =   "Number of keywords"
      Top             =   4680
      Width           =   855
   End
   Begin VB.Label Label5 
      Caption         =   "Words:"
      Height          =   255
      Left            =   5040
      TabIndex        =   5
      Top             =   4680
      Width           =   615
   End
   Begin VB.Label Label4 
      Caption         =   "&Keywords (separated from User Settings):"
      Height          =   255
      Left            =   240
      TabIndex        =   3
      Top             =   4440
      Width           =   3495
   End
   Begin VB.Label Label3 
      Caption         =   "&User Settings (name):"
      Height          =   255
      Left            =   240
      TabIndex        =   2
      Top             =   2160
      Width           =   1695
   End
   Begin VB.Label Label2 
      Caption         =   "&System Settings (http-equiv):"
      Height          =   255
      Left            =   240
      TabIndex        =   1
      Top             =   600
      Width           =   2415
   End
   Begin VB.Label Label1 
      Caption         =   "&File:"
      Height          =   255
      Left            =   240
      TabIndex        =   0
      Top             =   240
      Width           =   615
   End
End
Attribute VB_Name = "frmMetaInfo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim oAnalyzer As New HTMLDocAnalyzer
Dim oVA As New ValueAnalyzer
Dim nKeywordBytes As Long

Dim oAttribColl As New Collection


Private Sub cmdView_Click()

    Dim nRes As Long
    Dim sVar As String
    Dim sVal As String
    Dim i As Long
    Dim oObj As HTMLAObject
    
    
    ClearSystemSettings
    ClearUserSettings
    
    lblKeywordBytes.Caption = 0
    lstKeywords.Clear
    lblWords.Caption = 0
    
    nKeywordBytes = 0
    
    
    If Len(Trim(txtFileName)) = 0 Then
        txtFileName.SetFocus
        Exit Sub
    End If
    
    
    oAnalyzer.FilterClear
    oAnalyzer.FilterAdd (SHTAObjectTypeTagStart)
    
    oAnalyzer.TagNameFilterClear
    oAnalyzer.TagNameFilterAdd ("META")
    
    'analyze file
    nRes = oAnalyzer.Analyze(txtFileName)
    If nRes <> 0 Then
        MsgBox "Analyze Error: " & Str(nRes)
    End If
    
    For i = 1 To oAnalyzer.Count
    
        Set oObj = oAnalyzer.GetObject(i)
        
        If oObj.Type = SHTAObjectTypeTagStart Then
        
            'check first for HTTP-QUIV attribute
            sVar = oObj.AttributeValue("HTTP-EQUIV")
            If Len(sVar) > 0 Then
            
                sVal = oObj.AttributeValue("CONTENT")
                AddSystemSetting UCase(Trim(sVar)), sVal
                
            Else
            
                'check for NAME attribute
                sVar = UCase(oObj.AttributeValue("NAME"))
               
                If Len(sVar) > 0 Then
                
                    sVal = oObj.AttributeValue("CONTENT")
                    'lstUserSettings.AddItem Trim(sVar) & " (" & sVal & ")"
                    AddUserSetting UCase(Trim(sVar)), sVal
                    
                    If sVar = "KEYWORDS" Then
                        ProcessKeywords (sVal)
                    End If
                    
                End If
                
            End If
            
        End If
        
    Next
    
    txtFileName.SetFocus
    
End Sub

Private Sub ProcessKeywords(ByVal sVal As String)
    
    Dim nRes As Long
    Dim i As Long
    Dim sTmp As String
    
    
    nRes = oVA.Analyze(sVal)
    
    For i = 1 To oVA.Count
        sTmp = oVA.ValueData(i)
        lstKeywords.AddItem sTmp
        nKeywordBytes = nKeywordBytes + Len(sTmp)
    Next
    
    lblWords.Caption = lstKeywords.ListCount
    lblKeywordBytes.Caption = nKeywordBytes

End Sub

Private Sub Form_Load()

    lvSystemSettings.ColumnHeaders.Add , , "Name", lvSystemSettings.Width / 4
    lvSystemSettings.ColumnHeaders.Add , , "Value", lvSystemSettings.Width / 1.6
    
    lvUserSettings.ColumnHeaders.Add , , "Name", lvUserSettings.Width / 4
    lvUserSettings.ColumnHeaders.Add , , "Value", lvUserSettings.Width / 1.6
    

End Sub

Private Sub lvSystemSettings_ItemClick(ByVal Item As ComctlLib.ListItem)

    txtData.Text = Item.Tag

End Sub

Private Sub lvUserSettings_GotFocus()
    Dim oItem As ListItem
    
    Set oItem = lvUserSettings.SelectedItem
    If Not oItem Is Nothing Then
        txtData.Text = oItem.Tag
    End If

End Sub

Private Sub lvSystemSettings_GotFocus()
    Dim oItem As ListItem
    
    Set oItem = lvSystemSettings.SelectedItem
    If Not oItem Is Nothing Then
        txtData.Text = oItem.Tag
    End If

End Sub


Private Sub lvUserSettings_ItemClick(ByVal Item As ComctlLib.ListItem)

    txtData.Text = Item.Tag
    
End Sub

Private Sub txtFileName_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single)

    If Data.GetFormat(vbCFFiles) Then
        If Data.Files.Count = 1 Then
            txtFileName = Data.Files.Item(1)
        End If
    End If

End Sub

Private Sub txtFileName_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, X As Single, Y As Single, State As Integer)

    If Data.GetFormat(vbCFFiles) Then
        Effect = vbDropEffectCopy And Effect
    Else
        Effect = vbDropEffectNone
    End If
    
End Sub

Private Sub AddSystemSetting(sName As String, sValue As String)

    Dim oItem As ListItem
    
    Set oItem = lvSystemSettings.ListItems.Add(, , sName)
    oItem.SubItems(1) = sValue
    oItem.Tag = sValue
    
End Sub
Private Sub ClearSystemSettings()
    lvSystemSettings.ListItems.Clear
End Sub
Private Sub AddUserSetting(sName As String, sValue As String)

    Dim oItem As ListItem
    
    Set oItem = lvUserSettings.ListItems.Add(, , sName)
    oItem.SubItems(1) = sValue
    oItem.Tag = sValue
    
    End Sub
    
Private Sub ClearUserSettings()

    lvUserSettings.ListItems.Clear
    
End Sub

