VERSION 5.00
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.1#0"; "COMDLG32.OCX"
Object = "{6B7E6392-850A-101B-AFC0-4210102A8DA7}#1.2#0"; "COMCTL32.OCX"
Begin VB.Form LinkInfo 
   BorderStyle     =   1  'Fest Einfach
   Caption         =   "LinkInfo"
   ClientHeight    =   3225
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   7215
   LinkTopic       =   "Form1"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   OLEDropMode     =   1  'Manuell
   ScaleHeight     =   3225
   ScaleWidth      =   7215
   StartUpPosition =   2  'Bildschirmmitte
   Begin ComctlLib.ListView lvLinks 
      Height          =   1815
      Left            =   120
      TabIndex        =   6
      Top             =   1200
      Width           =   6975
      _ExtentX        =   12303
      _ExtentY        =   3201
      View            =   3
      LabelWrap       =   -1  'True
      HideSelection   =   -1  'True
      _Version        =   327680
      ForeColor       =   -2147483640
      BackColor       =   -2147483643
      BorderStyle     =   1
      Appearance      =   1
      NumItems        =   0
   End
   Begin MSComDlg.CommonDialog CommonDialog1 
      Left            =   5400
      Top             =   120
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   327680
   End
   Begin VB.CommandButton cmdSelect 
      Caption         =   "..."
      Height          =   255
      Left            =   5280
      TabIndex        =   4
      ToolTipText     =   "Select file name"
      Top             =   240
      Width           =   615
   End
   Begin VB.CommandButton cmdAnalyze 
      Caption         =   "Analyze"
      Default         =   -1  'True
      Height          =   375
      Index           =   1
      Left            =   6120
      TabIndex        =   1
      ToolTipText     =   "Start analyzing"
      Top             =   120
      Width           =   975
   End
   Begin VB.TextBox txtFileName 
      BeginProperty Font 
         Name            =   "Arial"
         Size            =   8.25
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   285
      Left            =   1200
      OLEDropMode     =   1  'Manuell
      TabIndex        =   0
      ToolTipText     =   "Enter a file name or drag one from Windows Explorer"
      Top             =   240
      Width           =   3975
   End
   Begin VB.Label txtBase 
      BorderStyle     =   1  'Fest Einfach
      Height          =   255
      Left            =   1200
      TabIndex        =   5
      ToolTipText     =   "Base URL in file"
      Top             =   720
      Width           =   5895
   End
   Begin VB.Label Label2 
      Caption         =   "Base URL:"
      Height          =   255
      Left            =   120
      TabIndex        =   3
      Top             =   720
      Width           =   975
   End
   Begin VB.Label Label1 
      Caption         =   "File name:"
      Height          =   255
      Left            =   120
      TabIndex        =   2
      Top             =   240
      Width           =   855
   End
End
Attribute VB_Name = "LinkInfo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim oAna        As New HTMLDocAnalyzer
Dim oURLAna     As New URLAnalyzer


Private Sub cmdAnalyze_Click(Index As Integer)


Dim oObj        As HTMLAObject
Dim i           As Long
Dim nRes        As Long
Dim sAnchorText   As String
Dim sBaseURL    As String
Dim sHRef       As String
Dim bCollect    As Boolean
Dim sData       As String
   
    If Len(txtFileName.Text) = 0 Then
        MsgBox "Filename missing!", , "Error"
        Exit Sub
    End If
    
    'clear link list
    ClearLinks
    
    'clear base URL text field
    txtBase = ""
    
   
    oAna.FilterClear
    oAna.UpperCaseTagNames = True   ' convert tag names to upper-case
    oAna.ConvertCharRefs = True     ' convert Character References to text objects
    
    oAna.TagNameFilterClear
    oAna.TagNameFilterAdd ("Base")  ' enabel BASE name
    oAna.TagNameFilterAdd ("A")     ' enable A name
    oAna.TagNameFilterAdd ("AREA")  ' enable AREA name
    
    oURLAna.ConvertEscapes = True
    
    
    'analyze file
    nRes = oAna.Analyze(txtFileName.Text)
    If nRes <> 0 Then
        MsgBox "Error (" & Trim(Str(nRes)) & ") Analyze " & txtFileName.Text & " !", , "Error"
        'lookup errors
        For i = 1 To oAna.Count
            Set oObj = oAna.GetObject(i)
            If oObj.Type = SHTAObjectTypeError Then
                MsgBox "Error Line: " & Str(oObj.Line) & " Offset: " & oObj.Offset & " Data: " & oObj.Data
            End If
        Next
        'Exit Sub
    End If
    
    ' walk throw all objects and retrieve information
    For i = 1 To oAna.Count
    
        'retrieve object i
        Set oObj = oAna.GetObject(i)
        
        Select Case oObj.Type()
        
            Case SHTAObjectTypeTagStart
            
                sData = oObj.Data
                
                If sData = "BASE" Then
                    sBaseURL = oObj.AttributeValue("HREF")
                ElseIf sData = "A" Then
                    bCollect = False
                    sHRef = oObj.AttributeValue("HREF")
                    If Len(sHRef) > 0 Then
                        If Left(sHRef, 1) <> "#" Then
                            bCollect = True
                        End If
                    End If
                ElseIf sData = "AREA" Then
                    sHRef = oObj.AttributeValue("HREF")
                    If Len(sHRef) > 0 Then
                        If Left(sHRef, 1) <> "#" Then
                            AddURL oObj.AttributeValue("ALT"), oURLAna.Join(sBaseURL, sHRef)
                        End If
                        sHRef = ""
                    End If
                End If
                
            Case SHTAObjectTypeTagEnd
                    
                    If oObj.Data = "A" And bCollect Then
                       AddURL Trim(CompressSpaces(sAnchorText)), oURLAna.Join(sBaseURL, sHRef)
                       sAnchorText = ""
                       bCollect = False
                       sHRef = ""
                    End If
                    
            Case SHTAObjectTypeText
                    
                    If bCollect Then
                        sAnchorText = sAnchorText & oObj.Data
                    End If
            
            Case SHTAObjectTypeEol
                    
                    If bCollect Then
                        sAnchorText = sAnchorText & " "
                    End If
        
        End Select
        
        
    Next
    

    'show detected Base URL
    txtBase.Caption = sBaseURL
    
    txtFileName.SetFocus
   
    
End Sub
Private Function CompressSpaces(sText As String) As String

    Dim i As Long
    Dim sRes As String
    Dim c As String
    Dim nState As Long
    
    nState = 0
    i = 1
    
    While i <= Len(sText)
        
        c = Mid(sText, i, 1)
    
        Select Case nState
        
            Case 0
                If c = " " Or c = Chr(9) Or c = Chr(160) Then
                    sRes = sRes + " "
                    nState = 1
                Else
                    sRes = sRes + c
                End If
                i = i + 1
                
            Case 1
                If Not (c = " " Or c = Chr(9) Or c = Chr(160)) Then
                    sRes = sRes + c
                    nState = 0
                End If
                i = i + 1
        
        End Select
    
    Wend
    
    CompressSpaces = sRes
    
End Function


Private Sub cmdSelect_Click()

On Error GoTo ErrHandler
   
    CommonDialog1.Filter = "All Files (*.*)|*.*|HTML Files (*.htm)|*.htm|" & _
        "HTML Files (*.html)|*.html"
    CommonDialog1.FilterIndex = 2
    CommonDialog1.CancelError = True
    CommonDialog1.ShowOpen

    txtFileName.Text = CommonDialog1.filename
    txtFileName.SetFocus
    
    Exit Sub
    
ErrHandler:
        Exit Sub
    
    
End Sub


Private Sub Form_Load()

    Dim oHeader As ColumnHeader
    
    txtFileName.Text = ""
    
    Set oHeader = lvLinks.ColumnHeaders.Add(, , "Text")
    oHeader.Width = lvLinks.Width / 2 - 450
    
    Set oHeader = lvLinks.ColumnHeaders.Add(, , "URL")
    oHeader.Width = lvLinks.Width / 2 - 450
    
        
End Sub

Private Sub Form_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, x As Single, y As Single)

    txtFileName_OLEDragDrop Data, Effect, Button, Shift, x, y

End Sub

Private Sub Form_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, x As Single, y As Single, State As Integer)

    txtFileName_OLEDragOver Data, Effect, Button, Shift, x, y, State

End Sub


Private Sub txtFileName_OLEDragDrop(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, x As Single, y As Single)

    If Data.GetFormat(vbCFFiles) Then
        
        If Data.Files.Count = 1 Then
            txtFileName.Text = Data.Files.Item(1)
        End If
        
    End If

End Sub

Private Sub txtFileName_OLEDragOver(Data As DataObject, Effect As Long, Button As Integer, Shift As Integer, x As Single, y As Single, State As Integer)

    If Data.GetFormat(vbCFFiles) Then
        Effect = vbDropEffectCopy And Effect
    Else
        Effect = vbDropEffectNone
    End If

End Sub

Private Sub AddURL(sText As String, sURL As String)

    Dim oItem As ListItem
    
    Set oItem = lvLinks.ListItems.Add(, , sText)
    oItem.SubItems(1) = sURL
    

End Sub

Private Sub ClearLinks()

    lvLinks.ListItems.Clear
    
End Sub

