/* Release 3.00 */
/*-------------------------------------------------------------------------*
*                                                                          *
*  winstyle.h -  Windows styles for Windows3.                              *
*                                                                          *
*  COPYRIGHT (C) 1989..1991 Jensen and Partners. All Rights Reserved.      *
*                                                                          *
*--------------------------------------------------------------------------*/

#ifndef _WINSTYLE_INC
#define _WINSTYLE_INC
/* Window Styles */

#define WS_OVERLAPPED	    0x00000000L
#define WS_POPUP	    0x80000000L
#define WS_CHILD	    0x40000000L
#define WS_MINIMIZE	    0x20000000L
#define WS_VISIBLE	    0x10000000L
#define WS_DISABLED	    0x08000000L
#define WS_CLIPSIBLINGS     0x04000000L
#define WS_CLIPCHILDREN     0x02000000L
#define WS_MAXIMIZE	    0x01000000L
#define WS_CAPTION	    0x00C00000L
#define WS_BORDER	    0x00800000L
#define WS_DLGFRAME	    0x00400000L
#define WS_VSCROLL	    0x00200000L
#define WS_HSCROLL	    0x00100000L
#define WS_SYSMENU	    0x00080000L
#define WS_THICKFRAME	    0x00040000L
#define WS_GROUP	    0x00020000L
#define WS_TABSTOP	    0x00010000L

#define WS_MINIMIZEBOX	    0x00020000L
#define WS_MAXIMIZEBOX	    0x00010000L

#define WS_TILED	    WS_OVERLAPPED
#define WS_ICONIC	    WS_MINIMIZE
#define WS_SIZEBOX	    WS_THICKFRAME

/* Common Window Styles */

#define WS_OVERLAPPEDWINDOW (WS_OVERLAPPED | WS_CAPTION | WS_SYSMENU | WS_THICKFRAME | WS_MINIMIZEBOX | WS_MAXIMIZEBOX)
#define WS_POPUPWINDOW	    (WS_POPUP | WS_BORDER | WS_SYSMENU)
#define WS_CHILDWINDOW	    (WS_CHILD)
#define WS_TILEDWINDOW	    (WS_OVERLAPPEDWINDOW)

/* Extended Window Styles */

#define WS_EX_DLGMODALFRAME 0x00000001L
#define WS_EX_NOPARENTNOTIFY 0x00000004L

/* Class styles */

#define CS_VREDRAW	    0x0001
#define CS_HREDRAW	    0x0002
#define CS_KEYCVTWINDOW     0x0004
#define CS_DBLCLKS	    0x0008

/*  0x0010 is no longer used */

#define CS_OWNDC	    0x0020
#define CS_CLASSDC	    0x0040
#define CS_PARENTDC	    0x0080
#define CS_NOKEYCVT	    0x0100
#define CS_NOCLOSE	    0x0200
#define CS_SAVEBITS	    0x0800
#define CS_BYTEALIGNCLIENT  0x1000
#define CS_BYTEALIGNWINDOW  0x2000
#define CS_GLOBALCLASS	    0x4000

/* Edit Control Styles */

#define ES_LEFT             0x0000L
#define ES_CENTER           0x0001L
#define ES_RIGHT            0x0002L
#define ES_MULTILINE        0x0004L
#define ES_UPPERCASE        0x0008L
#define ES_LOWERCASE        0x0010L
#define ES_PASSWORD         0x0020L
#define ES_AUTOVSCROLL      0x0040L
#define ES_AUTOHSCROLL      0x0080L
#define ES_NOHIDESEL        0x0100L
#define ES_OEMCONVERT       0x0400L

/* Button Control Styles */

#define BS_PUSHBUTTON	   0x00L
#define BS_DEFPUSHBUTTON   0x01L
#define BS_CHECKBOX	   0x02L
#define BS_AUTOCHECKBOX    0x03L
#define BS_RADIOBUTTON	   0x04L
#define BS_3STATE	   0x05L
#define BS_AUTO3STATE	   0x06L
#define BS_GROUPBOX	   0x07L
#define BS_USERBUTTON	   0x08L
#define BS_AUTORADIOBUTTON 0x09L
#define BS_PUSHBOX	   0x0AL
#define BS_OWNERDRAW	   0x0BL
#define BS_LEFTTEXT	   0x20L

/* Listbox Styles */

#define LBS_NOTIFY	      0x0001L
#define LBS_SORT	      0x0002L
#define LBS_NOREDRAW	      0x0004L
#define LBS_MULTIPLESEL       0x0008L
#define LBS_OWNERDRAWFIXED    0x0010L
#define LBS_OWNERDRAWVARIABLE 0x0020L
#define LBS_HASSTRINGS        0x0040L
#define LBS_USETABSTOPS       0x0080L
#define LBS_NOINTEGRALHEIGHT  0x0100L
#define LBS_MULTICOLUMN       0x0200L
#define LBS_WANTKEYBOARDINPUT 0x0400L
#define LBS_EXTENDEDSEL	      0x0800L
#define LBS_STANDARD	      (LBS_NOTIFY | LBS_SORT | WS_VSCROLL | WS_BORDER)

/* Scroll Bar Styles */

#define SBS_HORZ		    0x0000L
#define SBS_VERT		    0x0001L
#define SBS_TOPALIGN		    0x0002L
#define SBS_LEFTALIGN		    0x0002L
#define SBS_BOTTOMALIGN		    0x0004L
#define SBS_RIGHTALIGN		    0x0004L
#define SBS_SIZEBOXTOPLEFTALIGN	    0x0002L
#define SBS_SIZEBOXBOTTOMRIGHTALIGN 0x0004L
#define SBS_SIZEBOX		    0x0008L

/* Dialog Styles */

#define DS_ABSALIGN	    0x01L
#define DS_SYSMODAL	    0x02L
#define DS_LOCALEDIT	    0x20L
#define DS_SETFONT	    0x40L
#define DS_MODALFRAME	    0x80L
#define DS_NOIDLEMSG	    0x100L


/* Dialog Box Command ID  */

#define IDOK		    1
#define IDCANCEL	    2
#define IDABORT 	    3
#define IDRETRY 	    4
#define IDIGNORE	    5
#define IDYES		    6
#define IDNO		    7

/* Static Control Constants */

#define SS_LEFT 	   0x00L
#define SS_CENTER	   0x01L
#define SS_RIGHT	   0x02L
#define SS_ICON 	   0x03L
#define SS_BLACKRECT	   0x04L
#define SS_GRAYRECT	   0x05L
#define SS_WHITERECT	   0x06L
#define SS_BLACKFRAME	   0x07L
#define SS_GRAYFRAME	   0x08L
#define SS_WHITEFRAME	   0x09L
#define SS_USERITEM	   0x0AL
#define SS_SIMPLE	   0x0BL
#define SS_LEFTNOWORDWRAP  0x0CL
#define SS_NOPREFIX	   0x80L    /* Don't do & translation */

/* Virtual Keys - Standard Set */

#define VK_LBUTTON	    0x01
#define VK_RBUTTON	    0x02
#define VK_CANCEL	    0x03
#define VK_MBUTTON	    0x04    /* NOT contiguous with L & RBUTTON */
#define VK_BACK 	    0x08
#define VK_TAB		    0x09
#define VK_CLEAR	    0x0C
#define VK_RETURN	    0x0D
#define VK_SHIFT	    0x10
#define VK_CONTROL	    0x11
#define VK_MENU 	    0x12
#define VK_PAUSE	    0x13
#define VK_CAPITAL	    0x14
#define VK_ESCAPE	    0x1B
#define VK_SPACE	    0x20
#define VK_PRIOR	    0x21
#define VK_NEXT 	    0x22
#define VK_END		    0x23
#define VK_HOME 	    0x24
#define VK_LEFT 	    0x25
#define VK_UP		    0x26
#define VK_RIGHT	    0x27
#define VK_DOWN 	    0x28
#define VK_SELECT	    0x29
#define VK_PRINT	    0x2A
#define VK_EXECUTE	    0x2B
#define VK_SNAPSHOT	    0x2C
/* #define VK_COPY 	    0x2C not used  */
#define VK_INSERT	    0x2D
#define VK_DELETE	    0x2E
#define VK_HELP 	    0x2F

#define VK_NUMPAD0	    0x60
#define VK_NUMPAD1	    0x61
#define VK_NUMPAD2	    0x62
#define VK_NUMPAD3	    0x63
#define VK_NUMPAD4	    0x64
#define VK_NUMPAD5	    0x65
#define VK_NUMPAD6	    0x66
#define VK_NUMPAD7	    0x67
#define VK_NUMPAD8	    0x68
#define VK_NUMPAD9	    0x69
#define VK_MULTIPLY	    0x6A
#define VK_ADD		    0x6B
#define VK_SEPARATOR	    0x6C
#define VK_SUBTRACT	    0x6D
#define VK_DECIMAL	    0x6E
#define VK_DIVIDE	    0x6F
#define VK_F1		    0x70
#define VK_F2		    0x71
#define VK_F3		    0x72
#define VK_F4		    0x73
#define VK_F5		    0x74
#define VK_F6		    0x75
#define VK_F7		    0x76
#define VK_F8		    0x77
#define VK_F9		    0x78
#define VK_F10		    0x79
#define VK_F11		    0x7A
#define VK_F12		    0x7B
#define VK_F13		    0x7C
#define VK_F14		    0x7D
#define VK_F15		    0x7E
#define VK_F16		    0x7F
#define VK_NUMLOCK	    0x90

#endif
