(*# check(stack=>off,
          index=>off,
          range=>off,
          overflow=>off,
          nil_ptr=>off) *)

IMPLEMENTATION MODULE ApplFish;

IMPORT Windows,WMain;
FROM Storage IMPORT ALLOCATE, DEALLOCATE;
FROM Lib     IMPORT RANDOM;

CONST
(* String table constants *)
  IDSNAME  =   100;
  IDSABOUT =   200;
  IDSTITLE =   300;
  IDSMESSAGE = 400;
  IDSCAPTION = 500;
  IDSDEFSPEC = 501;
  IDSDEFEXT  = 502;

  IDM_DESTROY    =     301;

  SPECIAL_CHANGE =     0401H;
  INIT_INSTANCES =     0402H;

  FORWARDS     =       2;
  BACKWARDS    =       1;
  TURNING      =       0;


PROCEDURE ReOutputOtherInstances(ThisFish : WMain.Fish ;
                                 hMemoryDC,hdc : Windows.HDC);
VAR TempInst : WMain.InstancePtr;
    hOldbmap : Windows.HBITMAP;
BEGIN
     TempInst := ThisFish.Other;
     WHILE TempInst # NIL DO
         hOldbmap := Windows.SelectObject(hMemoryDC, ThisFish.bmap[TempInst^.direction,TempInst^.bmapno]);
         IF Windows.BitBlt(hdc,TempInst^.xpos,TempInst^.ypos,ThisFish.xextent,ThisFish.yextent,hMemoryDC,0,0,Windows.SRCPAINT) # 0 THEN END;
         TempInst := TempInst^.NextInstance
     END
END ReOutputOtherInstances;

PROCEDURE DeleteFishInstances;
VAR i : INTEGER;
    TempInst : WMain.InstancePtr;
BEGIN
    FOR i := 1 TO WMain.FishMax DO
        WHILE WMain.FishHead[i].Other # NIL DO
              TempInst := WMain.FishHead[i].Other;
              WMain.FishHead[i].Other := WMain.FishHead[i].Other^.NextInstance;
              DISPOSE(TempInst)
        END
    END
END DeleteFishInstances;


PROCEDURE AnimateOtherInstances(hdc,hMemoryDC   : Windows.HDC;
                                ThisFish        : WMain.Fish);
VAR TempInst : WMain.InstancePtr;
    hOldbmap : Windows.HBITMAP;
BEGIN
     TempInst := ThisFish.Other;
     WHILE TempInst # NIL DO
        IF ((TempInst^.speedx < 0) AND (TempInst^.pspeedx >= 0)) OR
           ((TempInst^.speedx > 0) AND (TempInst^.pspeedx <= 0)) THEN
           hOldbmap := Windows.SelectObject(hMemoryDC,ThisFish.turnbmap);
           IF Windows.BitBlt(hdc,TempInst^.xpos,TempInst^.ypos,ThisFish.xextent,ThisFish.yextent,hMemoryDC,0,0,Windows.SRCCOPY) = 0 THEN
           END;
        END;
        IF TempInst^.speedx > 0 THEN
           IF Windows.BitBlt(hdc,TempInst^.xpos,TempInst^.ypos,TempInst^.speedx,ThisFish.yextent,hMemoryDC,0,0,Windows.BLACKNESS) # 0 THEN END;
        END;
        IF TempInst^.speedx < 0 THEN
           IF Windows.BitBlt(hdc,TempInst^.xpos+ThisFish.xextent+INTEGER(TempInst^.speedx),TempInst^.ypos,-TempInst^.speedx,ThisFish.yextent,hMemoryDC,0,0,Windows.BLACKNESS) # 0 THEN END;
        END;
          TempInst^.pspeedx := TempInst^.speedx;
          TempInst^.pspeedy := TempInst^.speedy;
        IF TempInst^.xpos < WMain.RealXYRect.left-ThisFish.xextent THEN TempInst^.xpos := WMain.RealXYRect.right END;
        IF TempInst^.xpos > WMain.RealXYRect.right THEN TempInst^.xpos := WMain.RealXYRect.left-ThisFish.xextent END;
        TempInst^.xpos := TempInst^.xpos + INTEGER(TempInst^.speedx);
        TempInst^.ypos := TempInst^.ypos + INTEGER(TempInst^.speedy);
        IF TempInst^.ypos > WMain.RealXYRect.bottom THEN TempInst^.ypos := WMain.RealXYRect.top-ThisFish.yextent END;
        IF TempInst^.ypos < WMain.RealXYRect.top-ThisFish.yextent THEN TempInst^.ypos := WMain.RealXYRect.bottom END;
        IF TempInst^.bmapno = 4 THEN
           TempInst^.bmapno := 1
        ELSE
           INC(TempInst^.bmapno)
        END;
        hOldbmap := Windows.SelectObject(hMemoryDC, ThisFish.bmap[TempInst^.direction,TempInst^.bmapno]);
        IF Windows.BitBlt(hdc,TempInst^.xpos,TempInst^.ypos,ThisFish.xextent,ThisFish.yextent,hMemoryDC,0,0,Windows.SRCCOPY) # 0 THEN END;

        TempInst := TempInst^.NextInstance;
     END;

END AnimateOtherInstances;

PROCEDURE RandomizeInstances(ThisFish : WMain.Fish);
VAR TempInst : WMain.InstancePtr;
    randomy  : CARDINAL;
  PROCEDURE Increase( VAR X : INTEGER);
  BEGIN
      IF X < 0 THEN DEC(X) END;
      IF X > 0 THEN INC(X) END;
  END Increase;

BEGIN
     TempInst := ThisFish.Other;
     WHILE TempInst # NIL DO
         randomy := RANDOM(5);
         TempInst^.pspeedx := TempInst^.speedx;
         TempInst^.pspeedy := TempInst^.speedy;
         CASE randomy OF
              | 0 :  TempInst^.speedy := -1;Increase(TempInst^.speedx);
              | 1 :  TempInst^.speedy := 1;TempInst^.speedx := 0;
              | 2 :  TempInst^.speedx := ThisFish.basespeed;TempInst^.direction:=FORWARDS;TempInst^.speedy := 0;
              | 3 :  TempInst^.speedx := -ThisFish.basespeed;TempInst^.direction:=BACKWARDS;TempInst^.speedy := 0;
         END;
         TempInst := TempInst^.NextInstance
     END

END RandomizeInstances;

PROCEDURE ReInitInstances(hWnd : Windows.HWND ;
                          hdc  : Windows.HDC ;
                          NInstances, FishHere : CARDINAL);
VAR
  TempInst,NextInst : WMain.InstancePtr;
  i                 : INTEGER;
  Rect              : Windows.RECT;
  Xorg,Yorg         : INTEGER;
  Origin            : LONGCARD;

BEGIN
    WMain.StopAllTimers(hWnd);
    TempInst := WMain.FishHead[FishHere].Other;
    WHILE TempInst # NIL DO
      NextInst := TempInst^.NextInstance;
      DISPOSE(TempInst);
      TempInst := NextInst
    END;
    TempInst := NIL;
    WMain.FishHead[FishHere].Instances := NInstances -1;
    Origin := Windows.GetWindowOrg(hdc);
    Xorg := INTEGER(Windows.LOWORD(Origin));
    Yorg := INTEGER(Windows.HIWORD(Origin));
    Windows.GetClientRect(hWnd,Rect);
    NextInst := NIL;
    WHILE NInstances > 1 DO
          NEW(TempInst);
          NInstances := NInstances - 1;
          TempInst^.bmapno := 1;
          TempInst^.direction := WMain.FishHead[FishHere].direction;
          TempInst^.xpos := RANDOM(Rect.right) + CARDINAL(Xorg);
          TempInst^.ypos := RANDOM(Rect.bottom) + CARDINAL(Yorg);
          TempInst^.speedx := WMain.FishHead[FishHere].speedx;
          TempInst^.speedy := WMain.FishHead[FishHere].speedy;
          TempInst^.NextInstance := NextInst;
          NextInst := TempInst
    END;
    WMain.FishHead[FishHere].Other := NextInst;
    WMain.StartAllTimers(hWnd);
END ReInitInstances;

PROCEDURE ResourcesLow(hWnd : Windows.HWND) : BOOLEAN;
BEGIN
    WMain.StopAllTimers(hWnd);
    IF Windows.MessageBox(hWnd,"Application Termination Advised. Terminate ?","System Resources Low",
       Windows.MB_ICONSTOP + Windows.MB_YESNO) = Windows.IDYES THEN

       WMain.QuickDeleteRgns(hWnd);

       IF Windows.SetTimer(hWnd,IDM_DESTROY,500,Windows.FARPROC(0)) = 0 THEN END;

       RETURN(TRUE);

    END;
    RETURN (FALSE)

END ResourcesLow;

PROCEDURE TimersLow(hWnd : Windows.HWND);
BEGIN
    WMain.StopAllTimers(hWnd);
    IF Windows.MessageBox(hWnd,"Application Termination Advised. Terminate ?","Too Many Timers Running",
       Windows.MB_ICONSTOP + Windows.MB_YESNO) = Windows.IDYES THEN

       IF Windows.SendMessage(hWnd,Windows.WM_CLOSE,0,0) = 0 THEN END
    END;
END TimersLow;

END ApplFish.
