(*#check(stack=>off,
          index=>off,
          range=>off,
          overflow=>off,
          nil_ptr=>off) *)
IMPLEMENTATION MODULE WMain;

IMPORT Windows,WinStr,ApplDlg,ApplFish,Str;
FROM Storage IMPORT ALLOCATE,DEALLOCATE;
FROM Lib IMPORT RANDOMIZE,RANDOM;

CONST
(* bitmaps *)
  BUBBLE   =     5;
  BUBBLE1  =     51;
  BUBBLE2  =     52;
  BUBBLE3  =     53;
  STAR1    =     1006;
  STAR2    =     1007;
  STAR3    =     1008;
  STAR4    =     1009;
  STAR5    =     1010;
  FLOOR    =     1011;
  WEED1    =     1024;
  WEED2    =     1029;
  CHESTA   =     1041;
  CHESTB   =     1042;
  CHESTC   =     1043;

  FISHF1A  =     2000;
  FISHF1B  =     2001;
  FISHF1C  =     2002;
  FISHF1D  =     2003;
  FISHB1A  =     2004;
  FISHB1B  =     2005;
  FISHB1C  =     2006;
  FISHB1D  =     2007;
  FISHT1   =     2008;

  FISHF2A  =     2010;
  FISHF2B  =     2011;
  FISHF2C  =     2012;
  FISHF2D  =     2013;
  FISHB2A  =     2014;
  FISHB2B  =     2015;
  FISHB2C  =     2016;
  FISHB2D  =     2017;
  FISHT2   =     2018;

  FISHF3A  =     2020;
  FISHF3B  =     2021;
  FISHF3C  =     2022;
  FISHF3D  =     2023;
  FISHB3A  =     2024;
  FISHB3B  =     2025;
  FISHB3C  =     2026;
  FISHB3D  =     2027;
  FISHT3   =     2028;

  FISHF4A  =     2030;
  FISHF4B  =     2031;
  FISHF4C  =     2032;
  FISHF4D  =     2033;
  FISHB4A  =     2034;
  FISHB4B  =     2035;
  FISHB4C  =     2036;
  FISHB4D  =     2037;
  FISHT4   =     2038;

  FISHF5A  =     2040;
  FISHF5B  =     2041;
  FISHF5C  =     2042;
  FISHF5D  =     2043;
  FISHB5A  =     2044;
  FISHB5B  =     2045;
  FISHB5C  =     2046;
  FISHB5D  =     2047;
  FISHT5   =     2048;

  FISHF6A  =     2050;
  FISHF6B  =     2051;
  FISHF6C  =     2052;
  FISHF6D  =     2053;
  FISHB6A  =     2054;
  FISHB6B  =     2055;
  FISHB6C  =     2056;
  FISHB6D  =     2057;
  FISHT6   =     2058;

  FISHF7A  =     2060;
  FISHF7B  =     2061;
  FISHF7C  =     2062;
  FISHF7D  =     2063;
  FISHB7A  =     2064;
  FISHB7B  =     2065;
  FISHB7C  =     2066;
  FISHB7D  =     2067;
  FISHT7   =     2068;


  FISH1X   =     71;
  FISH1Y   =     40;

  FISHX1X  =     42;
  FISHX1Y  =     36;

  FISHX2X  =     22;
  FISHX2Y  =     22;

  FISHX3X  =     22;
  FISHX3Y  =     22;

  F1X      =     72;
  F1Y      =     71;

(* Options Menu Items *)
  IDM_PLUSBUB   =     101;
  IDM_MINUSBUB  =     102;
  IDM_BUBBLE    =     103;
  IDM_RANDOM    =     104;
  IDM_START     =     105;
  IDM_CHANGEVIEW =    106;

(* Fish Menu Items *)
  IDM_SELECT    =     201;
  IDM_INFO      =     202;

  FISHOPTION    =       1;

  IDM_DEFAULT   =     400;
  IDM_FISH1     =     401;
  IDM_FISH2     =     402;
  IDM_FISH3     =     403;
  IDM_FISH4     =     404;
  IDM_FISH5     =     405;
  IDM_FISH6     =     406;
  IDM_FISH7     =     407;

(* debug options *)
  IDM_DEBUG     =     300;
  IDM_DESTROY   =     301;

(* Help Menu Items *)
  IDM_ABOUT     =      901;
  IDS_ABOUTA    =      902;

(* Timer Identifiers *)
   FISHMOVE     =        1;
   BUBBLEMOVE   =        2;
   SETRANDOM    =        3;
   STARMOVE     =        4;
   WEEDMOVE     =        5;
   CHESTMOVE    =        6;

(* other constants *)
   FORWARDS     =       2;
   BACKWARDS    =       1;
   TURNING      =       0;

   FISHTIMER    =       40;
   BUBBLETIMER  =       50;
   RANDOMTIMER  =       1000;
   STARTIMER    =       3000;
   WEEDTIMER    =       4000;
   CHESTTIMER   =       6000;

   BUBBLE_X_XTENT =     4;
   BUBBLE_Y_XTENT =     4;

   MAXSTARS     =       4;
   STARXPOS     =       200;
   STARXXTENT   =       266;
   STARXSIZE    =       66;
   STARYSIZE    =       55;

   FLOORXSIZE   =       1000;
   FLOORYSIZE   =       44;

   CLIENTREGION =       1;
   FISHREGION   =       2;
   STARREGION   =       3;
   FLOORREGION  =       4;
   CLIPREGION   =       5;
   TANKREGION   =       6;
   WEEDREGION   =       7;

   NORMAL       =       1;
   FIT          =       2;

   WEEDXPOS     =       50;
   MAXWEEDS     =       2;
   WEEDXXTENT   =       266;
   WEEDXSIZE    =       72;
   WEEDYSIZE    =       72;

   TANKDEPTHDIFF =      50;

   SBHORZUNITS  =       10;
   SBVERTUNITS  =       10;

   CHESTXPOS    =       425;
   CHESTXXTENT  =       33;
   CHESTYXTENT  =       28;

   SPECIAL_CHANGE =     0401H;
   INIT_INSTANCES =     0402H;
   RESTART        =     0403H;

TYPE
    StarType    = RECORD
                    hStar       : Windows.HBITMAP;
                    StarPoints  : ARRAY[1..11] OF Windows.POINT;
                    hStarRgn    : Windows.HRGN;
                    hClipRgn    : Windows.HRGN;
                  END;

    WeedType    = RECORD
                    hWeed       : Windows.HBITMAP;
                  END;


    InvalidPtr = POINTER TO Invalids;
    Invalids = RECORD
                    top,left,bottom,right : INTEGER;
                    NextInvalid : InvalidPtr;
               END;

    Bubbles      = RECORD
                     X,Y        : INTEGER;
                     Speed      : CARDINAL;
                   END;


VAR
  FishHere : INTEGER;
  BubbleHead : ARRAY[1..10] OF Bubbles;
  BubbleHere,BubbleMax : INTEGER;

  lpprocAbout,lpOpenDlg,lpLifeDlg,lpInfoDlg: Windows.FARPROC;

  hFISHF1A      : Windows.HBITMAP;
  hFISHF1B      : Windows.HBITMAP;
  hFISHF1C      : Windows.HBITMAP;
  hFISHF1D      : Windows.HBITMAP;
  hFISHB1A      : Windows.HBITMAP;
  hFISHB1B      : Windows.HBITMAP;
  hFISHB1C      : Windows.HBITMAP;
  hFISHB1D      : Windows.HBITMAP;
  hFISHT1       : Windows.HBITMAP;

  hFISHF2A      : Windows.HBITMAP;
  hFISHF2B      : Windows.HBITMAP;
  hFISHF2C      : Windows.HBITMAP;
  hFISHF2D      : Windows.HBITMAP;
  hFISHB2A      : Windows.HBITMAP;
  hFISHB2B      : Windows.HBITMAP;
  hFISHB2C      : Windows.HBITMAP;
  hFISHB2D      : Windows.HBITMAP;
  hFISHT2       : Windows.HBITMAP;

  hFISHF3A      : Windows.HBITMAP;
  hFISHF3B      : Windows.HBITMAP;
  hFISHF3C      : Windows.HBITMAP;
  hFISHF3D      : Windows.HBITMAP;
  hFISHB3A      : Windows.HBITMAP;
  hFISHB3B      : Windows.HBITMAP;
  hFISHB3C      : Windows.HBITMAP;
  hFISHB3D      : Windows.HBITMAP;
  hFISHT3       : Windows.HBITMAP;

  hFISHF4A      : Windows.HBITMAP;
  hFISHF4B      : Windows.HBITMAP;
  hFISHF4C      : Windows.HBITMAP;
  hFISHF4D      : Windows.HBITMAP;
  hFISHB4A      : Windows.HBITMAP;
  hFISHB4B      : Windows.HBITMAP;
  hFISHB4C      : Windows.HBITMAP;
  hFISHB4D      : Windows.HBITMAP;
  hFISHT4       : Windows.HBITMAP;

  hFISHF5A      : Windows.HBITMAP;
  hFISHF5B      : Windows.HBITMAP;
  hFISHF5C      : Windows.HBITMAP;
  hFISHF5D      : Windows.HBITMAP;
  hFISHB5A      : Windows.HBITMAP;
  hFISHB5B      : Windows.HBITMAP;
  hFISHB5C      : Windows.HBITMAP;
  hFISHB5D      : Windows.HBITMAP;
  hFISHT5       : Windows.HBITMAP;

  hFISHF6A      : Windows.HBITMAP;
  hFISHF6B      : Windows.HBITMAP;
  hFISHF6C      : Windows.HBITMAP;
  hFISHF6D      : Windows.HBITMAP;
  hFISHB6A      : Windows.HBITMAP;
  hFISHB6B      : Windows.HBITMAP;
  hFISHB6C      : Windows.HBITMAP;
  hFISHB6D      : Windows.HBITMAP;
  hFISHT6       : Windows.HBITMAP;

  hFISHF7A      : Windows.HBITMAP;
  hFISHF7B      : Windows.HBITMAP;
  hFISHF7C      : Windows.HBITMAP;
  hFISHF7D      : Windows.HBITMAP;
  hFISHB7A      : Windows.HBITMAP;
  hFISHB7B      : Windows.HBITMAP;
  hFISHB7C      : Windows.HBITMAP;
  hFISHB7D      : Windows.HBITMAP;
  hFISHT7       : Windows.HBITMAP;

  hBUBBLEbmap   : Windows.HBITMAP;
  hBUBBLE1bmap  : Windows.HBITMAP;
  hBUBBLE2bmap  : Windows.HBITMAP;
  hBUBBLE3bmap  : Windows.HBITMAP;
  hFLOORbmap    : Windows.HBITMAP;
  hCHEST          : ARRAY [1..3] OF Windows.HBITMAP;

  hBUBBLES      : ARRAY[1..3] OF Windows.HBITMAP;
  hSTARS        : ARRAY[1..MAXSTARS] OF StarType;
  hWEEDS        : ARRAY[1..MAXWEEDS] OF WeedType;
  hdc           : Windows.HDC;
  hMemoryDC     : Windows.HDC;
  Bitmap        : Windows.BITMAP;
  hOldbmap      : Windows.HBITMAP;
  LPBitmap      : Windows.LPBITMAP;
  TempRect      : Windows.RECT;
  XYRect,OldXYRect : Windows.RECT;

  staron,bubbleon,done,randomset      : BOOLEAN;
  bubblewason,starwason,randomwasset  : BOOLEAN;
  timerid,randomy                     : INTEGER;
  TankWidth,TankDepth                 : INTEGER;
  TempStr                             : ARRAY[0..15] OF CHAR;

  starypos, staryxtent,
  floorypos, weedypos,
  chestypos, weedyxtent,
  weed, prevweed                      : INTEGER;

  fishxpos                            : INTEGER;
  bubbleypos,bubble                   : INTEGER;

  star, prevstar,
  chest                               : INTEGER;

  WindowOrg                           : LONGCARD;

  SbXPos,SbYPos                       : INTEGER;

  SbXInc,SbYInc,Temp1,Temp2           : INTEGER;

  movement                            : INTEGER;
  maxheight                           : INTEGER;

  hRgna, hTankRgn                     : Windows.HRGN;
  hStarRgn, hFishRgn,
  hFloorRgn, hClientRgn,
  hUnionRgn, hClipRgn                 : Windows.HRGN;

  ClipRgnType,ViewType,OldMapMode     : INTEGER;

  Dextent                             : LONGINT;

  hOldBrush, hBrush                   : Windows.HBRUSH;

  hAccTable                           : Windows.HANDLE;


PROCEDURE MessagePaint( hWnd    : Windows.HWND;
                        hdc     : Windows.HDC;
                        RCPaint : Windows.RECT);
VAR FishHere : INTEGER;
BEGIN

    IF ClipRgnType = 99 THEN   (* special case *)
       IF Windows.BitBlt(hdc,0,0,1,1,hMemoryDC,0,0,
                         Windows.BLACKNESS) = 0 THEN END
    END;

    IF (ClipRgnType = CLIENTREGION) OR
       (ClipRgnType = FISHREGION) OR
       (ClipRgnType = TANKREGION) OR
       (ClipRgnType = CLIPREGION) THEN
       FishHere := 1;
             WHILE (FishHere <= FishMax) DO
              IF FishHead[FishHere].status THEN
                 hOldbmap := Windows.SelectObject(hMemoryDC, FishHead[FishHere].bmap[FishHead[FishHere].direction,
                                                  FishHead[FishHere].bmapno]);
                 IF Windows.BitBlt(hdc,FishHead[FishHere].xpos,FishHead[FishHere].ypos,
                                   FishHead[FishHere].xextent,FishHead[FishHere].yextent,
                                   hMemoryDC,0,0,Windows.SRCPAINT) # 0 THEN END;
                 InstanceHead := FishHead[FishHere].Other;
                 WHILE InstanceHead # NIL DO
                     hOldbmap := Windows.SelectObject(hMemoryDC, FishHead[FishHere].bmap[FishHead[FishHere].direction,
                                                      InstanceHead^.bmapno]);
                     IF Windows.BitBlt(hdc,InstanceHead^.xpos,InstanceHead^.ypos,
                                       FishHead[FishHere].xextent,FishHead[FishHere].yextent,hMemoryDC,0,0,
                                       Windows.SRCPAINT) # 0 THEN END;
                     InstanceHead := InstanceHead^.NextInstance
                 END
              END;
              FishHere := FishHere+1;
           END; (* DO *)
        FishHere := 1;
     END;

    IF (ClipRgnType = CLIENTREGION) OR
       (ClipRgnType = TANKREGION) OR
       (ClipRgnType = FLOORREGION) OR
       (ClipRgnType = CLIPREGION) THEN
       IF ClipRgnType = CLIPREGION THEN
          IF Windows.SelectClipRgn(hdc,hFloorRgn) = 0 THEN END;
          hOldbmap    := Windows.SelectObject(hMemoryDC,hFLOORbmap);
          IF Windows.BitBlt(hdc,0,floorypos,FLOORXSIZE,FLOORYSIZE,hMemoryDC,0,0,Windows.SRCCOPY) # 0 THEN END;
          IF Windows.SelectClipRgn(hdc,hSTARS[star].hClipRgn) = 0 THEN END
       ELSE
          hOldbmap    := Windows.SelectObject(hMemoryDC,hFLOORbmap);
          IF Windows.BitBlt(hdc,0,floorypos,FLOORXSIZE,FLOORYSIZE,hMemoryDC,0,0,Windows.SRCCOPY) # 0 THEN END;
       END
    ELSIF
       (Windows.RectInRegion(hFloorRgn,RCPaint) # 0) THEN

       IF Windows.SelectClipRgn(hdc,hFloorRgn) = 0 THEN END;
       hOldbmap    := Windows.SelectObject(hMemoryDC,hFLOORbmap);
       IF Windows.BitBlt(hdc,0,floorypos,FLOORXSIZE,FLOORYSIZE,hMemoryDC,0,0,Windows.SRCCOPY) # 0 THEN END;
       CASE ClipRgnType OF
         | CLIPREGION:
           IF Windows.SelectClipRgn(hdc,hSTARS[star].hClipRgn) = 0 THEN END;
         | STARREGION:
           IF Windows.SelectClipRgn(hdc,hSTARS[star].hStarRgn) = 0 THEN END;
         | WEEDREGION:
           IF Windows.SelectClipRgn(hdc,hFloorRgn) = 0 THEN END;
       END;

    END;

    IF (ClipRgnType = CLIENTREGION) OR
       (ClipRgnType = STARREGION) OR
       (ClipRgnType = CLIPREGION) OR
       (ClipRgnType = TANKREGION) THEN (* if these  are changed then change case *)

       IF Windows.SelectClipRgn(hdc,hSTARS[star].hStarRgn) = 0 THEN END;
       hOldbmap := Windows.SelectObject(hMemoryDC,hSTARS[star].hStar);
       IF Windows.BitBlt(hdc,STARXPOS,starypos,STARXSIZE,STARYSIZE,hMemoryDC,0,0,Windows.SRCPAINT) # 0 THEN END;

       CASE ClipRgnType OF
         | CLIENTREGION:
           IF Windows.SelectClipRgn(hdc,hClientRgn) = 0 THEN END;
         | TANKREGION:
           IF Windows.SelectClipRgn(hdc,hTankRgn) = 0 THEN END;
         | CLIPREGION:
           IF Windows.SelectClipRgn(hdc,hSTARS[star].hClipRgn) = 0 THEN END;
       END;

    END;

    IF (ClipRgnType = CLIENTREGION) OR
       (ClipRgnType = WEEDREGION) OR
       (ClipRgnType = CLIPREGION) OR
       (ClipRgnType = TANKREGION) THEN (* if these  are changed then change case *)

       IF Windows.SelectClipRgn(hdc,hFloorRgn) = 0 THEN END;
       hOldbmap := Windows.SelectObject(hMemoryDC,hWEEDS[weed].hWeed);
       IF Windows.BitBlt(hdc,WEEDXPOS,weedypos,WEEDXSIZE,WEEDYSIZE,hMemoryDC,0,0,Windows.SRCPAINT) # 0 THEN END;

       CASE ClipRgnType OF
         | CLIENTREGION:
           IF Windows.SelectClipRgn(hdc,hClientRgn) = 0 THEN END;
         | TANKREGION:
           IF Windows.SelectClipRgn(hdc,hTankRgn) = 0 THEN END;
         | CLIPREGION:
           IF Windows.SelectClipRgn(hdc,hSTARS[star].hClipRgn) = 0 THEN END;
       END;

    END;


END MessagePaint;

PROCEDURE Increase( VAR X : INTEGER);
BEGIN
    IF X < 0 THEN DEC(X) END;
    IF X > 0 THEN INC(X) END;
END Increase;

PROCEDURE ReDrawAll(hWnd     : Windows.HWND;
                    ClipType : INTEGER );
BEGIN
    ClipRgnType := TANKREGION;
    IF Windows.SelectClipRgn(hdc,hTankRgn) = 0 THEN END;

    Windows.InvalidateRgn(hWnd,hTankRgn,1);
    Windows.UpdateWindow(hWnd);

    CASE ClipType OF

         | CLIPREGION:
           ClipRgnType := CLIPREGION;
           IF Windows.SelectClipRgn(hdc,hSTARS[star].hClipRgn) = 0 THEN END;

         | STARREGION:
           ClipRgnType := STARREGION;
           IF Windows.SelectClipRgn(hdc,hSTARS[star].hStarRgn) = 0 THEN END;

         | FLOORREGION:
           ClipRgnType := FLOORREGION;
           IF Windows.SelectClipRgn(hdc,hFloorRgn) = 0 THEN END;

         | CLIENTREGION:
           ClipRgnType := CLIENTREGION;
           IF Windows.SelectClipRgn(hdc,hClientRgn) = 0 THEN END;
    END;
END ReDrawAll;


PROCEDURE CreateFishNode(Name           : NameType;
                         FishHere       : INTEGER ;
                         stat           : BOOLEAN;
                         bmap1, bmap2,
                         bmap3, bmap4,
                         bmap5, bmap6,
                         bmap7, bmap8,
                         bmap9          : Windows.HBITMAP;
                         xpos,ypos      : INTEGER;
                         xextent,
                         yextent,
                         basespeed      : INTEGER;
                         direction,
                         timerid        : INTEGER );
BEGIN
  FishHead[FishHere].name := Name;
  FishHead[FishHere].status := stat;
  IF direction = BACKWARDS THEN
      FishHead[FishHere].bmap[BACKWARDS,1] := bmap1;
      FishHead[FishHere].bmap[BACKWARDS,2] := bmap2;
      FishHead[FishHere].bmap[BACKWARDS,3] := bmap3;
      FishHead[FishHere].bmap[BACKWARDS,4] := bmap4;
      FishHead[FishHere].bmap[FORWARDS,1] := bmap5;
      FishHead[FishHere].bmap[FORWARDS,2] := bmap6;
      FishHead[FishHere].bmap[FORWARDS,3] := bmap7;
      FishHead[FishHere].bmap[FORWARDS,4] := bmap8;
  ELSE
      FishHead[FishHere].bmap[BACKWARDS,1] := bmap5;
      FishHead[FishHere].bmap[BACKWARDS,2] := bmap6;
      FishHead[FishHere].bmap[BACKWARDS,3] := bmap7;
      FishHead[FishHere].bmap[BACKWARDS,4] := bmap8;
      FishHead[FishHere].bmap[FORWARDS,1] := bmap1;
      FishHead[FishHere].bmap[FORWARDS,2] := bmap2;
      FishHead[FishHere].bmap[FORWARDS,3] := bmap3;
      FishHead[FishHere].bmap[FORWARDS,4] := bmap4;
  END;
  FishHead[FishHere].Other := NIL;
  FishHead[FishHere].Instances := 0;
  FishHead[FishHere].turnbmap := bmap9;
  FishHead[FishHere].bmapno := 1;
  FishHead[FishHere].DialogFrame := 1;
  FishHead[FishHere].xpos := xpos;
  FishHead[FishHere].ypos := ypos;
  FishHead[FishHere].xextent := xextent;
  FishHead[FishHere].yextent := yextent;

  IF direction = FORWARDS THEN
    FishHead[FishHere].speedx := basespeed;
  ELSE
    FishHead[FishHere].speedx := -basespeed;
  END;

  FishHead[FishHere].pspeedx := FishHead[FishHere].speedx;
  FishHead[FishHere].speedy := 0;
  FishHead[FishHere].pspeedy := 0;
  FishHead[FishHere].basespeed := basespeed;
  FishHead[FishHere].direction := direction;
  FishHead[FishHere].TimerId := timerid;

END CreateFishNode;

PROCEDURE SetRectInvalid( hWnd          : Windows.HWND;
                          top, left,
                          bottom, right :INTEGER);

VAR InvalidRect : Windows.RECT;

BEGIN

    InvalidRect.top := top;
    InvalidRect.right := right;
    InvalidRect.bottom := bottom;
    InvalidRect.left := left;
    Windows.InvalidateRect(hWnd,InvalidRect,1);

END SetRectInvalid;


PROCEDURE  SetUpBubbles;
VAR i : INTEGER;
BEGIN
  BubbleMax := 4;

  BubbleHead[1].X := RANDOM(XYRect.right);
  BubbleHead[1].Y := RANDOM(XYRect.bottom DIV 3);
  BubbleHead[1].Speed := RANDOM(3) + 4;

  BubbleHead[2].X := RANDOM(XYRect.right);
  BubbleHead[2].Y := RANDOM(XYRect.bottom DIV 3)  + (CARDINAL(XYRect.bottom) DIV 3);
  BubbleHead[2].Speed := RANDOM(3) + 4;

  BubbleHead[3].X := RANDOM(XYRect.right);
  BubbleHead[3].Y := RANDOM(XYRect.bottom DIV 3)  + (CARDINAL(XYRect.bottom) DIV 3);
  BubbleHead[3].Speed := RANDOM(3) + 4;

  BubbleHead[4].X := RANDOM(XYRect.right);
  BubbleHead[4].Y := RANDOM(XYRect.bottom DIV 3) +(2* (CARDINAL(XYRect.bottom) DIV 3));
  BubbleHead[4].Speed := RANDOM(3) + 4;

END SetUpBubbles;

PROCEDURE ResizeStarParams(hWnd : Windows.HWND) : BOOLEAN;

VAR Xorg,Yorg,i         : INTEGER;
    Origin              : LONGCARD;

BEGIN

    Origin := Windows.GetWindowOrg(hdc);
    Xorg := INTEGER(Windows.LOWORD(Origin));
    Yorg := INTEGER(Windows.HIWORD(Origin));

    starypos := floorypos - 47;
    staryxtent := floorypos - 47 + STARYSIZE;
    hSTARS[1].StarPoints[1].x := STARXPOS + 52; (* these map the points of the perimiter of the star *)
    hSTARS[1].StarPoints[1].y := starypos + 2;
    hSTARS[1].StarPoints[2].x := STARXPOS + 43;
    hSTARS[1].StarPoints[2].y := starypos + 23;
    hSTARS[1].StarPoints[3].x := STARXPOS + 65;
    hSTARS[1].StarPoints[3].y := starypos + 35;
    hSTARS[1].StarPoints[4].x := STARXPOS + 38;
    hSTARS[1].StarPoints[4].y := starypos + 36;
    hSTARS[1].StarPoints[5].x := STARXPOS + 30;
    hSTARS[1].StarPoints[5].y := starypos + 53;
    hSTARS[1].StarPoints[6].x := STARXPOS + 24;
    hSTARS[1].StarPoints[6].y := starypos + 36;
    hSTARS[1].StarPoints[7].x := STARXPOS + 3;
    hSTARS[1].StarPoints[7].y := starypos + 39;
    hSTARS[1].StarPoints[8].x := STARXPOS + 21;
    hSTARS[1].StarPoints[8].y := starypos + 25;
    hSTARS[1].StarPoints[9].x := STARXPOS + 9;
    hSTARS[1].StarPoints[9].y := starypos + 8;
    hSTARS[1].StarPoints[10].x := STARXPOS + 31;
    hSTARS[1].StarPoints[10].y := starypos + 16;
    hSTARS[1].StarPoints[11].x := STARXPOS + 52;
    hSTARS[1].StarPoints[11].y := starypos + 2;

    hSTARS[2].StarPoints[1].x := STARXPOS + 11;
    hSTARS[2].StarPoints[1].y := starypos + 2;
    hSTARS[2].StarPoints[2].x := STARXPOS + 33;
    hSTARS[2].StarPoints[2].y := starypos + 15;
    hSTARS[2].StarPoints[3].x := STARXPOS + 55;
    hSTARS[2].StarPoints[3].y := starypos + 7 ;
    hSTARS[2].StarPoints[4].x := STARXPOS + 43;
    hSTARS[2].StarPoints[4].y := starypos + 25;
    hSTARS[2].StarPoints[5].x := STARXPOS + 62;
    hSTARS[2].StarPoints[5].y := starypos + 41;
    hSTARS[2].StarPoints[6].x := STARXPOS + 40;
    hSTARS[2].StarPoints[6].y := starypos + 36;
    hSTARS[2].StarPoints[7].x := STARXPOS + 34;
    hSTARS[2].StarPoints[7].y := starypos + 52;
    hSTARS[2].StarPoints[8].x := STARXPOS + 25;
    hSTARS[2].StarPoints[8].y := starypos + 34;
    hSTARS[2].StarPoints[9].x := STARXPOS + 0;
    hSTARS[2].StarPoints[9].y := starypos + 36;
    hSTARS[2].StarPoints[10].x := STARXPOS + 21;
    hSTARS[2].StarPoints[10].y := starypos + 21;
    hSTARS[2].StarPoints[11].x := STARXPOS + 11;
    hSTARS[2].StarPoints[11].y := starypos + 2;

    hSTARS[3].StarPoints[1].x := STARXPOS + 31;
    hSTARS[3].StarPoints[1].y := starypos + 15;
    hSTARS[3].StarPoints[2].x := STARXPOS + 52;
    hSTARS[3].StarPoints[2].y := starypos + 0 ;
    hSTARS[3].StarPoints[3].x := STARXPOS + 43;
    hSTARS[3].StarPoints[3].y := starypos + 21;
    hSTARS[3].StarPoints[4].x := STARXPOS + 63;
    hSTARS[3].StarPoints[4].y := starypos + 33;
    hSTARS[3].StarPoints[5].x := STARXPOS + 39;
    hSTARS[3].StarPoints[5].y := starypos + 33;
    hSTARS[3].StarPoints[6].x := STARXPOS + 29;
    hSTARS[3].StarPoints[6].y := starypos + 50;
    hSTARS[3].StarPoints[7].x := STARXPOS + 23;
    hSTARS[3].StarPoints[7].y := starypos + 34;
    hSTARS[3].StarPoints[8].x := STARXPOS + 0 ;
    hSTARS[3].StarPoints[8].y := starypos + 38;
    hSTARS[3].StarPoints[9].x := STARXPOS + 20;
    hSTARS[3].StarPoints[9].y := starypos + 25;
    hSTARS[3].StarPoints[10].x := STARXPOS + 8 ;
    hSTARS[3].StarPoints[10].y := starypos + 5 ;
    hSTARS[3].StarPoints[11].x := STARXPOS + 31;
    hSTARS[3].StarPoints[11].y := starypos + 15;

    hSTARS[4].StarPoints[1].x := STARXPOS + 15;
    hSTARS[4].StarPoints[1].y := starypos + 3;
    hSTARS[4].StarPoints[2].x := STARXPOS + 36;
    hSTARS[4].StarPoints[2].y := starypos + 17;
    hSTARS[4].StarPoints[3].x := STARXPOS + 57;
    hSTARS[4].StarPoints[3].y := starypos + 7 ;
    hSTARS[4].StarPoints[4].x := STARXPOS + 46;
    hSTARS[4].StarPoints[4].y := starypos + 26;
    hSTARS[4].StarPoints[5].x := STARXPOS + 64;
    hSTARS[4].StarPoints[5].y := starypos + 40;
    hSTARS[4].StarPoints[6].x := STARXPOS + 43;
    hSTARS[4].StarPoints[6].y := starypos + 36;
    hSTARS[4].StarPoints[7].x := STARXPOS + 37;
    hSTARS[4].StarPoints[7].y := starypos + 54;
    hSTARS[4].StarPoints[8].x := STARXPOS + 28;
    hSTARS[4].StarPoints[8].y := starypos + 35;
    hSTARS[4].StarPoints[9].x := STARXPOS + 3;
    hSTARS[4].StarPoints[9].y := starypos + 35;
    hSTARS[4].StarPoints[10].x := STARXPOS + 25;
    hSTARS[4].StarPoints[10].y := starypos + 24;
    hSTARS[4].StarPoints[11].x := STARXPOS + 15;
    hSTARS[4].StarPoints[11].y := starypos + 3;

    FOR i := 1 TO 4 DO (* create regions which contain exactly each star *)
        IF Windows.DeleteObject(hSTARS[i].hStarRgn) = 0 THEN END;

        hSTARS[i].hStarRgn := Windows.CreatePolygonRgn(hSTARS[i].StarPoints[1],11,Windows.WINDING);

        IF hSTARS[i].hStarRgn = 0 THEN
           RETURN(ApplFish.ResourcesLow(hWnd))
        END

    END;

    IF Windows.DeleteObject(hClientRgn) = 0 THEN END;
    hClientRgn := Windows.CreateRectRgn(0,0,TankWidth,TankDepth);
    IF hClientRgn = 0 THEN
       RETURN(ApplFish.ResourcesLow(hWnd))
    END;

    (* create clip regions *)

    IF Windows.CombineRgn(hFishRgn,hClientRgn,hFloorRgn,Windows.RGN_DIFF) = Windows.ERROR THEN
           RETURN(ApplFish.ResourcesLow(hWnd))
    END;

    IF Windows.CombineRgn(hSTARS[1].hClipRgn,hFishRgn,hSTARS[1].hStarRgn,Windows.RGN_DIFF) = Windows.ERROR THEN
           RETURN(ApplFish.ResourcesLow(hWnd))
    END;
    IF Windows.CombineRgn(hSTARS[2].hClipRgn,hFishRgn,hSTARS[2].hStarRgn,Windows.RGN_DIFF) = Windows.ERROR THEN
           RETURN(ApplFish.ResourcesLow(hWnd))
    END;
    IF Windows.CombineRgn(hSTARS[3].hClipRgn,hFishRgn,hSTARS[3].hStarRgn,Windows.RGN_DIFF) = Windows.ERROR THEN
           RETURN(ApplFish.ResourcesLow(hWnd))
    END;
    IF Windows.CombineRgn(hSTARS[4].hClipRgn,hFishRgn,hSTARS[4].hStarRgn,Windows.RGN_DIFF) = Windows.ERROR THEN
           RETURN(ApplFish.ResourcesLow(hWnd))
    END;

    IF Windows.DeleteObject(hFishRgn) # 0 THEN END;
    RETURN FALSE

END ResizeStarParams;

PROCEDURE ReCalcFloorRegion(hWnd : Windows.HWND) : BOOLEAN;

VAR FloorPoints : ARRAY[1..70] OF Windows.POINT;

BEGIN

    FloorPoints[1].x := 0;
    FloorPoints[1].y := floorypos + 29;
    FloorPoints[2].x := 5;
    FloorPoints[2].y := floorypos + 13;
    FloorPoints[3].x := 12;
    FloorPoints[3].y := floorypos + 12;
    FloorPoints[4].x := 15;
    FloorPoints[4].y := floorypos + 7;
    FloorPoints[5].x := 22;
    FloorPoints[5].y := floorypos + 6;
    FloorPoints[6].x := 23;
    FloorPoints[6].y := floorypos + 12;
    FloorPoints[7].x := 35;
    FloorPoints[7].y := floorypos + 6;
    FloorPoints[8].x := 53;
    FloorPoints[8].y := floorypos + 0;

    weedypos := floorypos - WEEDYSIZE+1;
    weedyxtent := floorypos;
    FloorPoints[1+8].x := WEEDXPOS + 5;
    FloorPoints[1+8].y := weedypos + 71;
    FloorPoints[2+8].x := WEEDXPOS + 9;
    FloorPoints[2+8].y := weedypos + 58;
    FloorPoints[3+8].x := WEEDXPOS + 1;
    FloorPoints[3+8].y := weedypos + 45;
    FloorPoints[4+8].x := WEEDXPOS + 7;
    FloorPoints[4+8].y := weedypos + 15;
    FloorPoints[5+8].x := WEEDXPOS + 11;
    FloorPoints[5+8].y := weedypos + 8;
    FloorPoints[6+8].x := WEEDXPOS + 31;
    FloorPoints[6+8].y := weedypos + 41;
    FloorPoints[7+8].x := WEEDXPOS + 34;
    FloorPoints[7+8].y := weedypos + 51;
    FloorPoints[8+8].x := WEEDXPOS + 44;
    FloorPoints[8+8].y := weedypos + 29;
    FloorPoints[9+8].x := WEEDXPOS + 46;
    FloorPoints[9+8].y := weedypos + 13;
    FloorPoints[10+8].x := WEEDXPOS + 55;
    FloorPoints[10+8].y := weedypos + 0;
    FloorPoints[11+8].x := WEEDXPOS + 60;
    FloorPoints[11+8].y := weedypos + 1;
    FloorPoints[12+8].x := WEEDXPOS + 63;
    FloorPoints[12+8].y := weedypos + 11;
    FloorPoints[13+8].x := WEEDXPOS + 58;
    FloorPoints[13+8].y := weedypos + 24;
    FloorPoints[14+8].x := WEEDXPOS + 58;
    FloorPoints[14+8].y := weedypos + 48;
    FloorPoints[15+8].x := WEEDXPOS + 64;
    FloorPoints[15+8].y := weedypos + 56;
    FloorPoints[16+8].x := WEEDXPOS + 59;
    FloorPoints[16+8].y := weedypos + 71;

    FloorPoints[9+16].x := 112;
    FloorPoints[9+16].y := floorypos + 0;
    FloorPoints[10+16].x := 116;
    FloorPoints[10+16].y := floorypos + 5;

    FloorPoints[11+16].x := 135;
    FloorPoints[11+16].y := floorypos + 3;
    FloorPoints[12+16].x := 143;
    FloorPoints[12+16].y := floorypos + 7;
    FloorPoints[13+16].x := 161;
    FloorPoints[13+16].y := floorypos + 0;
    FloorPoints[14+16].x := 168;
    FloorPoints[14+16].y := floorypos + 0;
    FloorPoints[15+16].x := 190;
    FloorPoints[15+16].y := floorypos + 5;
    FloorPoints[16+16].x := 215;
    FloorPoints[16+16].y := floorypos + 5;
    FloorPoints[17+16].x := 223;
    FloorPoints[17+16].y := floorypos + 1;
    FloorPoints[18+16].x := 246;
    FloorPoints[18+16].y := floorypos + 0;
    FloorPoints[19+16].x := 258;
    FloorPoints[19+16].y := floorypos + 6;
    FloorPoints[20+16].x := 271;
    FloorPoints[20+16].y := floorypos + 6;
    FloorPoints[21+16].x := 293;
    FloorPoints[21+16].y := floorypos + 16;
    FloorPoints[22+16].x := 312;
    FloorPoints[22+16].y := floorypos + 17;
    FloorPoints[23+16].x := 321;
    FloorPoints[23+16].y := floorypos + 22;
    FloorPoints[24+16].x := 324;
    FloorPoints[24+16].y := floorypos + 29;
    FloorPoints[25+16].x := 336;
    FloorPoints[25+16].y := floorypos + 31;
    FloorPoints[26+16].x := 342;
    FloorPoints[26+16].y := floorypos + 23;
    FloorPoints[27+16].x := 347;
    FloorPoints[27+16].y := floorypos + 21;
    FloorPoints[28+16].x := 347;
    FloorPoints[28+16].y := floorypos + 13;
    FloorPoints[29+16].x := 352;
    FloorPoints[29+16].y := floorypos + 8;

    FloorPoints[30+16].x := 363;
    FloorPoints[30+16].y := floorypos + 23;
    FloorPoints[31+16].x := 384;
    FloorPoints[31+16].y := floorypos + 22;
    FloorPoints[32+16].x := 391;
    FloorPoints[32+16].y := floorypos + 3;
    FloorPoints[33+16].x := 398;
    FloorPoints[33+16].y := floorypos + 0;
    FloorPoints[34+16].x := 404;
    FloorPoints[34+16].y := floorypos + 10;
    FloorPoints[35+16].x := 403;
    FloorPoints[35+16].y := floorypos + 18;
    FloorPoints[36+16].x := 413;
    FloorPoints[36+16].y := floorypos + 19;
    FloorPoints[37+16].x := 429;
    FloorPoints[37+16].y := floorypos + 2;
    FloorPoints[38+16].x := 469;
    FloorPoints[38+16].y := floorypos + 4;
    FloorPoints[39+16].x := 492;
    FloorPoints[39+16].y := floorypos + 2;
    FloorPoints[40+16].x := 511;
    FloorPoints[40+16].y := floorypos + 3;
    FloorPoints[41+16].x := 515;
    FloorPoints[41+16].y := floorypos + 7;
    FloorPoints[42+16].x := 533;
    FloorPoints[42+16].y := floorypos + 2;
    FloorPoints[43+16].x := 541;
    FloorPoints[43+16].y := floorypos + 3;
    FloorPoints[44+16].x := 576;
    FloorPoints[44+16].y := floorypos + 43;
    FloorPoints[45+16].x := 590;
    FloorPoints[45+16].y := floorypos + 43;
    FloorPoints[46+16].x := 596;
    FloorPoints[46+16].y := floorypos + 29;
    FloorPoints[47+16].x := 602;
    FloorPoints[47+16].y := floorypos + 29;
    FloorPoints[48+16].x := 611;
    FloorPoints[48+16].y := floorypos + 45;
    FloorPoints[49+16].x := 627;
    FloorPoints[49+16].y := floorypos + 21;
    FloorPoints[50+16].x := 646;
    FloorPoints[50+16].y := floorypos + 13;
    FloorPoints[51+16].x := 646;
    FloorPoints[51+16].y := floorypos + 45;
    FloorPoints[52+16].x := 0;
    FloorPoints[52+16].y := floorypos + 45;
    FloorPoints[53+16].x := 0;
    FloorPoints[53+16].y := floorypos + 29;

    hFloorRgn := Windows.CreatePolygonRgn(FloorPoints[1],69,Windows.WINDING);
    IF hFloorRgn = 0 THEN
           RETURN(ApplFish.ResourcesLow(hWnd))
    END;
    RETURN FALSE

END ReCalcFloorRegion;

PROCEDURE ReCalcRegions(hWnd : Windows.HWND) : BOOLEAN; (* Called when the Window Org is changed by scroll bar *)
VAR Xorg,Yorg,i : INTEGER;
    Origin      : LONGCARD;
BEGIN

    Origin := Windows.GetWindowOrg(hdc);
    Xorg := INTEGER(Windows.LOWORD(Origin));
    Yorg := INTEGER(Windows.HIWORD(Origin));

    FOR i := 1 TO 4 DO
        IF Windows.DeleteObject(hSTARS[i].hStarRgn) = 0 THEN END;
        hSTARS[i].hStarRgn := Windows.CreatePolygonRgn(hSTARS[i].StarPoints[1],11,Windows.WINDING);
        IF hSTARS[i].hStarRgn = 0 THEN
           RETURN(ApplFish.ResourcesLow(hWnd))
        END
    END;

    IF Windows.OffsetRgn(hSTARS[1].hStarRgn,-SbXInc,-SbYInc) = 0 THEN END;
    IF Windows.OffsetRgn(hSTARS[2].hStarRgn,-SbXInc,-SbYInc) = 0 THEN END;
    IF Windows.OffsetRgn(hSTARS[3].hStarRgn,-SbXInc,-SbYInc) = 0 THEN END;
    IF Windows.OffsetRgn(hSTARS[4].hStarRgn,-SbXInc,-SbYInc) = 0 THEN END;

    IF Windows.DeleteObject(hFloorRgn) = 0 THEN END;
    IF ReCalcFloorRegion(hWnd) THEN (* Resource problem *)
       RETURN (FALSE)
    END;
    IF Windows.OffsetRgn(hFloorRgn,-SbXInc,-SbYInc) = 0 THEN END;

    hFishRgn := Windows.CreateRectRgnIndirect(XYRect); (* Needs to be created just once for combine rgn *)
    IF hFishRgn = 0 THEN
       RETURN(ApplFish.ResourcesLow(hWnd))
    END;

    IF Windows.CombineRgn(hFishRgn,hClientRgn,hFloorRgn,Windows.RGN_DIFF) = Windows.ERROR THEN
       RETURN(ApplFish.ResourcesLow(hWnd))
    END;

    FOR i := 1 TO MAXSTARS DO
        IF Windows.CombineRgn(hSTARS[i].hClipRgn,hFishRgn,hSTARS[i].hStarRgn,Windows.RGN_DIFF) = Windows.ERROR THEN
               RETURN(ApplFish.ResourcesLow(hWnd))
        END
    END;

    IF Windows.DeleteObject(hFishRgn) # 0 THEN END;

    RETURN FALSE
END ReCalcRegions;

PROCEDURE QuickDeleteRgns(hWnd  : Windows.HWND);
VAR i : INTEGER;
BEGIN
       FOR i := 1 TO MAXSTARS DO
           IF Windows.DeleteObject(hSTARS[i].hStarRgn) = 0 THEN END;
           IF Windows.DeleteObject(hSTARS[i].hStar) # 0 THEN END;
           IF Windows.DeleteObject(hSTARS[i].hClipRgn) # 0 THEN END;
       END; (* for i *)
       IF Windows.DeleteObject(hFloorRgn) # 0 THEN END;
       IF Windows.DeleteObject(hClientRgn) # 0 THEN END;
       IF Windows.DeleteObject(hTankRgn) # 0 THEN END;
END QuickDeleteRgns;


PROCEDURE StopAllTimers(hWnd : Windows.HWND);
BEGIN

      IF Windows.KillTimer(hWnd,FISHMOVE) = 0 THEN END;
      IF Windows.KillTimer(hWnd,BUBBLEMOVE) = 0 THEN END;
      IF Windows.KillTimer(hWnd,SETRANDOM) = 0 THEN END;
      IF Windows.KillTimer(hWnd,STARMOVE) = 0 THEN END;
      IF Windows.KillTimer(hWnd,WEEDMOVE) = 0 THEN END;
      IF Windows.KillTimer(hWnd,CHESTMOVE) = 0 THEN END;

END StopAllTimers;

PROCEDURE StartAllTimers(hWnd : Windows.HWND);
VAR timerid : INTEGER;
BEGIN
      timerid := Windows.SetTimer(hWnd,FISHMOVE,FISHTIMER,Windows.FARPROC(0));
      IF timerid = 0 THEN
         ApplFish.TimersLow(hWnd)
      END;
      timerid := Windows.SetTimer(hWnd,BUBBLEMOVE,BUBBLETIMER,Windows.FARPROC(0));
      IF timerid = 0 THEN
         ApplFish.TimersLow(hWnd)
      END;
      timerid := Windows.SetTimer(hWnd,SETRANDOM,RANDOMTIMER,Windows.FARPROC(0));
      IF timerid = 0 THEN
         ApplFish.TimersLow(hWnd)
      END;
      timerid := Windows.SetTimer(hWnd,STARMOVE,STARTIMER,Windows.FARPROC(0));
      IF timerid = 0 THEN
         ApplFish.TimersLow(hWnd)
      END;
      timerid := Windows.SetTimer(hWnd,WEEDMOVE,WEEDTIMER,Windows.FARPROC(0));
      IF timerid = 0 THEN
         ApplFish.TimersLow(hWnd)
      END;
      timerid := Windows.SetTimer(hWnd,CHESTMOVE,CHESTTIMER,Windows.FARPROC(0));
      IF timerid = 0 THEN
         ApplFish.TimersLow(hWnd)
      END;

END StartAllTimers;

PROCEDURE CreateInstance(hWnd : Windows.HWND);
BEGIN

  (* Load resources *)
    hFISHF1A    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHF1A)));
    hFISHF1B    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHF1B)));
    hFISHF1C    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHF1C)));
    hFISHF1D    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHF1D)));
    hFISHB1A    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHB1A)));
    hFISHB1B    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHB1B)));
    hFISHB1C    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHB1C)));
    hFISHB1D    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHB1D)));
    hFISHT1     := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHT1)));

    hFISHF2A    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHF2A)));
    hFISHF2B    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHF2B)));
    hFISHF2C    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHF2C)));
    hFISHF2D    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHF2D)));
    hFISHB2A    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHB2A)));
    hFISHB2B    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHB2B)));
    hFISHB2C    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHB2C)));
    hFISHB2D    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHB2D)));
    hFISHT2     := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHT2)));

    hFISHF3A    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHF3A)));
    hFISHF3B    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHF3B)));
    hFISHF3C    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHF3C)));
    hFISHF3D    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHF3D)));
    hFISHB3A    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHB3A)));
    hFISHB3B    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHB3B)));
    hFISHB3C    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHB3C)));
    hFISHB3D    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHB3D)));
    hFISHT3     := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHT3)));

    hFISHF4A    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHF4A)));
    hFISHF4B    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHF4B)));
    hFISHF4C    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHF4C)));
    hFISHF4D    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHF4D)));
    hFISHB4A    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHB4A)));
    hFISHB4B    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHB4B)));
    hFISHB4C    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHB4C)));
    hFISHB4D    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHB4D)));
    hFISHT4     := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHT4)));

    hFISHF5A    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHF5A)));
    hFISHF5B    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHF5B)));
    hFISHF5C    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHF5C)));
    hFISHF5D    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHF5D)));
    hFISHB5A    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHB5A)));
    hFISHB5B    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHB5B)));
    hFISHB5C    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHB5C)));
    hFISHB5D    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHB5D)));
    hFISHT5     := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHT5)));

    hFISHF6A    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHF6A)));
    hFISHF6B    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHF6B)));
    hFISHF6C    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHF6C)));
    hFISHF6D    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHF6D)));
    hFISHB6A    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHB6A)));
    hFISHB6B    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHB6B)));
    hFISHB6C    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHB6C)));
    hFISHB6D    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHB6D)));
    hFISHT6     := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHT6)));

    hFISHF7A    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHF7A)));
    hFISHF7B    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHF7B)));
    hFISHF7C    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHF7C)));
    hFISHF7D    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHF7D)));
    hFISHB7A    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHB7A)));
    hFISHB7B    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHB7B)));
    hFISHB7C    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHB7C)));
    hFISHB7D    := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHB7D)));
    hFISHT7     := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FISHT7)));

    hBUBBLEbmap := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(BUBBLE)));
    hBUBBLE1bmap := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(BUBBLE1)));
    hBUBBLE2bmap := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(BUBBLE2)));
    hBUBBLE3bmap := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(BUBBLE3)));
    hSTARS[1].hStar := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(STAR1)));
    hSTARS[2].hStar := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(STAR3)));
    hSTARS[3].hStar := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(STAR4)));
    hSTARS[4].hStar := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(STAR5)));
    hFLOORbmap := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(FLOOR)));
    hWEEDS[1].hWeed := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(WEED1)));
    hWEEDS[2].hWeed := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(WEED2)));
    hCHEST[1] := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(CHESTA)));
    hCHEST[2] := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(CHESTB)));
    hCHEST[3] := Windows.LoadBitmap( hInst, FarADDRESS(LONGCARD(CHESTC)));

    hAccTable := Windows.LoadAccelerators(hInst, "ApplAcclKeys");

    bubbleon := FALSE;
    hBUBBLES[1] := hBUBBLE1bmap;
    hBUBBLES[2] := hBUBBLE2bmap;
    hBUBBLES[3] := hBUBBLE3bmap;
    bubble := 1;

    ViewType := NORMAL;

    staron := FALSE;
    star := 1;
    weed := 1;
    chest := 1;
    FishHere := 1;
    CreateFishNode("Ugly",FishHere,TRUE,hFISHF1A,hFISHF1B,hFISHF1C,hFISHF1D,
    hFISHB1A,hFISHB1B,hFISHB1C,hFISHB1D,hFISHT1,450,100,FISH1X,FISH1Y,FASTSPEED,BACKWARDS,FISHMOVE);
    FishHere := 2;
    CreateFishNode("Chernobyl Eddie",FishHere,FALSE,hFISHF2A,hFISHF2B,hFISHF2C,hFISHF2D,
    hFISHB2A,hFISHB2B,hFISHB2C,hFISHB2D,hFISHT2,250,200,72,55,AVERAGESPEED,BACKWARDS,FISHMOVE);
    FishHere := 3;
    CreateFishNode("Tropical Trudy",FishHere,TRUE,hFISHF3A,hFISHF3B,hFISHF3C,hFISHF3D,
    hFISHB3A,hFISHB3B,hFISHB3C,hFISHB3D,hFISHT3,250,280,FISHX3X,FISHX3Y,AVERAGESPEED,FORWARDS,FISHMOVE);
    FishHere := 4;
    CreateFishNode("Angel",FishHere,TRUE,hFISHF4A,hFISHF4B,hFISHF4C,hFISHF4D,
    hFISHB4A,hFISHB4B,hFISHB4C,hFISHB4D,hFISHT4,200,50,FISHX1X,FISHX1Y,AVERAGESPEED,BACKWARDS,FISHMOVE);
    FishHere := 5;
    CreateFishNode("Red Ronnie",FishHere,TRUE,hFISHF5A,hFISHF5B,hFISHF5C,hFISHF5D,
    hFISHB5A,hFISHB5B,hFISHB5C,hFISHB5D,hFISHT5,50,80,FISHX2X,FISHX2Y,AVERAGESPEED,BACKWARDS,FISHMOVE);
    FishHere := 6;
    CreateFishNode("Goldie",FishHere,TRUE,hFISHF6A,hFISHF6B,hFISHF6C,hFISHF6D,
    hFISHB6A,hFISHB6B,hFISHB6C,hFISHB6D,hFISHT6,50,180,32,32,SLOWSPEED,BACKWARDS,FISHMOVE);
    FishHere := 7;
    CreateFishNode("The Gangers",FishHere,FALSE,hFISHF7A,hFISHF7B,hFISHF7C,hFISHF7D,
    hFISHB7A,hFISHB7B,hFISHB7C,hFISHB7D,hFISHT7,50,180,F1X,F1Y,FASTSPEED,BACKWARDS,FISHMOVE);

    FishMax := 7;

    RANDOMIZE;

    Windows.SetScrollRange(hWnd,Windows.SB_HORZ,0,SBHORZUNITS,0);
    Windows.SetScrollRange(hWnd,Windows.SB_VERT,0,SBVERTUNITS,0);


END CreateInstance;


(* The windows function *)

PROCEDURE MainWndProc( hWnd     : Windows.HWND;
                       message  : CARDINAL;
                       wParam   : CARDINAL;
                       lParam   : LONGINT ): LONGINT;

VAR
    ps: Windows.PAINTSTRUCT;
    hOldbmap  : Windows.HBITMAP;
    i,j : INTEGER;
    v : LONGCARD;
    hNewMenu,hTMenu : Windows.HMENU;

BEGIN
    CASE message OF
        | Windows.WM_COMMAND:
         CASE wParam OF
                | IDM_START:
                    timerid := Windows.SetTimer(hWnd,FISHMOVE,FISHTIMER,Windows.FARPROC(0));
                    IF timerid = 0 THEN
                             ApplFish.TimersLow(hWnd)
                    END;

                    timerid := Windows.SetTimer(hWnd,BUBBLEMOVE,BUBBLETIMER,Windows.FARPROC(0));
                    IF timerid = 0 THEN
                             ApplFish.TimersLow(hWnd)
                    END;
                    IF NOT(randomset) THEN
                       randomset := TRUE;
                       timerid := Windows.SetTimer(hWnd,SETRANDOM,RANDOMTIMER,Windows.FARPROC(0));
                       IF timerid = 0 THEN
                                ApplFish.TimersLow(hWnd)
                       END;
                    END;
                    IF (NOT(staron)) THEN
                       staron      := TRUE;
                       timerid := Windows.SetTimer(hWnd,STARMOVE,STARTIMER,Windows.FARPROC(0));
                       IF timerid = 0 THEN
                                ApplFish.TimersLow(hWnd)
                       END;
                    END;
                    timerid := Windows.SetTimer(hWnd,WEEDMOVE,WEEDTIMER,Windows.FARPROC(0));
                    IF timerid = 0 THEN
                             ApplFish.TimersLow(hWnd)
                    END;
                    timerid := Windows.SetTimer(hWnd,CHESTMOVE,CHESTTIMER,Windows.FARPROC(0));
                    IF timerid = 0 THEN
                             ApplFish.TimersLow(hWnd)
                    END;
                    ReDrawAll(hWnd,CLIPREGION);
                | IDM_DEBUG:
                    IF Windows.DestroyWindow(hWnd) = 0 THEN END;
                    ReDrawAll(hWnd,CLIPREGION);

                | IDM_DESTROY:
                    IF Windows.DestroyWindow(hWnd) = 0 THEN END;

                | IDM_ABOUT:

                    StopAllTimers(hWnd); (* When about is shown it sends a message bak here to start timers again *)
                    lpprocAbout := Windows.MakeProcInstance( Windows.FARPROC(FarADR(ApplDlg.About)), hInst);
                    IF Windows.DialogBox( hInst, FarADDRESS(LONGCARD(ABOUTBOX)), hWnd, lpprocAbout ) # 0 THEN END;
                    Windows.FreeProcInstance(lpprocAbout);

                | RESTART:
                    StartAllTimers(hWnd);

                | IDM_SELECT:

                    lpOpenDlg := Windows.MakeProcInstance( Windows.FARPROC(FarADR(ApplDlg.Selec)), hInst);
                    IF Windows.DialogBox( hInst, FarADDRESS(LONGCARD(FISHSELECT)), hWnd, lpOpenDlg ) = 0 THEN END;
                    Windows.FreeProcInstance(lpOpenDlg);

                | IDM_PLUSBUB:

                    IF BubbleMax < 10 THEN
                       BubbleMax := BubbleMax + 1;
                       BubbleHead[BubbleMax].X := RANDOM(XYRect.right);
                       BubbleHead[BubbleMax].Y := RANDOM(floorypos DIV 3) +(2* (CARDINAL(floorypos) DIV 3));
                       BubbleHead[BubbleMax].Speed := RANDOM(3) + 4;
                    END;

                | IDM_MINUSBUB:
                    IF BubbleMax > 1 THEN

                       hOldbmap := Windows.SelectObject(hMemoryDC, hBUBBLEbmap);
                       IF Windows.BitBlt(hdc,BubbleHead[BubbleMax].X,BubbleHead[BubbleMax].Y,BUBBLE_X_XTENT,BUBBLE_Y_XTENT,hMemoryDC,0,0,Windows.BLACKNESS) # 0 THEN END;
                       BubbleMax := BubbleMax - 1;
                    END;

                | IDM_CHANGEVIEW:

                  IF ViewType = NORMAL THEN

                    IF Windows.KillTimer(hWnd,FISHMOVE) = 0 THEN END;
                    IF Windows.KillTimer(hWnd,BUBBLEMOVE) = 0 THEN END;
                    IF Windows.KillTimer(hWnd,SETRANDOM) = 0 THEN END;
                    IF Windows.KillTimer(hWnd,STARMOVE) = 0 THEN END;
                    IF Windows.KillTimer(hWnd,WEEDMOVE) = 0 THEN END;
                    IF Windows.KillTimer(hWnd,CHESTMOVE) = 0 THEN END;

                     OldMapMode := Windows.SetMapMode(hdc,Windows.MM_ANISOTROPIC);
                     Windows.GetClientRect(hWnd,TempRect);
                     SbXPos := 0;
                     SbYPos := 0;
                     SbXInc := 0;
                     SbYInc := 0;

                     IF Windows.SetWindowOrg(hdc,0,0) = 0 THEN END;
                     IF Windows.SetScrollPos(hWnd,Windows.SB_HORZ,0,1) = 0 THEN END;
                     IF Windows.SetScrollPos(hWnd,Windows.SB_VERT,0,1) = 0 THEN END;
                     IF ReCalcRegions(hWnd) THEN
                        RETURN Windows.False
                     END;

                     IF Windows.SetWindowExt(hdc,TankWidth,TankDepth) = 0 THEN
                        IF Windows.MessageBox(hWnd,"Couldn't set wind ext","Warning",Windows.MB_OK) = 0 THEN END;
                     END;
                     IF Windows.SetViewportExt(hdc,TempRect.right,TempRect.bottom) = 0 THEN
                        IF Windows.MessageBox(hWnd,"Couldn't set viewport ext","Warning",Windows.MB_OK) = 0 THEN END;
                     END;

                    ReDrawAll(hWnd,CLIPREGION);
                    timerid := Windows.SetTimer(hWnd,FISHMOVE,FISHTIMER,Windows.FARPROC(0));
                    IF timerid = 0 THEN
                             ApplFish.TimersLow(hWnd)
                    END;

                    timerid := Windows.SetTimer(hWnd,BUBBLEMOVE,BUBBLETIMER,Windows.FARPROC(0));
                    IF timerid = 0 THEN
                             ApplFish.TimersLow(hWnd)
                    END;

                    timerid := Windows.SetTimer(hWnd,SETRANDOM,RANDOMTIMER,Windows.FARPROC(0));
                    IF timerid = 0 THEN
                             ApplFish.TimersLow(hWnd)
                    END;

                    timerid := Windows.SetTimer(hWnd,STARMOVE,STARTIMER,Windows.FARPROC(0));
                    IF timerid = 0 THEN
                             ApplFish.TimersLow(hWnd)
                    END;

                    timerid := Windows.SetTimer(hWnd,WEEDMOVE,WEEDTIMER,Windows.FARPROC(0));
                    IF timerid = 0 THEN
                             ApplFish.TimersLow(hWnd)
                    END;

                    timerid := Windows.SetTimer(hWnd,CHESTMOVE,CHESTTIMER,Windows.FARPROC(0));
                    IF timerid = 0 THEN
                             ApplFish.TimersLow(hWnd)
                    END;

                    ViewType := FIT

                  ELSE

                     IF Windows.SetMapMode(hdc,OldMapMode) = 0 THEN END;
                     IF Windows.SetWindowExt(hdc,1,1) = 0 THEN END;
                     IF Windows.SetViewportExt(hdc,1,1) = 0 THEN END;

                     Windows.GetClientRect(hWnd,XYRect);
                     RealXYRect:= XYRect;
                     ReDrawAll(hWnd,CLIPREGION);
                     ViewType := NORMAL;
                  END;

                | IDM_DEFAULT:

                     hTMenu:= Windows.GetSubMenu(Windows.GetMenu(hWnd),FISHOPTION);
                     FishHead[1].status := TRUE;
                     IF Windows.CheckMenuItem(hTMenu,IDM_FISH1,Windows.MF_CHECKED) = 0 THEN END;
                     FishHead[2].status := FALSE;
                     IF Windows.CheckMenuItem(hTMenu,IDM_FISH2,Windows.MF_UNCHECKED) = 0 THEN END;
                     FishHead[3].status := TRUE;
                     IF Windows.CheckMenuItem(hTMenu,IDM_FISH3,Windows.MF_CHECKED) = 0 THEN END;
                     FishHead[4].status := TRUE;
                     IF Windows.CheckMenuItem(hTMenu,IDM_FISH4,Windows.MF_CHECKED) = 0 THEN END;
                     FishHead[5].status := TRUE;
                     IF Windows.CheckMenuItem(hTMenu,IDM_FISH5,Windows.MF_CHECKED) = 0 THEN END;
                     FishHead[6].status := TRUE;
                     IF Windows.CheckMenuItem(hTMenu,IDM_FISH6,Windows.MF_CHECKED) = 0 THEN END;
                     FishHead[7].status := FALSE;
                     IF Windows.CheckMenuItem(hTMenu,IDM_FISH7,Windows.MF_UNCHECKED) = 0 THEN END;
                     ReDrawAll(hWnd,CLIPREGION);

                  | IDM_FISH1:

                     StopAllTimers(hWnd); (* dialog function will restart timers when it is ready *)
                     FishSelected := 1;
                     lpLifeDlg := Windows.MakeProcInstance( Windows.FARPROC(FarADR(ApplDlg.LifeInfo)), WMain.hInst);
                     IF Windows.DialogBox( WMain.hInst, FarADDRESS(LONGCARD(LIFEDATABOX)), hWnd, lpLifeDlg ) # 0 THEN END;
                     Windows.FreeProcInstance(lpLifeDlg);
                     hTMenu:= Windows.GetSubMenu(Windows.GetMenu(hWnd),FISHOPTION);

                     IF FishHead[1].status = TRUE THEN
                        IF Windows.CheckMenuItem(hTMenu,IDM_FISH1,Windows.MF_CHECKED) = 0 THEN END;
                     ELSE
                        IF Windows.CheckMenuItem(hTMenu,IDM_FISH1,Windows.MF_UNCHECKED) = 0 THEN END;
                     END;
                     ReDrawAll(hWnd,CLIPREGION);

                  | IDM_FISH2:

                     StopAllTimers(hWnd);
                     FishSelected := 2;

                     lpLifeDlg := Windows.MakeProcInstance( Windows.FARPROC(FarADR(ApplDlg.LifeInfo)), WMain.hInst);
                     IF Windows.DialogBox( WMain.hInst, FarADDRESS(LONGCARD(LIFEDATABOX)), hWnd, lpLifeDlg ) # 0 THEN END;
                     Windows.FreeProcInstance(lpLifeDlg);

                     hTMenu:= Windows.GetSubMenu(Windows.GetMenu(hWnd),FISHOPTION);

                     IF FishHead[2].status = TRUE THEN
                        IF Windows.CheckMenuItem(hTMenu,IDM_FISH2,Windows.MF_CHECKED) = 0 THEN END;
                     ELSE
                        IF Windows.CheckMenuItem(hTMenu,IDM_FISH2,Windows.MF_UNCHECKED) = 0 THEN END;
                     END;
                     ReDrawAll(hWnd,CLIPREGION);

                  | IDM_FISH3:

                     StopAllTimers(hWnd);
                     FishSelected := 3;
                     lpLifeDlg := Windows.MakeProcInstance( Windows.FARPROC(FarADR(ApplDlg.LifeInfo)), WMain.hInst);
                     IF Windows.DialogBox( WMain.hInst, FarADDRESS(LONGCARD(LIFEDATABOX)), hWnd, lpLifeDlg ) # 0 THEN END;
                     Windows.FreeProcInstance(lpLifeDlg);

                     hTMenu:= Windows.GetSubMenu(Windows.GetMenu(hWnd),FISHOPTION);

                     IF FishHead[3].status = TRUE THEN
                        IF Windows.CheckMenuItem(hTMenu,IDM_FISH3,Windows.MF_CHECKED) = 0 THEN END;
                     ELSE
                        IF Windows.CheckMenuItem(hTMenu,IDM_FISH3,Windows.MF_UNCHECKED) = 0 THEN END;
                     END;
                     ReDrawAll(hWnd,CLIPREGION);

                  | IDM_FISH4:

                     StopAllTimers(hWnd);
                     FishSelected := 4;
                     lpLifeDlg := Windows.MakeProcInstance( Windows.FARPROC(FarADR(ApplDlg.LifeInfo)), WMain.hInst);
                     IF Windows.DialogBox( WMain.hInst, FarADDRESS(LONGCARD(LIFEDATABOX)), hWnd, lpLifeDlg ) # 0 THEN END;
                     Windows.FreeProcInstance(lpLifeDlg);

                     hTMenu:= Windows.GetSubMenu(Windows.GetMenu(hWnd),FISHOPTION);

                     IF FishHead[4].status = TRUE THEN
                        IF Windows.CheckMenuItem(hTMenu,IDM_FISH4,Windows.MF_CHECKED) = 0 THEN END;
                     ELSE
                        IF Windows.CheckMenuItem(hTMenu,IDM_FISH4,Windows.MF_UNCHECKED) = 0 THEN END;
                     END;
                     ReDrawAll(hWnd,CLIPREGION);

                  | IDM_FISH5:

                     StopAllTimers(hWnd);
                     FishSelected := 5;
                     lpLifeDlg := Windows.MakeProcInstance( Windows.FARPROC(FarADR(ApplDlg.LifeInfo)), WMain.hInst);
                     IF Windows.DialogBox( WMain.hInst, FarADDRESS(LONGCARD(LIFEDATABOX)), hWnd, lpLifeDlg ) # 0 THEN END;
                     Windows.FreeProcInstance(lpLifeDlg);

                     hTMenu:= Windows.GetSubMenu(Windows.GetMenu(hWnd),FISHOPTION);

                     IF FishHead[5].status = TRUE THEN
                        IF Windows.CheckMenuItem(hTMenu,IDM_FISH5,Windows.MF_CHECKED) = 0 THEN END;
                     ELSE
                        IF Windows.CheckMenuItem(hTMenu,IDM_FISH5,Windows.MF_UNCHECKED) = 0 THEN END;
                     END;
                     ReDrawAll(hWnd,CLIPREGION);

                  | IDM_FISH6:

                     StopAllTimers(hWnd);
                     FishSelected := 6;
                     lpLifeDlg := Windows.MakeProcInstance( Windows.FARPROC(FarADR(ApplDlg.LifeInfo)), WMain.hInst);
                     IF Windows.DialogBox( WMain.hInst, FarADDRESS(LONGCARD(LIFEDATABOX)), hWnd, lpLifeDlg ) # 0 THEN END;
                     Windows.FreeProcInstance(lpLifeDlg);

                     hTMenu:= Windows.GetSubMenu(Windows.GetMenu(hWnd),FISHOPTION);

                     IF FishHead[6].status = TRUE THEN
                        IF Windows.CheckMenuItem(hTMenu,IDM_FISH6,Windows.MF_CHECKED) = 0 THEN END;
                     ELSE
                        IF Windows.CheckMenuItem(hTMenu,IDM_FISH6,Windows.MF_UNCHECKED) = 0 THEN END;
                     END;
                     ReDrawAll(hWnd,CLIPREGION);

                | IDM_FISH7:
                     StopAllTimers(hWnd);
                     FishSelected := 7;
                     lpLifeDlg := Windows.MakeProcInstance( Windows.FARPROC(FarADR(ApplDlg.LifeInfo)), WMain.hInst);
                     IF Windows.DialogBox( WMain.hInst, FarADDRESS(LONGCARD(LIFEDATABOX)), hWnd, lpLifeDlg ) # 0 THEN END;
                     Windows.FreeProcInstance(lpLifeDlg);

                     hTMenu:= Windows.GetSubMenu(Windows.GetMenu(hWnd),FISHOPTION);

                     IF FishHead[7].status = TRUE THEN
                        IF Windows.CheckMenuItem(hTMenu,IDM_FISH7,Windows.MF_CHECKED) = 0 THEN END;
                     ELSE
                        IF Windows.CheckMenuItem(hTMenu,IDM_FISH7,Windows.MF_UNCHECKED) = 0 THEN END;
                     END;
                     ReDrawAll(hWnd,CLIPREGION);


                ELSE           (* End of menu option selections *)

                    RETURN Windows.DefWindowProc( hWnd, message, wParam, lParam);
                               (* If option not known pass on to windows *)
                END;

         | SPECIAL_CHANGE:

               StartAllTimers(hWnd);
               RETURN (1);

         | INIT_INSTANCES:

               ApplFish.ReInitInstances(hWnd,hdc,CARDINAL(wParam),CARDINAL(lParam));


         | Windows.WM_TIMER:
           CASE wParam OF

           | IDM_DESTROY:
             IF Windows.DestroyWindow(hWnd) = 0 THEN END;

           | FISHMOVE:

             FishHere := 1;
             WHILE (FishHere <=FishMax) DO

              IF FishHead[FishHere].status THEN

                  IF ((FishHead[FishHere].speedx < 0) AND (FishHead[FishHere].pspeedx >= 0)) OR
                     ((FishHead[FishHere].speedx > 0) AND (FishHead[FishHere].pspeedx <= 0)) THEN
                     hOldbmap := Windows.SelectObject(hMemoryDC,FishHead[FishHere].turnbmap);
                     IF Windows.BitBlt(hdc,FishHead[FishHere].xpos,FishHead[FishHere].ypos,
                                       FishHead[FishHere].xextent,FishHead[FishHere].yextent,
                                       hMemoryDC,0,0,Windows.SRCCOPY) = 0 THEN
                     END;
                  END;

                  IF FishHead[FishHere].speedx > 0 THEN
                     IF Windows.BitBlt(hdc,FishHead[FishHere].xpos,FishHead[FishHere].ypos,
                                       FishHead[FishHere].speedx,FishHead[FishHere].yextent,hMemoryDC,0,0,
                                       Windows.BLACKNESS) # 0 THEN END;
                  END;

                  IF FishHead[FishHere].speedx < 0 THEN
                     IF Windows.BitBlt(hdc,FishHead[FishHere].xpos+FishHead[FishHere].xextent+INTEGER(FishHead[FishHere].speedx),
                                       FishHead[FishHere].ypos, -FishHead[FishHere].speedx,FishHead[FishHere].yextent,
                                       hMemoryDC,0,0,Windows.BLACKNESS) # 0 THEN END;
                  END;

                  FishHead[FishHere].pspeedx := FishHead[FishHere].speedx;
                  FishHead[FishHere].pspeedy := FishHead[FishHere].speedy;

                  IF FishHead[FishHere].xpos < RealXYRect.left-FishHead[FishHere].xextent THEN
                         FishHead[FishHere].xpos := RealXYRect.right
                  END;

                  IF FishHead[FishHere].xpos > RealXYRect.right THEN
                         FishHead[FishHere].xpos := RealXYRect.left-FishHead[FishHere].xextent
                  END;

                  FishHead[FishHere].xpos := FishHead[FishHere].xpos + INTEGER(FishHead[FishHere].speedx);
                  FishHead[FishHere].ypos := FishHead[FishHere].ypos + INTEGER(FishHead[FishHere].speedy);

                  IF FishHead[FishHere].ypos > RealXYRect.bottom THEN FishHead[FishHere].ypos :=
                                                                      RealXYRect.top-FishHead[FishHere].yextent
                  END;

                  IF FishHead[FishHere].ypos < RealXYRect.top-FishHead[FishHere].yextent THEN
                          FishHead[FishHere].ypos := RealXYRect.bottom
                  END;

                  IF FishHead[FishHere].bmapno = 4 THEN
                     FishHead[FishHere].bmapno := 1
                  ELSE
                     INC(FishHead[FishHere].bmapno)
                  END;

                  hOldbmap := Windows.SelectObject(hMemoryDC, FishHead[FishHere].bmap[FishHead[FishHere].direction,
                                                   FishHead[FishHere].bmapno]);

                  IF Windows.BitBlt(hdc,FishHead[FishHere].xpos,FishHead[FishHere].ypos,
                                    FishHead[FishHere].xextent,FishHead[FishHere].yextent,hMemoryDC,
                                    0,0,Windows.SRCCOPY) # 0 THEN END;


                  IF FishHead[FishHere].Instances > 0 THEN
                      ApplFish.AnimateOtherInstances(hdc,hMemoryDC,FishHead[FishHere])
                  END;

             END;   (* if status *)
             FishHere := FishHere+1;
           END; (* DO *)

           FishHere := 1;

           WHILE (FishHere <= FishMax) DO (* output again, ORing the bmaps to reduce flicker *)

            IF FishHead[FishHere].status THEN

              hOldbmap := Windows.SelectObject(hMemoryDC, FishHead[FishHere].bmap[FishHead[FishHere].direction,
                                               FishHead[FishHere].bmapno]);
              IF Windows.BitBlt(hdc,FishHead[FishHere].xpos,FishHead[FishHere].ypos,
                                FishHead[FishHere].xextent,FishHead[FishHere].yextent,hMemoryDC,0,0,Windows.SRCPAINT) # 0 THEN END;

              IF FishHead[FishHere].Instances > 0 THEN
                 ApplFish.ReOutputOtherInstances(FishHead[FishHere],hMemoryDC,hdc)
              END;
            END;
            FishHere := FishHere+1
           END;
           FishHere := 1;
(* here *)

         | BUBBLEMOVE:

              BubbleHere := 1;
              hOldbmap := Windows.SelectObject(hMemoryDC, hBUBBLEbmap);
              WHILE (BubbleHere <= BubbleMax) DO
                 IF Windows.BitBlt(hdc,BubbleHead[BubbleHere].X,BubbleHead[BubbleHere].Y,BUBBLE_X_XTENT,BUBBLE_Y_XTENT,hMemoryDC,0,0,Windows.BLACKNESS) # 0 THEN END;

                 IF BubbleHead[BubbleHere].Y < RealXYRect.top THEN
                    BubbleHead[BubbleHere].Y := RealXYRect.bottom + INTEGER(RANDOM(50));
                    BubbleHead[BubbleHere].X := RANDOM(XYRect.right)+CARDINAL(Windows.LOWORD(Windows.GetWindowOrg(hdc)));
                 ELSE
                    BubbleHead[BubbleHere].Y := BubbleHead[BubbleHere].Y - INTEGER(BubbleHead[BubbleHere].Speed);
                 END;
                 IF Windows.BitBlt(hdc,BubbleHead[BubbleHere].X,BubbleHead[BubbleHere].Y,BUBBLE_X_XTENT,BUBBLE_Y_XTENT,hMemoryDC,0,0,Windows.SRCPAINT) # 0 THEN END;
                 BubbleHere := BubbleHere+1
              END;
          | SETRANDOM:
              i := ClipRgnType; (* need to invalidate an area or menu won't show *)
              ClipRgnType := 99;
              SetRectInvalid(hWnd,0,0,1,1);
              ClipRgnType:=i;

              FishHere := 1;
              WHILE (FishHere <= FishMax) DO
               IF FishHead[FishHere].status THEN
                 randomy := RANDOM(5);
                 FishHead[FishHere].pspeedx := FishHead[FishHere].speedx;
                 FishHead[FishHere].pspeedy := FishHead[FishHere].speedy;
                 CASE randomy OF
                      | 0 :  FishHead[FishHere].speedy := -1;Increase(FishHead[FishHere].speedx);
                      | 1 :  FishHead[FishHere].speedy := 1;FishHead[FishHere].speedx := 0;
                      | 2 :  FishHead[FishHere].speedx := FishHead[FishHere].basespeed;FishHead[FishHere].direction:=FORWARDS;FishHead[FishHere].speedy := 0;
                      | 3 :  FishHead[FishHere].speedx := -FishHead[FishHere].basespeed;FishHead[FishHere].direction:=BACKWARDS;FishHead[FishHere].speedy := 0;
                 END;
                 IF FishHead[FishHere].Instances > 0 THEN
                    ApplFish.RandomizeInstances(FishHead[FishHere]);
                 END
               END;
               FishHere := FishHere+1;
              END;
              FishHere := 1;
          | STARMOVE:
              prevstar := star;
              IF star = 4 THEN
                 star := 1
              ELSE
                 star := star + 1
              END;
               IF Windows.SelectClipRgn(hdc,hSTARS[prevstar].hStarRgn) = 0 THEN END;
               hOldbmap := Windows.SelectObject(hMemoryDC,hSTARS[star].hStar);
               IF Windows.BitBlt(hdc,STARXPOS,starypos,STARXSIZE,STARYSIZE,hMemoryDC,0,0,Windows.BLACKNESS) # 0 THEN END;
               IF Windows.SelectClipRgn(hdc,hSTARS[star].hStarRgn) = 0 THEN END;
               IF Windows.BitBlt(hdc,STARXPOS,starypos,STARXSIZE,STARYSIZE,hMemoryDC,0,0,Windows.SRCCOPY) # 0 THEN END;
              ClipRgnType := CLIPREGION;
              IF Windows.SelectClipRgn(hdc,hSTARS[star].hClipRgn) = Windows.ERROR THEN END;

          | WEEDMOVE:
              prevweed := weed;
              IF weed = MAXWEEDS THEN
                 weed := 1
              ELSE
                 weed := weed + 1
              END;
              ClipRgnType := WEEDREGION;
               IF Windows.SelectClipRgn(hdc,hFloorRgn) = 0 THEN END;
               hOldbmap := Windows.SelectObject(hMemoryDC,hWEEDS[weed].hWeed);
               IF Windows.BitBlt(hdc,WEEDXPOS,weedypos,WEEDXSIZE,WEEDYSIZE,hMemoryDC,0,0,Windows.SRCCOPY) # 0 THEN END;
              ClipRgnType := CLIPREGION;
              IF Windows.SelectClipRgn(hdc,hSTARS[star].hClipRgn) = Windows.ERROR THEN END;

          | CHESTMOVE:
              IF chest = 3 THEN
                 chest := 1
              ELSE
                 chest := chest + 1
              END;
              ClipRgnType := FLOORREGION;
               IF Windows.SelectClipRgn(hdc,hFloorRgn) = 0 THEN END;
               hOldbmap := Windows.SelectObject(hMemoryDC,hCHEST[chest]);
               IF Windows.BitBlt(hdc,CHESTXPOS,chestypos,CHESTXXTENT,CHESTYXTENT,hMemoryDC,0,0,Windows.SRCCOPY) # 0 THEN END;
              ClipRgnType := CLIPREGION;
              IF Windows.SelectClipRgn(hdc,hSTARS[star].hClipRgn) = Windows.ERROR THEN END;

           END;
         | Windows.WM_CREATE:
            CreateInstance(hWnd);

         | Windows.WM_HSCROLL:
            Windows.GetClientRect(hWnd,TempRect);
            SbXPos := Windows.GetScrollPos(hWnd,Windows.SB_HORZ);
            WindowOrg := Windows.GetWindowOrg(hdc);
            CASE wParam OF
                 | Windows.SB_LINEUP:
                   IF SbXPos > 0 THEN
                      SbXPos := SbXPos -1;
                      SbXInc := ((TankWidth-TempRect.right) * SbXPos) DIV SBHORZUNITS;
                      IF Windows.SetWindowOrg(hdc,Windows.LOWORD(LONGCARD(SbXInc)),Windows.HIWORD(WindowOrg)) = 0 THEN END;
                      IF Windows.SetScrollPos(hWnd,Windows.SB_HORZ,SbXPos,1) = 0 THEN END;
                   END;
                 | Windows.SB_LINEDOWN:
                   IF SbXPos < SBHORZUNITS THEN
                      SbXPos := SbXPos +1;
                      SbXInc := ((TankWidth-TempRect.right) * SbXPos) DIV SBHORZUNITS;
                      IF Windows.SetWindowOrg(hdc,Windows.LOWORD(LONGCARD(SbXInc)),Windows.HIWORD(WindowOrg)) = 0 THEN END;
                      IF Windows.SetScrollPos(hWnd,Windows.SB_HORZ,SbXPos,1) = 0 THEN END;
                   END;
                 | Windows.SB_PAGEUP:
                   IF SbXPos > 0 THEN
                      IF (TankWidth DIV TempRect.right) = 0 THEN
                         SbXPos := 0
                      ELSE
                         SbXPos := SbXPos - (SBHORZUNITS DIV (TankWidth DIV TempRect.right));
                                          (* Calc how many units a page up would be *)
                         IF SbXPos < 0 THEN
                            SbXPos := 0
                         END;
                      END;
                      SbXInc := ((TankWidth-TempRect.right) * SbXPos) DIV SBHORZUNITS;
                      IF Windows.SetWindowOrg(hdc,Windows.LOWORD(LONGCARD(SbXInc)),Windows.HIWORD(WindowOrg)) = 0 THEN END;
                      IF Windows.SetScrollPos(hWnd,Windows.SB_HORZ,SbXPos,1) = 0 THEN END;
                   END;
                 | Windows.SB_PAGEDOWN:
                   IF SbXPos < SBHORZUNITS THEN
                      IF (TankWidth DIV TempRect.right) = 0 THEN
                         SbXPos := SBHORZUNITS
                      ELSE
                         SbXPos := SbXPos + ( SBHORZUNITS DIV (TankWidth DIV TempRect.right));
                                   (* Calc how many units a page down would be *)
                         IF SbXPos > SBHORZUNITS THEN
                            SbXPos := SBHORZUNITS
                         END;
                      END;
                      SbXInc := ((TankWidth-TempRect.right) * SbXPos) DIV SBHORZUNITS;
                      IF Windows.SetWindowOrg(hdc,Windows.LOWORD(LONGCARD(SbXInc)),Windows.HIWORD(WindowOrg)) = 0 THEN END;
                      IF Windows.SetScrollPos(hWnd,Windows.SB_HORZ,SbXPos,1) = 0 THEN END;
                   END;
                 | Windows.SB_THUMBPOSITION:
                      SbXPos := INTEGER(Windows.LOWORD(lParam));
                      SbXInc := ((TankWidth-TempRect.right) * SbXPos) DIV SBHORZUNITS;
                      IF Windows.SetWindowOrg(hdc,Windows.LOWORD(LONGCARD(SbXInc)),Windows.HIWORD(WindowOrg)) = 0 THEN END;
                      IF Windows.SetScrollPos(hWnd,Windows.SB_HORZ,SbXPos,1) = 0 THEN END;

            END;
            IF (wParam = Windows.SB_LINEUP) OR
               (wParam = Windows.SB_LINEDOWN) OR
               (wParam = Windows.SB_PAGEUP) OR
               (wParam = Windows.SB_PAGEDOWN) OR
               (wParam = Windows.SB_THUMBPOSITION) THEN
               IF ReCalcRegions(hWnd) THEN
                  RETURN (Windows.False)
               END;
               RealXYRect := TempRect;
               Windows.OffsetRect(RealXYRect,
                               Windows.LOWORD(Windows.GetWindowOrg(hdc)),
                               Windows.HIWORD(Windows.GetWindowOrg(hdc)));

               ReDrawAll(hWnd,ClipRgnType);
            END;

         | Windows.WM_VSCROLL:
            Windows.GetClientRect(hWnd,TempRect);
            SbYPos := Windows.GetScrollPos(hWnd,Windows.SB_VERT);
            WindowOrg := Windows.GetWindowOrg(hdc);
            CASE wParam OF
                 | Windows.SB_LINEUP:
                   IF SbYPos > 0 THEN
                      SbYPos := SbYPos -1;
                      SbYInc := ((TankDepth-TempRect.bottom) * SbYPos) DIV SBVERTUNITS;
                      IF Windows.SetWindowOrg(hdc,Windows.LOWORD(WindowOrg),Windows.LOWORD(LONGCARD(SbYInc))) = 0 THEN END;
                      IF Windows.SetScrollPos(hWnd,Windows.SB_VERT,SbYPos,1) = 0 THEN END;
                   END;
                 | Windows.SB_LINEDOWN:
                   IF SbYPos < SBVERTUNITS THEN
                      SbYPos := SbYPos+1;
                      SbYInc := ((TankDepth-TempRect.bottom) * SbYPos) DIV SBVERTUNITS;
                      IF Windows.SetWindowOrg(hdc,Windows.LOWORD(WindowOrg),Windows.LOWORD(LONGCARD(SbYInc))) = 0 THEN END;
                      IF Windows.SetScrollPos(hWnd,Windows.SB_VERT,SbYPos,1) = 0 THEN END;
                   END;
                 | Windows.SB_PAGEUP:
                   IF SbYPos > 0 THEN
                      IF (TankDepth DIV TempRect.bottom) = 0 THEN (* in case div by zero *)
                         SbYPos := 0;
                      ELSE
                         SbYPos := SbYPos - (SBVERTUNITS DIV (TankDepth DIV TempRect.bottom)); (* Calc how many units a page up would be *)
                         IF SbYPos < 0 THEN
                            SbYPos := 0
                         END;
                      END;
                      SbYInc := ((TankDepth-TempRect.bottom) * SbYPos) DIV SBVERTUNITS;
                      IF Windows.SetWindowOrg(hdc,Windows.LOWORD(WindowOrg),Windows.LOWORD(LONGCARD(SbYInc))) = 0 THEN END;
                      IF Windows.SetScrollPos(hWnd,Windows.SB_VERT,SbYPos,1) = 0 THEN END;
                   END;
                 | Windows.SB_PAGEDOWN:
                   IF SbYPos < SBVERTUNITS THEN
                      IF (TankDepth DIV TempRect.bottom) = 0 THEN
                         SbYPos := SBVERTUNITS
                      ELSE
                         SbYPos := SbYPos + (SBVERTUNITS DIV (TankDepth DIV TempRect.bottom)); (* Calc how many units a page down would be *)
                         IF SbYPos > SBVERTUNITS THEN
                            SbYPos := SBVERTUNITS
                         END;
                      END;
                      SbYInc := ((TankDepth-TempRect.bottom) * SbYPos) DIV SBVERTUNITS;
                      IF Windows.SetWindowOrg(hdc,Windows.LOWORD(WindowOrg),Windows.LOWORD(LONGCARD(SbYInc))) = 0 THEN END;
                      IF Windows.SetScrollPos(hWnd,Windows.SB_VERT,SbYPos,1) = 0 THEN END;
                   END;
                 | Windows.SB_THUMBPOSITION:
                      SbYPos := INTEGER(Windows.LOWORD(lParam));
                      SbYInc := ((TankDepth-TempRect.bottom) * SbYPos) DIV SBVERTUNITS;
                      IF Windows.SetWindowOrg(hdc,Windows.LOWORD(WindowOrg),Windows.LOWORD(LONGCARD(SbYInc))) = 0 THEN END;
                      IF Windows.SetScrollPos(hWnd,Windows.SB_VERT,SbYPos,1) = 0 THEN END;
            END;
            IF (wParam = Windows.SB_LINEUP) OR
               (wParam = Windows.SB_LINEDOWN) OR
               (wParam = Windows.SB_PAGEUP) OR
               (wParam = Windows.SB_PAGEDOWN) OR
               (wParam = Windows.SB_THUMBPOSITION) THEN
               IF ReCalcRegions(hWnd) THEN
                  RETURN Windows.False
               END;
               RealXYRect := TempRect;
               Windows.OffsetRect(RealXYRect,
                                  Windows.LOWORD(Windows.GetWindowOrg(hdc)),
                                  Windows.HIWORD(Windows.GetWindowOrg(hdc)));
               ReDrawAll(hWnd,ClipRgnType);
            END;

         | Windows.WM_DESTROY:
(*          WHILE (FishHead # NIL) DO
              FishHere := FishHead;
              FishHead := FishHead^.NextFish;
              DEALLOCATE(FishHere,SIZE(FishHere))
            END;
            WHILE (BubbleHead # NIL) DO
              BubbleHere := BubbleHead;
              BubbleHead := BubbleHead^.NextBubble;
              DEALLOCATE(BubbleHere,SIZE(BubbleHere))
            END;

*)
            ApplFish.DeleteFishInstances;
            FOR i := 1 TO MAXSTARS DO
                IF Windows.DeleteObject(hSTARS[i].hStarRgn) = 0 THEN END;
                IF Windows.DeleteObject(hSTARS[i].hStar) # 0 THEN END;
                IF Windows.DeleteObject(hSTARS[i].hClipRgn) # 0 THEN END;
            END; (* for i *)
            IF Windows.DeleteObject(hFloorRgn) # 0 THEN END;
            IF Windows.DeleteObject(hClientRgn) # 0 THEN END;
        (*    IF Windows.DeleteObject(hFishRgn) # 0 THEN END; *)
            IF Windows.DeleteObject(hTankRgn) # 0 THEN END;
            IF Windows.DeleteDC(hMemoryDC) # 0 THEN END;
            IF Windows.DeleteObject(hBUBBLEbmap) # 0 THEN END;
            IF Windows.DeleteObject(hBUBBLE3bmap) # 0 THEN END;
            IF Windows.DeleteObject(hBUBBLE1bmap) # 0 THEN END;
            IF Windows.DeleteObject(hBUBBLE2bmap) # 0 THEN END;
            IF Windows.DeleteObject(hFLOORbmap) # 0 THEN END;
            IF Windows.DeleteObject(hWEEDS[1].hWeed) # 0 THEN END;
            IF Windows.DeleteObject(hWEEDS[2].hWeed) # 0 THEN END;
            IF Windows.DeleteObject(hCHEST[1]) # 0 THEN END;
            IF Windows.DeleteObject(hCHEST[2]) # 0 THEN END;
            IF Windows.DeleteObject(hCHEST[3]) # 0 THEN END;

            IF Windows.DeleteObject(hFISHF1A) # 0 THEN END;
            IF Windows.DeleteObject(hFISHF1B) # 0 THEN END;
            IF Windows.DeleteObject(hFISHF1C) # 0 THEN END;
            IF Windows.DeleteObject(hFISHF1D) # 0 THEN END;
            IF Windows.DeleteObject(hFISHB1A) # 0 THEN END;
            IF Windows.DeleteObject(hFISHB1B) # 0 THEN END;
            IF Windows.DeleteObject(hFISHB1C) # 0 THEN END;
            IF Windows.DeleteObject(hFISHB1D) # 0 THEN END;
            IF Windows.DeleteObject(hFISHT1) # 0 THEN END;

            IF Windows.DeleteObject(hFISHF2A) # 0 THEN END;
            IF Windows.DeleteObject(hFISHF2B) # 0 THEN END;
            IF Windows.DeleteObject(hFISHF2C) # 0 THEN END;
            IF Windows.DeleteObject(hFISHF2D) # 0 THEN END;
            IF Windows.DeleteObject(hFISHB2A) # 0 THEN END;
            IF Windows.DeleteObject(hFISHB2B) # 0 THEN END;
            IF Windows.DeleteObject(hFISHB2C) # 0 THEN END;
            IF Windows.DeleteObject(hFISHB2D) # 0 THEN END;
            IF Windows.DeleteObject(hFISHT2) # 0 THEN END;

            IF Windows.DeleteObject(hFISHF3A) # 0 THEN END;
            IF Windows.DeleteObject(hFISHF3B) # 0 THEN END;
            IF Windows.DeleteObject(hFISHF3C) # 0 THEN END;
            IF Windows.DeleteObject(hFISHF3D) # 0 THEN END;
            IF Windows.DeleteObject(hFISHB3A) # 0 THEN END;
            IF Windows.DeleteObject(hFISHB3B) # 0 THEN END;
            IF Windows.DeleteObject(hFISHB3C) # 0 THEN END;
            IF Windows.DeleteObject(hFISHB3D) # 0 THEN END;
            IF Windows.DeleteObject(hFISHT3) # 0 THEN END;

            IF Windows.DeleteObject(hFISHF4A) # 0 THEN END;
            IF Windows.DeleteObject(hFISHF4B) # 0 THEN END;
            IF Windows.DeleteObject(hFISHF4C) # 0 THEN END;
            IF Windows.DeleteObject(hFISHF4D) # 0 THEN END;
            IF Windows.DeleteObject(hFISHB4A) # 0 THEN END;
            IF Windows.DeleteObject(hFISHB4B) # 0 THEN END;
            IF Windows.DeleteObject(hFISHB4C) # 0 THEN END;
            IF Windows.DeleteObject(hFISHB4D) # 0 THEN END;
            IF Windows.DeleteObject(hFISHT4) # 0 THEN END;

            IF Windows.DeleteObject(hFISHF5A) # 0 THEN END;
            IF Windows.DeleteObject(hFISHF5B) # 0 THEN END;
            IF Windows.DeleteObject(hFISHF5C) # 0 THEN END;
            IF Windows.DeleteObject(hFISHF5D) # 0 THEN END;
            IF Windows.DeleteObject(hFISHB5A) # 0 THEN END;
            IF Windows.DeleteObject(hFISHB5B) # 0 THEN END;
            IF Windows.DeleteObject(hFISHB5C) # 0 THEN END;
            IF Windows.DeleteObject(hFISHB5D) # 0 THEN END;
            IF Windows.DeleteObject(hFISHT5) # 0 THEN END;

            IF Windows.DeleteObject(hFISHF6A) # 0 THEN END;
            IF Windows.DeleteObject(hFISHF6B) # 0 THEN END;
            IF Windows.DeleteObject(hFISHF6C) # 0 THEN END;
            IF Windows.DeleteObject(hFISHF6D) # 0 THEN END;
            IF Windows.DeleteObject(hFISHB6A) # 0 THEN END;
            IF Windows.DeleteObject(hFISHB6B) # 0 THEN END;
            IF Windows.DeleteObject(hFISHB6C) # 0 THEN END;
            IF Windows.DeleteObject(hFISHB6D) # 0 THEN END;
            IF Windows.DeleteObject(hFISHT6) # 0 THEN END;

            IF Windows.DeleteObject(hFISHF7A) # 0 THEN END;
            IF Windows.DeleteObject(hFISHF7B) # 0 THEN END;
            IF Windows.DeleteObject(hFISHF7C) # 0 THEN END;
            IF Windows.DeleteObject(hFISHF7D) # 0 THEN END;
            IF Windows.DeleteObject(hFISHB7A) # 0 THEN END;
            IF Windows.DeleteObject(hFISHB7B) # 0 THEN END;
            IF Windows.DeleteObject(hFISHB7C) # 0 THEN END;
            IF Windows.DeleteObject(hFISHB7D) # 0 THEN END;
            IF Windows.DeleteObject(hFISHT7) # 0 THEN END;

            IF Windows.DeleteObject(hAccTable) # 0 THEN END;

            Windows.PostQuitMessage(0);
         | Windows.WM_PAINT:
            IF Windows.BeginPaint(hWnd, ps) # Windows.HDC(0) THEN END;
            MessagePaint(hWnd,ps.hdc,ps.rcPaint);
            Windows.EndPaint(hWnd, ps);

        ELSE

          IF (wParam = Windows.WM_SIZE) OR
             (wParam = Windows.SC_MAXIMIZE) OR
             (wParam = Windows.SC_ZOOM) THEN
            OldXYRect := XYRect;
            Windows.GetClientRect(hWnd,XYRect); (* client area may have changed *)
            IF Windows.EqualRect(OldXYRect,XYRect) = 0 THEN
               RealXYRect := XYRect;
               SbXPos := 0;
               SbYPos := 0;
               SbXInc := 0;
               SbYInc := 0;
               IF Windows.SetWindowOrg(hdc,0,0) = 0 THEN END;
               IF Windows.SetScrollPos(hWnd,Windows.SB_HORZ,0,1) = 0 THEN END;
               IF Windows.SetScrollPos(hWnd,Windows.SB_VERT,0,1) = 0 THEN END;
               IF ReCalcRegions(hWnd) THEN
                  RETURN Windows.False
               END;
               ReDrawAll(hWnd,CLIPREGION);

            END; (* if not equal rects *)
          END;
          RETURN Windows.DefWindowProc( hWnd, message, wParam, lParam);
        END;
    RETURN 0;
END MainWndProc;



(* This procedure called when the program is loaded for the first time *)

PROCEDURE DemoInit(hInstance: Windows.HANDLE): BOOLEAN;

VAR
  DemoClass: Windows.WNDCLASS;
BEGIN

  IF Windows.LoadString(hInstance, IDSNAME,szAppName, 10) # 0 THEN END;
  IF Windows.LoadString(hInstance, IDSABOUT,szAbout, 10) # 0 THEN END;
  MessageLength:= Windows.LoadString(hInstance, IDSTITLE,szMessage, 25);
  IF Windows.LoadString(hInstance, IDSDEFSPEC, szDefSpec, 13) # 0 THEN END;
  IF Windows.LoadString(hInstance, IDSDEFEXT, szDefExt, 4) # 0 THEN END;

(*  pDemoClass := Windows.PWNDCLASS(Windows.LocalAlloc( Windows.LPTR, SIZE(Windows.WNDCLASS))); *)

  DemoClass.hCursor := Windows.LoadCursor(Windows.HANDLE(0), FarADDRESS(Windows.IDC_ARROW));
  DemoClass.hIcon := 0;
(*  DemoClass.hIcon := Windows.LoadIcon(hInstance, FarADDRESS(LONGCARD(AQUAICON)));*)
  DemoClass.lpszMenuName := FarNIL;
  DemoClass.lpszClassName := Windows.LPSTR(FarADR(szAppName));
  DemoClass.hbrBackground := Windows.HBRUSH(Windows.GetStockObject(Windows.BLACK_BRUSH));
  DemoClass.hInstance:=hInstance;
  DemoClass.style := Windows.CS_HREDRAW + Windows.CS_VREDRAW + Windows.CS_OWNDC;
  DemoClass.lpfnWndProc := FarADR(MainWndProc);

  IF Windows.RegisterClass(DemoClass) = 0 THEN
        (* Initialization failed.
         * Windows will automatically deallocate all allocated memory. *)
    RETURN FALSE;
  END;
(*  IF Windows.LocalFree( Windows.HANDLE(pDemoClass)) # Windows.HANDLE(0) THEN END; *)
  RETURN TRUE;        (* Success *)
END DemoInit;


PROCEDURE WinMain(hInstance: Windows.HANDLE; hPrevInstance: Windows.HANDLE; lpszCmdLine: Windows.LPSTR; cmdShow: INTEGER): Windows.BOOL;

VAR
    msg: Windows.MSG;
    hWnd: Windows.HWND;
    hMenu: Windows.HWND;
    hApplMenu : Windows.HMENU;
    i,j       : INTEGER;
    jab : LONGCARD;
    ja : FarADDRESS;
BEGIN
    IF hPrevInstance = Windows.HANDLE(0) THEN
        (* Call initialization procedure if this is the first instance *)
        IF NOT DemoInit(hInstance) THEN
            RETURN INTEGER(FALSE);
        END;
    ELSE
        (* Copy data from previous instance *)
        IF Windows.GetInstanceData(hPrevInstance, NearADR(szAppName), 10) # 0 THEN END;
        IF Windows.GetInstanceData(hPrevInstance, NearADR(szAbout), 10) # 0 THEN END;
        IF Windows.GetInstanceData(hPrevInstance, NearADR(szMessage), 25) # 0 THEN END;
        IF Windows.GetInstanceData(hPrevInstance, NearADR(MessageLength), SIZE(INTEGER)) # 0 THEN END;
        IF Windows.GetInstanceData(hPrevInstance, NearADR(szDefSpec), 13) # 0 THEN END;
        IF Windows.GetInstanceData(hPrevInstance, NearADR(szDefExt), 4) # 0 THEN END;
    END;

    (* Load Menu from Resource file *)
    hApplMenu := Windows.LoadMenu (hInstance, "ApplMenu");

    hBrush := Windows.CreateSolidBrush(Windows.RGB(255,0,0));

    (* Save instance handle for DialogBox *)
    hInst := hInstance;

    hWnd := Windows.CreateWindow(Windows.LPSTR(FarADR(szAppName)),
                        szMessage,
                        Windows.WS_OVERLAPPEDWINDOW + Windows.WS_HSCROLL + Windows.WS_VSCROLL,
                        Windows.CW_USEDEFAULT,
                        Windows.CW_USEDEFAULT,
                        Windows.CW_USEDEFAULT,
                        Windows.CW_USEDEFAULT,
                        Windows.HWND(0),        (* no parent *)
                        hApplMenu,        (* use class menu *)
                        hInstance,     (* handle to window instance *)
                        FarNIL         (* no params to pass on *)
                        );

    hMenu:= Windows.GetSubMenu(Windows.GetMenu(hWnd),FISHOPTION);
    Windows.ChangeMenu(hMenu, 0, FarADR("Default"), IDM_DEFAULT, Windows.MF_APPEND + Windows.MF_STRING);
    Windows.ChangeMenu(hMenu, 0, FarNIL, 999, Windows.MF_APPEND + Windows.MF_SEPARATOR);
    Windows.ChangeMenu(hMenu, 0, FarADDRESS(Windows.MAKELONG(hFISHF1A,0)), IDM_FISH1, Windows.MF_APPEND + Windows.MF_BITMAP + Windows.MF_CHECKED);
    Windows.ChangeMenu(hMenu, 0, FarNIL, 999, Windows.MF_APPEND + Windows.MF_SEPARATOR);
    Windows.ChangeMenu(hMenu, 0, FarADDRESS(Windows.MAKELONG(hFISHF2A,0)), IDM_FISH2, Windows.MF_APPEND + Windows.MF_BITMAP + Windows.MF_UNCHECKED);
    Windows.ChangeMenu(hMenu, 0, FarNIL, 999, Windows.MF_APPEND + Windows.MF_SEPARATOR);
    Windows.ChangeMenu(hMenu, 0, FarADDRESS(Windows.MAKELONG(hFISHF3A,0)), IDM_FISH3, Windows.MF_APPEND + Windows.MF_BITMAP + Windows.MF_CHECKED);
    Windows.ChangeMenu(hMenu, 0, FarNIL, 999, Windows.MF_APPEND + Windows.MF_SEPARATOR);
    Windows.ChangeMenu(hMenu, 0, FarADDRESS(Windows.MAKELONG(hFISHF4A,0)), IDM_FISH4, Windows.MF_APPEND + Windows.MF_BITMAP + Windows.MF_CHECKED);
    Windows.ChangeMenu(hMenu, 0, FarNIL, 999, Windows.MF_APPEND + Windows.MF_SEPARATOR);
    Windows.ChangeMenu(hMenu, 0, FarADDRESS(Windows.MAKELONG(hFISHF5A,0)), IDM_FISH5, Windows.MF_APPEND + Windows.MF_BITMAP + Windows.MF_CHECKED);
    Windows.ChangeMenu(hMenu, 0, FarNIL, 999, Windows.MF_APPEND + Windows.MF_SEPARATOR);
    Windows.ChangeMenu(hMenu, 0, FarADDRESS(Windows.MAKELONG(hFISHF6A,0)), IDM_FISH6, Windows.MF_APPEND + Windows.MF_BITMAP + Windows.MF_CHECKED);
    Windows.ChangeMenu(hMenu, 0, FarNIL, 999, Windows.MF_APPEND + Windows.MF_SEPARATOR);
    Windows.ChangeMenu(hMenu, 0, FarADDRESS(Windows.MAKELONG(hFISHF7A,0)), IDM_FISH7, Windows.MF_APPEND + Windows.MF_BITMAP + Windows.MF_UNCHECKED);


    hdc := Windows.GetDC(hWnd);
    hMemoryDC := Windows.CreateCompatibleDC(hdc);

    TankDepth := Windows.GetDeviceCaps(hdc,Windows.VERTRES);
    TankWidth := Windows.GetDeviceCaps(hdc,Windows.HORZRES);
    TankDepth := TankDepth-TANKDEPTHDIFF;

    Windows.GetClientRect(hWnd,XYRect);

    floorypos := TankDepth - FLOORYSIZE;
    weedypos := floorypos - 72;
    chestypos := floorypos + 8;

    hTankRgn := Windows.CreateRectRgn(0,0,TankWidth,TankDepth);
    IF hTankRgn = 0 THEN
       IF ApplFish.ResourcesLow(hWnd) THEN
          RETURN Windows.False
       END
    END;

    IF ReCalcFloorRegion(hWnd) THEN (* Resource problem *)
       RETURN (Windows.False)
    END;
    hFishRgn := Windows.CreateRectRgnIndirect(XYRect); (* Needs to be created just once for combine rgn *)
    IF hFishRgn = 0 THEN
       IF ApplFish.ResourcesLow(hWnd) THEN
          RETURN Windows.False
       END
    END;
    SetUpBubbles;  (* Needs Client Area info before setup *)
    FOR i := 1 TO 4 DO
        hSTARS[i].hClipRgn := Windows.CreateRectRgnIndirect(XYRect);
        IF hSTARS[i].hClipRgn = 0 THEN
           IF ApplFish.ResourcesLow(hWnd) THEN
              RETURN Windows.False
           END
        END
    END;

    RealXYRect := XYRect;

    IF (ResizeStarParams(hWnd)) THEN (* Then resource problem *) (* Also needs floor info *)
       RETURN(Windows.False) (* Also needs floor info *)
    END;

    hClientRgn := Windows.CreateRectRgn(0,0,TankWidth,TankDepth);
    IF hClientRgn = 0 THEN
       IF ApplFish.ResourcesLow(hWnd) THEN
          RETURN Windows.False
       END
    END;

    WindowOrg := Windows.GetWindowOrg(hdc);

    ClipRgnType := CLIENTREGION;
    IF Windows.SelectClipRgn(hdc,hClientRgn) = Windows.ERROR THEN END;

   (* Make window visible according to the way the app is activated *)
    IF Windows.ShowWindow(hWnd, cmdShow) # 0 THEN END;
    Windows.UpdateWindow(hWnd);
    IF Windows.PostMessage(hWnd,Windows.WM_COMMAND,IDM_START,0) = 0 THEN END;


    (* Polling messages from event queue *)
    WHILE (Windows.GetMessage(msg, Windows.HWND(0), 0, 0)) # 0 DO
       IF Windows.TranslateAccelerator(hWnd, hAccTable,msg) = 0 THEN END;
        IF Windows.TranslateMessage(msg) # 0 THEN END;
        IF Windows.DispatchMessage(msg) # 0 THEN END;
    END;
    RETURN msg.wParam;
END WinMain;



END WMain.
