program ScreenSaver;

uses Wintypes, WinProcs, Objects, OMemory, OWindows, ODialogs, Saver;

{The below description must start with the {$D SCRNSAVE  and
follow with the name to show up in control panel.  You must
compile this program to an .EXE and copy it to your windows
directory with the extention .SCR. }

{$D SCRNSAVE Beavis & ButtHead}

{$R BEAVIS.RES}

const
NumberOfBitmaps = 2;

type

TSaveApplication = object(TSApplication)
  procedure InitMainWindow; virtual;
  destructor Done; virtual;
 end;

PSaveWindow = ^TSaveWindow;
TSaveWindow = object(TScrnSavWindow)
  hBmp : array[1..NumberofBitmaps] of  hBitmap;
  constructor Init(aParent: PWindowsObject; aTitle: PChar);
  procedure SetupWindow; virtual;
  procedure Animate; virtual;
  destructor Done; virtual;
end;

procedure TSaveApplication.InitMainWindow;
begin
 if (ParamStr(1) <> '/c') and (ParamStr(1) <> '-c') then
   MainWindow:= New(PSaveWindow, Init(nil, 'ScreenSaver'))
 else
 begin
   Configure := True;
   MainWindow := New(PDialog, Init(nil, 'ConfigDialog'));
 end
end;

constructor TSaveWindow.Init(aParent: PWindowsObject; aTitle: PChar);
begin
  BackGroundColor := Null_Brush;
  TScrnSavWindow.Init(aParent, aTitle);
end;

procedure TSaveWindow.SetupWindow;
begin
  Randomize;
  TScrnSavWindow.SetupWindow;
  hBmp[1] := loadBitmap(hInstance, 'Beavis');
  hBmp[2] := loadBitmap(hInstance, 'Butthead');
end;

procedure TSaveWindow.Animate;
var
  MyHdc, MemhDC: hDC;
  BitMp : TBitMap;
  Rect:TRect;
  bmNumber: Byte;
  x,y:Word;
begin
  bmNumber := Random(2) + 1;
  MyHDC := GetWindowDC(hWindow);
  MemHDC := CreateCompatibleDC(myHDC);
  GetClientRect(hWindow,Rect);
  SelectObject(MemHDC, hBmp[bmNumber]);
  GetObject(hbmp[bmNumber], sizeof(BitMp), @BitMp);
  x := random(Rect.Right - BitMp.bmWidth);
  y := random(Rect.Bottom - BitMp.bmHeight);
  StretchBlt(MyHdc, x, y, Bitmp.bmWidth,
             Bitmp.bmHeight , memHDC, 0, 0,
             Bitmp.bmWidth, bitmp.bmHeight, SRCcopy);
  ReleaseDC(hWindow, MyHDC);
  DeleteDC(MemHDC);
  ReleaseDC(hWindow, MyHDC);
end;

destructor TSaveWindow.Done;
var
  i: Integer;
begin
  for i := 1 to NumberOfBitmaps do
    Deleteobject(hBmp[i]);
  TScrnSavWindow.Done;
end;

destructor TSaveApplication.Done;
begin
  TApplication.Done;
end;

var
  TSApp: TSaveApplication;

begin
  TSApp.Init('Saver');
  TSApp.Run;
  TSApp.Done;
end.
